(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1639476,      52791]*)
(*NotebookOutlinePosition[   1640142,      52814]*)
(*  CellTagsIndexPosition[   1640098,      52810]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Phase Portraits", "Subtitle"],

Cell[CellGroupData[{

Cell["Proper Node", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = y\)], "Input"],

Cell[BoxData[
    \(y\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = x\)], "Input"],

Cell[BoxData[
    \(x\)], "Output"]
}, Closed]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-5\) \[LessEqual] x \[LessEqual] 5\)},
          {\(\(-5\) \[LessEqual] y \[LessEqual] 5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -5, x, 5], 
        LessEqual[ -5, y, 5]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx == y\/x\)], "Output"]
}, Closed]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(y(t)\)}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(x(t)\)}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 
            y[ t]], 
          Equal[ 
            Derivative[ 1][ x][ t], 
            x[ t]]}],
        Editable->False], TraditionalForm]], "Output"]
}, Closed]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0926184 0.5 0.0926184 [
[.12953 -0.0125 -6 -9 ]
[.12953 -0.0125 6 0 ]
[.31476 -0.0125 -6 -9 ]
[.31476 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68524 -0.0125 -3 -9 ]
[.68524 -0.0125 3 0 ]
[.87047 -0.0125 -3 -9 ]
[.87047 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12953 -12 -4.5 ]
[-0.0125 .12953 0 4.5 ]
[-0.0125 .31476 -12 -4.5 ]
[-0.0125 .31476 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68524 -6 -4.5 ]
[-0.0125 .68524 0 4.5 ]
[-0.0125 .87047 -6 -4.5 ]
[-0.0125 .87047 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12953 0 m
.12953 .00625 L
s
[(-4)] .12953 -0.0125 0 1 Mshowa
.31476 0 m
.31476 .00625 L
s
[(-2)] .31476 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68524 0 m
.68524 .00625 L
s
[(2)] .68524 -0.0125 0 1 Mshowa
.87047 0 m
.87047 .00625 L
s
[(4)] .87047 -0.0125 0 1 Mshowa
.125 Mabswid
.17584 0 m
.17584 .00375 L
s
.22214 0 m
.22214 .00375 L
s
.26845 0 m
.26845 .00375 L
s
.36107 0 m
.36107 .00375 L
s
.40738 0 m
.40738 .00375 L
s
.45369 0 m
.45369 .00375 L
s
.54631 0 m
.54631 .00375 L
s
.59262 0 m
.59262 .00375 L
s
.63893 0 m
.63893 .00375 L
s
.73155 0 m
.73155 .00375 L
s
.77786 0 m
.77786 .00375 L
s
.82416 0 m
.82416 .00375 L
s
.08322 0 m
.08322 .00375 L
s
.03691 0 m
.03691 .00375 L
s
.91678 0 m
.91678 .00375 L
s
.96309 0 m
.96309 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12953 m
.00625 .12953 L
s
[(-4)] -0.0125 .12953 1 0 Mshowa
0 .31476 m
.00625 .31476 L
s
[(-2)] -0.0125 .31476 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68524 m
.00625 .68524 L
s
[(2)] -0.0125 .68524 1 0 Mshowa
0 .87047 m
.00625 .87047 L
s
[(4)] -0.0125 .87047 1 0 Mshowa
.125 Mabswid
0 .17584 m
.00375 .17584 L
s
0 .22214 m
.00375 .22214 L
s
0 .26845 m
.00375 .26845 L
s
0 .36107 m
.00375 .36107 L
s
0 .40738 m
.00375 .40738 L
s
0 .45369 m
.00375 .45369 L
s
0 .54631 m
.00375 .54631 L
s
0 .59262 m
.00375 .59262 L
s
0 .63893 m
.00375 .63893 L
s
0 .73155 m
.00375 .73155 L
s
0 .77786 m
.00375 .77786 L
s
0 .82416 m
.00375 .82416 L
s
0 .08322 m
.00375 .08322 L
s
0 .03691 m
.00375 .03691 L
s
0 .91678 m
.00375 .91678 L
s
0 .96309 m
.00375 .96309 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12953 .99375 m
.12953 1 L
s
.31476 .99375 m
.31476 1 L
s
.5 .99375 m
.5 1 L
s
.68524 .99375 m
.68524 1 L
s
.87047 .99375 m
.87047 1 L
s
.125 Mabswid
.17584 .99625 m
.17584 1 L
s
.22214 .99625 m
.22214 1 L
s
.26845 .99625 m
.26845 1 L
s
.36107 .99625 m
.36107 1 L
s
.40738 .99625 m
.40738 1 L
s
.45369 .99625 m
.45369 1 L
s
.54631 .99625 m
.54631 1 L
s
.59262 .99625 m
.59262 1 L
s
.63893 .99625 m
.63893 1 L
s
.73155 .99625 m
.73155 1 L
s
.77786 .99625 m
.77786 1 L
s
.82416 .99625 m
.82416 1 L
s
.08322 .99625 m
.08322 1 L
s
.03691 .99625 m
.03691 1 L
s
.91678 .99625 m
.91678 1 L
s
.96309 .99625 m
.96309 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12953 m
1 .12953 L
s
.99375 .31476 m
1 .31476 L
s
.99375 .5 m
1 .5 L
s
.99375 .68524 m
1 .68524 L
s
.99375 .87047 m
1 .87047 L
s
.125 Mabswid
.99625 .17584 m
1 .17584 L
s
.99625 .22214 m
1 .22214 L
s
.99625 .26845 m
1 .26845 L
s
.99625 .36107 m
1 .36107 L
s
.99625 .40738 m
1 .40738 L
s
.99625 .45369 m
1 .45369 L
s
.99625 .54631 m
1 .54631 L
s
.99625 .59262 m
1 .59262 L
s
.99625 .63893 m
1 .63893 L
s
.99625 .73155 m
1 .73155 L
s
.99625 .77786 m
1 .77786 L
s
.99625 .82416 m
1 .82416 L
s
.99625 .08322 m
1 .08322 L
s
.99625 .03691 m
1 .03691 L
s
.99625 .91678 m
1 .91678 L
s
.99625 .96309 m
1 .96309 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.03691 .03691 m
.03691 .96309 L
.96309 .96309 L
.96309 .03691 L
F
0 0 0 r
.01 w
.03691 .03691 m
.96309 .03691 L
.96309 .96309 L
.03691 .96309 L
.03691 .03691 L
s
0 g
.5 Mabswid
.03691 .5 m
.96309 .5 L
s
.5 .03691 m
.5 .96309 L
s
.01 .66 .62 r
.04617 .04617 m
.02765 .02765 L
s
.04664 .09198 m
.02717 .07445 L
s
.04714 .13771 m
.02668 .12134 L
s
.04764 .18335 m
.02618 .16832 L
s
.04814 .22888 m
.02568 .21541 L
s
.04862 .27431 m
.02519 .2626 L
s
.04907 .31963 m
.02475 .3099 L
s
.04945 .36484 m
.02436 .35731 L
s
.04975 .40995 m
.02406 .40481 L
s
.04994 .45499 m
.02387 .45239 L
s
.05001 .5 m
.02381 .5 L
s
.04994 .54501 m
.02387 .54761 L
s
.04975 .59005 m
.02406 .59519 L
s
.04945 .63516 m
.02436 .64269 L
s
.04907 .68037 m
.02475 .6901 L
s
.04862 .72569 m
.02519 .7374 L
s
.04814 .77112 m
.02568 .78459 L
s
.04764 .81665 m
.02618 .83168 L
s
.04714 .86229 m
.02668 .87866 L
s
.04664 .90802 m
.02717 .92555 L
s
.04617 .95383 m
.02765 .97235 L
s
.09198 .04664 m
.07445 .02717 L
s
.09248 .09248 m
.07396 .07396 L
s
.09301 .13823 m
.07343 .12082 L
s
.09356 .18388 m
.07288 .16779 L
s
.09412 .22941 m
.07232 .21488 L
s
.09467 .27481 m
.07177 .26209 L
s
.09519 .32008 m
.07125 .30944 L
s
.09564 .36521 m
.07079 .35693 L
s
.096 .41022 m
.07043 .40454 L
s
.09624 .45514 m
.0702 .45224 L
s
.09632 .5 m
.07012 .5 L
s
.09624 .54486 m
.0702 .54776 L
s
.096 .58978 m
.07043 .59546 L
s
.09564 .63479 m
.07079 .64307 L
s
.09519 .67992 m
.07125 .69056 L
s
.09467 .72519 m
.07177 .73791 L
s
.09412 .77059 m
.07232 .78512 L
s
.09356 .81612 m
.07288 .83221 L
s
.09301 .86177 m
.07343 .87918 L
s
.09248 .90752 m
.07396 .92604 L
s
.09198 .95336 m
.07445 .97283 L
s
.13771 .04714 m
.12134 .02668 L
s
.13823 .09301 m
.12082 .07343 L
s
.13879 .13879 m
.12026 .12026 L
s
.13938 .18446 m
.11967 .16721 L
s
.14 .23 m
.11905 .21429 L
s
.14063 .2754 m
.11842 .26151 L
s
.14124 .32062 m
.11781 .30891 L
s
.14179 .36567 m
.11726 .35647 L
s
.14223 .41056 m
.11682 .4042 L
s
.14252 .45532 m
.11653 .45207 L
s
.14262 .5 m
.11643 .5 L
s
.14252 .54468 m
.11653 .54793 L
s
.14223 .58944 m
.11682 .5958 L
s
.14179 .63433 m
.11726 .64353 L
s
.14124 .67938 m
.11781 .69109 L
s
.14063 .7246 m
.11842 .73849 L
s
.14 .77 m
.11905 .78571 L
s
.13938 .81554 m
.11967 .83279 L
s
.13879 .86121 m
.12026 .87974 L
s
.13823 .90699 m
.12082 .92657 L
s
.13771 .95286 m
.12134 .97332 L
s
.18335 .04764 m
.16832 .02618 L
s
.18388 .09356 m
.16779 .07288 L
s
.18446 .13938 m
.16721 .11967 L
s
.1851 .1851 m
.16657 .16657 L
s
.18578 .23067 m
.16589 .21362 L
s
.18649 .27607 m
.16518 .26084 L
s
.18721 .32126 m
.16446 .30826 L
s
.18787 .36623 m
.1638 .35591 L
s
.18843 .41098 m
.16324 .40378 L
s
.1888 .45554 m
.16287 .45184 L
s
.18893 .5 m
.16274 .5 L
s
.1888 .54446 m
.16287 .54816 L
s
.18843 .58902 m
.16324 .59622 L
s
.18787 .63377 m
.1638 .64409 L
s
.18721 .67874 m
.16446 .69174 L
s
.18649 .72393 m
.16518 .73916 L
s
.18578 .76933 m
.16589 .78638 L
s
.1851 .8149 m
.16657 .83343 L
s
.18446 .86062 m
.16721 .88033 L
s
.18388 .90644 m
.16779 .92712 L
s
.18335 .95236 m
.16832 .97382 L
s
.22888 .04814 m
.21541 .02568 L
s
.22941 .09412 m
.21488 .07232 L
s
.23 .14 m
.21429 .11905 L
s
.23067 .18578 m
.21362 .16589 L
s
.23141 .23141 m
.21288 .21288 L
s
.23221 .27684 m
.21208 .26007 L
s
.23304 .32203 m
.21125 .3075 L
s
.23386 .36693 m
.21043 .35521 L
s
.23457 .41152 m
.20972 .40324 L
s
.23506 .45584 m
.20922 .45154 L
s
.23524 .5 m
.20905 .5 L
s
.23506 .54416 m
.20922 .54846 L
s
.23457 .58848 m
.20972 .59676 L
s
.23386 .63307 m
.21043 .64479 L
s
.23304 .67797 m
.21125 .6925 L
s
.23221 .72316 m
.21208 .73993 L
s
.23141 .76859 m
.21288 .78712 L
s
.23067 .81422 m
.21362 .83411 L
s
.23 .86 m
.21429 .88095 L
s
.22941 .90588 m
.21488 .92768 L
s
.22888 .95186 m
.21541 .97432 L
s
.27431 .04862 m
.2626 .02519 L
s
.27481 .09467 m
.26209 .07177 L
s
.2754 .14063 m
.26151 .11842 L
s
.27607 .18649 m
.26084 .16518 L
s
.27684 .23221 m
.26007 .21208 L
s
.27772 .27772 m
.25919 .25919 L
s
.27868 .32295 m
.25823 .30658 L
s
.27969 .36781 m
.25722 .35433 L
s
.28062 .41225 m
.25629 .40252 L
s
.2813 .45626 m
.25561 .45112 L
s
.28155 .5 m
.25536 .5 L
s
.2813 .54374 m
.25561 .54888 L
s
.28062 .58775 m
.25629 .59748 L
s
.27969 .63219 m
.25722 .64567 L
s
.27868 .67705 m
.25823 .69342 L
s
.27772 .72228 m
.25919 .74081 L
s
.27684 .76779 m
.26007 .78792 L
s
.27607 .81351 m
.26084 .83482 L
s
.2754 .85937 m
.26151 .88158 L
s
.27481 .90533 m
.26209 .92823 L
s
.27431 .95138 m
.2626 .97481 L
s
.31963 .04907 m
.3099 .02475 L
s
.32008 .09519 m
.30944 .07125 L
s
.32062 .14124 m
.30891 .11781 L
s
.32126 .18721 m
.30826 .16446 L
s
.32203 .23304 m
.3075 .21125 L
s
.32295 .27868 m
.30658 .25823 L
s
.32402 .32402 m
.3055 .3055 L
s
.32524 .36893 m
.30428 .35321 L
s
.32648 .41324 m
.30305 .40152 L
s
.32747 .45687 m
.30206 .45051 L
s
.32786 .5 m
.30166 .5 L
s
.32747 .54313 m
.30206 .54949 L
s
.32648 .58676 m
.30305 .59848 L
s
.32524 .63107 m
.30428 .64679 L
s
.32402 .67598 m
.3055 .6945 L
s
.32295 .72132 m
.30658 .74177 L
s
.32203 .76696 m
.3075 .78875 L
s
.32126 .81279 m
.30826 .83554 L
s
.32062 .85876 m
.30891 .88219 L
s
.32008 .90481 m
.30944 .92875 L
s
.31963 .95093 m
.3099 .97525 L
s
.36484 .04945 m
.35731 .02436 L
s
.36521 .09564 m
.35693 .07079 L
s
.36567 .14179 m
.35647 .11726 L
s
.36623 .18787 m
.35591 .1638 L
s
.36693 .23386 m
.35521 .21043 L
s
.36781 .27969 m
.35433 .25722 L
s
.36893 .32524 m
.35321 .30428 L
s
.37033 .37033 m
.35181 .35181 L
s
.37197 .41465 m
.35017 .40012 L
s
.3735 .45783 m
.34865 .44955 L
s
.37417 .5 m
.34797 .5 L
s
.3735 .54217 m
.34865 .55045 L
s
.37197 .58535 m
.35017 .59988 L
s
.37033 .62967 m
.35181 .64819 L
s
.36893 .67476 m
.35321 .69572 L
s
.36781 .72031 m
.35433 .74278 L
s
.36693 .76614 m
.35521 .78957 L
s
.36623 .81213 m
.35591 .8362 L
s
.36567 .85821 m
.35647 .88274 L
s
.36521 .90436 m
.35693 .92921 L
s
.36484 .95055 m
.35731 .97564 L
s
.40995 .04975 m
.40481 .02406 L
s
.41022 .096 m
.40454 .07043 L
s
.41056 .14223 m
.4042 .11682 L
s
.41098 .18843 m
.40378 .16324 L
s
.41152 .23457 m
.40324 .20972 L
s
.41225 .28062 m
.40252 .25629 L
s
.41324 .32648 m
.40152 .30305 L
s
.41465 .37197 m
.40012 .35017 L
s
.41664 .41664 m
.39812 .39812 L
s
.4191 .45955 m
.39567 .44783 L
s
.42048 .5 m
.39428 .5 L
s
.4191 .54045 m
.39567 .55217 L
s
.41664 .58336 m
.39812 .60188 L
s
.41465 .62803 m
.40012 .64983 L
s
.41324 .67352 m
.40152 .69695 L
s
.41225 .71938 m
.40252 .74371 L
s
.41152 .76543 m
.40324 .79028 L
s
.41098 .81157 m
.40378 .83676 L
s
.41056 .85777 m
.4042 .88318 L
s
.41022 .904 m
.40454 .92957 L
s
.40995 .95025 m
.40481 .97594 L
s
.45499 .04994 m
.45239 .02387 L
s
.45514 .09624 m
.45224 .0702 L
s
.45532 .14252 m
.45207 .11653 L
s
.45554 .1888 m
.45184 .16287 L
s
.45584 .23506 m
.45154 .20922 L
s
.45626 .2813 m
.45112 .25561 L
s
.45687 .32747 m
.45051 .30206 L
s
.45783 .3735 m
.44955 .34865 L
s
.45955 .4191 m
.44783 .39567 L
s
.46295 .46295 m
.44443 .44443 L
s
.46679 .5 m
.44059 .5 L
s
.46295 .53705 m
.44443 .55557 L
s
.45955 .5809 m
.44783 .60433 L
s
.45783 .6265 m
.44955 .65135 L
s
.45687 .67253 m
.45051 .69794 L
s
.45626 .7187 m
.45112 .74439 L
s
.45584 .76494 m
.45154 .79078 L
s
.45554 .8112 m
.45184 .83713 L
s
.45532 .85748 m
.45207 .88347 L
s
.45514 .90376 m
.45224 .9298 L
s
.45499 .95006 m
.45239 .97613 L
s
.5 .05001 m
.5 .02381 L
s
.5 .09632 m
.5 .07012 L
s
.5 .14262 m
.5 .11643 L
s
.5 .18893 m
.5 .16274 L
s
.5 .23524 m
.5 .20905 L
s
.5 .28155 m
.5 .25536 L
s
.5 .32786 m
.5 .30166 L
s
.5 .37417 m
.5 .34797 L
s
.5 .42048 m
.5 .39428 L
s
.5 .46679 m
.5 .44059 L
s
newpath
.5 .5 .00655 0 365.73 arc
s
.5 .53321 m
.5 .55941 L
s
.5 .57952 m
.5 .60572 L
s
.5 .62583 m
.5 .65203 L
s
.5 .67214 m
.5 .69834 L
s
.5 .71845 m
.5 .74464 L
s
.5 .76476 m
.5 .79095 L
s
.5 .81107 m
.5 .83726 L
s
.5 .85738 m
.5 .88357 L
s
.5 .90368 m
.5 .92988 L
s
.5 .94999 m
.5 .97619 L
s
.54501 .04994 m
.54761 .02387 L
s
.54486 .09624 m
.54776 .0702 L
s
.54468 .14252 m
.54793 .11653 L
s
.54446 .1888 m
.54816 .16287 L
s
.54416 .23506 m
.54846 .20922 L
s
.54374 .2813 m
.54888 .25561 L
s
.54313 .32747 m
.54949 .30206 L
s
.54217 .3735 m
.55045 .34865 L
s
.54045 .4191 m
.55217 .39567 L
s
.53705 .46295 m
.55557 .44443 L
s
.53321 .5 m
.55941 .5 L
s
.53705 .53705 m
.55557 .55557 L
s
.54045 .5809 m
.55217 .60433 L
s
.54217 .6265 m
.55045 .65135 L
s
.54313 .67253 m
.54949 .69794 L
s
.54374 .7187 m
.54888 .74439 L
s
.54416 .76494 m
.54846 .79078 L
s
.54446 .8112 m
.54816 .83713 L
s
.54468 .85748 m
.54793 .88347 L
s
.54486 .90376 m
.54776 .9298 L
s
.54501 .95006 m
.54761 .97613 L
s
.59005 .04975 m
.59519 .02406 L
s
.58978 .096 m
.59546 .07043 L
s
.58944 .14223 m
.5958 .11682 L
s
.58902 .18843 m
.59622 .16324 L
s
.58848 .23457 m
.59676 .20972 L
s
.58775 .28062 m
.59748 .25629 L
s
.58676 .32648 m
.59848 .30305 L
s
.58535 .37197 m
.59988 .35017 L
s
.58336 .41664 m
.60188 .39812 L
s
.5809 .45955 m
.60433 .44783 L
s
.57952 .5 m
.60572 .5 L
s
.5809 .54045 m
.60433 .55217 L
s
.58336 .58336 m
.60188 .60188 L
s
.58535 .62803 m
.59988 .64983 L
s
.58676 .67352 m
.59848 .69695 L
s
.58775 .71938 m
.59748 .74371 L
s
.58848 .76543 m
.59676 .79028 L
s
.58902 .81157 m
.59622 .83676 L
s
.58944 .85777 m
.5958 .88318 L
s
.58978 .904 m
.59546 .92957 L
s
.59005 .95025 m
.59519 .97594 L
s
.63516 .04945 m
.64269 .02436 L
s
.63479 .09564 m
.64307 .07079 L
s
.63433 .14179 m
.64353 .11726 L
s
.63377 .18787 m
.64409 .1638 L
s
.63307 .23386 m
.64479 .21043 L
s
.63219 .27969 m
.64567 .25722 L
s
.63107 .32524 m
.64679 .30428 L
s
.62967 .37033 m
.64819 .35181 L
s
.62803 .41465 m
.64983 .40012 L
s
.6265 .45783 m
.65135 .44955 L
s
.62583 .5 m
.65203 .5 L
s
.6265 .54217 m
.65135 .55045 L
s
.62803 .58535 m
.64983 .59988 L
s
.62967 .62967 m
.64819 .64819 L
s
.63107 .67476 m
.64679 .69572 L
s
.63219 .72031 m
.64567 .74278 L
s
.63307 .76614 m
.64479 .78957 L
s
.63377 .81213 m
.64409 .8362 L
s
.63433 .85821 m
.64353 .88274 L
s
.63479 .90436 m
.64307 .92921 L
s
.63516 .95055 m
.64269 .97564 L
s
.68037 .04907 m
.6901 .02475 L
s
.67992 .09519 m
.69056 .07125 L
s
.67938 .14124 m
.69109 .11781 L
s
.67874 .18721 m
.69174 .16446 L
s
.67797 .23304 m
.6925 .21125 L
s
.67705 .27868 m
.69342 .25823 L
s
.67598 .32402 m
.6945 .3055 L
s
.67476 .36893 m
.69572 .35321 L
s
.67352 .41324 m
.69695 .40152 L
s
.67253 .45687 m
.69794 .45051 L
s
.67214 .5 m
.69834 .5 L
s
.67253 .54313 m
.69794 .54949 L
s
.67352 .58676 m
.69695 .59848 L
s
.67476 .63107 m
.69572 .64679 L
s
.67598 .67598 m
.6945 .6945 L
s
.67705 .72132 m
.69342 .74177 L
s
.67797 .76696 m
.6925 .78875 L
s
.67874 .81279 m
.69174 .83554 L
s
.67938 .85876 m
.69109 .88219 L
s
.67992 .90481 m
.69056 .92875 L
s
.68037 .95093 m
.6901 .97525 L
s
.72569 .04862 m
.7374 .02519 L
s
.72519 .09467 m
.73791 .07177 L
s
.7246 .14063 m
.73849 .11842 L
s
.72393 .18649 m
.73916 .16518 L
s
.72316 .23221 m
.73993 .21208 L
s
.72228 .27772 m
.74081 .25919 L
s
.72132 .32295 m
.74177 .30658 L
s
.72031 .36781 m
.74278 .35433 L
s
.71938 .41225 m
.74371 .40252 L
s
.7187 .45626 m
.74439 .45112 L
s
.71845 .5 m
.74464 .5 L
s
.7187 .54374 m
.74439 .54888 L
s
.71938 .58775 m
.74371 .59748 L
s
.72031 .63219 m
.74278 .64567 L
s
.72132 .67705 m
.74177 .69342 L
s
.72228 .72228 m
.74081 .74081 L
s
.72316 .76779 m
.73993 .78792 L
s
.72393 .81351 m
.73916 .83482 L
s
.7246 .85937 m
.73849 .88158 L
s
.72519 .90533 m
.73791 .92823 L
s
.72569 .95138 m
.7374 .97481 L
s
.77112 .04814 m
.78459 .02568 L
s
.77059 .09412 m
.78512 .07232 L
s
.77 .14 m
.78571 .11905 L
s
.76933 .18578 m
.78638 .16589 L
s
.76859 .23141 m
.78712 .21288 L
s
.76779 .27684 m
.78792 .26007 L
s
.76696 .32203 m
.78875 .3075 L
s
.76614 .36693 m
.78957 .35521 L
s
.76543 .41152 m
.79028 .40324 L
s
.76494 .45584 m
.79078 .45154 L
s
.76476 .5 m
.79095 .5 L
s
.76494 .54416 m
.79078 .54846 L
s
.76543 .58848 m
.79028 .59676 L
s
.76614 .63307 m
.78957 .64479 L
s
.76696 .67797 m
.78875 .6925 L
s
.76779 .72316 m
.78792 .73993 L
s
.76859 .76859 m
.78712 .78712 L
s
.76933 .81422 m
.78638 .83411 L
s
.77 .86 m
.78571 .88095 L
s
.77059 .90588 m
.78512 .92768 L
s
.77112 .95186 m
.78459 .97432 L
s
.81665 .04764 m
.83168 .02618 L
s
.81612 .09356 m
.83221 .07288 L
s
.81554 .13938 m
.83279 .11967 L
s
.8149 .1851 m
.83343 .16657 L
s
.81422 .23067 m
.83411 .21362 L
s
.81351 .27607 m
.83482 .26084 L
s
.81279 .32126 m
.83554 .30826 L
s
.81213 .36623 m
.8362 .35591 L
s
.81157 .41098 m
.83676 .40378 L
s
.8112 .45554 m
.83713 .45184 L
s
.81107 .5 m
.83726 .5 L
s
.8112 .54446 m
.83713 .54816 L
s
.81157 .58902 m
.83676 .59622 L
s
.81213 .63377 m
.8362 .64409 L
s
.81279 .67874 m
.83554 .69174 L
s
.81351 .72393 m
.83482 .73916 L
s
.81422 .76933 m
.83411 .78638 L
s
.8149 .8149 m
.83343 .83343 L
s
.81554 .86062 m
.83279 .88033 L
s
.81612 .90644 m
.83221 .92712 L
s
.81665 .95236 m
.83168 .97382 L
s
.86229 .04714 m
.87866 .02668 L
s
.86177 .09301 m
.87918 .07343 L
s
.86121 .13879 m
.87974 .12026 L
s
.86062 .18446 m
.88033 .16721 L
s
.86 .23 m
.88095 .21429 L
s
.85937 .2754 m
.88158 .26151 L
s
.85876 .32062 m
.88219 .30891 L
s
.85821 .36567 m
.88274 .35647 L
s
.85777 .41056 m
.88318 .4042 L
s
.85748 .45532 m
.88347 .45207 L
s
.85738 .5 m
.88357 .5 L
s
.85748 .54468 m
.88347 .54793 L
s
.85777 .58944 m
.88318 .5958 L
s
.85821 .63433 m
.88274 .64353 L
s
.85876 .67938 m
.88219 .69109 L
s
.85937 .7246 m
.88158 .73849 L
s
.86 .77 m
.88095 .78571 L
s
.86062 .81554 m
.88033 .83279 L
s
.86121 .86121 m
.87974 .87974 L
s
.86177 .90699 m
.87918 .92657 L
s
.86229 .95286 m
.87866 .97332 L
s
.90802 .04664 m
.92555 .02717 L
s
.90752 .09248 m
.92604 .07396 L
s
.90699 .13823 m
.92657 .12082 L
s
.90644 .18388 m
.92712 .16779 L
s
.90588 .22941 m
.92768 .21488 L
s
.90533 .27481 m
.92823 .26209 L
s
.90481 .32008 m
.92875 .30944 L
s
.90436 .36521 m
.92921 .35693 L
s
.904 .41022 m
.92957 .40454 L
s
.90376 .45514 m
.9298 .45224 L
s
.90368 .5 m
.92988 .5 L
s
.90376 .54486 m
.9298 .54776 L
s
.904 .58978 m
.92957 .59546 L
s
.90436 .63479 m
.92921 .64307 L
s
.90481 .67992 m
.92875 .69056 L
s
.90533 .72519 m
.92823 .73791 L
s
.90588 .77059 m
.92768 .78512 L
s
.90644 .81612 m
.92712 .83221 L
s
.90699 .86177 m
.92657 .87918 L
s
.90752 .90752 m
.92604 .92604 L
s
.90802 .95336 m
.92555 .97283 L
s
.95383 .04617 m
.97235 .02765 L
s
.95336 .09198 m
.97283 .07445 L
s
.95286 .13771 m
.97332 .12134 L
s
.95236 .18335 m
.97382 .16832 L
s
.95186 .22888 m
.97432 .21541 L
s
.95138 .27431 m
.97481 .2626 L
s
.95093 .31963 m
.97525 .3099 L
s
.95055 .36484 m
.97564 .35731 L
s
.95025 .40995 m
.97594 .40481 L
s
.95006 .45499 m
.97613 .45239 L
s
.94999 .5 m
.97619 .5 L
s
.95006 .54501 m
.97613 .54761 L
s
.95025 .59005 m
.97594 .59519 L
s
.95055 .63516 m
.97564 .64269 L
s
.95093 .68037 m
.97525 .6901 L
s
.95138 .72569 m
.97481 .7374 L
s
.95186 .77112 m
.97432 .78459 L
s
.95236 .81665 m
.97382 .83168 L
s
.95286 .86229 m
.97332 .87866 L
s
.95336 .90802 m
.97283 .92555 L
s
.95383 .95383 m
.97235 .97235 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00=?ooool3o`0002gooooo1Ol0000]ooooo`;o0000
;_ooool5o`0002oooooo0ol0000Sooooo`00=Oooool00ol0003oooooooooo`0]ooooo`04o`000?oo
ooooooooo`0002cooooo00Co0000oooooooooooo0000;_ooool01?l0003oooooooooool0000`oooo
o`03o`000?oooooooooo02;ooooo000/ooooo`Go000000?oooooo`000?l000000ol0000Wooooo`Go
00000oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0002oooooo00?o0000oooo
ooooool0;Oooool5o`0002?ooooo000booooo`04o`000?ooooooooooo`00037ooooo00?o0000oooo
ooooool0:oooool01?l0003oooooooooool0000`ooooo`03o`000?oooooooooo02cooooo00Co0000
oooooooooooo00009?ooool003?ooooo00?o0000ooooool00000;_ooool01Ol0003ooooooooooooo
oooo000002cooooo00Co0000oooooooooooo0000;Oooool01Ol0003ooooooooooooooooo000002ko
oooo00?o0000ooooool000009?ooool003Cooooo0_l0000^ooooo`05o`000?ooooooooooooooool0
0000;?ooool01?l0003oooooooooool0000]ooooo`05o`000?ooooooooooooooool00000;oooool2
o`0002Cooooo000eooooo`03o`000?oooooooooo02gooooo0ol0000^ooooo`;o0000;oooool3o`00
037ooooo00?o0000ooooooooool08_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000ooooooool0000Ao`00007ooooo000?ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool08?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo03Oooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
=oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Ooo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Cooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`05ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02oooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo0_l00007ooooo`03o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9koooooooooo`05ooooo`;o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool00ol0003o0ZRNo`00000;o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNooooooooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool0
2?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?l000002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000colcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI033oc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol2Z9koc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0000FolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T04_o<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN0_l00009olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI0_l000000ooooooo0ZRNo`:XWP06ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool00ol2Z9ko0000olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI
0_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool000oooooo0_l00007ooooo`03o`000?l2
Z9ko0ZRN00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`;o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_l0003o000000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00003_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001TolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
HOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l00019olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@15olcVf@;o00002Oooool1o`00007ooooo0008ooooo`?o00001?ooool00ol0003ooooooooo
o`04ooooo`;o0ZRN0_l00009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oo
oooooooo00Cooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Kooooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@;o000000?ooooo
o`:XW_ooool01_ooool1o`00007ooooo0005o`000003ooooool0003o000000?o00001?ooool00ol0
003oooooooooo`06ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00
0003o`:XW_oooooooooo00Kooooo0Ol00001ooooo`001_ooool01?l0003oooooooooool00005oooo
o`?o00001_ooool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0
003o0ZRNooooo`07ooooo`;o00000Oooool000Oooooo00?o0000ooooool000001Oooool00ol0003o
ooooooooo`06ooooo`;o000000?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000ooooooooool0
1_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_l0003o000000Wooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Kooooo0_l00010olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0??o<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0002ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0;?o<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN0_l00009olcVf@;o0ZRN2_o<i]T2o`:X
WP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPOoc>KI0_l000000ooooooo0ZRNo`:XWP06oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol2Z9ko0000olcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool000oooooo
0_l00007ooooo`03o`000?l2Z9ko0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h:olcVf@;o0ZRN2?ooool2o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNo`000?l000002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
1?l2Z9koc>KIo`000?l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0001_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0GolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001TolcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T0HOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0001RolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T0Goo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00008_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T07oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`;o0ZRN
0_l00009olcVf@;o0ZRN2_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN1oo<i]T2o`000003oooo
ool2Z9ko0ZRN00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`:XW_l0
003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Kooooo0Ol0
0001ooooo`003oooool2o`0000Oooooo00?o0000o`:XW_l2Z9h02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2?ooool2o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNo`000?l000002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9ko
c>KIo`000?l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0004co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI04Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001EolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI05;oc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0001Goc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<
i]T2o`:XWP[oc>KI0_l2Z9hDolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Cooooo0_l2Z9h2o`0000Soc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T2o`:XWPOoc>KI0_l00002ooooo`;o0ZRN1Oooool1o`00007ooooo000?oooo
o`;o00001oooool2o`:XWP[oc>KI0ol2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T2o`:XWP[oc>KI0_l2Z9h<olcVf@;o0ZRN2Oo<i]T01?l0003o0ZRNo`:XW_l2Z9h6
ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0000;o0ZRN2oo<i]T2o`:X
WP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2_o<i]T2o`:X
WP03o`000?oooooooooo00Oooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00Co0ZRNolcVfOl0
003o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000dolcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI037oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0006Goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@1RolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006ooc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI06coc>KI
0_l00009ooooo`7o00000Oooool000Kooooo1Ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0
0018olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@15olcVf@;o00002Oooool1o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o
0000ooooooooool01_ooool2o`0000Soc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2
Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2
Z9h7olcVf@;o00002Oooool1o`00007ooooo0005o`0000?ooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`04ooooo`?o0ZRN00?o0000olcVfOo<i]T02?o<i]T3o`:XWP[oc>KI0_l2Z9h;
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08
olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o00000Ooo
ool000Wooooo00?o0000ooooooooool00oooool3o`0000Kooooo00Co0000o`:XW_l2Z9ko0ZRN2oo<
i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@?o0ZRN1ooo
ool2o`00007ooooo0006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`06ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2
Z9h2o`0000Wooooo0Ol00001ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool01_ooool2o`0002Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI02Coc>KI0_l00009ooooo`7o00000Oooool000Oooooo0ol00005
ooooo`03o`000?oooooooooo00Kooooo0_l0001IolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI05Koc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001_olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@1/olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l00018olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWTKo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool2o`:XWP;o0000
2?o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o0ZRN
2_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWPOoc>KI0_l00002ooooo`;o0ZRN
1Oooool1o`00007ooooo000?ooooo`;o00001oooool2o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<
i]T3o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T3o`:XWP[oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<
i]T3o`:XWPWoc>KI0ol2Z9h9olcVf@04o`000?l2Z9ko0ZRNo`:XWPKooooo0_l00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o00000_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2
Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2
Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP03o`000?oooooooooo00Oooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00Co0ZRNolcVfOl0003o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@1:olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001aolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2
Z9koc>KIolcVf@1^olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000K_o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0Joo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000Aoo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9i6olcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00?ooooo0ol2Z9h2o`0000Soc>KI0ol2
Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN3?o<i]T2o`:XWP_oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2
Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o0000
0Oooool000oooooo0_l00007ooooo`?o0ZRN2_o<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<
i]T3o`:XWPWoc>KI0ol2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<
i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h7ooooo`;o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9ko0ZRN00_oc>KI0_l2Z9h;
olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000C_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T0B_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000I_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI06?o
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006koc>KI00?o0ZRNolcVfOo<i]T03?o<
i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI06[oc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0005Coc>KI0_l2Z9h:olcVf@;o0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2
o`:XWP_oc>KI0_l2Z9iBolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00?ooooo1Ol2Z9h8olcVf@Go0ZRN2?o<i]T5o`:XWPOoc>KI1Ol2Z9h8olcVf@Go0ZRN1oo<i]T5o`:X
WPSoc>KI1Ol2Z9h:olcVf@;o0ZRN2_o<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T4o`:X
WPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8olcVf@Co0ZRN1oo<i]T2o`00
00Co0ZRN1Oooool1o`00007ooooo000?ooooo`;o00001oooool2o`0000?o0ZRN2_o<i]T3o`:XWP[o
c>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T2o`:XWP_o
c>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@08olcVf@;o0ZRN2_o<i]T2o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2Oo<i]T4o`:XWPSo
c>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8ooooo`;o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0005[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0Eoo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000Loo<i]T00ol2Z9koc>KIolcV
f@07olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T0Koo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo0008ooooo`;o00001Oooool00ol0003oooooooooo`06ooooo`;o0000O?o<i]T2o`:XWW_o
c>KI0_l00009ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003o
ooooooooo`06ooooo`;o0000Noo<i]T01?l2Z9koc>KIo`000?l2Z9ijolcVf@;o00002Oooool1o`00
007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo0ol00003ooooo`So0ZRN1Ol00008o`:X
WPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:X
WPGo00002?l2Z9h5o`0000So0ZRN1_l000001?l2Z9ko0000o`000?l2Z9h7o`0000So0ZRN1?l00008
o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008
o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?ooool2o`00007ooooo0007ooooo`04o`000?oooooooooo
o`0000Cooooo00?o0000ooooooooool01_ooool2o`0007_oc>KI0_l2Z9h00ol0003o0ZRNolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`001oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Sooooo0_l00005oooo
o`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2
Z9koc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001colcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9ko
c>KIolcVf@1_olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001VolcVf@;o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWVCoc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool00ol0003o0ZRNo`:XWP02o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<
i]T4o`:XWPWoc>KI1?l2Z9h8olcVf@Co0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h8olcVf@?o0ZRN2oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWPSoc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T5o`:XWPSoc>KI1Ol2Z9h7olcVf@Go0ZRN2?o<
i]T5o`:XWPOoc>KI1Ol2Z9h8olcVf@Go0ZRN2?ooool1o`00007ooooo000?ooooo`;o00001?ooool4
o`:XWP03o`000?o<i]Woc>KI00Koc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8
olcVf@Co0ZRN2oo<i]T3o`:XWP[oc>KI0ol2Z9h8olcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPWoc>KI0ol2Z9h9
olcVf@?o0ZRN3?o<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h7
olcVf@;o000000Coooooo`:XW_l2Z9ko0ZRN1?ooool2o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l00017olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWTKoc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0006koc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI06[oc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007;oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:X
W_o<i]Woc>KI06koc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0005Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWUSoc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0001[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3
o`:XWQSoc>KI0_l00009ooooo`7o00000Oooool000oooooo0_l00007ooooo`03o`000?l2Z9ko0ZRN
00;o0ZRN2Oo<i]T4o`:XWPOoc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0ol2Z9h:olcV
f@?o0ZRN2Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@;o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2Z9h;olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h6olcV
f@Go0ZRN2?o<i]T5o`:XWPOooooo0_l00001ooooo`003oooool00ol0003oooooooooo`03ooooo`Co
0ZRN00?o0000olcVfOo<i]T01_o<i]T4o`:XWPWoc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_o
c>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@?o0ZRN1oo<i]T2o`000004
ooooool2Z9ko0ZRNo`:XWPGooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000>_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03Ooc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00067oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@1NolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001^olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@1[olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000FOo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1F
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000colcV
f@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h:olcV
f@;o0ZRN2oo<i]T2o`:XWS;oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`000003olcVfOl2Z9ko0ZRN00[oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T3o`:XWPWo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9ko
c>KIolcVf@07olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN00?o0000oooooooo
ool01oooool1o`00007ooooo000?ooooo`;o00001oooool3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN
2Oo<i]T3o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@?o0ZRN
2_o<i]T3o`:XWPWoc>KI0ol2Z9h9olcVf@04o`000?l2Z9ko0ZRNo`:XWPKooooo0_l00001ooooo`00
3oooool00ol0003oooooooooo`04ooooo`;o0ZRN0_l00008olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN1oo<i]T2o`0000;ooooo
0_l2Z9h5ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0002koc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T0:oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000H_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI05koc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001UolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0H_o<i]T2o`00
00Wooooo0Ol00001ooooo`001_ooool5o`0000Cooooo00?o0000ooooooooool01_ooool2o`00043o
c>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03goc>KI0_l00009ooooo`7o00000Oooool000Oooooo
00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2
Z9h02oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o
0ZRN2_o<i]T2o`:XWP;o00002Oooool1o`00007ooooo0008ooooo`03o`000?oooooooooo00Cooooo
0ol00006ooooo`03o`000?l2Z9ko0ZRN00[oc>KI0ol2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI
0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0ol2Z9h7ooooo`;o00000Oooool000Wooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`;o0ZRN00?o0000olcVfOo<i]T01oo<
i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2?o<
i]T2o`000003ooooool2Z9ko0ZRN00Kooooo0Ol00001ooooo`001_ooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool01?ooool01?l2Z9koooooo`000?l00008olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Goc>KI0_l00003ooooo`03o`:XW_oooooooooo00?ooooo0Ol00001ooooo`001_oo
ool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01_ooool2o`0003_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0holcVf@;o00002Oooool1o`00007ooooo
0007ooooo`?o00001Oooool00ol0003oooooooooo`06ooooo`;o0000H_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI05ooc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001=olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@19olcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRNo`:XWP0;olcV
f@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcV
f@;o0ZRN0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003
o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2Oooool1o`00007ooooo000?ooooo`;o0000
1oooool2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN
2_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;o000000?o0ZRNooooooooool01Oooool2o`00007ooooo
000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002Oo<i]T2o`:XWP_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l0
00000ooooooo0ZRNo`:XWP06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool0
1?l2Z9koooooo`000?l00008olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_l00003ooooo`03o`:XW_oo
oooooooo00?ooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000>oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03Soc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0006ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI06coc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000FOo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1EolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000JolcVf@;o
0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T2o`:XWQWoc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`000003olcVfOl2Z9ko0ZRN00[oc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWP[oc>KI0_l2Z9h2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`03o`000?l2Z9ko0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWPWooooo0Ol00001ooooo`003oooool2o`0000Kooooo0_l2Z9h00ol0003oc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@;o0ZRN2Oo<i]T2o`0000;o0ZRN1_ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo
00Cooooo00Co0ZRNooooool0003o00002_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000_ooool0
0ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000B?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T0AOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003Coc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
<?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o
c>KIo`:XW_l2Z9h02_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2
Z9h:olcVf@;o0ZRN0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000ooooo`08
ooooo`7o00000Oooool000oooooo0_l00007ooooo`;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPWoc>KI00?o0000o`:X
W_l2Z9h01oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l0
00002_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Cooooo00Co0ZRNooooool0003o00002Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@05olcVf@;o00000_ooool00ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0001Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0BolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001SolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0Goo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001HolcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI05Goc>KI0_l00009ooooo`7o00000Oooool000Sooooo0ol00004ooooo`03o`000?oooooo
oooo00Kooooo0_l0000>olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l00009ooooo`7o00000Oooool0
00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:X
W_l2Z9h02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN00?o0000ooooooooool01oooool1o`00
007ooooo0006ooooo`Go00001?ooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`00
1_ooool01?l0003oooooooooool00005ooooo`?o00001_ooool2o`:XWP_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0_l00001ooooo`001oooool00ol0003ooooo
o`000005ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@07olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo0008ooooo`;o00001Ooo
ool00ol0003oooooooooo`04ooooo`04o`:XW_oooooo0000o`0000Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
1_o<i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1o`00007ooooo0009ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool01_ooool2o`0002ooc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0;?o<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0003?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0<?o<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2Z9h02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o000000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`003oooool2o`0000Oooooo00?o0000o`:XW_o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oooooo0_l00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T2o`000003o`:XW_oooooooooo00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05
ooooo`03o`:XW_l0003o000000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003ooooool2Z9ko
oooo00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`04o`:XW_oooooo0000
o`0000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00019olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@16olcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006Coc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1QolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNo`000?l000002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l000000ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNo`000?ooool0
2?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo00?o0000o`:XW_o<i]T03?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003oooool2
o`0000Oooooo00?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000;o`000003o`:XW_oooooo
oooo00Gooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003o0000
00_o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ooooooo0ZRNooooo`06ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01?ooool00ol2Z9koooooooooo`0;ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00_o
oooo00?o0ZRNooooooooool01?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo017ooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo
00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo
00?o0ZRNooooooooool04Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0
;oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0
;oooool00ol0003oooooooooo`0Pooooo`7o00000Oooool000oooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01ooo
ool1o`00007ooooo000?oooooooo00004Ol00001ooooo`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-6.01076, -5.95359, 0.039771, \
0.039771}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 0.5. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{k, 4}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), 4}, {\(-4\), 4}, {\(-3\), 4}, {\(-2\), 4}, {\(-1\), 4}, {0, 
        4}, {1, 4}, {2, 4}, {3, 4}, {4, 4}, {5, 4}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t2 = Table[{k, \(-4\)}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), \(-4\)}, {\(-4\), \(-4\)}, {\(-3\), \(-4\)}, {\(-2\), \
\(-4\)}, {\(-1\), \(-4\)}, {0, \(-4\)}, {1, \(-4\)}, {2, \(-4\)}, {3, \
\(-4\)}, {4, \(-4\)}, {5, \(-4\)}}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(thePoints = Join[t1, t2];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Produce Final Output", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayAll;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[.1 -0.0125 -6 -9 ]
[.1 -0.0125 6 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7 -0.0125 -3 -9 ]
[.7 -0.0125 3 0 ]
[.9 -0.0125 -3 -9 ]
[.9 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .1 -12 -4.5 ]
[-0.0125 .1 0 4.5 ]
[-0.0125 .3 -12 -4.5 ]
[-0.0125 .3 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7 -6 -4.5 ]
[-0.0125 .7 0 4.5 ]
[-0.0125 .9 -6 -4.5 ]
[-0.0125 .9 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1 0 m
.1 .00625 L
s
[(-4)] .1 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-2)] .3 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(2)] .7 -0.0125 0 1 Mshowa
.9 0 m
.9 .00625 L
s
[(4)] .9 -0.0125 0 1 Mshowa
.125 Mabswid
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.25 0 m
.25 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.75 0 m
.75 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.05 0 m
.05 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .1 m
.00625 .1 L
s
[(-4)] -0.0125 .1 1 0 Mshowa
0 .3 m
.00625 .3 L
s
[(-2)] -0.0125 .3 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7 m
.00625 .7 L
s
[(2)] -0.0125 .7 1 0 Mshowa
0 .9 m
.00625 .9 L
s
[(4)] -0.0125 .9 1 0 Mshowa
.125 Mabswid
0 .15 m
.00375 .15 L
s
0 .2 m
.00375 .2 L
s
0 .25 m
.00375 .25 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .45 m
.00375 .45 L
s
0 .55 m
.00375 .55 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .75 m
.00375 .75 L
s
0 .8 m
.00375 .8 L
s
0 .85 m
.00375 .85 L
s
0 .05 m
.00375 .05 L
s
0 .95 m
.00375 .95 L
s
.25 Mabswid
0 0 m
0 1 L
s
.1 .99375 m
.1 1 L
s
.3 .99375 m
.3 1 L
s
.5 .99375 m
.5 1 L
s
.7 .99375 m
.7 1 L
s
.9 .99375 m
.9 1 L
s
.125 Mabswid
.15 .99625 m
.15 1 L
s
.2 .99625 m
.2 1 L
s
.25 .99625 m
.25 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.45 .99625 m
.45 1 L
s
.55 .99625 m
.55 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.75 .99625 m
.75 1 L
s
.8 .99625 m
.8 1 L
s
.85 .99625 m
.85 1 L
s
.05 .99625 m
.05 1 L
s
.95 .99625 m
.95 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .1 m
1 .1 L
s
.99375 .3 m
1 .3 L
s
.99375 .5 m
1 .5 L
s
.99375 .7 m
1 .7 L
s
.99375 .9 m
1 .9 L
s
.125 Mabswid
.99625 .15 m
1 .15 L
s
.99625 .2 m
1 .2 L
s
.99625 .25 m
1 .25 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .45 m
1 .45 L
s
.99625 .55 m
1 .55 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .75 m
1 .75 L
s
.99625 .8 m
1 .8 L
s
.99625 .85 m
1 .85 L
s
.99625 .05 m
1 .05 L
s
.99625 .95 m
1 .95 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
.01 .01 m
0 0 rlineto s
.01 .01 m
0 0 L
s
.01051 .05946 m
0 0 rlineto s
.01051 .05946 m
0 .05 L
s
.01104 .10883 m
0 0 rlineto s
.01104 .10883 m
0 .1 L
s
.01159 .15811 m
0 0 rlineto s
.01159 .15811 m
0 .15 L
s
.01213 .20728 m
0 0 rlineto s
.01213 .20728 m
0 .2 L
s
.01265 .25632 m
0 0 rlineto s
.01265 .25632 m
0 .25 L
s
.01313 .30525 m
0 0 rlineto s
.01313 .30525 m
0 .3 L
s
.01355 .35406 m
0 0 rlineto s
.01355 .35406 m
0 .35 L
s
.01387 .40277 m
0 0 rlineto s
.01387 .40277 m
0 .4 L
s
.01407 .45141 m
0 0 rlineto s
.01407 .45141 m
0 .45 L
s
.01414 .5 m
0 0 rlineto s
.01414 .5 m
0 .5 L
s
.01407 .54859 m
0 0 rlineto s
.01407 .54859 m
0 .55 L
s
.01387 .59723 m
0 0 rlineto s
.01387 .59723 m
0 .6 L
s
.01355 .64594 m
0 0 rlineto s
.01355 .64594 m
0 .65 L
s
.01313 .69475 m
0 0 rlineto s
.01313 .69475 m
0 .7 L
s
.01265 .74368 m
0 0 rlineto s
.01265 .74368 m
0 .75 L
s
.01213 .79272 m
0 0 rlineto s
.01213 .79272 m
0 .8 L
s
.01159 .84189 m
0 0 rlineto s
.01159 .84189 m
0 .85 L
s
.01104 .89117 m
0 0 rlineto s
.01104 .89117 m
0 .9 L
s
.01051 .94054 m
0 0 rlineto s
.01051 .94054 m
0 .95 L
s
.01 .99 m
0 0 rlineto s
.01 .99 m
0 1 L
s
.05946 .01051 m
0 0 rlineto s
.05946 .01051 m
.05 0 L
s
.06 .06 m
.04 .04 L
s
.06057 .1094 m
.03943 .0906 L
s
.06116 .15868 m
.03884 .14132 L
s
.06177 .20784 m
.03823 .19216 L
s
.06236 .25687 m
.03764 .24313 L
s
.06292 .30574 m
.03708 .29426 L
s
.06342 .35447 m
.03658 .34553 L
s
.06381 .40307 m
.03619 .39693 L
s
.06406 .45156 m
.03594 .44844 L
s
.06414 .5 m
.03586 .5 L
s
.06406 .54844 m
.03594 .55156 L
s
.06381 .59693 m
.03619 .60307 L
s
.06342 .64553 m
.03658 .65447 L
s
.06292 .69426 m
.03708 .70574 L
s
.06236 .74313 m
.03764 .75687 L
s
.06177 .79216 m
.03823 .80784 L
s
.06116 .84132 m
.03884 .85868 L
s
.06057 .8906 m
.03943 .9094 L
s
.06 .94 m
.04 .96 L
s
.05946 .98949 m
0 0 rlineto s
.05946 .98949 m
.05 1 L
s
.10883 .01104 m
0 0 rlineto s
.10883 .01104 m
.1 0 L
s
.1094 .06057 m
.0906 .03943 L
s
.11 .11 m
.09 .09 L
s
.11064 .15931 m
.08936 .14069 L
s
.11131 .20849 m
.08869 .19151 L
s
.11199 .2575 m
.08801 .2425 L
s
.11265 .30632 m
.08735 .29368 L
s
.11324 .35497 m
.08676 .34503 L
s
.11372 .40343 m
.08628 .39657 L
s
.11403 .45175 m
.08597 .44825 L
s
.11414 .5 m
.08586 .5 L
s
.11403 .54825 m
.08597 .55175 L
s
.11372 .59657 m
.08628 .60343 L
s
.11324 .64503 m
.08676 .65497 L
s
.11265 .69368 m
.08735 .70632 L
s
.11199 .7425 m
.08801 .7575 L
s
.11131 .79151 m
.08869 .80849 L
s
.11064 .84069 m
.08936 .85931 L
s
.11 .89 m
.09 .91 L
s
.1094 .93943 m
.0906 .96057 L
s
.10883 .98896 m
0 0 rlineto s
.10883 .98896 m
.1 1 L
s
.15811 .01159 m
0 0 rlineto s
.15811 .01159 m
.15 0 L
s
.15868 .06116 m
.14132 .03884 L
s
.15931 .11064 m
.14069 .08936 L
s
.16 .16 m
.14 .14 L
s
.16074 .2092 m
.13926 .1908 L
s
.16151 .25822 m
.13849 .24178 L
s
.16228 .30702 m
.13772 .29298 L
s
.163 .35557 m
.137 .34443 L
s
.1636 .40389 m
.1364 .39611 L
s
.164 .452 m
.136 .448 L
s
.16414 .5 m
.13586 .5 L
s
.164 .548 m
.136 .552 L
s
.1636 .59611 m
.1364 .60389 L
s
.163 .64443 m
.137 .65557 L
s
.16228 .69298 m
.13772 .70702 L
s
.16151 .74178 m
.13849 .75822 L
s
.16074 .7908 m
.13926 .8092 L
s
.16 .84 m
.14 .86 L
s
.15931 .88936 m
.14069 .91064 L
s
.15868 .93884 m
.14132 .96116 L
s
.15811 .98841 m
0 0 rlineto s
.15811 .98841 m
.15 1 L
s
.20728 .01213 m
0 0 rlineto s
.20728 .01213 m
.2 0 L
s
.20784 .06177 m
.19216 .03823 L
s
.20849 .11131 m
.19151 .08869 L
s
.2092 .16074 m
.1908 .13926 L
s
.21 .21 m
.19 .19 L
s
.21086 .25905 m
.18914 .24095 L
s
.21177 .30784 m
.18823 .29216 L
s
.21265 .35632 m
.18735 .34368 L
s
.21342 .40447 m
.18658 .39553 L
s
.21395 .45232 m
.18605 .44768 L
s
.21414 .5 m
.18586 .5 L
s
.21395 .54768 m
.18605 .55232 L
s
.21342 .59553 m
.18658 .60447 L
s
.21265 .64368 m
.18735 .65632 L
s
.21177 .69216 m
.18823 .70784 L
s
.21086 .74095 m
.18914 .75905 L
s
.21 .79 m
.19 .81 L
s
.2092 .83926 m
.1908 .86074 L
s
.20849 .88869 m
.19151 .91131 L
s
.20784 .93823 m
.19216 .96177 L
s
.20728 .98787 m
0 0 rlineto s
.20728 .98787 m
.2 1 L
s
.25632 .01265 m
0 0 rlineto s
.25632 .01265 m
.25 0 L
s
.25687 .06236 m
.24313 .03764 L
s
.2575 .11199 m
.2425 .08801 L
s
.25822 .16151 m
.24178 .13849 L
s
.25905 .21086 m
.24095 .18914 L
s
.26 .26 m
.24 .24 L
s
.26104 .30883 m
.23896 .29117 L
s
.26213 .35728 m
.23787 .34272 L
s
.26313 .40525 m
.23687 .39475 L
s
.26387 .45277 m
.23613 .44723 L
s
.26414 .5 m
.23586 .5 L
s
.26387 .54723 m
.23613 .55277 L
s
.26313 .59475 m
.23687 .60525 L
s
.26213 .64272 m
.23787 .65728 L
s
.26104 .69117 m
.23896 .70883 L
s
.26 .74 m
.24 .76 L
s
.25905 .78914 m
.24095 .81086 L
s
.25822 .83849 m
.24178 .86151 L
s
.2575 .88801 m
.2425 .91199 L
s
.25687 .93764 m
.24313 .96236 L
s
.25632 .98735 m
0 0 rlineto s
.25632 .98735 m
.25 1 L
s
.30525 .01313 m
0 0 rlineto s
.30525 .01313 m
.3 0 L
s
.30574 .06292 m
.29426 .03708 L
s
.30632 .11265 m
.29368 .08735 L
s
.30702 .16228 m
.29298 .13772 L
s
.30784 .21177 m
.29216 .18823 L
s
.30883 .26104 m
.29117 .23896 L
s
.31 .31 m
.29 .29 L
s
.31131 .35849 m
.28869 .34151 L
s
.31265 .40632 m
.28735 .39368 L
s
.31372 .45343 m
.28628 .44657 L
s
.31414 .5 m
.28586 .5 L
s
.31372 .54657 m
.28628 .55343 L
s
.31265 .59368 m
.28735 .60632 L
s
.31131 .64151 m
.28869 .65849 L
s
.31 .69 m
.29 .71 L
s
.30883 .73896 m
.29117 .76104 L
s
.30784 .78823 m
.29216 .81177 L
s
.30702 .83772 m
.29298 .86228 L
s
.30632 .88735 m
.29368 .91265 L
s
.30574 .93708 m
.29426 .96292 L
s
.30525 .98687 m
0 0 rlineto s
.30525 .98687 m
.3 1 L
s
.35406 .01355 m
0 0 rlineto s
.35406 .01355 m
.35 0 L
s
.35447 .06342 m
.34553 .03658 L
s
.35497 .11324 m
.34503 .08676 L
s
.35557 .163 m
.34443 .137 L
s
.35632 .21265 m
.34368 .18735 L
s
.35728 .26213 m
.34272 .23787 L
s
.35849 .31131 m
.34151 .28869 L
s
.36 .36 m
.34 .34 L
s
.36177 .40784 m
.33823 .39216 L
s
.36342 .45447 m
.33658 .44553 L
s
.36414 .5 m
.33586 .5 L
s
.36342 .54553 m
.33658 .55447 L
s
.36177 .59216 m
.33823 .60784 L
s
.36 .64 m
.34 .66 L
s
.35849 .68869 m
.34151 .71131 L
s
.35728 .73787 m
.34272 .76213 L
s
.35632 .78735 m
.34368 .81265 L
s
.35557 .837 m
.34443 .863 L
s
.35497 .88676 m
.34503 .91324 L
s
.35447 .93658 m
.34553 .96342 L
s
.35406 .98645 m
0 0 rlineto s
.35406 .98645 m
.35 1 L
s
.40277 .01387 m
0 0 rlineto s
.40277 .01387 m
.4 0 L
s
.40307 .06381 m
.39693 .03619 L
s
.40343 .11372 m
.39657 .08628 L
s
.40389 .1636 m
.39611 .1364 L
s
.40447 .21342 m
.39553 .18658 L
s
.40525 .26313 m
.39475 .23687 L
s
.40632 .31265 m
.39368 .28735 L
s
.40784 .36177 m
.39216 .33823 L
s
.41 .41 m
.39 .39 L
s
.41265 .45632 m
.38735 .44368 L
s
.41414 .5 m
.38586 .5 L
s
.41265 .54368 m
.38735 .55632 L
s
.41 .59 m
.39 .61 L
s
.40784 .63823 m
.39216 .66177 L
s
.40632 .68735 m
.39368 .71265 L
s
.40525 .73687 m
.39475 .76313 L
s
.40447 .78658 m
.39553 .81342 L
s
.40389 .8364 m
.39611 .8636 L
s
.40343 .88628 m
.39657 .91372 L
s
.40307 .93619 m
.39693 .96381 L
s
.40277 .98613 m
0 0 rlineto s
.40277 .98613 m
.4 1 L
s
.45141 .01407 m
0 0 rlineto s
.45141 .01407 m
.45 0 L
s
.45156 .06406 m
.44844 .03594 L
s
.45175 .11403 m
.44825 .08597 L
s
.452 .164 m
.448 .136 L
s
.45232 .21395 m
.44768 .18605 L
s
.45277 .26387 m
.44723 .23613 L
s
.45343 .31372 m
.44657 .28628 L
s
.45447 .36342 m
.44553 .33658 L
s
.45632 .41265 m
.44368 .38735 L
s
.46 .46 m
.44 .44 L
s
.46414 .5 m
.43586 .5 L
s
.46 .54 m
.44 .56 L
s
.45632 .58735 m
.44368 .61265 L
s
.45447 .63658 m
.44553 .66342 L
s
.45343 .68628 m
.44657 .71372 L
s
.45277 .73613 m
.44723 .76387 L
s
.45232 .78605 m
.44768 .81395 L
s
.452 .836 m
.448 .864 L
s
.45175 .88597 m
.44825 .91403 L
s
.45156 .93594 m
.44844 .96406 L
s
.45141 .98593 m
0 0 rlineto s
.45141 .98593 m
.45 1 L
s
.5 .01414 m
0 0 rlineto s
.5 .01414 m
.5 0 L
s
.5 .06414 m
.5 .03586 L
s
.5 .11414 m
.5 .08586 L
s
.5 .16414 m
.5 .13586 L
s
.5 .21414 m
.5 .18586 L
s
.5 .26414 m
.5 .23586 L
s
.5 .31414 m
.5 .28586 L
s
.5 .36414 m
.5 .33586 L
s
.5 .41414 m
.5 .38586 L
s
.5 .46414 m
.5 .43586 L
s
newpath
.5 .5 .00707 0 365.73 arc
s
.5 .53586 m
.5 .56414 L
s
.5 .58586 m
.5 .61414 L
s
.5 .63586 m
.5 .66414 L
s
.5 .68586 m
.5 .71414 L
s
.5 .73586 m
.5 .76414 L
s
.5 .78586 m
.5 .81414 L
s
.5 .83586 m
.5 .86414 L
s
.5 .88586 m
.5 .91414 L
s
.5 .93586 m
.5 .96414 L
s
.5 .98586 m
0 0 rlineto s
.5 .98586 m
.5 1 L
s
.54859 .01407 m
0 0 rlineto s
.54859 .01407 m
.55 0 L
s
.54844 .06406 m
.55156 .03594 L
s
.54825 .11403 m
.55175 .08597 L
s
.548 .164 m
.552 .136 L
s
.54768 .21395 m
.55232 .18605 L
s
.54723 .26387 m
.55277 .23613 L
s
.54657 .31372 m
.55343 .28628 L
s
.54553 .36342 m
.55447 .33658 L
s
.54368 .41265 m
.55632 .38735 L
s
.54 .46 m
.56 .44 L
s
.53586 .5 m
.56414 .5 L
s
.54 .54 m
.56 .56 L
s
.54368 .58735 m
.55632 .61265 L
s
.54553 .63658 m
.55447 .66342 L
s
.54657 .68628 m
.55343 .71372 L
s
.54723 .73613 m
.55277 .76387 L
s
.54768 .78605 m
.55232 .81395 L
s
.548 .836 m
.552 .864 L
s
.54825 .88597 m
.55175 .91403 L
s
.54844 .93594 m
.55156 .96406 L
s
.54859 .98593 m
0 0 rlineto s
.54859 .98593 m
.55 1 L
s
.59723 .01387 m
0 0 rlineto s
.59723 .01387 m
.6 0 L
s
.59693 .06381 m
.60307 .03619 L
s
.59657 .11372 m
.60343 .08628 L
s
.59611 .1636 m
.60389 .1364 L
s
.59553 .21342 m
.60447 .18658 L
s
.59475 .26313 m
.60525 .23687 L
s
.59368 .31265 m
.60632 .28735 L
s
.59216 .36177 m
.60784 .33823 L
s
.59 .41 m
.61 .39 L
s
.58735 .45632 m
.61265 .44368 L
s
.58586 .5 m
.61414 .5 L
s
.58735 .54368 m
.61265 .55632 L
s
.59 .59 m
.61 .61 L
s
.59216 .63823 m
.60784 .66177 L
s
.59368 .68735 m
.60632 .71265 L
s
.59475 .73687 m
.60525 .76313 L
s
.59553 .78658 m
.60447 .81342 L
s
.59611 .8364 m
.60389 .8636 L
s
.59657 .88628 m
.60343 .91372 L
s
.59693 .93619 m
.60307 .96381 L
s
.59723 .98613 m
0 0 rlineto s
.59723 .98613 m
.6 1 L
s
.64594 .01355 m
0 0 rlineto s
.64594 .01355 m
.65 0 L
s
.64553 .06342 m
.65447 .03658 L
s
.64503 .11324 m
.65497 .08676 L
s
.64443 .163 m
.65557 .137 L
s
.64368 .21265 m
.65632 .18735 L
s
.64272 .26213 m
.65728 .23787 L
s
.64151 .31131 m
.65849 .28869 L
s
.64 .36 m
.66 .34 L
s
.63823 .40784 m
.66177 .39216 L
s
.63658 .45447 m
.66342 .44553 L
s
.63586 .5 m
.66414 .5 L
s
.63658 .54553 m
.66342 .55447 L
s
.63823 .59216 m
.66177 .60784 L
s
.64 .64 m
.66 .66 L
s
.64151 .68869 m
.65849 .71131 L
s
.64272 .73787 m
.65728 .76213 L
s
.64368 .78735 m
.65632 .81265 L
s
.64443 .837 m
.65557 .863 L
s
.64503 .88676 m
.65497 .91324 L
s
.64553 .93658 m
.65447 .96342 L
s
.64594 .98645 m
0 0 rlineto s
.64594 .98645 m
.65 1 L
s
.69475 .01313 m
0 0 rlineto s
.69475 .01313 m
.7 0 L
s
.69426 .06292 m
.70574 .03708 L
s
.69368 .11265 m
.70632 .08735 L
s
.69298 .16228 m
.70702 .13772 L
s
.69216 .21177 m
.70784 .18823 L
s
.69117 .26104 m
.70883 .23896 L
s
.69 .31 m
.71 .29 L
s
.68869 .35849 m
.71131 .34151 L
s
.68735 .40632 m
.71265 .39368 L
s
.68628 .45343 m
.71372 .44657 L
s
.68586 .5 m
.71414 .5 L
s
.68628 .54657 m
.71372 .55343 L
s
.68735 .59368 m
.71265 .60632 L
s
.68869 .64151 m
.71131 .65849 L
s
.69 .69 m
.71 .71 L
s
.69117 .73896 m
.70883 .76104 L
s
.69216 .78823 m
.70784 .81177 L
s
.69298 .83772 m
.70702 .86228 L
s
.69368 .88735 m
.70632 .91265 L
s
.69426 .93708 m
.70574 .96292 L
s
.69475 .98687 m
0 0 rlineto s
.69475 .98687 m
.7 1 L
s
.74368 .01265 m
0 0 rlineto s
.74368 .01265 m
.75 0 L
s
.74313 .06236 m
.75687 .03764 L
s
.7425 .11199 m
.7575 .08801 L
s
.74178 .16151 m
.75822 .13849 L
s
.74095 .21086 m
.75905 .18914 L
s
.74 .26 m
.76 .24 L
s
.73896 .30883 m
.76104 .29117 L
s
.73787 .35728 m
.76213 .34272 L
s
.73687 .40525 m
.76313 .39475 L
s
.73613 .45277 m
.76387 .44723 L
s
.73586 .5 m
.76414 .5 L
s
.73613 .54723 m
.76387 .55277 L
s
.73687 .59475 m
.76313 .60525 L
s
.73787 .64272 m
.76213 .65728 L
s
.73896 .69117 m
.76104 .70883 L
s
.74 .74 m
.76 .76 L
s
.74095 .78914 m
.75905 .81086 L
s
.74178 .83849 m
.75822 .86151 L
s
.7425 .88801 m
.7575 .91199 L
s
.74313 .93764 m
.75687 .96236 L
s
.74368 .98735 m
0 0 rlineto s
.74368 .98735 m
.75 1 L
s
.79272 .01213 m
0 0 rlineto s
.79272 .01213 m
.8 0 L
s
.79216 .06177 m
.80784 .03823 L
s
.79151 .11131 m
.80849 .08869 L
s
.7908 .16074 m
.8092 .13926 L
s
.79 .21 m
.81 .19 L
s
.78914 .25905 m
.81086 .24095 L
s
.78823 .30784 m
.81177 .29216 L
s
.78735 .35632 m
.81265 .34368 L
s
.78658 .40447 m
.81342 .39553 L
s
.78605 .45232 m
.81395 .44768 L
s
.78586 .5 m
.81414 .5 L
s
.78605 .54768 m
.81395 .55232 L
s
.78658 .59553 m
.81342 .60447 L
s
.78735 .64368 m
.81265 .65632 L
s
.78823 .69216 m
.81177 .70784 L
s
.78914 .74095 m
.81086 .75905 L
s
.79 .79 m
.81 .81 L
s
.7908 .83926 m
.8092 .86074 L
s
.79151 .88869 m
.80849 .91131 L
s
.79216 .93823 m
.80784 .96177 L
s
.79272 .98787 m
0 0 rlineto s
.79272 .98787 m
.8 1 L
s
.84189 .01159 m
0 0 rlineto s
.84189 .01159 m
.85 0 L
s
.84132 .06116 m
.85868 .03884 L
s
.84069 .11064 m
.85931 .08936 L
s
.84 .16 m
.86 .14 L
s
.83926 .2092 m
.86074 .1908 L
s
.83849 .25822 m
.86151 .24178 L
s
.83772 .30702 m
.86228 .29298 L
s
.837 .35557 m
.863 .34443 L
s
.8364 .40389 m
.8636 .39611 L
s
.836 .452 m
.864 .448 L
s
.83586 .5 m
.86414 .5 L
s
.836 .548 m
.864 .552 L
s
.8364 .59611 m
.8636 .60389 L
s
.837 .64443 m
.863 .65557 L
s
.83772 .69298 m
.86228 .70702 L
s
.83849 .74178 m
.86151 .75822 L
s
.83926 .7908 m
.86074 .8092 L
s
.84 .84 m
.86 .86 L
s
.84069 .88936 m
.85931 .91064 L
s
.84132 .93884 m
.85868 .96116 L
s
.84189 .98841 m
0 0 rlineto s
.84189 .98841 m
.85 1 L
s
.89117 .01104 m
0 0 rlineto s
.89117 .01104 m
.9 0 L
s
.8906 .06057 m
.9094 .03943 L
s
.89 .11 m
.91 .09 L
s
.88936 .15931 m
.91064 .14069 L
s
.88869 .20849 m
.91131 .19151 L
s
.88801 .2575 m
.91199 .2425 L
s
.88735 .30632 m
.91265 .29368 L
s
.88676 .35497 m
.91324 .34503 L
s
.88628 .40343 m
.91372 .39657 L
s
.88597 .45175 m
.91403 .44825 L
s
.88586 .5 m
.91414 .5 L
s
.88597 .54825 m
.91403 .55175 L
s
.88628 .59657 m
.91372 .60343 L
s
.88676 .64503 m
.91324 .65497 L
s
.88735 .69368 m
.91265 .70632 L
s
.88801 .7425 m
.91199 .7575 L
s
.88869 .79151 m
.91131 .80849 L
s
.88936 .84069 m
.91064 .85931 L
s
.89 .89 m
.91 .91 L
s
.8906 .93943 m
.9094 .96057 L
s
.89117 .98896 m
0 0 rlineto s
.89117 .98896 m
.9 1 L
s
.94054 .01051 m
0 0 rlineto s
.94054 .01051 m
.95 0 L
s
.94 .06 m
.96 .04 L
s
.93943 .1094 m
.96057 .0906 L
s
.93884 .15868 m
.96116 .14132 L
s
.93823 .20784 m
.96177 .19216 L
s
.93764 .25687 m
.96236 .24313 L
s
.93708 .30574 m
.96292 .29426 L
s
.93658 .35447 m
.96342 .34553 L
s
.93619 .40307 m
.96381 .39693 L
s
.93594 .45156 m
.96406 .44844 L
s
.93586 .5 m
.96414 .5 L
s
.93594 .54844 m
.96406 .55156 L
s
.93619 .59693 m
.96381 .60307 L
s
.93658 .64553 m
.96342 .65447 L
s
.93708 .69426 m
.96292 .70574 L
s
.93764 .74313 m
.96236 .75687 L
s
.93823 .79216 m
.96177 .80784 L
s
.93884 .84132 m
.96116 .85868 L
s
.93943 .8906 m
.96057 .9094 L
s
.94 .94 m
.96 .96 L
s
.94054 .98949 m
0 0 rlineto s
.94054 .98949 m
.95 1 L
s
.99 .01 m
0 0 rlineto s
.99 .01 m
1 0 L
s
.98949 .05946 m
0 0 rlineto s
.98949 .05946 m
1 .05 L
s
.98896 .10883 m
0 0 rlineto s
.98896 .10883 m
1 .1 L
s
.98841 .15811 m
0 0 rlineto s
.98841 .15811 m
1 .15 L
s
.98787 .20728 m
0 0 rlineto s
.98787 .20728 m
1 .2 L
s
.98735 .25632 m
0 0 rlineto s
.98735 .25632 m
1 .25 L
s
.98687 .30525 m
0 0 rlineto s
.98687 .30525 m
1 .3 L
s
.98645 .35406 m
0 0 rlineto s
.98645 .35406 m
1 .35 L
s
.98613 .40277 m
0 0 rlineto s
.98613 .40277 m
1 .4 L
s
.98593 .45141 m
0 0 rlineto s
.98593 .45141 m
1 .45 L
s
.98586 .5 m
0 0 rlineto s
.98586 .5 m
1 .5 L
s
.98593 .54859 m
0 0 rlineto s
.98593 .54859 m
1 .55 L
s
.98613 .59723 m
0 0 rlineto s
.98613 .59723 m
1 .6 L
s
.98645 .64594 m
0 0 rlineto s
.98645 .64594 m
1 .65 L
s
.98687 .69475 m
0 0 rlineto s
.98687 .69475 m
1 .7 L
s
.98735 .74368 m
0 0 rlineto s
.98735 .74368 m
1 .75 L
s
.98787 .79272 m
0 0 rlineto s
.98787 .79272 m
1 .8 L
s
.98841 .84189 m
0 0 rlineto s
.98841 .84189 m
1 .85 L
s
.98896 .89117 m
0 0 rlineto s
.98896 .89117 m
1 .9 L
s
.98949 .94054 m
0 0 rlineto s
.98949 .94054 m
1 .95 L
s
.99 .99 m
0 0 rlineto s
.99 .99 m
1 1 L
s
.871 .722 .529 r
.005 w
.5 1 m
.5 .95833 L
.5 .91667 L
.5 .875 L
.5 .83333 L
.5 .79167 L
.5 .75 L
.5 .70833 L
.5 .66667 L
.5 .625 L
.5 .58333 L
.5 .54167 L
.5 .5 L
.5 .45833 L
.5 .41667 L
.5 .375 L
.5 .33333 L
.5 .29167 L
.5 .25 L
.5 .20833 L
.5 .16667 L
.5 .125 L
.5 .08333 L
.5 .04167 L
.5 0 L
s
.274 .51 .706 r
0 .5 m
.04167 .5 L
.08333 .5 L
.125 .5 L
.16667 .5 L
.20833 .5 L
.25 .5 L
.29167 .5 L
.33333 .5 L
.375 .5 L
.41667 .5 L
.45833 .5 L
.5 .5 L
.54167 .5 L
.58333 .5 L
.625 .5 L
.66667 .5 L
.70833 .5 L
.75 .5 L
.79167 .5 L
.83333 .5 L
.875 .5 L
.91667 .5 L
.95833 .5 L
1 .5 L
s
.89 .09 .05 r
.49998 .50002 m
.49997 .50003 L
.49995 .50004 L
.49992 .50006 L
.49988 .5001 L
.49982 .50015 L
.49972 .50022 L
.49957 .50034 L
.49935 .50052 L
.49903 .50078 L
.49851 .50119 L
.49774 .5018 L
.49664 .50268 L
.49488 .5041 L
.4923 .50616 L
.48813 .50949 L
.482 .5144 L
.47311 .52151 L
.4588 .53296 L
.43786 .54971 L
.40383 .57693 L
.35353 .61718 L
.28043 .67566 L
.16227 .77019 L
s
.16227 .77019 m
0 .9 L
s
.49998 .50002 m
.49997 .50003 L
.49996 .50004 L
.49993 .50007 L
.4999 .5001 L
.49984 .50016 L
.49976 .50024 L
.49963 .50037 L
.49943 .50057 L
.49914 .50086 L
.49867 .50133 L
.49796 .50204 L
.49694 .50306 L
.49527 .50473 L
.49281 .50719 L
.48879 .51121 L
.4828 .5172 L
.47404 .52596 L
.45977 .54023 L
.43866 .56134 L
.40397 .59603 L
.3521 .6479 L
.27589 .72411 L
.15132 .84868 L
s
.15132 .84868 m
0 1 L
s
.49999 .50002 m
.49998 .50003 L
.49997 .50004 L
.49995 .50007 L
.49992 .5001 L
.49988 .50016 L
.49982 .50024 L
.49972 .50037 L
.49957 .50057 L
.49936 .50086 L
.499 .50133 L
.49847 .50204 L
.4977 .50306 L
.49645 .50473 L
.49461 .50719 L
.49159 .51121 L
.4871 .5172 L
.48053 .52596 L
.46983 .54023 L
.454 .56134 L
.42798 .59603 L
.38907 .6479 L
.33192 .72411 L
.23849 .84868 L
s
.23849 .84868 m
.125 1 L
s
.49999 .50002 m
.49999 .50003 L
.49998 .50004 L
.49997 .50007 L
.49995 .5001 L
.49992 .50016 L
.49988 .50024 L
.49982 .50037 L
.49972 .50057 L
.49957 .50086 L
.49933 .50133 L
.49898 .50204 L
.49847 .50306 L
.49763 .50473 L
.49641 .50719 L
.4944 .51121 L
.4914 .5172 L
.48702 .52596 L
.47989 .54023 L
.46933 .56134 L
.45199 .59603 L
.42605 .6479 L
.38795 .72411 L
.32566 .84868 L
s
.32566 .84868 m
.25 1 L
s
.5 .50002 m
.49999 .50003 L
.49999 .50004 L
.49998 .50007 L
.49997 .5001 L
.49996 .50016 L
.49994 .50024 L
.49991 .50037 L
.49986 .50057 L
.49979 .50086 L
.49967 .50133 L
.49949 .50204 L
.49923 .50306 L
.49882 .50473 L
.4982 .50719 L
.4972 .51121 L
.4957 .5172 L
.49351 .52596 L
.48994 .54023 L
.48467 .56134 L
.47599 .59603 L
.46302 .6479 L
.44397 .72411 L
.41283 .84868 L
s
.41283 .84868 m
.375 1 L
s
.5 .50002 m
.5 .50003 L
.5 .50004 L
.5 .50007 L
.5 .5001 L
.5 .50016 L
.5 .50024 L
.5 .50037 L
.5 .50057 L
.5 .50086 L
.5 .50133 L
.5 .50204 L
.5 .50306 L
.5 .50473 L
.5 .50719 L
.5 .51121 L
.5 .5172 L
.5 .52596 L
.5 .54023 L
.5 .56134 L
.5 .59603 L
.5 .6479 L
.5 .72411 L
.5 .84868 L
s
.5 .84868 m
.5 1 L
s
.5 .50002 m
.50001 .50003 L
.50001 .50004 L
.50002 .50007 L
.50003 .5001 L
.50004 .50016 L
.50006 .50024 L
.50009 .50037 L
.50014 .50057 L
.50021 .50086 L
.50033 .50133 L
.50051 .50204 L
.50077 .50306 L
.50118 .50473 L
.5018 .50719 L
.5028 .51121 L
.5043 .5172 L
.50649 .52596 L
.51006 .54023 L
.51533 .56134 L
.52401 .59603 L
.53698 .6479 L
.55603 .72411 L
.58717 .84868 L
s
.58717 .84868 m
.625 1 L
s
.50001 .50002 m
.50001 .50003 L
.50002 .50004 L
.50003 .50007 L
.50005 .5001 L
.50008 .50016 L
.50012 .50024 L
.50018 .50037 L
.50028 .50057 L
.50043 .50086 L
.50067 .50133 L
.50102 .50204 L
.50153 .50306 L
.50237 .50473 L
.50359 .50719 L
.5056 .51121 L
.5086 .5172 L
.51298 .52596 L
.52011 .54023 L
.53067 .56134 L
.54801 .59603 L
.57395 .6479 L
.61205 .72411 L
.67434 .84868 L
s
.67434 .84868 m
.75 1 L
s
.50001 .50002 m
.50002 .50003 L
.50003 .50004 L
.50005 .50007 L
.50008 .5001 L
.50012 .50016 L
.50018 .50024 L
.50028 .50037 L
.50043 .50057 L
.50064 .50086 L
.501 .50133 L
.50153 .50204 L
.5023 .50306 L
.50355 .50473 L
.50539 .50719 L
.50841 .51121 L
.5129 .5172 L
.51947 .52596 L
.53017 .54023 L
.546 .56134 L
.57202 .59603 L
.61093 .6479 L
.66808 .72411 L
.76151 .84868 L
s
.76151 .84868 m
.875 1 L
s
.50002 .50002 m
.50003 .50003 L
.50004 .50004 L
.50007 .50007 L
.5001 .5001 L
.50016 .50016 L
.50024 .50024 L
.50037 .50037 L
.50057 .50057 L
.50086 .50086 L
.50133 .50133 L
.50204 .50204 L
.50306 .50306 L
.50473 .50473 L
.50719 .50719 L
.51121 .51121 L
.5172 .5172 L
.52596 .52596 L
.54023 .54023 L
.56134 .56134 L
.59603 .59603 L
.6479 .6479 L
.72411 .72411 L
.84868 .84868 L
s
.84868 .84868 m
1 1 L
s
.50002 .50002 m
.50003 .50003 L
.50005 .50004 L
.50008 .50006 L
.50012 .5001 L
.50018 .50015 L
.50028 .50022 L
.50043 .50034 L
.50065 .50052 L
.50097 .50078 L
.50149 .50119 L
.50226 .5018 L
.50336 .50268 L
.50512 .5041 L
.5077 .50616 L
.51187 .50949 L
.518 .5144 L
.52689 .52151 L
.5412 .53296 L
.56214 .54971 L
.59617 .57693 L
.64647 .61718 L
.71957 .67566 L
.83773 .77019 L
s
.83773 .77019 m
1 .9 L
s
.49998 .49998 m
.49997 .49997 L
.49995 .49996 L
.49992 .49994 L
.49988 .4999 L
.49982 .49985 L
.49972 .49978 L
.49957 .49966 L
.49935 .49948 L
.49903 .49922 L
.49851 .49881 L
.49774 .4982 L
.49664 .49732 L
.49488 .4959 L
.4923 .49384 L
.48813 .49051 L
.482 .4856 L
.47311 .47849 L
.4588 .46704 L
.43786 .45029 L
.40383 .42307 L
.35353 .38282 L
.28043 .32434 L
.16227 .22981 L
s
.16227 .22981 m
0 .1 L
s
.49998 .49998 m
.49997 .49997 L
.49996 .49996 L
.49993 .49993 L
.4999 .4999 L
.49984 .49984 L
.49976 .49976 L
.49963 .49963 L
.49943 .49943 L
.49914 .49914 L
.49867 .49867 L
.49796 .49796 L
.49694 .49694 L
.49527 .49527 L
.49281 .49281 L
.48879 .48879 L
.4828 .4828 L
.47404 .47404 L
.45977 .45977 L
.43866 .43866 L
.40397 .40397 L
.3521 .3521 L
.27589 .27589 L
.15132 .15132 L
s
.15132 .15132 m
0 0 L
s
.49999 .49998 m
.49998 .49997 L
.49997 .49996 L
.49995 .49993 L
.49992 .4999 L
.49988 .49984 L
.49982 .49976 L
.49972 .49963 L
.49957 .49943 L
.49936 .49914 L
.499 .49867 L
.49847 .49796 L
.4977 .49694 L
.49645 .49527 L
.49461 .49281 L
.49159 .48879 L
.4871 .4828 L
.48053 .47404 L
.46983 .45977 L
.454 .43866 L
.42798 .40397 L
.38907 .3521 L
.33192 .27589 L
.23849 .15132 L
s
.23849 .15132 m
.125 0 L
s
.49999 .49998 m
.49999 .49997 L
.49998 .49996 L
.49997 .49993 L
.49995 .4999 L
.49992 .49984 L
.49988 .49976 L
.49982 .49963 L
.49972 .49943 L
.49957 .49914 L
.49933 .49867 L
.49898 .49796 L
.49847 .49694 L
.49763 .49527 L
.49641 .49281 L
.4944 .48879 L
.4914 .4828 L
.48702 .47404 L
.47989 .45977 L
.46933 .43866 L
.45199 .40397 L
.42605 .3521 L
.38795 .27589 L
.32566 .15132 L
s
.32566 .15132 m
.25 0 L
s
.5 .49998 m
.49999 .49997 L
.49999 .49996 L
.49998 .49993 L
.49997 .4999 L
.49996 .49984 L
.49994 .49976 L
.49991 .49963 L
.49986 .49943 L
.49979 .49914 L
.49967 .49867 L
.49949 .49796 L
.49923 .49694 L
.49882 .49527 L
.4982 .49281 L
.4972 .48879 L
.4957 .4828 L
.49351 .47404 L
.48994 .45977 L
.48467 .43866 L
.47599 .40397 L
.46302 .3521 L
.44397 .27589 L
.41283 .15132 L
s
.41283 .15132 m
.375 0 L
s
.5 .49998 m
.5 .49997 L
.5 .49996 L
.5 .49993 L
.5 .4999 L
.5 .49984 L
.5 .49976 L
.5 .49963 L
.5 .49943 L
.5 .49914 L
.5 .49867 L
.5 .49796 L
.5 .49694 L
.5 .49527 L
.5 .49281 L
.5 .48879 L
.5 .4828 L
.5 .47404 L
.5 .45977 L
.5 .43866 L
.5 .40397 L
.5 .3521 L
.5 .27589 L
.5 .15132 L
s
.5 .15132 m
.5 0 L
s
.5 .49998 m
.50001 .49997 L
.50001 .49996 L
.50002 .49993 L
.50003 .4999 L
.50004 .49984 L
.50006 .49976 L
.50009 .49963 L
.50014 .49943 L
.50021 .49914 L
.50033 .49867 L
.50051 .49796 L
.50077 .49694 L
.50118 .49527 L
.5018 .49281 L
.5028 .48879 L
.5043 .4828 L
.50649 .47404 L
.51006 .45977 L
.51533 .43866 L
.52401 .40397 L
.53698 .3521 L
.55603 .27589 L
.58717 .15132 L
s
.58717 .15132 m
.625 0 L
s
.50001 .49998 m
.50001 .49997 L
.50002 .49996 L
.50003 .49993 L
.50005 .4999 L
.50008 .49984 L
.50012 .49976 L
.50018 .49963 L
.50028 .49943 L
.50043 .49914 L
.50067 .49867 L
.50102 .49796 L
.50153 .49694 L
.50237 .49527 L
.50359 .49281 L
.5056 .48879 L
.5086 .4828 L
.51298 .47404 L
.52011 .45977 L
.53067 .43866 L
.54801 .40397 L
.57395 .3521 L
.61205 .27589 L
.67434 .15132 L
s
.67434 .15132 m
.75 0 L
s
.50001 .49998 m
.50002 .49997 L
.50003 .49996 L
.50005 .49993 L
.50008 .4999 L
.50012 .49984 L
.50018 .49976 L
.50028 .49963 L
.50043 .49943 L
.50064 .49914 L
.501 .49867 L
.50153 .49796 L
.5023 .49694 L
.50355 .49527 L
.50539 .49281 L
.50841 .48879 L
.5129 .4828 L
.51947 .47404 L
.53017 .45977 L
.546 .43866 L
.57202 .40397 L
.61093 .3521 L
.66808 .27589 L
.76151 .15132 L
s
.76151 .15132 m
.875 0 L
s
.50002 .49998 m
.50003 .49997 L
.50004 .49996 L
.50007 .49993 L
.5001 .4999 L
.50016 .49984 L
.50024 .49976 L
.50037 .49963 L
.50057 .49943 L
.50086 .49914 L
.50133 .49867 L
.50204 .49796 L
.50306 .49694 L
.50473 .49527 L
.50719 .49281 L
.51121 .48879 L
.5172 .4828 L
.52596 .47404 L
.54023 .45977 L
.56134 .43866 L
.59603 .40397 L
.6479 .3521 L
.72411 .27589 L
.84868 .15132 L
s
.84868 .15132 m
1 0 L
s
.50002 .49998 m
.50003 .49997 L
.50005 .49996 L
.50008 .49994 L
.50012 .4999 L
.50018 .49985 L
.50028 .49978 L
.50043 .49966 L
.50065 .49948 L
.50097 .49922 L
.50149 .49881 L
.50226 .4982 L
.50336 .49732 L
.50512 .4959 L
.5077 .49384 L
.51187 .49051 L
.518 .4856 L
.52689 .47849 L
.5412 .46704 L
.56214 .45029 L
.59617 .42307 L
.64647 .38282 L
.71957 .32434 L
.83773 .22981 L
s
.83773 .22981 m
1 .1 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00;?ooool3o`00037ooooo1Ol0000aooooo`;o0000
<_ooool5o`0003?ooooo0ol0000Kooooo`00;Oooool00ol0003oooooooooo`0aooooo`04o`000?oo
ooooooooo`00033ooooo00Co0000oooooooooooo0000<_ooool01?l0003oooooooooool0000doooo
o`03o`000?oooooooooo01[ooooo000Tooooo`Go000000?oooooo`000?l000000ol0000[ooooo`Go
00000oooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0003?ooooo00?o0000oooo
ooooool0<Oooool5o`0001_ooooo000Zooooo`04o`000?ooooooooooo`0003Gooooo00?o0000oooo
ooooool0;oooool01?l0003oooooooooool0000dooooo`03o`000?oooooooooo033ooooo00Co0000
oooooooooooo00007?ooool002_ooooo00?o0000ooooool00000<_ooool01Ol0003ooooooooooooo
oooo0000033ooooo00Co0000oooooooooooo0000<Oooool01Ol0003ooooooooooooooooo000003;o
oooo00?o0000ooooool000007?ooool002cooooo0_l0000booooo`05o`000?ooooooooooooooool0
0000<?ooool01?l0003oooooooooool0000aooooo`05o`000?ooooooooooooooool00000<oooool2
o`0001cooooo000]ooooo`03o`000?oooooooooo037ooooo0ol0000booooo`;o0000<oooool3o`00
03Gooooo00?o0000ooooooooool06_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000kooooo00?o0000on<G3?l000002ol000000ol2Z9ko0000o`00000;o`00
0003o`:XW_l0003o000000Co000000?ohaL<o`000?l000001?l000000ol2Z9ko0000o`00000:o`00
0003o`:XW_l0003o000000_o000000?ohaL<o`000?l000002_l000000ol2Z9ko0000o`00000;o`00
0003o`:XW_l0003o000000Co000000?ohaL<o`000?l000000ol000000ol2Z9ko0000o`00000;o`00
0003o`:XW_l0003o000001So000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000004o`00
0003on<G3?l0003o000000?o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000;o`00
0003on<G3?l0003o000000[o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000003o`00
0003on<G3?l0003o000000Co000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000:o`00
007ohaL<0Oooool000kooooo00?o0000on<G3?l2Z9h03?l000000ol2Z9ko0000o`00000:o`000003
o`:XW_l0003o000000Co000000?ohaL<o`000?l000001?l000000ol2Z9ko0000o`00000:o`000003
o`:XW_l0003o000000_o000000?ohaL<o`000?l000002_l000000ol2Z9ko0000o`00000;o`000003
o`:XW_l0003o000000Co000000?ohaL<o`000?l000000ol000000ol2Z9ko0000o`00000;o`000003
o`:XW_l0003o000001So000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000004o`000003
on<G3?l0003o000000?o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000;o`000003
on<G3?l0003o000000[o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000003o`000003
on<G3?l0003o000000Co000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000;o`00007o
haL<0Oooool000kooooo0_l000000ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T1on<G307o00000Oooool000kooooo0_l000000oo<i]WohaL<o`:X
WP0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h5olcVf@03on<G3?o<i]Woc>KI00?oc>KI0_l2
Z9h;olcVf@;o0ZRN3?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@09olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcV
f@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?l0003o0000007ooooo000>ooooo`;o00000_o<i]T00ooS5`coc>KIolcVf@0O
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI00?o0000
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<
olcVfOo<i]T00oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@0O
olcVf@04on<G3?o<i]Wo0000o`00007ooooo000>ooooo`;o00000oo<i]T00ooS5`coc>KIolcVf@0N
olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0N
olcVf@03o`000?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0M
olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T00_l00001ooooo`003_ooool2o`00
00Coc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI
01goc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ol0003oc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI
01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0NolcVf@04on<G3?o<i]Woc>KI
olcVf@;o00000Oooool000kooooo0_l00005olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcV
fOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o0000olcV
fOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcV
fOo<i]T07_o<i]T00ooS5`coc>KIolcVf@02olcVf@;o00000Oooool000kooooo0_l00006olcVf@03
on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03
on<G3?o<i]Woc>KI01goc>KI00?o0000olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03
on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@03olcVf@;o
00000Oooool000kooooo0_l00007olcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T0
7Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o0000olcVfOo<i]T0
7Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T0
7Oo<i]T00ooS5`coc>KIolcVf@04olcVf@;o00000Oooool000kooooo0_l00008olcVf@03on<G3?o<
i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0BolcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS
5``02Oo<i]T00ol2Z9koc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<
i]T07Oo<i]T00ooS5`coc>KIolcVf@05olcVf@;o00000Oooool000kooooo0_l00009olcVf@03on<G
3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Wo
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:X
WPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
haL<olcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:X
W_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05
on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00Ooc>KI0_l00001ooooo`003_ooool2o`0000_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<
i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<
i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Soc>KI
0_l00001ooooo`003_ooool00ol0003o0ZRNolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<
i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcV
fOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcV
fOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T1
o`00007o0ZRN0Oooool000kooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
1Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<
i]T02_o<i]T1o`00007o0ZRN0Oooool000kooooo0_l000000oo<i]Wo0ZRNo`:XWP0;olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07
olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0:olcVf@;o0ZRN0Ol00001ooooo`003_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0;olcVf@03o`:XW_l0003o0000007ooooo000>ooooo`;o00004?o<i]T00ooS5`co
c>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2
Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T03Oo<i]T2
o`00007ooooo000>ooooo`;o00004Oo<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI
01[oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0KolcVf@03o`000?o<i]Woc>KI
01[oc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI
01[oc>KI00?ohaL<olcVfOo<i]T03_o<i]T2o`00007ooooo000>ooooo`;o00004_o<i]T00ooS5`co
c>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`co
c>KIolcVf@0JolcVf@03o`000?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`co
c>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T03oo<i]T2o`00007o
oooo000>ooooo`;o00004oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0JolcVf@03o`000?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T04?o<i]T2o`00007ooooo000>ooooo`;o00005?o<i]T00ooS5`coc>KIolcV
f@0JolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcV
f@0JolcVf@03o`000?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcV
f@0JolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T04Oo<i]T2o`00007ooooo000>
ooooo`;o00005Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<
olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03o`000?o<i]Woc>KI01Woc>KI00?ohaL<
olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<
olcVfOo<i]T04_o<i]T2o`00007ooooo000>ooooo`;o00005_o<i]T00ooS5`coc>KIolcVf@0IolcV
f@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T04oo<i]T2o`00007ooooo0008ooooo`?o
00000oooool2o`0000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
on<G3?o<i]Woc>KI00[oc>KI0_l2Z9h8olcVf@;o00000Oooool000Wooooo00?o0000ooooooooool0
0_ooool2o`0000_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G
3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00007ooooo0005o`000003ooooool0
003o000000?o00000oooool2o`0000coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`00007ooooo0006
ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000on<G3?oS5``03?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;ohaL<0Oooool000Oooooo00?o0000ooooool000001?ooool2o`000003olcVfOoS5`co
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0000o`000001ooooo`002?ooool2o`00
00Cooooo0_l00002olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?oS
5`co0ZRNo`000?l00001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o00000oo<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI00;o00000Oooool000kooooo0_l00004olcVf@;o
haL<6?o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<
i]T06?o<i]T00ooS5`coc>KIolcVf@0GolcVf@03o`000?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<
i]T05oo<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<
i]T05_o<i]T2on<G30?oc>KI0_l00001ooooo`003_ooool2o`0000Koc>KI00?ohaL<olcVfOo<i]T0
5_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
6?o<i]T00ooS5`coc>KIolcVf@0GolcVf@03o`000?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
6?o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
5_o<i]T00ooS5`coc>KIolcVf@03olcVf@;o00000Oooool000kooooo0_l00007olcVf@03on<G3?o<
i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<
i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<
i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<
i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T01?o<i]T2o`00007ooooo000>ooooo`;o00002?o<i]T0
0ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?o0000olcVfOo<i]T05_o<i]T0
0ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI00Goc>KI0_l00001ooooo`003_ooool2o`00
00Woc>KI0_oS5``GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?o0000olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS
5`coc>KIolcVf@0EolcVf@;ohaL<2?o<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T00ooS5`co
c>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo
0ZRN01Goc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Wo
c>KI01Goc>KI00?ohaL<olcVfOo<i]T02?o<i]T2o`00007ooooo000>ooooo`;o00003?o<i]T00ooS
5`coc>KIolcVf@0EolcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS
5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G300:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<
i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9kohaL<olcVf@0FolcVf@03on<G3?o<i]Woc>KI00Woc>KI0_l00001ooooo`00
3_ooool2o`0000Woc>KI0_l2Z9h2olcVf@03on<G3?o<i]Woc>KI00Ooc>KI0_l2Z9h<olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00co
c>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00co
c>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRN
olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRN
olcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI0_l2
Z9h9olcVf@03on<G3?o<i]Woc>KI00;o0ZRN2?o<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T0
0ol2Z9koc>KIolcVf@02on<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<
i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<
i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI0_oS5``2olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l00001ooooo`003_ooool00ol0003o
0ZRNo`:XWP0;olcVf@;o0ZRN0_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcV
fOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:X
WP0=olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_o
c>KI0_l2Z9h1ooooo`003_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00Co0ZRNolcVfOo<i]Wo
haL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;ohaL<3?o<i]T00ol2Z9koc>KIolcVf@07olcVf@04
on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<
i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
0_oS5``<olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0;olcVf@03
o`:XW_l0003o0000007ooooo000>ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:X
W_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI
00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KI
on<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?o
haL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?o
haL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00Co0ZRNolcVfOl0003o
00000Oooool000kooooo0_l0000@olcVf@03o`:XW_o<i]Woc>KI00;ohaL<2?o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KI
olcVfOo<i]Wo0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h=
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2on<G30?oc>KI00?o0ZRN
olcVfOo<i]T03?o<i]T2o`00007ooooo000>ooooo`;o00005Oo<i]T00ooS5`coc>KIolcVf@0DolcV
f@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcVf@03olcV
f@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06
olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<
i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04_o<i]T2o`00007ooooo000>ooooo`;o00005_o<i]T0
0ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04_o<i]T0
0ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01?oc>KI0_l00001ooooo`003_ooool2o`00
01Ooc>KI0_oS5``EolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS
5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T04oo<i]T00ooS
5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS
5`coc>KIolcVf@0ColcVf@;ohaL<5_o<i]T2o`00007ooooo000>ooooo`;o00006Oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T04oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Koc>KI0_l00001ooooo`003_ooool2o`0001[oc>KI
00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01;oc>KI
00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0ColcVf@03o`000?o<i]Woc>KI01;oc>KI
00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI017oc>KI
00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0GolcVf@;o00000Oooool000kooooo0_l0
000KolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcV
f@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ol0003oc>KIolcV
f@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcV
f@0AolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T06?o<i]T2o`00007ooooo000>
ooooo`;o00007?o<i]T2on<G31Coc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0B
olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9kohaL<olcVf@0C
olcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04_o<i]T2on<G31_oc>KI0_l00001
ooooo`003_ooool2o`0001Ooc>KI0_l2Z9h5olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h;olcV
f@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcV
f@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T2o`:XWPGoc>KI00?ohaL<olcV
fOo<i]T00oo<i]T2o`:XWQKoc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI0_l2Z9h>olcVf@03
o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T2o`:XWPSoc>KI0_l00001ooooo`00
3_ooool2o`0000_oc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
1Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o00000Oooool000kooooo00?o0000o`:XW_l2Z9h03?o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI0_oS5``6olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI0_oS5``5olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h;olcVf@;o0ZRN0Ooo
ool000kooooo0_l000000oo<i]Wo0ZRNo`:XWP0;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP;o00000Oooool0
00kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS
5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2
Z9koc>KIo`000?l00001ooooo`003_ooool2o`0002Goc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS
5`coc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS
5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T08_o<i]T2o`00
007ooooo000>ooooo`;o00009_o<i]T2on<G31;oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`co
c>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`co
c>KIolcVf@0@olcVf@;ohaL<9Oo<i]T2o`00007ooooo000>ooooo`;o0000:?o<i]T00ooS5`coc>KI
olcVf@0@olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KI
olcVf@0@olcVf@03on<G3?o<i]Woc>KI017oc>KI00?o0000olcVfOo<i]T04?o<i]T00ooS5`coc>KI
olcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KI
olcVf@0@olcVf@03on<G3?o<i]Woc>KI02Goc>KI0_l00001ooooo`003_ooool2o`0002Woc>KI00?o
haL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?o
haL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0VolcVf@;o00000Oooool000kooooo0_l0000Z
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0?
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0>
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T09oo<i]T2o`00007ooooo000>oooo
o`;o0000:oo<i]T2on<G317oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0?olcV
f@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?olcV
f@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0>olcV
f@03on<G3?o<i]Woc>KI00ooc>KI0_oS5``ZolcVf@;o00000Oooool000kooooo0_l0000]olcVf@03
on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0?olcVf@03
on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?olcVf@03
on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03
on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T0:_o<i]T2o`00007ooooo000>ooooo`;o0000
;_o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]Wo
haL<2_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00koc>KI00?o0000olcVfOo<i]T02oo<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ooS5`coc>KIolcV
f@0?olcVf@03on<G3?o<i]Woc>KI02_oc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI0_l2Z9h<
olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI00?ohaL<olcVfOo<i]T00_l2Z9h<olcVf@03o`:XW_oS5`co
c>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?o
haL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPkoc>KI
00?o0000olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Co
c>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcV
fOl2Z9h03?o<i]T00ooS5`co0ZRNolcVf@0;olcVf@;o0ZRN0_o<i]T00ooS5`coc>KIolcVf@07olcV
f@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h8olcVf@;o00000Oooool000kooooo0_l0000;olcVf@;o
0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_oS5``2olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<
00Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3_o<i]T00ol0003oc>KIolcVf@0;olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00;ohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
0_l2Z9h:olcVf@;o00000Oooool000kooooo00?o0000o`:XW_l2Z9h03?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`co
c>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcV
f@03o`000?o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Wo
c>KIo`:XWPcoc>KI00?ohaL<o`:XW_o<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h1ooooo`003_oo
ool2o`000003olcVfOl2Z9koc>KI00_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_oS5`coc>KI00_oc>KI
00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0000olcV
fOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:X
WP0;olcVf@03on<G3?l2Z9koc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@03o`:XW_l0003o0000007ooooo
000>ooooo`;o00000_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol0
003oc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:X
WP0;olcVf@03on<G3?l2Z9koc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KI
o`000?l00001ooooo`003_ooool2o`0002_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KI
olcVfOl2Z9h<olcVf@03o`:XW_oS5`coc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2?o<i]T00ol2
Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS
5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0000olcVfOo<i]T02Oo<i]T01Ol2Z9koc>KIolcVfOo<
i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN2oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@04o`:X
W_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T09oo<i]T2o`00007ooooo000>ooooo`;o0000
=_o<i]T2on<G30ooc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:X
W_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G
3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol0003oc>KIolcVf@09olcVf@05o`:XW_o<i]Woc>KIolcV
fOoS5``02?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00goc>KI0_oS5``eolcV
f@;o00000Oooool000kooooo0_l0000holcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<
i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<
i]T03_o<i]T00ol0003oc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<
i]T03Oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<
i]T0=Oo<i]T2o`00007ooooo000>ooooo`;o0000>Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI03Koc>KI0_l00001ooooo`003_ooool2o`0003[oc>KI00?ohaL<olcVfOo<i]T03Oo<
i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<
i]T00ooS5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<
i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03Oo<
i]T00ooS5`coc>KIolcVf@0golcVf@;o00000Oooool000kooooo0_l0000kolcVf@;ohaL<3Oo<i]T0
0ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T0
0ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T2
on<G33[oc>KI0_l00001ooooo`003_ooool2o`0003goc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS
5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS
5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS
5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS
5`coc>KIolcVf@0jolcVf@;o00000Oooool000kooooo0_l0000nolcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?l2Z9koc>KI00co
c>KI00?ohaL<olcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?ohaL<olcVfOo<i]T0>oo<i]T2o`00007ooooo0006ooooo`Go00000oooool2o`0003ooc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`co0ZRNolcVf@0<olcVf@03on<G3?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?l2Z9koc>KI00coc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0lolcVf@;o00000Oooool000Oooooo00Co
0000oooooooooooo00000oooool2o`0000Woc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI
0_l2Z9h<olcVf@;ohaL<3?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI
00?ohaL<o`:XW_o<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0<olcVf@03on<G3?l2Z9koc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T2on<G3003o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@;o0ZRN
3?o<i]T2o`:XWP_oc>KI0_l2Z9h8olcVf@;o00000Oooool000Go00000oooool00ol0003ooooooooo
o`03ooooo`;o00002oo<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
haL<o`:XW_o<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2o`00007ooooo0009
ooooo`03o`000?oooooooooo00;ooooo00Co0000o`:XW_l2Z9ko0ZRN3?o<i]T2o`:XWP[oc>KI0_l2
Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
0ZRNon<G3?o<i]T02oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
haL<o`:XW_o<i]T02_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@;o0ZRN3Oo<i]T2o`:XWP7ooooo0006ooooo`05o`000?ooooooooooooooool000000ooo
ool2o`0000;oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI0_l2Z9h2o`00007ooooo0006ooooo`05o`000?ooooooooooooooool000000ooo
ool2o`0001goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0JolcVf@;o00000Ooo
ool000Oooooo0ol00004ooooo`;o0000A_o<i]T2on<G30_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ol0003oc>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI0_oS5`a5olcVf@;o00000Oooool0
00kooooo0_l00018olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol0
003oc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS
5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0AOo<i]T2o`00
007ooooo000>ooooo`;o0000BOo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?o0000olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Wo
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI04Ko
c>KI0_l00001ooooo`003_ooool2o`0004[oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@09olcVf@03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@09olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KI
olcVf@17olcVf@;o00000Oooool000kooooo0_l0001;olcVf@;ohaL<2_o<i]T00ooS5`coc>KIolcV
f@09olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcV
f@09olcVf@03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcV
f@08olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T2on<G34[oc>KI0_l0
0001ooooo`003_ooool2o`0004goc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09
olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09
olcVf@03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09
olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@1:
olcVf@;o00000Oooool000kooooo0_l0001>olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOo<i]T02Oo<i]T00ol0003oc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcV
fOo<i]T02?o<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOo<i]T0Boo<i]T2o`00007ooooo000>ooooo`;o0000Coo<i]T2on<G30Woc>KI00?ohaL<olcVfOo<
i]T02Oo<i]T01?oS5`coc>KIolcVfOl2Z9h7olcVf@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcV
fOo<i]Woc>KIon<G300:olcVf@03o`000?o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<
i]T00ooS5`coc>KIolcVf@04olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02_o<i]T00ooS5`coc>KI
olcVf@07olcVf@;ohaL<C_o<i]T2o`00007ooooo000>ooooo`;o0000?oo<i]T2o`:XWPcoc>KI0_l2
Z9h2olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?ohaL<o`:XW_o<i]T02?o<i]T01?oS5`coc>KIolcV
fOl2Z9h7olcVf@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G300:olcVf@03
o`000?o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<i]T00ooS5`coc>KIolcVf@04olcV
f@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@02
o`:XWPcoc>KI0_l2Z9hnolcVf@;o00000Oooool000kooooo0_l00009olcVf@;o0ZRN2oo<i]T2o`:X
WPcoc>KI0_l2Z9h<olcVf@;o0ZRN3Oo<i]T2o`:XWPcoc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T0
0ooS5`co0ZRNolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPOoc>KI00?ohaL<olcVfOo<i]T00oo<
i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00[oc>KI00?o0000olcVfOo<i]T02?o<i]T01?oS5`coc>KI
olcVfOl2Z9h6olcVf@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcV
f@03on<G3?o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T2o`:XWPkoc>KI0_l2Z9h;
olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h8olcVf@;o00000Oooool000kooooo00?o0000o`:X
W_l2Z9h02_o<i]T3o`:XWP[oc>KI0ol2Z9h;olcVf@?o0ZRN2oo<i]T3o`:XWPcoc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02on<G30Soc>KI00?ohaL<o`:XW_o<i]T02?o<i]T01?oS
5`coc>KIolcVfOl2Z9h6olcVf@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G
3009olcVf@03o`000?o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<i]T00ooS5`coc>KI
olcVf@04olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?ohaL<olcVfOo<i]T01_o<i]T2on<G30;o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@?o0ZRN2_o<i]T3o`:XWP_o
c>KI0ol2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP7ooooo000>ooooo`;o000000Coc>KIo`:XW_l2Z9ko
0ZRN2_o<i]T2o`:XWP_oc>KI0ol2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@05
o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T2on<G30Woc>KI00CohaL<olcVfOo<i]Wo0ZRN1_o<i]T0
0ooS5`coc>KIolcVf@03olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol0003oc>KIolcV
f@07olcVf@04on<G3?o<i]Woc>KIo`:XWPKoc>KI00?ohaL<olcVfOo<i]T01?o<i]T01?l2Z9koc>KI
olcVfOoS5``9olcVf@03on<G3?o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0;olcV
f@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h2o`00
007ooooo000>ooooo`;o00000oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?ohaL<olcV
fOo<i]T01_o<i]T01?oS5`coc>KIolcVfOl2Z9h6olcVf@03on<G3?o<i]Woc>KI00?oc>KI00Go0ZRN
olcVfOo<i]Woc>KIon<G3009olcVf@03o`000?o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN
1_o<i]T00ooS5`coc>KIolcVf@03olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ooS5`co
c>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOl0003o00000Oooool000kooooo0_l0001ColcV
f@04o`:XW_o<i]Woc>KIolcVf@;ohaL<2?o<i]T00ooS5`coc>KIolcVf@06olcVf@04on<G3?o<i]Wo
c>KIo`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`00
0?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h01_o<i]T00ooS5`coc>KIolcVf@04olcVf@04o`:X
W_o<i]Woc>KIon<G30Soc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2on<G30?oc>KI00?o0ZRNolcVfOo<
i]T0D?o<i]T2o`00007ooooo000>ooooo`;o0000FOo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G
3?o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<i]Wo0ZRN1Oo<i]T00ooS5`coc>KIolcVf@03olcVf@05
o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol0003oc>KIolcVf@06olcVf@04on<G3?o<i]Woc>KI
o`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T01?l2Z9koc>KIolcVfOoS5``8olcVf@03on<G3?o<
i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0E_o<i]T2o`00007ooooo000>ooooo`;o0000F_o<i]T0
0ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01_o<i]T0
0ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0000olcVfOo<i]T01_o<i]T0
0ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01_o<i]T0
0ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI05Ooc>KI0_l00001ooooo`003_ooool2o`00
05_oc>KI0_oS5``7olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS
5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0000olcVfOo<i]T01_o<i]T00ooS
5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS
5`coc>KIolcVf@04olcVf@;ohaL<F_o<i]T2o`00007ooooo000>ooooo`;o0000GOo<i]T00ooS5`co
c>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`co
c>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0000olcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI05[oc>KI0_l00001ooooo`003_ooool2o`0005koc>KI
00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@06olcVf@03o`000?o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@1KolcVf@;o00000Oooool000kooooo0_l0
001OolcVf@;ohaL<1_o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`000?o<i]Woc>KI00Goc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o
haL<olcVfOo<i]T00oo<i]T2on<G35koc>KI0_l00001ooooo`003_ooool2o`00067oc>KI00?ohaL<
olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`000?o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@1NolcVf@;o00000Oooool000kooooo0_l0001RolcV
f@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_oS5`coc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol0003oc>KIolcVf@04olcV
f@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcV
f@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T0Goo<i]T2o`00007ooooo000>ooooo`;o
0000COo<i]T2o`:XWPcoc>KI0_l2Z9h6olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNon<G3?o<
i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_oS5`coc>KI00Goc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol0003oc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T2o`:XWP_oc>KI0_l2Z9i<olcVf@;o00000Oooool000kooooo0_l00009olcVf@?o0ZRN
2_o<i]T3o`:XWP_oc>KI0ol2Z9h;olcVf@?o0ZRN2_o<i]T3o`:XWPgoc>KI0_l2Z9h<olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI0_oS5``4olcVf@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9kohaL<olcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0000olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h;olcVf@;o0ZRN
3Oo<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWP_oc>KI0ol2Z9h7olcVf@;o0000
0Oooool000kooooo00Co0000o`:XW_l2Z9ko0ZRN2_o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@?o0ZRN
2oo<i]T3o`:XWP[oc>KI0ol2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h6olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNon<G3?o<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G
3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol0003oc>KIolcVf@03olcVf@03on<G
3?o<i]Woc>KI00Coc>KI00?o0ZRNon<G3?o<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G
3?o<i]Woc>KI00;oc>KI0_oS5``6olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@;o0ZRN
0Oooool000kooooo0_l00002olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3?o<
i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00;oc>KI00?o0ZRNon<G3?o<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_oS
5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol0003oc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01?o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<
i]T2o`:XWPcoc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h2o`00007ooooo000>
ooooo`;o0000E?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI0_oS5``3
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0000olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03
olcVf@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@02
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1A
olcVf@;o00000Oooool000kooooo0_l0001ZolcVf@05on<G3?o<i]Woc>KIolcVfOoS5``01Oo<i]T0
0ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNon<G3?o<i]T01?o<i]T0
0ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T0I_o<i]T2
o`00007ooooo000>ooooo`;o0000Joo<i]T01OoS5`coc>KIolcVfOo<i]WohaL<00Goc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0000
olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI06Ooc>KI0_l00001
ooooo`003_ooool2o`0006coc>KI00GohaL<olcVfOo<i]Woc>KIon<G3004olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`000?o<i]Wo
c>KI00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Wo
c>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@1XolcVf@;o00000Oooool0
00kooooo0_l0001]olcVf@;ohaL<0_o<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI
00?oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`000?o<i]Woc>KI
00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI
00;oc>KI00CohaL<olcVfOo<i]Woc>KI0_oS5`a[olcVf@;o00000Oooool000kooooo0_l0001_olcV
f@04on<G3?o<i]Woc>KIon<G30Coc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@02
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0000olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@02
olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T01OoS5`coc>KIolcVfOo<
i]WohaL<06goc>KI0_l00001ooooo`003_ooool2o`00073oc>KI00CohaL<olcVfOo<i]WohaL<1?o<
i]T00ooS5`coc>KIolcVf@02olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``01Oo<i]T00ol0003oc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI00;oc>KI00GohaL<olcVfOo<i]Woc>KIon<G3004olcVf@05
on<G3?o<i]Woc>KIolcVfOoS5``0K_o<i]T2o`00007ooooo000>ooooo`;o0000LOo<i]T01?oS5`co
c>KIolcVfOoS5``3olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS
5`coc>KIolcVf@02olcVf@05o`000?o<i]Woc>KIolcVfOoS5``01?o<i]T00ooS5`coc>KIolcVf@02
olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``00oo<i]T00ooS5`coc>KIolcVf@1]olcVf@;o00000Ooo
ool000kooooo0_l0001bolcVf@04on<G3?o<i]Woc>KIon<G30?oc>KI00GohaL<olcVfOo<i]Woc>KI
on<G3004olcVf@03on<G3?o<i]Woc>KI00;oc>KI00Go0000olcVfOo<i]Woc>KIon<G3004olcVf@05
on<G3?o<i]Woc>KIolcVfOoS5``00oo<i]T01OoS5`coc>KIolcVfOo<i]WohaL<073oc>KI0_l00001
ooooo`003_ooool2o`0007?oc>KI00?ohaL<olcVfOo<i]T00_oS5``2olcVf@05on<G3?o<i]Woc>KI
olcVfOoS5``00oo<i]T00ooS5`coc>KIolcVf@02olcVf@05o`000?o<i]Woc>KIolcVfOoS5``00oo<
i]T01OoS5`coc>KIolcVfOo<i]WohaL<00;oc>KI00?o0ZRNon<G3?o<i]T00_o<i]T00ooS5`coc>KI
olcVf@1_olcVf@;o00000Oooool000kooooo0_l0001JolcVf@;o0ZRN3?o<i]T2o`:XWP[oc>KI00Oo
haL<olcVfOo<i]Woc>KIon<G3?o<i]WohaL<00?oc>KI00GohaL<olcVfOo<i]Woc>KIon<G3004olcV
f@05o`000?o<i]Woc>KIolcVfOoS5``00oo<i]T02?oS5`coc>KIolcVfOo<i]WohaL<olcVfOl2Z9ko
haL<0oo<i]T00ooS5`coc>KIolcVf@07olcVf@;o0ZRN3?o<i]T2o`:XWUWoc>KI0_l00001ooooo`00
3_ooool2o`0000Woc>KI1Ol2Z9h8olcVf@Go0ZRN2Oo<i]T5o`:XWPSoc>KI1Ol2Z9h9olcVf@Go0ZRN
2Oo<i]T3o`:XWPcoc>KI0ol2Z9h;olcVf@?o0ZRN2?o<i]T01ooS5`coc>KIolcVfOo<i]WohaL<olcV
fOoS5``00oo<i]T01OoS5`coc>KIolcVfOo<i]WohaL<00?oc>KI00Co0000olcVfOo<i]WohaL<0oo<
i]T02?oS5`coc>KIolcVfOo<i]WohaL<olcVfOl2Z9kohaL<0oo<i]T00ooS5`coc>KIolcVf@05olcV
f@?o0ZRN2oo<i]T3o`:XWPgoc>KI0ol2Z9h9olcVf@Co0ZRN2Oo<i]T5o`:XWPWoc>KI1?l2Z9h9olcV
f@Go0ZRN2Oo<i]T5o`:XWPOoc>KI0_l00001ooooo`003_ooool00ol0003o0ZRNo`:XWP03o`:XWP[o
c>KI0ol2Z9h:olcVf@Co0ZRN2_o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@Co0ZRN2?o<i]T3o`:XWPco
c>KI0ol2Z9h;olcVf@;o0ZRN1oo<i]T2on<G30;oc>KI00?ohaL<olcVfOoS5``00oo<i]T01?oS5`co
c>KIolcVfOoS5``3olcVf@04o`000?o<i]Woc>KIon<G30;oc>KI00SohaL<olcVfOo<i]Woc>KIon<G
3?o<i]Wo0ZRNon<G30;oc>KI0_oS5``6olcVf@;o0ZRN3?o<i]T2o`:XWPcoc>KI1?l2Z9h8olcVf@Co
0ZRN2Oo<i]T4o`:XWP[oc>KI1?l2Z9h9olcVf@Co0ZRN2_o<i]T4o`:XWP[oc>KI1?l2Z9h1ooooo`00
3_ooool2o`0005?oc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
1_o<i]T01_oS5`coc>KIolcVfOoS5`coc>KIon<G30;oc>KI00CohaL<olcVfOo<i]WohaL<0oo<i]T0
1?l0003oc>KIolcVfOoS5``2olcVf@07on<G3?o<i]Woc>KIon<G3?o<i]Wo0ZRNon<G3002olcVf@03
on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o
0ZRND_o<i]T2o`00007ooooo000>ooooo`;o0000NOo<i]T01_oS5`coc>KIolcVfOoS5`coc>KIon<G
30;oc>KI00CohaL<olcVfOo<i]WohaL<0_o<i]T00ol0003oc>KIon<G3002olcVf@08on<G3?o<i]Wo
c>KIon<G3?o<i]Wo0ZRNon<G3?o<i]T2on<G37Ooc>KI0_l00001ooooo`003_ooool2o`0007[oc>KI
00?ohaL<olcVfOo<i]T00_oS5``2olcVf@04on<G3?o<i]Woc>KIon<G30;oc>KI00?o0000olcVfOoS
5``00_o<i]T02?oS5`coc>KIolcVfOoS5`coc>KIon<G3?o<i]WohaL<NOo<i]T2o`00007ooooo000>
ooooo`;o0000Noo<i]T2on<G3003olcVfOoS5`cohaL<00;oc>KI00?ohaL<olcVfOoS5``00_o<i]T0
1Ol0003oc>KIon<G3?o<i]WohaL<00;oc>KI00?ohaL<olcVfOoS5``00_oS5`ajolcVf@;o00000Ooo
ool000kooooo0_l0001molcVf@06on<G3?o<i]WohaL<on<G3?o<i]WohaL<0_o<i]T01?oS5`coc>KI
o`000?oS5``2olcVf@04on<G3?o<i]WohaL<olcVf@;ohaL<O?o<i]T2o`00007ooooo000>ooooo`;o
0000O_o<i]T04?oS5`coc>KIon<G3?oS5`coc>KIon<G3?o<i]WohaL<olcVfOl0003ohaL<olcVfOoS
5`coc>KIon<G3?o<i]T2on<G37goc>KI0_l00001ooooo`003_ooool2o`0007ooc>KI0ooS5``02_o<
i]WohaL<olcVfOoS5`coc>KIo`000?oS5`coc>KIon<G3?o<i]T3on<G37koc>KI0_l00001ooooo`00
3_ooool2o`00087oc>KI0_oS5``01Oo<i]WohaL<on<G3?o<i]Wo000000;ohaL<00Coc>KIon<G3?oS
5`cohaL<Ooo<i]T2o`00007ooooo000>ooooo`;o0000P_o<i]T4on<G3003olcVfOl0003ohaL<00Co
haL<P?o<i]T2o`00007ooooo000>ooooo`;o0000P_o<i]T00ooS5`coc>KIon<G3002on<G3003o`00
0?oS5`cohaL<00;ohaL<POo<i]T2o`00007ooooo0008ooooo`;o00001?ooool2o`0008?oc>KI1?oS
5``01?l0003ohaL<on<G3?oS5`b2olcVf@;o00000Oooool000Oooooo00Co0000oooooooooooo0000
0oooool2o`0008Goc>KI0_oS5``00ol0003ohaL<on<G3023olcVf@;o00000Oooool000Oooooo00Co
0000oooooooooooo00000oooooooo`0001;o00000Oooool000Oooooo00Co0000oooooooooooo0000
0oooool2o`0008Goc>KI0_oS5``00ol0003ohaL<o`:XWP23olcVf@;o00000Oooool000Oooooo00Co
0000oooooooooooo00000oooool2o`0008Coc>KI0ooS5``00ol0003ohaL<on<G3023olcVf@;o0000
0Oooool000Oooooo00Co0000oooooooooooo00000oooool2o`0008?oc>KI1?oS5``00ol0003ohaL<
on<G3002on<G387oc>KI0_l00001ooooo`002?ooool2o`0000Cooooo0_l00021olcVf@KohaL<00Ko
0000on<G3?oS5`cohaL<olcVfOoS5`b0olcVf@;o00000Oooool000kooooo0_l00020olcVf@03on<G
3?o<i]WohaL<00?ohaL<00?oc>KIo`000?oS5``01OoS5`aoolcVf@;o00000Oooool000kooooo0_l0
001nolcVf@;ohaL<00Coc>KIon<G3?oS5`coc>KI0_oS5``01oo<i]Wo0000on<G3?oS5`coc>KIon<G
3?o<i]T00ooS5`amolcVf@;o00000Oooool000kooooo0_l0001molcVf@03on<G3?o<i]Woc>KI00;o
haL<00ooc>KIon<G3?o<i]WohaL<olcVfOl0003ohaL<olcVfOoS5`coc>KIon<G3?o<i]WohaL<olcV
fOoS5``0O?o<i]T2o`00007ooooo000>ooooo`;o0000O?o<i]T04OoS5`coc>KIolcVfOoS5`coc>KI
on<G3?o<i]WohaL<olcVfOoS5`coc>KIo`000?oS5`coc>KIon<G3?o<i]WohaL<00;oc>KI00?ohaL<
olcVfOoS5``0Noo<i]T2o`00007ooooo000>ooooo`;o0000Noo<i]T02?oS5`coc>KIolcVfOoS5`co
c>KIon<G3?o<i]WohaL<0_o<i]T01?oS5`coc>KIo`000?oS5``2olcVf@03on<G3?o<i]WohaL<00;o
c>KI00CohaL<olcVfOoS5`cohaL<NOo<i]T2o`00007ooooo000>ooooo`;o0000N_o<i]T01_oS5`co
c>KIolcVfOoS5`coc>KIon<G30;oc>KI00?ohaL<olcVfOoS5``00_o<i]T01Ol0003oc>KIon<G3?o<
i]WohaL<00;oc>KI00CohaL<olcVfOo<i]WohaL<0_o<i]T00ooS5`coc>KIolcVf@1folcVf@;o0000
0Oooool000kooooo0_l0001iolcVf@06on<G3?o<i]Wo0ZRNon<G3?o<i]WohaL<0_o<i]T01?oS5`co
c>KIolcVfOoS5``2olcVf@03o`000?o<i]WohaL<00;oc>KI00OohaL<olcVfOo<i]WohaL<olcVfOl2
Z9kohaL<00;oc>KI00?ohaL<olcVfOo<i]T0MOo<i]T2o`00007ooooo000>ooooo`;o0000K_o<i]T2
o`:XWPSoc>KI00CohaL<olcVfOl2Z9kohaL<0_o<i]T01?oS5`coc>KIolcVfOoS5``2olcVf@06on<G
3?o<i]Woc>KIo`000?o<i]WohaL<0_o<i]T01?oS5`coc>KIolcVfOoS5``2olcVf@05on<G3?l2Z9ko
c>KIolcVfOoS5``01oo<i]T2o`:XWVgoc>KI0_l00001ooooo`003_ooool2o`000004olcVfOl2Z9ko
0ZRNo`:XWPWoc>KI1?l2Z9h9olcVf@Go0ZRN2Oo<i]T4o`:XWPWoc>KI1Ol2Z9h;olcVf@?o0ZRN2_o<
i]T3o`:XWP_oc>KI0ol2Z9h8olcVf@?o0ZRN2Oo<i]T01?oS5`coc>KIo`:XW_oS5``2olcVf@04on<G
3?o<i]Woc>KIon<G30;oc>KI00GohaL<olcVfOo<i]Woc>KIo`000002olcVf@04on<G3?o<i]Woc>KI
on<G30;oc>KI00GohaL<olcVfOo<i]WohaL<o`:XWP02olcVf@03on<G3?o<i]Woc>KI00Koc>KI0ol2
Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@Go0ZRN2Oo<i]T5o`:XWPSoc>KI1Ol2
Z9h9olcVf@Go0ZRN2Oo<i]T3o`:XWP7o00000Oooool000kooooo00?o0000o`:XW_l2Z9h02?o<i]T4
o`:XWPWoc>KI1?l2Z9h:olcVf@Co0ZRN2Oo<i]T4o`:XWPcoc>KI1?l2Z9h:olcVf@?o0ZRN2_o<i]T4
o`:XWPWoc>KI0_l2Z9h:olcVf@;ohaL<00?oc>KIo`:XW_oS5``00_o<i]T01OoS5`coc>KIolcVfOo<
i]WohaL<00;oc>KI00GohaL<olcVfOo<i]Woc>KIo`000002olcVf@04on<G3?o<i]Woc>KIon<G30?o
c>KI00GohaL<olcVfOo<i]WohaL<o`:XWP02olcVf@;ohaL<2Oo<i]T2o`:XWP[oc>KI0ol2Z9h:olcV
f@Co0ZRN2_o<i]T3o`:XWPcoc>KI1?l2Z9h:olcVf@?o0ZRN2_o<i]T4o`:XWP[oc>KI1?l2Z9h7olcV
f@7o00000Ol2Z9h1ooooo`003_ooool2o`0003ooc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01OoS5`coc>KIolcVfOl2Z9kohaL<00?oc>KI00CohaL<olcV
fOo<i]WohaL<0oo<i]T01OoS5`coc>KIolcVfOo<i]Wo000000;oc>KI00GohaL<olcVfOo<i]Woc>KI
on<G3002olcVf@06on<G3?o<i]Woc>KIolcVfOoS5`co0ZRN0oo<i]T00ooS5`coc>KIolcVf@08olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWSkoc>KI0_l00001oooo
o`003_ooool2o`0007?oc>KI00GohaL<olcVfOo<i]Wo0ZRNon<G3003olcVf@05on<G3?o<i]Woc>KI
olcVfOoS5``00_o<i]T00ooS5`coc>KIolcVf@02olcVf@05o`000?o<i]Woc>KIolcVfOoS5``00_o<
i]T01OoS5`coc>KIolcVfOo<i]WohaL<00?oc>KI00?ohaL<o`:XW_o<i]T00_o<i]T00ooS5`coc>KI
olcVf@1_olcVf@;o00000Oooool000kooooo0_l0001aolcVf@;ohaL<0oo<i]T01OoS5`coc>KIolcV
fOo<i]WohaL<00?oc>KI00GohaL<olcVfOo<i]Woc>KIon<G3004olcVf@05o`000?o<i]Woc>KIolcV
fOoS5``00oo<i]T01OoS5`coc>KIolcVfOo<i]WohaL<00?oc>KI0_oS5``3olcVf@;ohaL<Koo<i]T2
o`00007ooooo000>ooooo`;o0000L?o<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI
00;oc>KI00GohaL<olcVfOo<i]Woc>KIon<G3003olcVf@03on<G3?o<i]Woc>KI00;oc>KI00Go0000
olcVfOo<i]Woc>KIon<G3003olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``01Oo<i]T00ooS5`coc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI06coc>KI0_l00001ooooo`003_ooool2o`0006ooc>KI00?o
haL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@02olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``0
1?o<i]T00ooS5`coc>KIolcVf@02olcVf@05o`000?o<i]Woc>KIolcVfOoS5``01?o<i]T01OoS5`co
c>KIolcVfOo<i]WohaL<00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@1[olcV
f@;o00000Oooool000kooooo0_l0001^olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<
i]T00_o<i]T00ooS5`coc>KIolcVf@02olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``01Oo<i]T00ol0
003oc>KIolcVf@02olcVf@05on<G3?o<i]Woc>KIolcVfOoS5``01?o<i]T00ooS5`coc>KIolcVf@03
olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T0J_o<i]T2o`00007ooooo000>oooo
o`;o0000K?o<i]T2on<G30Coc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@02olcV
f@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol0003oc>KIolcVf@02olcV
f@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@03olcV
f@03on<G3?o<i]Woc>KI00;oc>KI0_oS5`aZolcVf@;o00000Oooool000kooooo0_l0001[olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@03olcVf@03
on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol0003oc>KIolcVf@02olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@03olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0Ioo<i]T2o`00007ooooo000>ooooo`;o0000
J_o<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0000olcVfOo<i]T0
0_o<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI06Koc>KI0_l00001ooooo`003_oo
ool2o`0006Woc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`000?o<
i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9kohaL<olcVf@03olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@1UolcVf@;o00000Ooo
ool000kooooo0_l0001PolcVf@;o0ZRN1Oo<i]T2on<G30Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
0ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNon<G3?o<i]T01?o<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T2
o`:XWUooc>KI0_l00001ooooo`003_ooool2o`0000?oc>KI00?o0ZRNolcVfOo<i]T05_o<i]T3o`:X
WP[oc>KI0ol2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI
00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T2on<G30Goc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0000olcVfOo<i]T00oo<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9kohaL<olcVf@04olcVf@;ohaL<1Oo<i]T2o`:XWPWoc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:X
WPcoc>KI0ol2Z9h;olcVf@?o0ZRN6?o<i]T01?l2Z9koc>KIo`000?l00001ooooo`003_ooool00ol0
003o0ZRNo`:XWP03o`:XWPWoc>KI1?l2Z9h7olcVf@Co0ZRN2_o<i]T3o`:XWPcoc>KI0ol2Z9h:olcV
f@?o0ZRN2oo<i]T3o`:XWP[oc>KI0_l2Z9h6olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<o`:X
W_o<i]T01Oo<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?ohaL<olcV
fOo<i]T01?o<i]T00ol0003oc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNon<G
3?o<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_oS5`coc>KI00Goc>KI00?ohaL<olcV
fOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@08olcVf@?o0ZRN2oo<i]T3o`:XWP[oc>KI0ol2Z9h<olcV
f@?o0ZRN2oo<i]T3o`:XWPOoc>KI1Ol2Z9h9olcVf@Co0ZRN0Oooool000kooooo0_l00009olcVf@Co
0ZRN2Oo<i]T2o`:XWPcoc>KI0_l2Z9h=olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h<olcVf@03
o`:XW_o<i]Woc>KI00Coc>KI0_oS5``5olcVf@03on<G3?l2Z9koc>KI00Goc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0000olcVfOo<
i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_oS5`coc>KI00Coc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ol2Z9kohaL<olcVf@05olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h;olcVf@;o
0ZRN3?o<i]T2o`:XWP_oc>KI0ol2Z9h<olcVf@;o0ZRN3?o<i]T2o`:XWP[oc>KI1?l2Z9h7olcVf@;o
00000Oooool000kooooo0_l0000bolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ooS5`co0ZRNolcVf@05olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNon<G3?o<i]T0
1?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`000?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNon<G3?o<i]T0
1Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI02koc>KI0_l00001ooooo`003_oo
ool2o`00067oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`co0ZRNolcVf@05olcVf@03on<G3?o<
i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`000?o<
i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9kohaL<olcVf@05olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNon<G3?o<i]T01Oo<i]T00ooS5`coc>KIolcVf@1NolcVf@;o00000Ooo
ool000kooooo0_l0001PolcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01_o<i]T0
0ooS5`coc>KIolcVf@04olcVf@03o`:XW_oS5`coc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ol0003oc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0GOo<i]T2
o`00007ooooo000>ooooo`;o0000G_o<i]T2on<G30Koc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS
5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol0
003oc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_oS5`aMolcVf@;o00000Oooool000ko
oooo0_l0001MolcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`co
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol0003o
c>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0F_o<i]T2o`00007o
oooo000>ooooo`;o0000G?o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Ooc>KI
00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Koc>KI
00?o0000olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI05Woc>KI
0_l00001ooooo`003_ooool2o`0005_oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcV
f@07olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcV
f@06olcVf@03o`000?o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcV
f@06olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcV
f@1HolcVf@;o00000Oooool000kooooo0_l0001IolcVf@;ohaL<1oo<i]T00ooS5`coc>KIolcVf@07
olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@06
olcVf@03o`000?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@05
olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2on<G35Soc>KI0_l00001
ooooo`003_ooool2o`0005Soc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@07olcV
f@03on<G3?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T00_o<i]T01Ol2Z9koc>KIolcVfOo<i]Wo
haL<00Soc>KI00?o0000olcVfOo<i]T01_o<i]T01?oS5`coc>KIolcVfOl2Z9h5olcVf@03on<G3?o<
i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@06olcVf@03on<G3?o<
i]Woc>KI05Goc>KI0_l00001ooooo`003_ooool2o`0005Ooc>KI00?ohaL<olcVfOo<i]T01_o<i]T0
0ooS5`co0ZRNolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPGoc>KI00?ohaL<olcVfOo<i]T00oo<
i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0000olcVfOo<i]T01_o<i]T01?oS5`coc>KI
olcVfOl2Z9h6olcVf@03on<G3?o<i]Woc>KI00?oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ooS
5`coc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI05Coc>KI0_l00001ooooo`003_ooool2o`0002[o
c>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h2olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI00?ohaL<o`:XW_o<i]T02?o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Goc>KI00?ohaL<olcV
fOo<i]T00oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`000?o<i]Woc>KI00Ooc>KI00?ohaL<
olcVfOl2Z9h01_o<i]T00ooS5`coc>KIolcVf@03olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<
i]T00ol2Z9kohaL<olcVf@07olcVf@03on<G3?o<i]Woc>KI00;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2
Z9h;olcVf@;o0ZRN:Oo<i]T2o`00007ooooo000>ooooo`;o000000Coc>KIo`:XW_l2Z9ko0ZRN2_o<
i]T3o`:XWP_oc>KI0ol2Z9h8olcVf@?o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<
i]Woc>KI00;ohaL<2?o<i]T00ooS5`co0ZRNolcVf@08olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h0
1Oo<i]T00ooS5`coc>KIolcVf@03olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol0003o
c>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNon<G3?o<i]T01oo<i]T2on<G30;oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h;
olcVf@?o0ZRN0Ol00001ooooo`003_ooool00ol0003o0ZRNo`:XWP0:olcVf@?o0ZRN2_o<i]T4o`:X
WPWoc>KI0_l2Z9h>olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:X
WP;oc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KI
o`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o
0000olcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h6olcVf@03on<G3?o<i]Woc>KI00Coc>KI
00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00;o
0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h:olcVf@?o
0ZRN2_o<i]T3o`:XWP[oc>KI0Ol00001o`:XWP7ooooo000>ooooo`;o00002Oo<i]T2o`:XWP_oc>KI
0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00coc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T01Ol2Z9koc>KI
olcVfOo<i]WohaL<00[oc>KI00?ohaL<olcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h6olcV
f@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`000?o<i]Wo
c>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<i]T00ooS5`coc>KIolcVf@03olcVf@05o`:XW_o<
i]Woc>KIolcVfOoS5``02Oo<i]T00ooS5`coc>KIolcVf@08olcVf@05on<G3?o<i]Woc>KIolcVfOl2
Z9h03?o<i]T2o`:XWPcoc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o
0ZRN2?o<i]T2o`00007ooooo000>ooooo`;o0000<_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G300:olcVf@03on<G3?o<i]Woc>KI00So
c>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<i]T00ooS5`coc>KIolcVf@04olcVf@04o`:XW_o<i]Woc>KI
on<G30[oc>KI00?o0000olcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP07olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03on<G3?o<i]Woc>KI00Soc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
;_o<i]T2o`00007ooooo000>ooooo`;o0000Coo<i]T2on<G30[oc>KI00?ohaL<olcVfOo<i]T02?o<
i]T01?oS5`coc>KIolcVfOl2Z9h7olcVf@03on<G3?o<i]Woc>KI00Coc>KI00Go0ZRNolcVfOo<i]Wo
c>KIon<G300:olcVf@03o`000?o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN1oo<i]T00ooS
5`coc>KIolcVf@04olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ooS5`coc>KIolcVf@08
olcVf@;ohaL<C_o<i]T2o`00007ooooo000>ooooo`;o0000C_o<i]T00ooS5`coc>KIolcVf@09olcV
f@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@04olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02_o<i]T00ol0003oc>KIolcVf@08olcVf@04on<G3?o<i]Wo
c>KIo`:XWPOoc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<
i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0Boo<i]T2o`00007ooooo000>ooooo`;o0000COo<i]T0
0ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T0
0ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T02?o<i]T0
0ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T02?o<i]T0
0ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI04[oc>KI0_l00001ooooo`003_ooool2o`00
04coc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI
00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09olcVf@03o`000?o<i]Woc>KI
00Woc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI
00Soc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@19olcVf@;o00000Oooool000ko
oooo0_l0001:olcVf@;ohaL<2oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00Wo
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03o`000?o<i]Woc>KI00Wo
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Wo
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T2on<G34Woc>KI0_l00001ooooo`003_ooool2o`0004Woc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI
00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03o`000?o<i]Woc>KI00Woc>KI
00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00Woc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@16olcVf@;o00000Oooool000kooooo0_l0
0018olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@09olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol0003oc>KIolcV
f@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcV
f@09olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0AOo<i]T2o`00007ooooo000>
ooooo`;o0000Aoo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0ZRN
on<G3?o<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0000
olcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<
olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI04Coc>KI0_l00001
ooooo`001_ooool5o`0000?ooooo0_l0000golcVf@;o0ZRN3?o<i]T2on<G30coc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI0_oS5``00ol2
Z9koc>KIolcVf@09olcVf@;o0ZRN=_o<i]T2o`00007ooooo0007ooooo`04o`000?ooooooooooo`00
00?ooooo0_l000001?o<i]Wo0ZRNo`:XW_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;
olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ooS5`coc>KIolcVf@0:
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ooS5`co0ZRNolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0ol2Z9h1
o`00007ooooo0008ooooo`03o`000?oooooooooo00?ooooo00?o0000o`:XW_l2Z9h02oo<i]T3o`:X
WP_oc>KI0_l2Z9h;olcVf@?o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI
00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI
00_oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@?o0ZRN2oo<i]T3o`:X
WP[oc>KI0ol2Z9h;olcVf@7o00000Ol2Z9h1ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o
00002_o<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03
on<G3?l2Z9koc>KI00_oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o
0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;o00000Oooool000Kooooo00Go0000oooooooooooo
ooooo`000003ooooo`;o00002Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?l2Z9koc>KI00_o
c>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000Oooool000Kooooo
00Go0000ooooooooooooooooo`000003ooooo`;o0000<_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o
haL<3Oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?ohaL<o`:XW_o<
i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<
i]T02_o<i]T00ol2Z9kohaL<olcVf@0<olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<o`:XW_o<
i]T02oo<i]T2on<G30coc>KI00?o0ZRNolcVfOo<i]T0;oo<i]T2o`00007ooooo0007ooooo`?o0000
1?ooool2o`0003koc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`00
0?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0kolcVf@;o0000
0Oooool000kooooo0_l0000molcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<
i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<
i]T00ol0003oc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<
i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T0>_o<
i]T2o`00007ooooo000>ooooo`;o0000??o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Wo
c>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Wo
c>KI03Woc>KI0_l00001ooooo`003_ooool2o`0003[oc>KI0_oS5``>olcVf@03on<G3?o<i]Woc>KI
00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI
00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI
00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@;ohaL<>Oo<i]T2o`00
007ooooo000>ooooo`;o0000>Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00go
c>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00go
c>KI00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00co
c>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI03Ko
c>KI0_l00001ooooo`003_ooool2o`0003Soc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0=olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0<olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0eolcVf@;o00000Oooool000kooooo0_l0000golcVf@03on<G3?o<i]Woc>KI00goc>KI00?o
haL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0000olcVfOo<i]T0
2Oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0dolcVf@;o00000Oooool000kooooo0_l0000eolcVf@;ohaL<3_o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcV
f@03o`000?o<i]Woc>KI00Woc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Wo
c>KIolcVfOl2Z9h02oo<i]T00ooS5`co0ZRNolcVf@0=olcVf@;ohaL<=?o<i]T2o`00007ooooo000>
ooooo`;o000000Coc>KIo`:XW_l2Z9ko0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN2?o<
i]T00ooS5`coc>KIolcVf@02o`:XWPcoc>KI00?ohaL<olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcV
fOoS5``9olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KI
olcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol0003oc>KIolcVf@09olcVf@05
o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI
00?oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?ohaL<
olcVfOo<i]T02_o<i]T2o`:XWP;oc>KI00?ohaL<olcVfOo<i]T01oo<i]T2o`:XWP_oc>KI0_l2Z9h;
olcVf@;o0ZRN3?o<i]T2o`:XWP;o00000Oooool000kooooo0_l000000ol2Z9koc>KIolcVf@0:olcV
f@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2Oo<i]T01?oS5`coc>KIolcVfOl2Z9h=
olcVf@03on<G3?o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcV
f@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcV
fOl2Z9h=olcVf@03o`000?o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`co
c>KIolcVfOo<i]Wo0ZRN00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI0Ol2Z9h1
o`00007ooooo000>ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:X
WPcoc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03on<G3?o<i]Wo
c>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI
00?o0000olcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<
i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<
i]Woc>KIo`:XWP0<olcVf@03on<G3?o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T2
o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0Ol00001o`:XWP7ooooo000>oooo
o`;o00002_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP[oc>KI00CohaL<olcV
fOo<i]Wo0ZRN3Oo<i]T00ooS5`coc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`000?o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Wo
c>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9ko
c>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?ohaL<olcVfOo<i]T02oo<i]T01?l2
Z9koc>KIolcVfOoS5``;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2
o`:XWPWoc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_oS5``2olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRN
olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<
olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`000?o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KI
on<G3009olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KI
olcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@02on<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI0_l00001ooooo`003_ooool2o`0002koc>KI00GohaL<olcVfOo<i]Wo
c>KIo`:XWP0=olcVf@03on<G3?o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcV
f@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@07olcV
f@04on<G3?o<i]Woc>KIo`:XWPkoc>KI00?o0000olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS
5``9olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcV
f@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ooS5`coc>KIolcVf@0;olcVf@05o`:X
W_o<i]Woc>KIolcVfOoS5``0;Oo<i]T2o`00007ooooo000>ooooo`;o0000;Oo<i]T00ooS5`coc>KI
olcVf@0?olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KI
olcVf@04olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3_o<i]T00ol0003o
c>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS
5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS
5`coc>KIolcVf@0ZolcVf@;o00000Oooool000kooooo0_l0000/olcVf@03on<G3?o<i]Woc>KI00oo
c>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00oo
c>KI00?ohaL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00oo
c>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00oo
c>KI00?ohaL<olcVfOo<i]T0:Oo<i]T2o`00007ooooo000>ooooo`;o0000:_o<i]T2on<G317oc>KI
00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00ooc>KI
00?ohaL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00ooc>KI
00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI00ooc>KI
0_oS5``YolcVf@;o00000Oooool000kooooo0_l0000YolcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T04?o<i]T00ol0003oc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o
haL<olcVfOo<i]T09_o<i]T2o`00007ooooo000>ooooo`;o0000:?o<i]T00ooS5`coc>KIolcVf@0@
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o0000olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0@
olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@
olcVf@03on<G3?o<i]Woc>KI02Goc>KI0_l00001ooooo`003_ooool2o`0002Ooc>KI00?ohaL<olcV
fOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcV
fOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<i]Woc>KI013oc>KI00?ohaL<olcV
fOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcV
fOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0TolcVf@;o00000Oooool000kooooo0_l0000UolcVf@;o
haL<4_o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<
i]T04?o<i]T2on<G32Coc>KI0_l00001ooooo`003_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T0
5oo<i]T2o`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T2o`:XWP_oc>KI00?o0ZRNon<G3?o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@;o0ZRN1?o<i]T00ooS5`coc>KIolcVf@04olcVf@;o0ZRN
6Oo<i]T01?l2Z9koc>KIo`000?l00001ooooo`003_ooool2o`000003olcVfOl2Z9ko0ZRN00coc>KI
0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_oS5`coc>KI00coc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI
0_l2Z9h2o`00007ooooo000>ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI00?o
0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNon<G3?o<i]T03?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?o
haL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
haL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0Ol2
Z9h1o`00007ooooo000>ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@04olcVf@;ohaL<1Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`co
c>KI00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9ko
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KIolcVf@02olcVf@;ohaL<1_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2_o<i]T1o`00007o0ZRN0Oooool000kooooo0_l0000:olcV
f@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcV
fOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcV
fOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcV
fOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KIolcVf@03olcVf@03
on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o
00000Oooool000kooooo0_l0000MolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01[oc>KI0_l00001ooooo`003_oo
ool2o`0001_oc>KI0_oS5``DolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<
i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T04_o<
i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<
i]T00ooS5`coc>KIolcVf@0BolcVf@;ohaL<6_o<i]T2o`00007ooooo000>ooooo`;o00006_o<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T04_o<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Ooc>KI0_l00001ooooo`003_ooool2o`00
01Woc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI
01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0ColcVf@03o`000?o<i]Woc>KI
01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI
01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0FolcVf@;o00000Oooool000ko
oooo0_l0000HolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`co
c>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ol0003o
c>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05Oo<i]T2o`00007o
oooo000>ooooo`;o00005_o<i]T2on<G31Goc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KI
olcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ol0003oc>KI
olcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KI
olcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI0_oS5``EolcVf@;o00000Oooool000kooooo0_l0
000EolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcV
f@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcV
f@0DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcV
f@0DolcVf@03on<G3?o<i]Woc>KI01;oc>KI0_l00001ooooo`003_ooool2o`0001Coc>KI00?ohaL<
olcVfOo<i]T04oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<
olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h0
3?o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<
i]T05?o<i]T00ooS5`coc>KIolcVf@0AolcVf@;o00000Oooool000kooooo0_l000000oo<i]Wo0ZRN
o`:XWP0<olcVf@;o0ZRN00?oc>KIon<G3?oS5``02?o<i]T2o`:XWPcoc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<
i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G
3009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T2o`:XWPSoc>KI0_oS
5``2olcVf@;o0ZRN2oo<i]T2o`:XWP;o00000Oooool000kooooo0_l000000ol2Z9koc>KIolcVf@0;
olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KI
olcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KI
olcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS
5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07
olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T1o`:XWP7o00000Oooool000kooooo00?o0000
o`:XW_o<i]T02oo<i]T2o`:XWP;oc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2
Z9h=olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03
o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@05
o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI0Ol00001
o`:XWP7ooooo000>ooooo`;o00002oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<
olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Wo
c>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0:
olcVf@;o00000Oooool000kooooo0_l0000:olcVf@03o`:XW_o<i]Woc>KI00;ohaL<2Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS
5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcV
fOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2on<G30;oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002Oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04
on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<
i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<
i]Woc>KI00coc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h8olcVf@;o
00000Oooool000kooooo0_l0000;olcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
5_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`co
c>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0FolcV
f@03on<G3?o<i]Woc>KI00Soc>KI0_l00001ooooo`003_ooool2o`0000[oc>KI00?ohaL<olcVfOo<
i]T05_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<
i]T05_o<i]T00ooS5`coc>KIolcVf@0FolcVf@03o`000?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<
i]T05_o<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<
i]T05_o<i]T00ooS5`coc>KIolcVf@07olcVf@;o00000Oooool000kooooo0_l00008olcVf@;ohaL<
6?o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T0
5oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03o`000?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T0
5oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
5_o<i]T2on<G30Ooc>KI0_l00001ooooo`003_ooool2o`0000Ooc>KI00?ohaL<olcVfOo<i]T05oo<
i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<
i]T00ooS5`coc>KIolcVf@0GolcVf@03o`000?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<
i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05oo<
i]T00ooS5`coc>KIolcVf@04olcVf@;o00000Oooool000kooooo0_l00006olcVf@03on<G3?o<i]Wo
c>KI01Ooc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI01Ooc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI01Ooc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Wo
c>KI01Ooc>KI00?ohaL<olcVfOo<i]T00oo<i]T2o`00007ooooo000>ooooo`;o00001Oo<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?o0000olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS
5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI00;oc>KI0_l00001ooooo`003_ooool2o`0000?o
c>KI0_oS5``IolcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`co
c>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI0_oS5``2olcVf@;o00000Oooool000Sooooo
0ol00003ooooo`;o00000_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@;o0ZRN2oo<i]T01?oS5`co0ZRN
o`000?l00001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o000000?oc>KIon<G3?o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l0003o0000007ooooo0006ooooo`Go00000ooo
ool2o`000003on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T1on<G307o00000Ooo
ool000Kooooo00Co0000oooooooooooo00001?ooool00ol0003ohaL<olcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS
5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI0Ol00001on<G307ooooo0007ooooo`03o`000?oooooo000000Cooooo0_l0000;
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<
olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l00001ooooo`002?ooool2o`0000Cooooo0_l0000:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcV
f@03o`:XW_o<i]Woc>KI00Koc>KI0_l00001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o
00005oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI01Coc>KI0_l00001ooooo`00
3_ooool2o`0001Koc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G
3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`00
0?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G
3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0ColcVf@;o0000
0Oooool000kooooo0_l0000EolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<
i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?o0000olcVfOo<i]T06Oo<
i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<
i]T00ooS5`coc>KIolcVf@0BolcVf@;o00000Oooool000kooooo0_l0000DolcVf@03on<G3?o<i]Wo
c>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Wo
c>KI01[oc>KI00?o0000olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Wo
c>KI01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0AolcVf@;o00000Oooool0
00kooooo0_l0000ColcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS
5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?o0000olcVfOo<i]T06_o<i]T00ooS
5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS
5`coc>KIolcVf@0@olcVf@;o00000Oooool000kooooo0_l0000BolcVf@03on<G3?o<i]Woc>KI01_o
c>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[o
c>KI00?o0000olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[o
c>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0?olcVf@;o00000Oooool000kooooo
0_l0000AolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KI
olcVf@0KolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?o0000olcVfOo<i]T06_o<i]T00ooS5`coc>KI
olcVf@0KolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KI
olcVf@0>olcVf@;o00000Oooool000kooooo0_l0000@olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<
i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcV
fOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcV
fOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T03Oo<i]T2
o`00007ooooo000>ooooo`;o000000?oc>KIo`:XW_l2Z9h03?o<i]T00ooS5`coc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G
3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03
o`:XW_l0003o0000007ooooo000>ooooo`;o000000?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2
Z9koc>KI00_oc>KI0Ol2Z9h1o`00007ooooo000>ooooo`03o`000?l2Z9koc>KI00coc>KI00?ohaL<
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`co0ZRNolcVf@0:olcVf@7o00000Ol2Z9h1ooooo`003_ooool2o`0000coc>KI00?ohaL<olcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
1?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<
i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<
i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRN
olcVf@09olcVf@;o00000Oooool000kooooo0_l0000;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<
i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS
5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@08
olcVf@;o00000Oooool000kooooo0_l0000:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRN
olcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?o
haL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T0
1oo<i]T2o`00007ooooo000>ooooo`;o00002Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<
i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<
i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@06olcVf@;o
00000Oooool000kooooo0_l00008olcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T0
7Oo<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o0000olcVfOo<i]T0
7?o<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T0
7Oo<i]T00ooS5`coc>KIolcVf@05olcVf@;o00000Oooool000kooooo0_l00007olcVf@03on<G3?o<
i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<
i]Woc>KI01goc>KI00?o0000olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<
i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@04olcVf@;o00000Ooo
ool000kooooo0_l00006olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T0
0ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o0000olcVfOo<i]T07Oo<i]T0
0ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T0
0ooS5`coc>KIolcVf@03olcVf@;o00000Oooool000kooooo0_l00005olcVf@03on<G3?o<i]Woc>KI
01koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI
01goc>KI00?o0000olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI
01coc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@02olcVf@;o00000Oooool000ko
oooo0_l00004olcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`co
c>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01koc>KI00?o0000olcVfOo<i]T07_o<i]T00ooS5`co
c>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07_o<i]T01?oS5`co
c>KIolcVfOo<i]T2o`00007ooooo000>ooooo`;o00000oo<i]T00ooS5`coc>KIolcVf@0NolcVf@03
on<G3?o<i]Woc>KI013oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI0_l2Z9h<olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0@olcVf@03
on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T00_l00001ooooo`003_ooool2o`0000;oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN1_o<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h4olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04on<G3?l2Z9ko0000o`00007o
oooo000>ooooo`;o000000?oc>KIon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?ohaL<o`000?l000000Oooool000kooooo0_l000000ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcV
f@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcV
f@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcV
f@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcV
f@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T1on<G307o00000Ooo
ool000kooooo00?o0000on<G3?l000002ol000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o
000000Co000000?ohaL<o`000?l000001?l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000_o000000?ohaL<o`000?l000002_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o
000000Co000000?ohaL<o`000?l000000ol000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o
000001So000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000004o`000003on<G3?l0003o
000000?o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000;o`000003on<G3?l0003o
000000[o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000003o`000003on<G3?l0003o
000000Co000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000:o`00007ohaL<0Oooool0
00koooooool0000Bo`00007ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.56707, -5.51412, 0.0368353, \
0.0368353}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Degenerate", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = 0\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = 1\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-5\) \[LessEqual] x \[LessEqual] 5\)},
          {\(\(-5\) \[LessEqual] y \[LessEqual] 5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -5, x, 5], 
        LessEqual[ -5, y, 5]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx == 0\)], "Output"]
}, Closed]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], "==", "0"}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], "==", "1"}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 0], 
          Equal[ 
            Derivative[ 1][ x][ t], 1]}],
        Editable->False], TraditionalForm]], "Output"]
}, Closed]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0926184 0.5 0.0952381 [
[.12953 -0.0125 -6 -9 ]
[.12953 -0.0125 6 0 ]
[.31476 -0.0125 -6 -9 ]
[.31476 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68524 -0.0125 -3 -9 ]
[.68524 -0.0125 3 0 ]
[.87047 -0.0125 -3 -9 ]
[.87047 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .11905 -12 -4.5 ]
[-0.0125 .11905 0 4.5 ]
[-0.0125 .30952 -12 -4.5 ]
[-0.0125 .30952 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .69048 -6 -4.5 ]
[-0.0125 .69048 0 4.5 ]
[-0.0125 .88095 -6 -4.5 ]
[-0.0125 .88095 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12953 0 m
.12953 .00625 L
s
[(-4)] .12953 -0.0125 0 1 Mshowa
.31476 0 m
.31476 .00625 L
s
[(-2)] .31476 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68524 0 m
.68524 .00625 L
s
[(2)] .68524 -0.0125 0 1 Mshowa
.87047 0 m
.87047 .00625 L
s
[(4)] .87047 -0.0125 0 1 Mshowa
.125 Mabswid
.17584 0 m
.17584 .00375 L
s
.22214 0 m
.22214 .00375 L
s
.26845 0 m
.26845 .00375 L
s
.36107 0 m
.36107 .00375 L
s
.40738 0 m
.40738 .00375 L
s
.45369 0 m
.45369 .00375 L
s
.54631 0 m
.54631 .00375 L
s
.59262 0 m
.59262 .00375 L
s
.63893 0 m
.63893 .00375 L
s
.73155 0 m
.73155 .00375 L
s
.77786 0 m
.77786 .00375 L
s
.82416 0 m
.82416 .00375 L
s
.08322 0 m
.08322 .00375 L
s
.03691 0 m
.03691 .00375 L
s
.91678 0 m
.91678 .00375 L
s
.96309 0 m
.96309 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .11905 m
.00625 .11905 L
s
[(-4)] -0.0125 .11905 1 0 Mshowa
0 .30952 m
.00625 .30952 L
s
[(-2)] -0.0125 .30952 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .69048 m
.00625 .69048 L
s
[(2)] -0.0125 .69048 1 0 Mshowa
0 .88095 m
.00625 .88095 L
s
[(4)] -0.0125 .88095 1 0 Mshowa
.125 Mabswid
0 .16667 m
.00375 .16667 L
s
0 .21429 m
.00375 .21429 L
s
0 .2619 m
.00375 .2619 L
s
0 .35714 m
.00375 .35714 L
s
0 .40476 m
.00375 .40476 L
s
0 .45238 m
.00375 .45238 L
s
0 .54762 m
.00375 .54762 L
s
0 .59524 m
.00375 .59524 L
s
0 .64286 m
.00375 .64286 L
s
0 .7381 m
.00375 .7381 L
s
0 .78571 m
.00375 .78571 L
s
0 .83333 m
.00375 .83333 L
s
0 .07143 m
.00375 .07143 L
s
0 .02381 m
.00375 .02381 L
s
0 .92857 m
.00375 .92857 L
s
0 .97619 m
.00375 .97619 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12953 .99375 m
.12953 1 L
s
.31476 .99375 m
.31476 1 L
s
.5 .99375 m
.5 1 L
s
.68524 .99375 m
.68524 1 L
s
.87047 .99375 m
.87047 1 L
s
.125 Mabswid
.17584 .99625 m
.17584 1 L
s
.22214 .99625 m
.22214 1 L
s
.26845 .99625 m
.26845 1 L
s
.36107 .99625 m
.36107 1 L
s
.40738 .99625 m
.40738 1 L
s
.45369 .99625 m
.45369 1 L
s
.54631 .99625 m
.54631 1 L
s
.59262 .99625 m
.59262 1 L
s
.63893 .99625 m
.63893 1 L
s
.73155 .99625 m
.73155 1 L
s
.77786 .99625 m
.77786 1 L
s
.82416 .99625 m
.82416 1 L
s
.08322 .99625 m
.08322 1 L
s
.03691 .99625 m
.03691 1 L
s
.91678 .99625 m
.91678 1 L
s
.96309 .99625 m
.96309 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .11905 m
1 .11905 L
s
.99375 .30952 m
1 .30952 L
s
.99375 .5 m
1 .5 L
s
.99375 .69048 m
1 .69048 L
s
.99375 .88095 m
1 .88095 L
s
.125 Mabswid
.99625 .16667 m
1 .16667 L
s
.99625 .21429 m
1 .21429 L
s
.99625 .2619 m
1 .2619 L
s
.99625 .35714 m
1 .35714 L
s
.99625 .40476 m
1 .40476 L
s
.99625 .45238 m
1 .45238 L
s
.99625 .54762 m
1 .54762 L
s
.99625 .59524 m
1 .59524 L
s
.99625 .64286 m
1 .64286 L
s
.99625 .7381 m
1 .7381 L
s
.99625 .78571 m
1 .78571 L
s
.99625 .83333 m
1 .83333 L
s
.99625 .07143 m
1 .07143 L
s
.99625 .02381 m
1 .02381 L
s
.99625 .92857 m
1 .92857 L
s
.99625 .97619 m
1 .97619 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.03691 .02381 m
.03691 .97619 L
.96309 .97619 L
.96309 .02381 L
F
0 0 0 r
.01 w
.03691 .02381 m
.96309 .02381 L
.96309 .97619 L
.03691 .97619 L
.03691 .02381 L
s
0 g
.5 Mabswid
.03691 .5 m
.96309 .5 L
s
.5 .02381 m
.5 .97619 L
s
.01 .66 .62 r
.02381 .02381 m
.05001 .02381 L
s
.02381 .07143 m
.05001 .07143 L
s
.02381 .11905 m
.05001 .11905 L
s
.02381 .16667 m
.05001 .16667 L
s
.02381 .21429 m
.05001 .21429 L
s
.02381 .2619 m
.05001 .2619 L
s
.02381 .30952 m
.05001 .30952 L
s
.02381 .35714 m
.05001 .35714 L
s
.02381 .40476 m
.05001 .40476 L
s
.02381 .45238 m
.05001 .45238 L
s
.02381 .5 m
.05001 .5 L
s
.02381 .54762 m
.05001 .54762 L
s
.02381 .59524 m
.05001 .59524 L
s
.02381 .64286 m
.05001 .64286 L
s
.02381 .69048 m
.05001 .69048 L
s
.02381 .7381 m
.05001 .7381 L
s
.02381 .78571 m
.05001 .78571 L
s
.02381 .83333 m
.05001 .83333 L
s
.02381 .88095 m
.05001 .88095 L
s
.02381 .92857 m
.05001 .92857 L
s
.02381 .97619 m
.05001 .97619 L
s
.07012 .02381 m
.09632 .02381 L
s
.07012 .07143 m
.09632 .07143 L
s
.07012 .11905 m
.09632 .11905 L
s
.07012 .16667 m
.09632 .16667 L
s
.07012 .21429 m
.09632 .21429 L
s
.07012 .2619 m
.09632 .2619 L
s
.07012 .30952 m
.09632 .30952 L
s
.07012 .35714 m
.09632 .35714 L
s
.07012 .40476 m
.09632 .40476 L
s
.07012 .45238 m
.09632 .45238 L
s
.07012 .5 m
.09632 .5 L
s
.07012 .54762 m
.09632 .54762 L
s
.07012 .59524 m
.09632 .59524 L
s
.07012 .64286 m
.09632 .64286 L
s
.07012 .69048 m
.09632 .69048 L
s
.07012 .7381 m
.09632 .7381 L
s
.07012 .78571 m
.09632 .78571 L
s
.07012 .83333 m
.09632 .83333 L
s
.07012 .88095 m
.09632 .88095 L
s
.07012 .92857 m
.09632 .92857 L
s
.07012 .97619 m
.09632 .97619 L
s
.11643 .02381 m
.14262 .02381 L
s
.11643 .07143 m
.14262 .07143 L
s
.11643 .11905 m
.14262 .11905 L
s
.11643 .16667 m
.14262 .16667 L
s
.11643 .21429 m
.14262 .21429 L
s
.11643 .2619 m
.14262 .2619 L
s
.11643 .30952 m
.14262 .30952 L
s
.11643 .35714 m
.14262 .35714 L
s
.11643 .40476 m
.14262 .40476 L
s
.11643 .45238 m
.14262 .45238 L
s
.11643 .5 m
.14262 .5 L
s
.11643 .54762 m
.14262 .54762 L
s
.11643 .59524 m
.14262 .59524 L
s
.11643 .64286 m
.14262 .64286 L
s
.11643 .69048 m
.14262 .69048 L
s
.11643 .7381 m
.14262 .7381 L
s
.11643 .78571 m
.14262 .78571 L
s
.11643 .83333 m
.14262 .83333 L
s
.11643 .88095 m
.14262 .88095 L
s
.11643 .92857 m
.14262 .92857 L
s
.11643 .97619 m
.14262 .97619 L
s
.16274 .02381 m
.18893 .02381 L
s
.16274 .07143 m
.18893 .07143 L
s
.16274 .11905 m
.18893 .11905 L
s
.16274 .16667 m
.18893 .16667 L
s
.16274 .21429 m
.18893 .21429 L
s
.16274 .2619 m
.18893 .2619 L
s
.16274 .30952 m
.18893 .30952 L
s
.16274 .35714 m
.18893 .35714 L
s
.16274 .40476 m
.18893 .40476 L
s
.16274 .45238 m
.18893 .45238 L
s
.16274 .5 m
.18893 .5 L
s
.16274 .54762 m
.18893 .54762 L
s
.16274 .59524 m
.18893 .59524 L
s
.16274 .64286 m
.18893 .64286 L
s
.16274 .69048 m
.18893 .69048 L
s
.16274 .7381 m
.18893 .7381 L
s
.16274 .78571 m
.18893 .78571 L
s
.16274 .83333 m
.18893 .83333 L
s
.16274 .88095 m
.18893 .88095 L
s
.16274 .92857 m
.18893 .92857 L
s
.16274 .97619 m
.18893 .97619 L
s
.20905 .02381 m
.23524 .02381 L
s
.20905 .07143 m
.23524 .07143 L
s
.20905 .11905 m
.23524 .11905 L
s
.20905 .16667 m
.23524 .16667 L
s
.20905 .21429 m
.23524 .21429 L
s
.20905 .2619 m
.23524 .2619 L
s
.20905 .30952 m
.23524 .30952 L
s
.20905 .35714 m
.23524 .35714 L
s
.20905 .40476 m
.23524 .40476 L
s
.20905 .45238 m
.23524 .45238 L
s
.20905 .5 m
.23524 .5 L
s
.20905 .54762 m
.23524 .54762 L
s
.20905 .59524 m
.23524 .59524 L
s
.20905 .64286 m
.23524 .64286 L
s
.20905 .69048 m
.23524 .69048 L
s
.20905 .7381 m
.23524 .7381 L
s
.20905 .78571 m
.23524 .78571 L
s
.20905 .83333 m
.23524 .83333 L
s
.20905 .88095 m
.23524 .88095 L
s
.20905 .92857 m
.23524 .92857 L
s
.20905 .97619 m
.23524 .97619 L
s
.25536 .02381 m
.28155 .02381 L
s
.25536 .07143 m
.28155 .07143 L
s
.25536 .11905 m
.28155 .11905 L
s
.25536 .16667 m
.28155 .16667 L
s
.25536 .21429 m
.28155 .21429 L
s
.25536 .2619 m
.28155 .2619 L
s
.25536 .30952 m
.28155 .30952 L
s
.25536 .35714 m
.28155 .35714 L
s
.25536 .40476 m
.28155 .40476 L
s
.25536 .45238 m
.28155 .45238 L
s
.25536 .5 m
.28155 .5 L
s
.25536 .54762 m
.28155 .54762 L
s
.25536 .59524 m
.28155 .59524 L
s
.25536 .64286 m
.28155 .64286 L
s
.25536 .69048 m
.28155 .69048 L
s
.25536 .7381 m
.28155 .7381 L
s
.25536 .78571 m
.28155 .78571 L
s
.25536 .83333 m
.28155 .83333 L
s
.25536 .88095 m
.28155 .88095 L
s
.25536 .92857 m
.28155 .92857 L
s
.25536 .97619 m
.28155 .97619 L
s
.30166 .02381 m
.32786 .02381 L
s
.30166 .07143 m
.32786 .07143 L
s
.30166 .11905 m
.32786 .11905 L
s
.30166 .16667 m
.32786 .16667 L
s
.30166 .21429 m
.32786 .21429 L
s
.30166 .2619 m
.32786 .2619 L
s
.30166 .30952 m
.32786 .30952 L
s
.30166 .35714 m
.32786 .35714 L
s
.30166 .40476 m
.32786 .40476 L
s
.30166 .45238 m
.32786 .45238 L
s
.30166 .5 m
.32786 .5 L
s
.30166 .54762 m
.32786 .54762 L
s
.30166 .59524 m
.32786 .59524 L
s
.30166 .64286 m
.32786 .64286 L
s
.30166 .69048 m
.32786 .69048 L
s
.30166 .7381 m
.32786 .7381 L
s
.30166 .78571 m
.32786 .78571 L
s
.30166 .83333 m
.32786 .83333 L
s
.30166 .88095 m
.32786 .88095 L
s
.30166 .92857 m
.32786 .92857 L
s
.30166 .97619 m
.32786 .97619 L
s
.34797 .02381 m
.37417 .02381 L
s
.34797 .07143 m
.37417 .07143 L
s
.34797 .11905 m
.37417 .11905 L
s
.34797 .16667 m
.37417 .16667 L
s
.34797 .21429 m
.37417 .21429 L
s
.34797 .2619 m
.37417 .2619 L
s
.34797 .30952 m
.37417 .30952 L
s
.34797 .35714 m
.37417 .35714 L
s
.34797 .40476 m
.37417 .40476 L
s
.34797 .45238 m
.37417 .45238 L
s
.34797 .5 m
.37417 .5 L
s
.34797 .54762 m
.37417 .54762 L
s
.34797 .59524 m
.37417 .59524 L
s
.34797 .64286 m
.37417 .64286 L
s
.34797 .69048 m
.37417 .69048 L
s
.34797 .7381 m
.37417 .7381 L
s
.34797 .78571 m
.37417 .78571 L
s
.34797 .83333 m
.37417 .83333 L
s
.34797 .88095 m
.37417 .88095 L
s
.34797 .92857 m
.37417 .92857 L
s
.34797 .97619 m
.37417 .97619 L
s
.39428 .02381 m
.42048 .02381 L
s
.39428 .07143 m
.42048 .07143 L
s
.39428 .11905 m
.42048 .11905 L
s
.39428 .16667 m
.42048 .16667 L
s
.39428 .21429 m
.42048 .21429 L
s
.39428 .2619 m
.42048 .2619 L
s
.39428 .30952 m
.42048 .30952 L
s
.39428 .35714 m
.42048 .35714 L
s
.39428 .40476 m
.42048 .40476 L
s
.39428 .45238 m
.42048 .45238 L
s
.39428 .5 m
.42048 .5 L
s
.39428 .54762 m
.42048 .54762 L
s
.39428 .59524 m
.42048 .59524 L
s
.39428 .64286 m
.42048 .64286 L
s
.39428 .69048 m
.42048 .69048 L
s
.39428 .7381 m
.42048 .7381 L
s
.39428 .78571 m
.42048 .78571 L
s
.39428 .83333 m
.42048 .83333 L
s
.39428 .88095 m
.42048 .88095 L
s
.39428 .92857 m
.42048 .92857 L
s
.39428 .97619 m
.42048 .97619 L
s
.44059 .02381 m
.46679 .02381 L
s
.44059 .07143 m
.46679 .07143 L
s
.44059 .11905 m
.46679 .11905 L
s
.44059 .16667 m
.46679 .16667 L
s
.44059 .21429 m
.46679 .21429 L
s
.44059 .2619 m
.46679 .2619 L
s
.44059 .30952 m
.46679 .30952 L
s
.44059 .35714 m
.46679 .35714 L
s
.44059 .40476 m
.46679 .40476 L
s
.44059 .45238 m
.46679 .45238 L
s
.44059 .5 m
.46679 .5 L
s
.44059 .54762 m
.46679 .54762 L
s
.44059 .59524 m
.46679 .59524 L
s
.44059 .64286 m
.46679 .64286 L
s
.44059 .69048 m
.46679 .69048 L
s
.44059 .7381 m
.46679 .7381 L
s
.44059 .78571 m
.46679 .78571 L
s
.44059 .83333 m
.46679 .83333 L
s
.44059 .88095 m
.46679 .88095 L
s
.44059 .92857 m
.46679 .92857 L
s
.44059 .97619 m
.46679 .97619 L
s
.4869 .02381 m
.5131 .02381 L
s
.4869 .07143 m
.5131 .07143 L
s
.4869 .11905 m
.5131 .11905 L
s
.4869 .16667 m
.5131 .16667 L
s
.4869 .21429 m
.5131 .21429 L
s
.4869 .2619 m
.5131 .2619 L
s
.4869 .30952 m
.5131 .30952 L
s
.4869 .35714 m
.5131 .35714 L
s
.4869 .40476 m
.5131 .40476 L
s
.4869 .45238 m
.5131 .45238 L
s
.4869 .5 m
.5131 .5 L
s
.4869 .54762 m
.5131 .54762 L
s
.4869 .59524 m
.5131 .59524 L
s
.4869 .64286 m
.5131 .64286 L
s
.4869 .69048 m
.5131 .69048 L
s
.4869 .7381 m
.5131 .7381 L
s
.4869 .78571 m
.5131 .78571 L
s
.4869 .83333 m
.5131 .83333 L
s
.4869 .88095 m
.5131 .88095 L
s
.4869 .92857 m
.5131 .92857 L
s
.4869 .97619 m
.5131 .97619 L
s
.53321 .02381 m
.55941 .02381 L
s
.53321 .07143 m
.55941 .07143 L
s
.53321 .11905 m
.55941 .11905 L
s
.53321 .16667 m
.55941 .16667 L
s
.53321 .21429 m
.55941 .21429 L
s
.53321 .2619 m
.55941 .2619 L
s
.53321 .30952 m
.55941 .30952 L
s
.53321 .35714 m
.55941 .35714 L
s
.53321 .40476 m
.55941 .40476 L
s
.53321 .45238 m
.55941 .45238 L
s
.53321 .5 m
.55941 .5 L
s
.53321 .54762 m
.55941 .54762 L
s
.53321 .59524 m
.55941 .59524 L
s
.53321 .64286 m
.55941 .64286 L
s
.53321 .69048 m
.55941 .69048 L
s
.53321 .7381 m
.55941 .7381 L
s
.53321 .78571 m
.55941 .78571 L
s
.53321 .83333 m
.55941 .83333 L
s
.53321 .88095 m
.55941 .88095 L
s
.53321 .92857 m
.55941 .92857 L
s
.53321 .97619 m
.55941 .97619 L
s
.57952 .02381 m
.60572 .02381 L
s
.57952 .07143 m
.60572 .07143 L
s
.57952 .11905 m
.60572 .11905 L
s
.57952 .16667 m
.60572 .16667 L
s
.57952 .21429 m
.60572 .21429 L
s
.57952 .2619 m
.60572 .2619 L
s
.57952 .30952 m
.60572 .30952 L
s
.57952 .35714 m
.60572 .35714 L
s
.57952 .40476 m
.60572 .40476 L
s
.57952 .45238 m
.60572 .45238 L
s
.57952 .5 m
.60572 .5 L
s
.57952 .54762 m
.60572 .54762 L
s
.57952 .59524 m
.60572 .59524 L
s
.57952 .64286 m
.60572 .64286 L
s
.57952 .69048 m
.60572 .69048 L
s
.57952 .7381 m
.60572 .7381 L
s
.57952 .78571 m
.60572 .78571 L
s
.57952 .83333 m
.60572 .83333 L
s
.57952 .88095 m
.60572 .88095 L
s
.57952 .92857 m
.60572 .92857 L
s
.57952 .97619 m
.60572 .97619 L
s
.62583 .02381 m
.65203 .02381 L
s
.62583 .07143 m
.65203 .07143 L
s
.62583 .11905 m
.65203 .11905 L
s
.62583 .16667 m
.65203 .16667 L
s
.62583 .21429 m
.65203 .21429 L
s
.62583 .2619 m
.65203 .2619 L
s
.62583 .30952 m
.65203 .30952 L
s
.62583 .35714 m
.65203 .35714 L
s
.62583 .40476 m
.65203 .40476 L
s
.62583 .45238 m
.65203 .45238 L
s
.62583 .5 m
.65203 .5 L
s
.62583 .54762 m
.65203 .54762 L
s
.62583 .59524 m
.65203 .59524 L
s
.62583 .64286 m
.65203 .64286 L
s
.62583 .69048 m
.65203 .69048 L
s
.62583 .7381 m
.65203 .7381 L
s
.62583 .78571 m
.65203 .78571 L
s
.62583 .83333 m
.65203 .83333 L
s
.62583 .88095 m
.65203 .88095 L
s
.62583 .92857 m
.65203 .92857 L
s
.62583 .97619 m
.65203 .97619 L
s
.67214 .02381 m
.69834 .02381 L
s
.67214 .07143 m
.69834 .07143 L
s
.67214 .11905 m
.69834 .11905 L
s
.67214 .16667 m
.69834 .16667 L
s
.67214 .21429 m
.69834 .21429 L
s
.67214 .2619 m
.69834 .2619 L
s
.67214 .30952 m
.69834 .30952 L
s
.67214 .35714 m
.69834 .35714 L
s
.67214 .40476 m
.69834 .40476 L
s
.67214 .45238 m
.69834 .45238 L
s
.67214 .5 m
.69834 .5 L
s
.67214 .54762 m
.69834 .54762 L
s
.67214 .59524 m
.69834 .59524 L
s
.67214 .64286 m
.69834 .64286 L
s
.67214 .69048 m
.69834 .69048 L
s
.67214 .7381 m
.69834 .7381 L
s
.67214 .78571 m
.69834 .78571 L
s
.67214 .83333 m
.69834 .83333 L
s
.67214 .88095 m
.69834 .88095 L
s
.67214 .92857 m
.69834 .92857 L
s
.67214 .97619 m
.69834 .97619 L
s
.71845 .02381 m
.74464 .02381 L
s
.71845 .07143 m
.74464 .07143 L
s
.71845 .11905 m
.74464 .11905 L
s
.71845 .16667 m
.74464 .16667 L
s
.71845 .21429 m
.74464 .21429 L
s
.71845 .2619 m
.74464 .2619 L
s
.71845 .30952 m
.74464 .30952 L
s
.71845 .35714 m
.74464 .35714 L
s
.71845 .40476 m
.74464 .40476 L
s
.71845 .45238 m
.74464 .45238 L
s
.71845 .5 m
.74464 .5 L
s
.71845 .54762 m
.74464 .54762 L
s
.71845 .59524 m
.74464 .59524 L
s
.71845 .64286 m
.74464 .64286 L
s
.71845 .69048 m
.74464 .69048 L
s
.71845 .7381 m
.74464 .7381 L
s
.71845 .78571 m
.74464 .78571 L
s
.71845 .83333 m
.74464 .83333 L
s
.71845 .88095 m
.74464 .88095 L
s
.71845 .92857 m
.74464 .92857 L
s
.71845 .97619 m
.74464 .97619 L
s
.76476 .02381 m
.79095 .02381 L
s
.76476 .07143 m
.79095 .07143 L
s
.76476 .11905 m
.79095 .11905 L
s
.76476 .16667 m
.79095 .16667 L
s
.76476 .21429 m
.79095 .21429 L
s
.76476 .2619 m
.79095 .2619 L
s
.76476 .30952 m
.79095 .30952 L
s
.76476 .35714 m
.79095 .35714 L
s
.76476 .40476 m
.79095 .40476 L
s
.76476 .45238 m
.79095 .45238 L
s
.76476 .5 m
.79095 .5 L
s
.76476 .54762 m
.79095 .54762 L
s
.76476 .59524 m
.79095 .59524 L
s
.76476 .64286 m
.79095 .64286 L
s
.76476 .69048 m
.79095 .69048 L
s
.76476 .7381 m
.79095 .7381 L
s
.76476 .78571 m
.79095 .78571 L
s
.76476 .83333 m
.79095 .83333 L
s
.76476 .88095 m
.79095 .88095 L
s
.76476 .92857 m
.79095 .92857 L
s
.76476 .97619 m
.79095 .97619 L
s
.81107 .02381 m
.83726 .02381 L
s
.81107 .07143 m
.83726 .07143 L
s
.81107 .11905 m
.83726 .11905 L
s
.81107 .16667 m
.83726 .16667 L
s
.81107 .21429 m
.83726 .21429 L
s
.81107 .2619 m
.83726 .2619 L
s
.81107 .30952 m
.83726 .30952 L
s
.81107 .35714 m
.83726 .35714 L
s
.81107 .40476 m
.83726 .40476 L
s
.81107 .45238 m
.83726 .45238 L
s
.81107 .5 m
.83726 .5 L
s
.81107 .54762 m
.83726 .54762 L
s
.81107 .59524 m
.83726 .59524 L
s
.81107 .64286 m
.83726 .64286 L
s
.81107 .69048 m
.83726 .69048 L
s
.81107 .7381 m
.83726 .7381 L
s
.81107 .78571 m
.83726 .78571 L
s
.81107 .83333 m
.83726 .83333 L
s
.81107 .88095 m
.83726 .88095 L
s
.81107 .92857 m
.83726 .92857 L
s
.81107 .97619 m
.83726 .97619 L
s
.85738 .02381 m
.88357 .02381 L
s
.85738 .07143 m
.88357 .07143 L
s
.85738 .11905 m
.88357 .11905 L
s
.85738 .16667 m
.88357 .16667 L
s
.85738 .21429 m
.88357 .21429 L
s
.85738 .2619 m
.88357 .2619 L
s
.85738 .30952 m
.88357 .30952 L
s
.85738 .35714 m
.88357 .35714 L
s
.85738 .40476 m
.88357 .40476 L
s
.85738 .45238 m
.88357 .45238 L
s
.85738 .5 m
.88357 .5 L
s
.85738 .54762 m
.88357 .54762 L
s
.85738 .59524 m
.88357 .59524 L
s
.85738 .64286 m
.88357 .64286 L
s
.85738 .69048 m
.88357 .69048 L
s
.85738 .7381 m
.88357 .7381 L
s
.85738 .78571 m
.88357 .78571 L
s
.85738 .83333 m
.88357 .83333 L
s
.85738 .88095 m
.88357 .88095 L
s
.85738 .92857 m
.88357 .92857 L
s
.85738 .97619 m
.88357 .97619 L
s
.90368 .02381 m
.92988 .02381 L
s
.90368 .07143 m
.92988 .07143 L
s
.90368 .11905 m
.92988 .11905 L
s
.90368 .16667 m
.92988 .16667 L
s
.90368 .21429 m
.92988 .21429 L
s
.90368 .2619 m
.92988 .2619 L
s
.90368 .30952 m
.92988 .30952 L
s
.90368 .35714 m
.92988 .35714 L
s
.90368 .40476 m
.92988 .40476 L
s
.90368 .45238 m
.92988 .45238 L
s
.90368 .5 m
.92988 .5 L
s
.90368 .54762 m
.92988 .54762 L
s
.90368 .59524 m
.92988 .59524 L
s
.90368 .64286 m
.92988 .64286 L
s
.90368 .69048 m
.92988 .69048 L
s
.90368 .7381 m
.92988 .7381 L
s
.90368 .78571 m
.92988 .78571 L
s
.90368 .83333 m
.92988 .83333 L
s
.90368 .88095 m
.92988 .88095 L
s
.90368 .92857 m
.92988 .92857 L
s
.90368 .97619 m
.92988 .97619 L
s
.94999 .02381 m
.97619 .02381 L
s
.94999 .07143 m
.97619 .07143 L
s
.94999 .11905 m
.97619 .11905 L
s
.94999 .16667 m
.97619 .16667 L
s
.94999 .21429 m
.97619 .21429 L
s
.94999 .2619 m
.97619 .2619 L
s
.94999 .30952 m
.97619 .30952 L
s
.94999 .35714 m
.97619 .35714 L
s
.94999 .40476 m
.97619 .40476 L
s
.94999 .45238 m
.97619 .45238 L
s
.94999 .5 m
.97619 .5 L
s
.94999 .54762 m
.97619 .54762 L
s
.94999 .59524 m
.97619 .59524 L
s
.94999 .64286 m
.97619 .64286 L
s
.94999 .69048 m
.97619 .69048 L
s
.94999 .7381 m
.97619 .7381 L
s
.94999 .78571 m
.97619 .78571 L
s
.94999 .83333 m
.97619 .83333 L
s
.94999 .88095 m
.97619 .88095 L
s
.94999 .92857 m
.97619 .92857 L
s
.94999 .97619 m
.97619 .97619 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00=?ooool3o`0002gooooo1Ol0000]ooooo`;o0000
;_ooool5o`0002oooooo0ol0000Sooooo`00=Oooool00ol0003oooooooooo`0]ooooo`04o`000?oo
ooooooooo`0002cooooo00Co0000oooooooooooo0000;_ooool01?l0003oooooooooool0000`oooo
o`03o`000?oooooooooo02;ooooo000/ooooo`Go000000?oooooo`000?l000000ol0000Wooooo`Go
00000oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0002oooooo00?o0000oooo
ooooool0;Oooool5o`0002?ooooo000booooo`04o`000?ooooooooooo`00037ooooo00?o0000oooo
ooooool0:oooool01?l0003oooooooooool0000`ooooo`03o`000?oooooooooo02cooooo00Co0000
oooooooooooo00009?ooool003?ooooo00?o0000ooooool00000;_ooool01Ol0003ooooooooooooo
oooo000002cooooo00Co0000oooooooooooo0000;Oooool01Ol0003ooooooooooooooooo000002ko
oooo00?o0000ooooool000009?ooool003Cooooo0_l0000^ooooo`05o`000?ooooooooooooooool0
0000;?ooool01?l0003oooooooooool0000]ooooo`05o`000?ooooooooooooooool00000;oooool2
o`0002Cooooo000eooooo`03o`000?oooooooooo02gooooo0ol0000^ooooo`;o0000;oooool3o`00
037ooooo00?o0000ooooooooool08_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000ooooooool0000Ao`00007ooooo000?ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool08?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGo00002?l2Z9h5o`0000So0ZRN
1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN
1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN
1Ol00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN
1?ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00KooooooOl00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:X
WPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo0008ooooo`?o00001?ooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo0009ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001Ol000000ooooooo0000
o`000003o`0000Cooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`001_ooool01?l0003oooooooooool00005ooooo`?o0000
0oooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN
1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN
1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN
1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00007ooooo0007ooooo`03o`000?oo
oooo000000Gooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`002Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo0_l00004ooooo`So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:X
WPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:X
WPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4ooooo`;o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Wo
c>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo0_l00004ooooo`So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2
Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2
Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2
Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2
Z9h4ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo0_l00004ooooo`So
0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So
0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So
0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So
0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4ooooo`;o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Wo
c>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009oooo
o`7o00000Oooool000Kooooo1Ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo0005o`0000?ooooo00?o0000ooooooooool01?ooool3o`0000?ooooo
2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI
2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI
2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI
2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCooooo0_l00001ooooo`002Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000Kooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000Kooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Oooooo0ol00005
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2
Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2
Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2
Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2
Z9h5olcVf@So0ZRN1?ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o
00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So
0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So
0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So
0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8
o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8
o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8
o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00Sooooo0_l00005ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo0ol00003ooooo`So0ZRN1Ol00008o`:X
WPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:X
WPGo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:X
WPCo00002?l2Z9h5o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:X
WPGo00002?l2Z9h4ooooo`;o00000Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000Sooooo0_l00005ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:X
WPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2
Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2
Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2
Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2
Z9h5olcVf@So0ZRN1?ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o
00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So
0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So
0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So
0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo0006ooooo`Go00001?ooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo0007ooooo`04o`00
0?ooooooooooo`0000Cooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`002?ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000Wooooo00?o0000ooooooooool00oooool3o`0000?ooooo2?l2Z9h5olcVf@So0ZRN1Oo<
i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<
i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<
i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<
i]T8o`:XWPCooooo0_l00001ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool3
o`0000Gooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool2
o`0000Cooooo2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8
o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8
o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8
o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCooooo0_l00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool2o`0000Cooooo2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI
2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI
2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI
2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCooooo
0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool2o`0000Cooooo2?l2Z9h5olcV
f@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcV
f@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcV
f@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcV
f@So0ZRN1Oo<i]T8o`:XWPCooooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`002?ooool3o`0000Cooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000Kooooo1Ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Kooooo00Co0000oooooooooooo0000
1Oooool3o`0000?ooooo2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN
1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN
1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN
1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCooooo0_l00001ooooo`001ooo
ool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Sooooo0_l00005ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1Oo<i]T8o`:X
WPCoc>KI2?l2Z9h5olcVf@So0ZRN1?o<i]T8o`:XWPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:X
WPGoc>KI2?l2Z9h4olcVf@So0ZRN1Oo<i]T8o`:XWPCoc>KI2?l2Z9h5olcVf@So0ZRN1?ooool2o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcV
fOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool2o`0000Cooooo2?l2Z9h5o`0000So0ZRN1Ol00008o`:XWPCo0000
2?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPGo0000
2?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo0000
2?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCooooo
0_l00001ooooo`003oooool00ol0003oooooooooo`06oooooogo00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool0;oooool00ol0003ooooo
ooooo`0`ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0;oooool00ol0003ooooo
ooooo`0Pooooo`7o00000Oooool000oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool02Oooool00ol0003ooooooooo
o`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01oooool1o`00007ooooo000?
oooooooo00004Ol00001ooooo`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-6.01076, -5.78983, 0.039771, \
0.0386771}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 0.5. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{0, k}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{0, \(-5\)}, {0, \(-4\)}, {0, \(-3\)}, {0, \(-2\)}, {0, \(-1\)}, {0, 
        0}, {0, 1}, {0, 2}, {0, 3}, {0, 4}, {0, 5}}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(thePoints = t1;\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Produce Final Output", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayCurves;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[.1 -0.0125 -6 -9 ]
[.1 -0.0125 6 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7 -0.0125 -3 -9 ]
[.7 -0.0125 3 0 ]
[.9 -0.0125 -3 -9 ]
[.9 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .1 -12 -4.5 ]
[-0.0125 .1 0 4.5 ]
[-0.0125 .3 -12 -4.5 ]
[-0.0125 .3 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7 -6 -4.5 ]
[-0.0125 .7 0 4.5 ]
[-0.0125 .9 -6 -4.5 ]
[-0.0125 .9 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1 0 m
.1 .00625 L
s
[(-4)] .1 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-2)] .3 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(2)] .7 -0.0125 0 1 Mshowa
.9 0 m
.9 .00625 L
s
[(4)] .9 -0.0125 0 1 Mshowa
.125 Mabswid
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.25 0 m
.25 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.75 0 m
.75 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.05 0 m
.05 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .1 m
.00625 .1 L
s
[(-4)] -0.0125 .1 1 0 Mshowa
0 .3 m
.00625 .3 L
s
[(-2)] -0.0125 .3 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7 m
.00625 .7 L
s
[(2)] -0.0125 .7 1 0 Mshowa
0 .9 m
.00625 .9 L
s
[(4)] -0.0125 .9 1 0 Mshowa
.125 Mabswid
0 .15 m
.00375 .15 L
s
0 .2 m
.00375 .2 L
s
0 .25 m
.00375 .25 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .45 m
.00375 .45 L
s
0 .55 m
.00375 .55 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .75 m
.00375 .75 L
s
0 .8 m
.00375 .8 L
s
0 .85 m
.00375 .85 L
s
0 .05 m
.00375 .05 L
s
0 .95 m
.00375 .95 L
s
.25 Mabswid
0 0 m
0 1 L
s
.1 .99375 m
.1 1 L
s
.3 .99375 m
.3 1 L
s
.5 .99375 m
.5 1 L
s
.7 .99375 m
.7 1 L
s
.9 .99375 m
.9 1 L
s
.125 Mabswid
.15 .99625 m
.15 1 L
s
.2 .99625 m
.2 1 L
s
.25 .99625 m
.25 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.45 .99625 m
.45 1 L
s
.55 .99625 m
.55 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.75 .99625 m
.75 1 L
s
.8 .99625 m
.8 1 L
s
.85 .99625 m
.85 1 L
s
.05 .99625 m
.05 1 L
s
.95 .99625 m
.95 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .1 m
1 .1 L
s
.99375 .3 m
1 .3 L
s
.99375 .5 m
1 .5 L
s
.99375 .7 m
1 .7 L
s
.99375 .9 m
1 .9 L
s
.125 Mabswid
.99625 .15 m
1 .15 L
s
.99625 .2 m
1 .2 L
s
.99625 .25 m
1 .25 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .45 m
1 .45 L
s
.99625 .55 m
1 .55 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .75 m
1 .75 L
s
.99625 .8 m
1 .8 L
s
.99625 .85 m
1 .85 L
s
.99625 .05 m
1 .05 L
s
.99625 .95 m
1 .95 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
.01414 0 m
0 0 rlineto s
0 .05 m
.01414 .05 L
s
0 .1 m
.01414 .1 L
s
0 .15 m
.01414 .15 L
s
0 .2 m
.01414 .2 L
s
0 .25 m
.01414 .25 L
s
0 .3 m
.01414 .3 L
s
0 .35 m
.01414 .35 L
s
0 .4 m
.01414 .4 L
s
0 .45 m
.01414 .45 L
s
0 .5 m
.01414 .5 L
s
0 .55 m
.01414 .55 L
s
0 .6 m
.01414 .6 L
s
0 .65 m
.01414 .65 L
s
0 .7 m
.01414 .7 L
s
0 .75 m
.01414 .75 L
s
0 .8 m
.01414 .8 L
s
0 .85 m
.01414 .85 L
s
0 .9 m
.01414 .9 L
s
0 .95 m
.01414 .95 L
s
0 1 m
.01414 1 L
s
.03586 0 m
.06414 0 L
s
.03586 .05 m
.06414 .05 L
s
.03586 .1 m
.06414 .1 L
s
.03586 .15 m
.06414 .15 L
s
.03586 .2 m
.06414 .2 L
s
.03586 .25 m
.06414 .25 L
s
.03586 .3 m
.06414 .3 L
s
.03586 .35 m
.06414 .35 L
s
.03586 .4 m
.06414 .4 L
s
.03586 .45 m
.06414 .45 L
s
.03586 .5 m
.06414 .5 L
s
.03586 .55 m
.06414 .55 L
s
.03586 .6 m
.06414 .6 L
s
.03586 .65 m
.06414 .65 L
s
.03586 .7 m
.06414 .7 L
s
.03586 .75 m
.06414 .75 L
s
.03586 .8 m
.06414 .8 L
s
.03586 .85 m
.06414 .85 L
s
.03586 .9 m
.06414 .9 L
s
.03586 .95 m
.06414 .95 L
s
.03586 1 m
.06414 1 L
s
.08586 0 m
.11414 0 L
s
.08586 .05 m
.11414 .05 L
s
.08586 .1 m
.11414 .1 L
s
.08586 .15 m
.11414 .15 L
s
.08586 .2 m
.11414 .2 L
s
.08586 .25 m
.11414 .25 L
s
.08586 .3 m
.11414 .3 L
s
.08586 .35 m
.11414 .35 L
s
.08586 .4 m
.11414 .4 L
s
.08586 .45 m
.11414 .45 L
s
.08586 .5 m
.11414 .5 L
s
.08586 .55 m
.11414 .55 L
s
.08586 .6 m
.11414 .6 L
s
.08586 .65 m
.11414 .65 L
s
.08586 .7 m
.11414 .7 L
s
.08586 .75 m
.11414 .75 L
s
.08586 .8 m
.11414 .8 L
s
.08586 .85 m
.11414 .85 L
s
.08586 .9 m
.11414 .9 L
s
.08586 .95 m
.11414 .95 L
s
.08586 1 m
.11414 1 L
s
.13586 0 m
.16414 0 L
s
.13586 .05 m
.16414 .05 L
s
.13586 .1 m
.16414 .1 L
s
.13586 .15 m
.16414 .15 L
s
.13586 .2 m
.16414 .2 L
s
.13586 .25 m
.16414 .25 L
s
.13586 .3 m
.16414 .3 L
s
.13586 .35 m
.16414 .35 L
s
.13586 .4 m
.16414 .4 L
s
.13586 .45 m
.16414 .45 L
s
.13586 .5 m
.16414 .5 L
s
.13586 .55 m
.16414 .55 L
s
.13586 .6 m
.16414 .6 L
s
.13586 .65 m
.16414 .65 L
s
.13586 .7 m
.16414 .7 L
s
.13586 .75 m
.16414 .75 L
s
.13586 .8 m
.16414 .8 L
s
.13586 .85 m
.16414 .85 L
s
.13586 .9 m
.16414 .9 L
s
.13586 .95 m
.16414 .95 L
s
.13586 1 m
.16414 1 L
s
.18586 0 m
.21414 0 L
s
.18586 .05 m
.21414 .05 L
s
.18586 .1 m
.21414 .1 L
s
.18586 .15 m
.21414 .15 L
s
.18586 .2 m
.21414 .2 L
s
.18586 .25 m
.21414 .25 L
s
.18586 .3 m
.21414 .3 L
s
.18586 .35 m
.21414 .35 L
s
.18586 .4 m
.21414 .4 L
s
.18586 .45 m
.21414 .45 L
s
.18586 .5 m
.21414 .5 L
s
.18586 .55 m
.21414 .55 L
s
.18586 .6 m
.21414 .6 L
s
.18586 .65 m
.21414 .65 L
s
.18586 .7 m
.21414 .7 L
s
.18586 .75 m
.21414 .75 L
s
.18586 .8 m
.21414 .8 L
s
.18586 .85 m
.21414 .85 L
s
.18586 .9 m
.21414 .9 L
s
.18586 .95 m
.21414 .95 L
s
.18586 1 m
.21414 1 L
s
.23586 0 m
.26414 0 L
s
.23586 .05 m
.26414 .05 L
s
.23586 .1 m
.26414 .1 L
s
.23586 .15 m
.26414 .15 L
s
.23586 .2 m
.26414 .2 L
s
.23586 .25 m
.26414 .25 L
s
.23586 .3 m
.26414 .3 L
s
.23586 .35 m
.26414 .35 L
s
.23586 .4 m
.26414 .4 L
s
.23586 .45 m
.26414 .45 L
s
.23586 .5 m
.26414 .5 L
s
.23586 .55 m
.26414 .55 L
s
.23586 .6 m
.26414 .6 L
s
.23586 .65 m
.26414 .65 L
s
.23586 .7 m
.26414 .7 L
s
.23586 .75 m
.26414 .75 L
s
.23586 .8 m
.26414 .8 L
s
.23586 .85 m
.26414 .85 L
s
.23586 .9 m
.26414 .9 L
s
.23586 .95 m
.26414 .95 L
s
.23586 1 m
.26414 1 L
s
.28586 0 m
.31414 0 L
s
.28586 .05 m
.31414 .05 L
s
.28586 .1 m
.31414 .1 L
s
.28586 .15 m
.31414 .15 L
s
.28586 .2 m
.31414 .2 L
s
.28586 .25 m
.31414 .25 L
s
.28586 .3 m
.31414 .3 L
s
.28586 .35 m
.31414 .35 L
s
.28586 .4 m
.31414 .4 L
s
.28586 .45 m
.31414 .45 L
s
.28586 .5 m
.31414 .5 L
s
.28586 .55 m
.31414 .55 L
s
.28586 .6 m
.31414 .6 L
s
.28586 .65 m
.31414 .65 L
s
.28586 .7 m
.31414 .7 L
s
.28586 .75 m
.31414 .75 L
s
.28586 .8 m
.31414 .8 L
s
.28586 .85 m
.31414 .85 L
s
.28586 .9 m
.31414 .9 L
s
.28586 .95 m
.31414 .95 L
s
.28586 1 m
.31414 1 L
s
.33586 0 m
.36414 0 L
s
.33586 .05 m
.36414 .05 L
s
.33586 .1 m
.36414 .1 L
s
.33586 .15 m
.36414 .15 L
s
.33586 .2 m
.36414 .2 L
s
.33586 .25 m
.36414 .25 L
s
.33586 .3 m
.36414 .3 L
s
.33586 .35 m
.36414 .35 L
s
.33586 .4 m
.36414 .4 L
s
.33586 .45 m
.36414 .45 L
s
.33586 .5 m
.36414 .5 L
s
.33586 .55 m
.36414 .55 L
s
.33586 .6 m
.36414 .6 L
s
.33586 .65 m
.36414 .65 L
s
.33586 .7 m
.36414 .7 L
s
.33586 .75 m
.36414 .75 L
s
.33586 .8 m
.36414 .8 L
s
.33586 .85 m
.36414 .85 L
s
.33586 .9 m
.36414 .9 L
s
.33586 .95 m
.36414 .95 L
s
.33586 1 m
.36414 1 L
s
.38586 0 m
.41414 0 L
s
.38586 .05 m
.41414 .05 L
s
.38586 .1 m
.41414 .1 L
s
.38586 .15 m
.41414 .15 L
s
.38586 .2 m
.41414 .2 L
s
.38586 .25 m
.41414 .25 L
s
.38586 .3 m
.41414 .3 L
s
.38586 .35 m
.41414 .35 L
s
.38586 .4 m
.41414 .4 L
s
.38586 .45 m
.41414 .45 L
s
.38586 .5 m
.41414 .5 L
s
.38586 .55 m
.41414 .55 L
s
.38586 .6 m
.41414 .6 L
s
.38586 .65 m
.41414 .65 L
s
.38586 .7 m
.41414 .7 L
s
.38586 .75 m
.41414 .75 L
s
.38586 .8 m
.41414 .8 L
s
.38586 .85 m
.41414 .85 L
s
.38586 .9 m
.41414 .9 L
s
.38586 .95 m
.41414 .95 L
s
.38586 1 m
.41414 1 L
s
.43586 0 m
.46414 0 L
s
.43586 .05 m
.46414 .05 L
s
.43586 .1 m
.46414 .1 L
s
.43586 .15 m
.46414 .15 L
s
.43586 .2 m
.46414 .2 L
s
.43586 .25 m
.46414 .25 L
s
.43586 .3 m
.46414 .3 L
s
.43586 .35 m
.46414 .35 L
s
.43586 .4 m
.46414 .4 L
s
.43586 .45 m
.46414 .45 L
s
.43586 .5 m
.46414 .5 L
s
.43586 .55 m
.46414 .55 L
s
.43586 .6 m
.46414 .6 L
s
.43586 .65 m
.46414 .65 L
s
.43586 .7 m
.46414 .7 L
s
.43586 .75 m
.46414 .75 L
s
.43586 .8 m
.46414 .8 L
s
.43586 .85 m
.46414 .85 L
s
.43586 .9 m
.46414 .9 L
s
.43586 .95 m
.46414 .95 L
s
.43586 1 m
.46414 1 L
s
.48586 0 m
.51414 0 L
s
.48586 .05 m
.51414 .05 L
s
.48586 .1 m
.51414 .1 L
s
.48586 .15 m
.51414 .15 L
s
.48586 .2 m
.51414 .2 L
s
.48586 .25 m
.51414 .25 L
s
.48586 .3 m
.51414 .3 L
s
.48586 .35 m
.51414 .35 L
s
.48586 .4 m
.51414 .4 L
s
.48586 .45 m
.51414 .45 L
s
.48586 .5 m
.51414 .5 L
s
.48586 .55 m
.51414 .55 L
s
.48586 .6 m
.51414 .6 L
s
.48586 .65 m
.51414 .65 L
s
.48586 .7 m
.51414 .7 L
s
.48586 .75 m
.51414 .75 L
s
.48586 .8 m
.51414 .8 L
s
.48586 .85 m
.51414 .85 L
s
.48586 .9 m
.51414 .9 L
s
.48586 .95 m
.51414 .95 L
s
.48586 1 m
.51414 1 L
s
.53586 0 m
.56414 0 L
s
.53586 .05 m
.56414 .05 L
s
.53586 .1 m
.56414 .1 L
s
.53586 .15 m
.56414 .15 L
s
.53586 .2 m
.56414 .2 L
s
.53586 .25 m
.56414 .25 L
s
.53586 .3 m
.56414 .3 L
s
.53586 .35 m
.56414 .35 L
s
.53586 .4 m
.56414 .4 L
s
.53586 .45 m
.56414 .45 L
s
.53586 .5 m
.56414 .5 L
s
.53586 .55 m
.56414 .55 L
s
.53586 .6 m
.56414 .6 L
s
.53586 .65 m
.56414 .65 L
s
.53586 .7 m
.56414 .7 L
s
.53586 .75 m
.56414 .75 L
s
.53586 .8 m
.56414 .8 L
s
.53586 .85 m
.56414 .85 L
s
.53586 .9 m
.56414 .9 L
s
.53586 .95 m
.56414 .95 L
s
.53586 1 m
.56414 1 L
s
.58586 0 m
.61414 0 L
s
.58586 .05 m
.61414 .05 L
s
.58586 .1 m
.61414 .1 L
s
.58586 .15 m
.61414 .15 L
s
.58586 .2 m
.61414 .2 L
s
.58586 .25 m
.61414 .25 L
s
.58586 .3 m
.61414 .3 L
s
.58586 .35 m
.61414 .35 L
s
.58586 .4 m
.61414 .4 L
s
.58586 .45 m
.61414 .45 L
s
.58586 .5 m
.61414 .5 L
s
.58586 .55 m
.61414 .55 L
s
.58586 .6 m
.61414 .6 L
s
.58586 .65 m
.61414 .65 L
s
.58586 .7 m
.61414 .7 L
s
.58586 .75 m
.61414 .75 L
s
.58586 .8 m
.61414 .8 L
s
.58586 .85 m
.61414 .85 L
s
.58586 .9 m
.61414 .9 L
s
.58586 .95 m
.61414 .95 L
s
.58586 1 m
.61414 1 L
s
.63586 0 m
.66414 0 L
s
.63586 .05 m
.66414 .05 L
s
.63586 .1 m
.66414 .1 L
s
.63586 .15 m
.66414 .15 L
s
.63586 .2 m
.66414 .2 L
s
.63586 .25 m
.66414 .25 L
s
.63586 .3 m
.66414 .3 L
s
.63586 .35 m
.66414 .35 L
s
.63586 .4 m
.66414 .4 L
s
.63586 .45 m
.66414 .45 L
s
.63586 .5 m
.66414 .5 L
s
.63586 .55 m
.66414 .55 L
s
.63586 .6 m
.66414 .6 L
s
.63586 .65 m
.66414 .65 L
s
.63586 .7 m
.66414 .7 L
s
.63586 .75 m
.66414 .75 L
s
.63586 .8 m
.66414 .8 L
s
.63586 .85 m
.66414 .85 L
s
.63586 .9 m
.66414 .9 L
s
.63586 .95 m
.66414 .95 L
s
.63586 1 m
.66414 1 L
s
.68586 0 m
.71414 0 L
s
.68586 .05 m
.71414 .05 L
s
.68586 .1 m
.71414 .1 L
s
.68586 .15 m
.71414 .15 L
s
.68586 .2 m
.71414 .2 L
s
.68586 .25 m
.71414 .25 L
s
.68586 .3 m
.71414 .3 L
s
.68586 .35 m
.71414 .35 L
s
.68586 .4 m
.71414 .4 L
s
.68586 .45 m
.71414 .45 L
s
.68586 .5 m
.71414 .5 L
s
.68586 .55 m
.71414 .55 L
s
.68586 .6 m
.71414 .6 L
s
.68586 .65 m
.71414 .65 L
s
.68586 .7 m
.71414 .7 L
s
.68586 .75 m
.71414 .75 L
s
.68586 .8 m
.71414 .8 L
s
.68586 .85 m
.71414 .85 L
s
.68586 .9 m
.71414 .9 L
s
.68586 .95 m
.71414 .95 L
s
.68586 1 m
.71414 1 L
s
.73586 0 m
.76414 0 L
s
.73586 .05 m
.76414 .05 L
s
.73586 .1 m
.76414 .1 L
s
.73586 .15 m
.76414 .15 L
s
.73586 .2 m
.76414 .2 L
s
.73586 .25 m
.76414 .25 L
s
.73586 .3 m
.76414 .3 L
s
.73586 .35 m
.76414 .35 L
s
.73586 .4 m
.76414 .4 L
s
.73586 .45 m
.76414 .45 L
s
.73586 .5 m
.76414 .5 L
s
.73586 .55 m
.76414 .55 L
s
.73586 .6 m
.76414 .6 L
s
.73586 .65 m
.76414 .65 L
s
.73586 .7 m
.76414 .7 L
s
.73586 .75 m
.76414 .75 L
s
.73586 .8 m
.76414 .8 L
s
.73586 .85 m
.76414 .85 L
s
.73586 .9 m
.76414 .9 L
s
.73586 .95 m
.76414 .95 L
s
.73586 1 m
.76414 1 L
s
.78586 0 m
.81414 0 L
s
.78586 .05 m
.81414 .05 L
s
.78586 .1 m
.81414 .1 L
s
.78586 .15 m
.81414 .15 L
s
.78586 .2 m
.81414 .2 L
s
.78586 .25 m
.81414 .25 L
s
.78586 .3 m
.81414 .3 L
s
.78586 .35 m
.81414 .35 L
s
.78586 .4 m
.81414 .4 L
s
.78586 .45 m
.81414 .45 L
s
.78586 .5 m
.81414 .5 L
s
.78586 .55 m
.81414 .55 L
s
.78586 .6 m
.81414 .6 L
s
.78586 .65 m
.81414 .65 L
s
.78586 .7 m
.81414 .7 L
s
.78586 .75 m
.81414 .75 L
s
.78586 .8 m
.81414 .8 L
s
.78586 .85 m
.81414 .85 L
s
.78586 .9 m
.81414 .9 L
s
.78586 .95 m
.81414 .95 L
s
.78586 1 m
.81414 1 L
s
.83586 0 m
.86414 0 L
s
.83586 .05 m
.86414 .05 L
s
.83586 .1 m
.86414 .1 L
s
.83586 .15 m
.86414 .15 L
s
.83586 .2 m
.86414 .2 L
s
.83586 .25 m
.86414 .25 L
s
.83586 .3 m
.86414 .3 L
s
.83586 .35 m
.86414 .35 L
s
.83586 .4 m
.86414 .4 L
s
.83586 .45 m
.86414 .45 L
s
.83586 .5 m
.86414 .5 L
s
.83586 .55 m
.86414 .55 L
s
.83586 .6 m
.86414 .6 L
s
.83586 .65 m
.86414 .65 L
s
.83586 .7 m
.86414 .7 L
s
.83586 .75 m
.86414 .75 L
s
.83586 .8 m
.86414 .8 L
s
.83586 .85 m
.86414 .85 L
s
.83586 .9 m
.86414 .9 L
s
.83586 .95 m
.86414 .95 L
s
.83586 1 m
.86414 1 L
s
.88586 0 m
.91414 0 L
s
.88586 .05 m
.91414 .05 L
s
.88586 .1 m
.91414 .1 L
s
.88586 .15 m
.91414 .15 L
s
.88586 .2 m
.91414 .2 L
s
.88586 .25 m
.91414 .25 L
s
.88586 .3 m
.91414 .3 L
s
.88586 .35 m
.91414 .35 L
s
.88586 .4 m
.91414 .4 L
s
.88586 .45 m
.91414 .45 L
s
.88586 .5 m
.91414 .5 L
s
.88586 .55 m
.91414 .55 L
s
.88586 .6 m
.91414 .6 L
s
.88586 .65 m
.91414 .65 L
s
.88586 .7 m
.91414 .7 L
s
.88586 .75 m
.91414 .75 L
s
.88586 .8 m
.91414 .8 L
s
.88586 .85 m
.91414 .85 L
s
.88586 .9 m
.91414 .9 L
s
.88586 .95 m
.91414 .95 L
s
.88586 1 m
.91414 1 L
s
.93586 0 m
.96414 0 L
s
.93586 .05 m
.96414 .05 L
s
.93586 .1 m
.96414 .1 L
s
.93586 .15 m
.96414 .15 L
s
.93586 .2 m
.96414 .2 L
s
.93586 .25 m
.96414 .25 L
s
.93586 .3 m
.96414 .3 L
s
.93586 .35 m
.96414 .35 L
s
.93586 .4 m
.96414 .4 L
s
.93586 .45 m
.96414 .45 L
s
.93586 .5 m
.96414 .5 L
s
.93586 .55 m
.96414 .55 L
s
.93586 .6 m
.96414 .6 L
s
.93586 .65 m
.96414 .65 L
s
.93586 .7 m
.96414 .7 L
s
.93586 .75 m
.96414 .75 L
s
.93586 .8 m
.96414 .8 L
s
.93586 .85 m
.96414 .85 L
s
.93586 .9 m
.96414 .9 L
s
.93586 .95 m
.96414 .95 L
s
.93586 1 m
.96414 1 L
s
.98586 0 m
0 0 rlineto s
.98586 .05 m
0 0 rlineto s
.98586 .05 m
1 .05 L
s
.98586 .1 m
0 0 rlineto s
.98586 .1 m
1 .1 L
s
.98586 .15 m
0 0 rlineto s
.98586 .15 m
1 .15 L
s
.98586 .2 m
0 0 rlineto s
.98586 .2 m
1 .2 L
s
.98586 .25 m
0 0 rlineto s
.98586 .25 m
1 .25 L
s
.98586 .3 m
0 0 rlineto s
.98586 .3 m
1 .3 L
s
.98586 .35 m
0 0 rlineto s
.98586 .35 m
1 .35 L
s
.98586 .4 m
0 0 rlineto s
.98586 .4 m
1 .4 L
s
.98586 .45 m
0 0 rlineto s
.98586 .45 m
1 .45 L
s
.98586 .5 m
0 0 rlineto s
.98586 .5 m
1 .5 L
s
.98586 .55 m
0 0 rlineto s
.98586 .55 m
1 .55 L
s
.98586 .6 m
0 0 rlineto s
.98586 .6 m
1 .6 L
s
.98586 .65 m
0 0 rlineto s
.98586 .65 m
1 .65 L
s
.98586 .7 m
0 0 rlineto s
.98586 .7 m
1 .7 L
s
.98586 .75 m
0 0 rlineto s
.98586 .75 m
1 .75 L
s
.98586 .8 m
0 0 rlineto s
.98586 .8 m
1 .8 L
s
.98586 .85 m
0 0 rlineto s
.98586 .85 m
1 .85 L
s
.98586 .9 m
0 0 rlineto s
.98586 .9 m
1 .9 L
s
.98586 .95 m
0 0 rlineto s
.98586 .95 m
1 .95 L
s
.98586 1 m
0 0 rlineto s
.98586 1 m
1 1 L
s
.89 .09 .05 r
.005 w
.04038 0 m
.08464 0 L
.12621 0 L
.16619 0 L
.20874 0 L
.2497 0 L
.29323 0 L
.33517 0 L
.37552 0 L
.41845 0 L
.45979 0 L
.49953 0 L
.54185 0 L
.58257 0 L
.62588 0 L
.66759 0 L
.70771 0 L
.7504 0 L
.7915 0 L
.83518 0 L
.87727 0 L
.91776 0 L
.96083 0 L
s
0 .1 m
.04038 .1 L
.08464 .1 L
.12621 .1 L
.16619 .1 L
.20874 .1 L
.2497 .1 L
.29323 .1 L
.33517 .1 L
.37552 .1 L
.41845 .1 L
.45979 .1 L
.49953 .1 L
.54185 .1 L
.58257 .1 L
.62588 .1 L
.66759 .1 L
.70771 .1 L
.7504 .1 L
.7915 .1 L
.83518 .1 L
.87727 .1 L
.91776 .1 L
.96083 .1 L
s
.96083 .1 m
1 .1 L
s
0 .2 m
.04038 .2 L
.08464 .2 L
.12621 .2 L
.16619 .2 L
.20874 .2 L
.2497 .2 L
.29323 .2 L
.33517 .2 L
.37552 .2 L
.41845 .2 L
.45979 .2 L
.49953 .2 L
.54185 .2 L
.58257 .2 L
.62588 .2 L
.66759 .2 L
.70771 .2 L
.7504 .2 L
.7915 .2 L
.83518 .2 L
.87727 .2 L
.91776 .2 L
.96083 .2 L
s
.96083 .2 m
1 .2 L
s
0 .3 m
.04038 .3 L
.08464 .3 L
.12621 .3 L
.16619 .3 L
.20874 .3 L
.2497 .3 L
.29323 .3 L
.33517 .3 L
.37552 .3 L
.41845 .3 L
.45979 .3 L
.49953 .3 L
.54185 .3 L
.58257 .3 L
.62588 .3 L
.66759 .3 L
.70771 .3 L
.7504 .3 L
.7915 .3 L
.83518 .3 L
.87727 .3 L
.91776 .3 L
.96083 .3 L
s
.96083 .3 m
1 .3 L
s
0 .4 m
.04038 .4 L
.08464 .4 L
.12621 .4 L
.16619 .4 L
.20874 .4 L
.2497 .4 L
.29323 .4 L
.33517 .4 L
.37552 .4 L
.41845 .4 L
.45979 .4 L
.49953 .4 L
.54185 .4 L
.58257 .4 L
.62588 .4 L
.66759 .4 L
.70771 .4 L
.7504 .4 L
.7915 .4 L
.83518 .4 L
.87727 .4 L
.91776 .4 L
.96083 .4 L
s
.96083 .4 m
1 .4 L
s
0 .5 m
.04038 .5 L
.08464 .5 L
.12621 .5 L
.16619 .5 L
.20874 .5 L
.2497 .5 L
.29323 .5 L
.33517 .5 L
.37552 .5 L
.41845 .5 L
.45979 .5 L
.49953 .5 L
.54185 .5 L
.58257 .5 L
.62588 .5 L
.66759 .5 L
.70771 .5 L
.7504 .5 L
.7915 .5 L
.83518 .5 L
.87727 .5 L
.91776 .5 L
.96083 .5 L
s
.96083 .5 m
1 .5 L
s
0 .6 m
.04038 .6 L
.08464 .6 L
.12621 .6 L
.16619 .6 L
.20874 .6 L
.2497 .6 L
.29323 .6 L
.33517 .6 L
.37552 .6 L
.41845 .6 L
.45979 .6 L
.49953 .6 L
.54185 .6 L
.58257 .6 L
.62588 .6 L
.66759 .6 L
.70771 .6 L
.7504 .6 L
.7915 .6 L
.83518 .6 L
.87727 .6 L
.91776 .6 L
.96083 .6 L
s
.96083 .6 m
1 .6 L
s
0 .7 m
.04038 .7 L
.08464 .7 L
.12621 .7 L
.16619 .7 L
.20874 .7 L
.2497 .7 L
.29323 .7 L
.33517 .7 L
.37552 .7 L
.41845 .7 L
.45979 .7 L
.49953 .7 L
.54185 .7 L
.58257 .7 L
.62588 .7 L
.66759 .7 L
.70771 .7 L
.7504 .7 L
.7915 .7 L
.83518 .7 L
.87727 .7 L
.91776 .7 L
.96083 .7 L
s
.96083 .7 m
1 .7 L
s
0 .8 m
.04038 .8 L
.08464 .8 L
.12621 .8 L
.16619 .8 L
.20874 .8 L
.2497 .8 L
.29323 .8 L
.33517 .8 L
.37552 .8 L
.41845 .8 L
.45979 .8 L
.49953 .8 L
.54185 .8 L
.58257 .8 L
.62588 .8 L
.66759 .8 L
.70771 .8 L
.7504 .8 L
.7915 .8 L
.83518 .8 L
.87727 .8 L
.91776 .8 L
.96083 .8 L
s
.96083 .8 m
1 .8 L
s
0 .9 m
.04038 .9 L
.08464 .9 L
.12621 .9 L
.16619 .9 L
.20874 .9 L
.2497 .9 L
.29323 .9 L
.33517 .9 L
.37552 .9 L
.41845 .9 L
.45979 .9 L
.49953 .9 L
.54185 .9 L
.58257 .9 L
.62588 .9 L
.66759 .9 L
.70771 .9 L
.7504 .9 L
.7915 .9 L
.83518 .9 L
.87727 .9 L
.91776 .9 L
.96083 .9 L
s
.96083 .9 m
1 .9 L
s
0 1 m
.04038 1 L
.08464 1 L
.12621 1 L
.16619 1 L
.20874 1 L
.2497 1 L
.29323 1 L
.33517 1 L
.37552 1 L
.41845 1 L
.45979 1 L
.49953 1 L
.54185 1 L
.58257 1 L
.62588 1 L
.66759 1 L
.70771 1 L
.7504 1 L
.7915 1 L
.83518 1 L
.87727 1 L
.91776 1 L
.96083 1 L
s
.96083 1 m
1 1 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00;?ooool3o`00037ooooo1Ol0000aooooo`;o0000
<_ooool5o`0003?ooooo0ol0000Kooooo`00;Oooool00ol0003oooooooooo`0aooooo`04o`000?oo
ooooooooo`00033ooooo00Co0000oooooooooooo0000<_ooool01?l0003oooooooooool0000doooo
o`03o`000?oooooooooo01[ooooo000Tooooo`Go000000?oooooo`000?l000000ol0000[ooooo`Go
00000oooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0003?ooooo00?o0000oooo
ooooool0<Oooool5o`0001_ooooo000Zooooo`04o`000?ooooooooooo`0003Gooooo00?o0000oooo
ooooool0;oooool01?l0003oooooooooool0000dooooo`03o`000?oooooooooo033ooooo00Co0000
oooooooooooo00007?ooool002_ooooo00?o0000ooooool00000<_ooool01Ol0003ooooooooooooo
oooo0000033ooooo00Co0000oooooooooooo0000<Oooool01Ol0003ooooooooooooooooo000003;o
oooo00?o0000ooooool000007?ooool002cooooo0_l0000booooo`05o`000?ooooooooooooooool0
0000<?ooool01?l0003oooooooooool0000aooooo`05o`000?ooooooooooooooool00000<oooool2
o`0001cooooo000]ooooo`03o`000?oooooooooo037ooooo0ol0000booooo`;o0000<oooool3o`00
03Gooooo00?o0000ooooooooool06_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000kooooo1Ol000000ol2Z9ko0000o`000003o`000003o`:XW_oS5`cohaL<
07_ohaL<00?o0000on<G3?oS5``0NooS5``00ol2Z9ko0000o`000003o`000004o`:XW_l0003o0000
o`00007ooooo000>oooooooo00004_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<
i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2
o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0
003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?o
c>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_oo
ool00ol0003o0ZRNo`:XWP03o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2
Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI1?l2
Z9h01?l0003o0ZRNo`:XW_l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN
1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@Co0ZRN
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2
o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0
003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?o
c>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`002?oo
ool3o`0000?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`002Oooool0
0ol0003oooooooooo`02ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool0
00Go000000?oooooo`000?l000000ol00003ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@21olcV
f@04o`:XW_o<i]Wo0000o`00007ooooo0006ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
on<G3?oS5``0Q_oS5``00ol0003ohaL<on<G3025on<G307ooooo0007ooooo`03o`000?oooooo0000
00Cooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`002?ooool2o`0000Co
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`002Oooool00ol0003ooooo
ooooo`02ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000
olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcV
f@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`00
3_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<
i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Wo
c>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00
007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo
00?o0000o`:XW_l2Z9h00ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN
1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Co0ZRN
00Co0000o`:XW_l2Z9ko0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGo
c>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T4o`:XWP7o
oooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000
olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcV
f@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`00
3_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<
i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Wo
c>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00
007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo
0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000kooooo00?o0000on<G3?oS5``0Q_oS5``00ol0003ohaL<on<G3025on<G
307ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo
0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001oooo
o`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000
Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<
i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2
o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000ko
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`03o`000?l2Z9ko0ZRN00?o0ZRN1Oo<
i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<
i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T4o`:XWP04o`000?l2Z9ko0ZRNo`:XWPGoc>KI
2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI
2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI1?l2Z9h1ooooo`003_ooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001oooo
o`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000
Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<
i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2
o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000ko
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0006ooooo`Go00000oooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000?ooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`001Ol00003ooooo`03o`000?oooooo
oooo00?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`002Oooool00ol0
003oooooooooo`02ooooo`03o`000?oS5`cohaL<08KohaL<00?o0000on<G3?oS5``0QOoS5``1oooo
o`001_ooool01Ol0003ooooooooooooooooo000000?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI
08?oc>KI0_l00001ooooo`001_ooool01Ol0003ooooooooooooooooo000000?ooooo0_l00027olcV
f@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`001oooool3o`0000Cooooo0_l00027olcVf@03
o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0
Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Ooo
ool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`00
08Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003o
c>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI
0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>
ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcV
f@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool00ol0003o0ZRNo`:XWP03o`:XWPGo
c>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGo
c>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI1?l2Z9h01?l0003o0ZRNo`:XW_l2Z9h5olcV
f@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcV
f@So0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@Co0ZRN0Oooool000kooooo0_l00027olcVf@03
o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0
Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Ooo
ool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`00
08Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003o
c>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI
0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>
ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcV
f@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<
i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool0
0ol0003ohaL<on<G3026on<G3003o`000?oS5`cohaL<08GohaL<0Oooool000kooooo0_l00027olcV
f@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<
i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2
o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0
003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?o
c>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI087oc>KI00Co0ZRNolcVfOl0003o
00000Oooool000kooooo00?o0000o`:XW_l2Z9h00ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI
2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI
2Ol2Z9h5olcVf@Co0ZRN00Co0000o`:XW_l2Z9ko0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So
0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Wo
0ZRN1Oo<i]T4o`:XWP7ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2
o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0
003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?o
c>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000Sooooo0_l00004ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000Oooooo00Co0000oooooooooooo00000oooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0
Poo<i]T2o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000?oooooool0000Bo`00007ooooo
0007ooooo`04o`000?ooooooooooo`0000?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI
0_l00001ooooo`001oooool01?l0003oooooooooool00003ooooo`;o0000Qoo<i]T00ol0003oc>KI
olcVf@23olcVf@;o00000Oooool000Oooooo00Co0000oooooooooooo00000oooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0008ooooo`;o00001?ooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001oooo
o`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000
Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<
i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2
o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000ko
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`03o`000?l2Z9ko0ZRN00?o0ZRN1Oo<
i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<
i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T4o`:XWP04o`000?l2Z9ko0ZRNo`:XWPGoc>KI
2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI
2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI1?l2Z9h1ooooo`003_ooool2o`0008Ooc>KI00?o
0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001oooo
o`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000
Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<
i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2
o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000ko
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcV
f@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001
ooooo`003_ooool00ol0003ohaL<on<G3026on<G3003o`000?oS5`cohaL<08GohaL<0Oooool000ko
oooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI
00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcV
f@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001
ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o
0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`00
0?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<
i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool0
00kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Oo
c>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KI
olcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l0
0001ooooo`003_ooool00ol0003o0ZRNo`:XWP03o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8
o`:XWPGoc>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9
o`:XWPGoc>KI1?l2Z9h01?l0003o0ZRNo`:XW_l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2
Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2
Z9h5olcVf@Co0ZRN0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001
ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o
0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`00
0?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<
i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool0
00kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Oo
c>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KI
olcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l0
0001ooooo`001_ooool5o`0000?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001
ooooo`001oooool01?l0003oooooooooool00003ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23
olcVf@;o00000Oooool000Sooooo00?o0000ooooooooool00oooool00ol0003ohaL<on<G3026on<G
3003o`000?oS5`cohaL<08GohaL<0Oooool000Wooooo00?o0000ooooooooool00_ooool2o`0008Oo
c>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0006ooooo`05o`000?ooooooooooooooool0
00000oooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0006ooooo`05o`00
0?ooooooooooooooool000000oooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007o
oooo0007ooooo`?o00001?ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_oo
ool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T0
0ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI
08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007o
oooo000>ooooo`03o`000?l2Z9ko0ZRN00?o0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN
1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN
1Oo<i]T4o`:XWP04o`000?l2Z9ko0ZRNo`:XWPGoc>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGo
c>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGo
c>KI1?l2Z9h1ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_oo
ool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T0
0ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI
08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007o
oooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000
olcVfOo<i]T0POo<i]T01?l2Z9koc>KIo`000?l00001ooooo`003_ooool00ol0003ohaL<on<G3026
on<G3003o`000?oS5`cohaL<08GohaL<0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI
08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007o
oooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000
olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcV
f@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`00
3_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<
i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Wo
c>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00
007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo
00?o0000o`:XW_l2Z9h00ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN
1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Co0ZRN
00Co0000o`:XW_l2Z9ko0ZRN1Oo<i]T9o`:XWPGoc>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGo
c>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T4o`:XWP7o
oooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l0
0027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000
olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcV
f@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`00
3_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<
i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Wo
c>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00
007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000Sooooo
0ol00003ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000Wooooo00?o
0000ooooooooool00_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0006
ooooo`Go00000oooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo0006oooo
o`04o`000?ooooooooooo`0000Cooooo00?o0000on<G3?oS5``0Q_oS5``00ol0003ohaL<on<G3025
on<G307ooooo0007ooooo`03o`000?oooooo000000Cooooo0_l00027olcVf@03o`000?o<i]Woc>KI
08?oc>KI0_l00001ooooo`002?ooool2o`0000Cooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?o
c>KI0_l00001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o0000Qoo<i]T00ol0003oc>KI
olcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l0
0001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>oooo
o`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03
o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0
Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Ooo
ool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`00
08Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003o
c>KIolcVf@23olcVf@;o00000Oooool000kooooo00?o0000o`:XW_l2Z9h00ol2Z9h5olcVf@So0ZRN
1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN
1Oo<i]T8o`:XWPGoc>KI2Ol2Z9h5olcVf@Co0ZRN00Co0000o`:XW_l2Z9ko0ZRN1Oo<i]T9o`:XWPGo
c>KI2Ol2Z9h5olcVf@So0ZRN1Oo<i]T9o`:XWPGoc>KI2?l2Z9h5olcVf@Wo0ZRN1Oo<i]T8o`:XWPGo
c>KI2Ol2Z9h5olcVf@Wo0ZRN1Oo<i]T4o`:XWP7ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KI
olcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l0
0001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>oooo
o`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03
o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0
Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Ooo
ool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`00
08Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003o
c>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI
0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>
ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo00?o0000on<G
3?oS5``0Q_oS5``00ol0003ohaL<on<G3025on<G307ooooo000>oooooooo00004_l00001ooooo`00
\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.56707, -5.51412, 0.0368353, \
0.0368353}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Improper Node", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = 2  y\)], "Input"],

Cell[BoxData[
    \(2\ y\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = x\)], "Input"],

Cell[BoxData[
    \(x\)], "Output"]
}, Closed]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-5\) \[LessEqual] x \[LessEqual] 5\)},
          {\(\(-5\) \[LessEqual] y \[LessEqual] 5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -5, x, 5], 
        LessEqual[ -5, y, 5]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx == \(2\ y\)\/x\)], "Output"]
}, Closed]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(2\ \(y(t)\)\)}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(x(t)\)}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 
            Times[ 2, 
              y[ t]]], 
          Equal[ 
            Derivative[ 1][ x][ t], 
            x[ t]]}],
        Editable->False], TraditionalForm]], "Output"]
}, Closed]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0926184 0.5 0.0926184 [
[.12953 -0.0125 -6 -9 ]
[.12953 -0.0125 6 0 ]
[.31476 -0.0125 -6 -9 ]
[.31476 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68524 -0.0125 -3 -9 ]
[.68524 -0.0125 3 0 ]
[.87047 -0.0125 -3 -9 ]
[.87047 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12953 -12 -4.5 ]
[-0.0125 .12953 0 4.5 ]
[-0.0125 .31476 -12 -4.5 ]
[-0.0125 .31476 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68524 -6 -4.5 ]
[-0.0125 .68524 0 4.5 ]
[-0.0125 .87047 -6 -4.5 ]
[-0.0125 .87047 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12953 0 m
.12953 .00625 L
s
[(-4)] .12953 -0.0125 0 1 Mshowa
.31476 0 m
.31476 .00625 L
s
[(-2)] .31476 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68524 0 m
.68524 .00625 L
s
[(2)] .68524 -0.0125 0 1 Mshowa
.87047 0 m
.87047 .00625 L
s
[(4)] .87047 -0.0125 0 1 Mshowa
.125 Mabswid
.17584 0 m
.17584 .00375 L
s
.22214 0 m
.22214 .00375 L
s
.26845 0 m
.26845 .00375 L
s
.36107 0 m
.36107 .00375 L
s
.40738 0 m
.40738 .00375 L
s
.45369 0 m
.45369 .00375 L
s
.54631 0 m
.54631 .00375 L
s
.59262 0 m
.59262 .00375 L
s
.63893 0 m
.63893 .00375 L
s
.73155 0 m
.73155 .00375 L
s
.77786 0 m
.77786 .00375 L
s
.82416 0 m
.82416 .00375 L
s
.08322 0 m
.08322 .00375 L
s
.03691 0 m
.03691 .00375 L
s
.91678 0 m
.91678 .00375 L
s
.96309 0 m
.96309 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12953 m
.00625 .12953 L
s
[(-4)] -0.0125 .12953 1 0 Mshowa
0 .31476 m
.00625 .31476 L
s
[(-2)] -0.0125 .31476 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68524 m
.00625 .68524 L
s
[(2)] -0.0125 .68524 1 0 Mshowa
0 .87047 m
.00625 .87047 L
s
[(4)] -0.0125 .87047 1 0 Mshowa
.125 Mabswid
0 .17584 m
.00375 .17584 L
s
0 .22214 m
.00375 .22214 L
s
0 .26845 m
.00375 .26845 L
s
0 .36107 m
.00375 .36107 L
s
0 .40738 m
.00375 .40738 L
s
0 .45369 m
.00375 .45369 L
s
0 .54631 m
.00375 .54631 L
s
0 .59262 m
.00375 .59262 L
s
0 .63893 m
.00375 .63893 L
s
0 .73155 m
.00375 .73155 L
s
0 .77786 m
.00375 .77786 L
s
0 .82416 m
.00375 .82416 L
s
0 .08322 m
.00375 .08322 L
s
0 .03691 m
.00375 .03691 L
s
0 .91678 m
.00375 .91678 L
s
0 .96309 m
.00375 .96309 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12953 .99375 m
.12953 1 L
s
.31476 .99375 m
.31476 1 L
s
.5 .99375 m
.5 1 L
s
.68524 .99375 m
.68524 1 L
s
.87047 .99375 m
.87047 1 L
s
.125 Mabswid
.17584 .99625 m
.17584 1 L
s
.22214 .99625 m
.22214 1 L
s
.26845 .99625 m
.26845 1 L
s
.36107 .99625 m
.36107 1 L
s
.40738 .99625 m
.40738 1 L
s
.45369 .99625 m
.45369 1 L
s
.54631 .99625 m
.54631 1 L
s
.59262 .99625 m
.59262 1 L
s
.63893 .99625 m
.63893 1 L
s
.73155 .99625 m
.73155 1 L
s
.77786 .99625 m
.77786 1 L
s
.82416 .99625 m
.82416 1 L
s
.08322 .99625 m
.08322 1 L
s
.03691 .99625 m
.03691 1 L
s
.91678 .99625 m
.91678 1 L
s
.96309 .99625 m
.96309 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12953 m
1 .12953 L
s
.99375 .31476 m
1 .31476 L
s
.99375 .5 m
1 .5 L
s
.99375 .68524 m
1 .68524 L
s
.99375 .87047 m
1 .87047 L
s
.125 Mabswid
.99625 .17584 m
1 .17584 L
s
.99625 .22214 m
1 .22214 L
s
.99625 .26845 m
1 .26845 L
s
.99625 .36107 m
1 .36107 L
s
.99625 .40738 m
1 .40738 L
s
.99625 .45369 m
1 .45369 L
s
.99625 .54631 m
1 .54631 L
s
.99625 .59262 m
1 .59262 L
s
.99625 .63893 m
1 .63893 L
s
.99625 .73155 m
1 .73155 L
s
.99625 .77786 m
1 .77786 L
s
.99625 .82416 m
1 .82416 L
s
.99625 .08322 m
1 .08322 L
s
.99625 .03691 m
1 .03691 L
s
.99625 .91678 m
1 .91678 L
s
.99625 .96309 m
1 .96309 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.03691 .03691 m
.03691 .96309 L
.96309 .96309 L
.96309 .03691 L
F
0 0 0 r
.01 w
.03691 .03691 m
.96309 .03691 L
.96309 .96309 L
.03691 .96309 L
.03691 .03691 L
s
0 g
.5 Mabswid
.03691 .5 m
.96309 .5 L
s
.5 .03691 m
.5 .96309 L
s
.01 .66 .62 r
.04277 .04862 m
.03105 .02519 L
s
.04327 .09467 m
.03055 .07177 L
s
.04385 .14063 m
.02997 .11842 L
s
.04452 .18649 m
.02929 .16518 L
s
.04529 .23221 m
.02852 .21208 L
s
.04617 .27772 m
.02765 .25919 L
s
.04714 .32295 m
.02668 .30658 L
s
.04814 .36781 m
.02568 .35433 L
s
.04907 .41225 m
.02475 .40252 L
s
.04975 .45626 m
.02406 .45112 L
s
.05001 .5 m
.02381 .5 L
s
.04975 .54374 m
.02406 .54888 L
s
.04907 .58775 m
.02475 .59748 L
s
.04814 .63219 m
.02568 .64567 L
s
.04714 .67705 m
.02668 .69342 L
s
.04617 .72228 m
.02765 .74081 L
s
.04529 .76779 m
.02852 .78792 L
s
.04452 .81351 m
.02929 .83482 L
s
.04385 .85937 m
.02997 .88158 L
s
.04327 .90533 m
.03055 .92823 L
s
.04277 .95138 m
.03105 .97481 L
s
.08859 .04885 m
.07784 .02496 L
s
.08907 .09493 m
.07736 .0715 L
s
.08964 .14094 m
.0768 .11811 L
s
.0903 .18685 m
.07613 .16482 L
s
.09108 .23262 m
.07536 .21167 L
s
.09198 .27819 m
.07445 .25872 L
s
.09301 .32347 m
.07343 .30606 L
s
.09412 .36834 m
.07232 .35381 L
s
.09519 .4127 m
.07125 .40206 L
s
.096 .45653 m
.07043 .45085 L
s
.09632 .5 m
.07012 .5 L
s
.096 .54347 m
.07043 .54915 L
s
.09519 .5873 m
.07125 .59794 L
s
.09412 .63166 m
.07232 .64619 L
s
.09301 .67653 m
.07343 .69394 L
s
.09198 .72181 m
.07445 .74128 L
s
.09108 .76738 m
.07536 .78833 L
s
.0903 .81315 m
.07613 .83518 L
s
.08964 .85906 m
.0768 .88189 L
s
.08907 .90507 m
.07736 .9285 L
s
.08859 .95115 m
.07784 .97504 L
s
.13439 .04907 m
.12466 .02475 L
s
.13485 .09519 m
.12421 .07125 L
s
.13538 .14124 m
.12367 .11781 L
s
.13602 .18721 m
.12303 .16446 L
s
.13679 .23304 m
.12226 .21125 L
s
.13771 .27868 m
.12134 .25823 L
s
.13879 .32402 m
.12026 .3055 L
s
.14 .36893 m
.11905 .35321 L
s
.14124 .41324 m
.11781 .40152 L
s
.14223 .45687 m
.11682 .45051 L
s
.14262 .5 m
.11643 .5 L
s
.14223 .54313 m
.11682 .54949 L
s
.14124 .58676 m
.11781 .59848 L
s
.14 .63107 m
.11905 .64679 L
s
.13879 .67598 m
.12026 .6945 L
s
.13771 .72132 m
.12134 .74177 L
s
.13679 .76696 m
.12226 .78875 L
s
.13602 .81279 m
.12303 .83554 L
s
.13538 .85876 m
.12367 .88219 L
s
.13485 .90481 m
.12421 .92875 L
s
.13439 .95093 m
.12466 .97525 L
s
.18016 .04927 m
.17151 .02454 L
s
.18058 .09542 m
.17109 .07101 L
s
.18109 .14153 m
.17059 .11753 L
s
.18169 .18755 m
.16998 .16412 L
s
.18244 .23346 m
.16924 .21083 L
s
.18335 .27918 m
.16832 .25772 L
s
.18446 .32462 m
.16721 .30491 L
s
.18578 .3696 m
.16589 .35255 L
s
.18721 .41388 m
.16446 .40088 L
s
.18843 .45729 m
.16324 .45009 L
s
.18893 .5 m
.16274 .5 L
s
.18843 .54271 m
.16324 .54991 L
s
.18721 .58612 m
.16446 .59912 L
s
.18578 .6304 m
.16589 .64745 L
s
.18446 .67538 m
.16721 .69509 L
s
.18335 .72082 m
.16832 .74228 L
s
.18244 .76654 m
.16924 .78917 L
s
.18169 .81245 m
.16998 .83588 L
s
.18109 .85847 m
.17059 .88247 L
s
.18058 .90458 m
.17109 .92899 L
s
.18016 .95073 m
.17151 .97546 L
s
.22591 .04945 m
.21838 .02436 L
s
.22629 .09564 m
.218 .07079 L
s
.22674 .14179 m
.21755 .11726 L
s
.2273 .18787 m
.21699 .1638 L
s
.228 .23386 m
.21629 .21043 L
s
.22888 .27969 m
.21541 .25722 L
s
.23 .32524 m
.21429 .30428 L
s
.23141 .37033 m
.21288 .35181 L
s
.23304 .41465 m
.21125 .40012 L
s
.23457 .45783 m
.20972 .44955 L
s
.23524 .5 m
.20905 .5 L
s
.23457 .54217 m
.20972 .55045 L
s
.23304 .58535 m
.21125 .59988 L
s
.23141 .62967 m
.21288 .64819 L
s
.23 .67476 m
.21429 .69572 L
s
.22888 .72031 m
.21541 .74278 L
s
.228 .76614 m
.21629 .78957 L
s
.2273 .81213 m
.21699 .8362 L
s
.22674 .85821 m
.21755 .88274 L
s
.22629 .90436 m
.218 .92921 L
s
.22591 .95055 m
.21838 .97564 L
s
.27163 .04961 m
.26528 .0242 L
s
.27196 .09584 m
.26495 .0706 L
s
.27236 .14203 m
.26455 .11702 L
s
.27286 .18817 m
.26405 .1635 L
s
.27349 .23424 m
.26342 .21005 L
s
.27431 .28017 m
.2626 .25674 L
s
.2754 .32587 m
.26151 .30366 L
s
.27684 .37113 m
.26007 .35101 L
s
.27868 .41556 m
.25823 .3992 L
s
.28062 .45856 m
.25629 .44883 L
s
.28155 .5 m
.25536 .5 L
s
.28062 .54144 m
.25629 .55117 L
s
.27868 .58444 m
.25823 .6008 L
s
.27684 .62887 m
.26007 .64899 L
s
.2754 .67413 m
.26151 .69634 L
s
.27431 .71983 m
.2626 .74326 L
s
.27349 .76576 m
.26342 .78995 L
s
.27286 .81183 m
.26405 .8365 L
s
.27236 .85797 m
.26455 .88298 L
s
.27196 .90416 m
.26495 .9294 L
s
.27163 .95039 m
.26528 .9758 L
s
.31733 .04975 m
.31219 .02406 L
s
.3176 .096 m
.31192 .07043 L
s
.31794 .14223 m
.31159 .11682 L
s
.31836 .18843 m
.31116 .16324 L
s
.31891 .23457 m
.31062 .20972 L
s
.31963 .28062 m
.3099 .25629 L
s
.32062 .32648 m
.30891 .30305 L
s
.32203 .37197 m
.3075 .35017 L
s
.32402 .41664 m
.3055 .39812 L
s
.32648 .45955 m
.30305 .44783 L
s
.32786 .5 m
.30166 .5 L
s
.32648 .54045 m
.30305 .55217 L
s
.32402 .58336 m
.3055 .60188 L
s
.32203 .62803 m
.3075 .64983 L
s
.32062 .67352 m
.30891 .69695 L
s
.31963 .71938 m
.3099 .74371 L
s
.31891 .76543 m
.31062 .79028 L
s
.31836 .81157 m
.31116 .83676 L
s
.31794 .85777 m
.31159 .88318 L
s
.3176 .904 m
.31192 .92957 L
s
.31733 .95025 m
.31219 .97594 L
s
.36302 .04986 m
.35913 .02395 L
s
.36323 .09614 m
.35892 .0703 L
s
.36349 .1424 m
.35866 .11665 L
s
.36382 .18864 m
.35833 .16303 L
s
.36425 .23485 m
.3579 .20944 L
s
.36484 .281 m
.35731 .25591 L
s
.36567 .32703 m
.35647 .3025 L
s
.36693 .37279 m
.35521 .34936 L
s
.36893 .41786 m
.35321 .3969 L
s
.37197 .46096 m
.35017 .44643 L
s
.37417 .5 m
.34797 .5 L
s
.37197 .53904 m
.35017 .55357 L
s
.36893 .58214 m
.35321 .6031 L
s
.36693 .62721 m
.35521 .65064 L
s
.36567 .67297 m
.35647 .6975 L
s
.36484 .719 m
.35731 .74409 L
s
.36425 .76515 m
.3579 .79056 L
s
.36382 .81136 m
.35833 .83697 L
s
.36349 .8576 m
.35866 .88335 L
s
.36323 .90386 m
.35892 .9297 L
s
.36302 .95014 m
.35913 .97605 L
s
.40868 .04994 m
.40608 .02387 L
s
.40883 .09624 m
.40594 .0702 L
s
.40901 .14252 m
.40576 .11653 L
s
.40923 .1888 m
.40553 .16287 L
s
.40953 .23506 m
.40523 .20922 L
s
.40995 .2813 m
.40481 .25561 L
s
.41056 .32747 m
.4042 .30206 L
s
.41152 .3735 m
.40324 .34865 L
s
.41324 .4191 m
.40152 .39567 L
s
.41664 .46295 m
.39812 .44443 L
s
.42048 .5 m
.39428 .5 L
s
.41664 .53705 m
.39812 .55557 L
s
.41324 .5809 m
.40152 .60433 L
s
.41152 .6265 m
.40324 .65135 L
s
.41056 .67253 m
.4042 .69794 L
s
.40995 .7187 m
.40481 .74439 L
s
.40953 .76494 m
.40523 .79078 L
s
.40923 .8112 m
.40553 .83713 L
s
.40901 .85748 m
.40576 .88347 L
s
.40883 .90376 m
.40594 .9298 L
s
.40868 .95006 m
.40608 .97613 L
s
.45434 .04999 m
.45304 .02383 L
s
.45442 .0963 m
.45296 .07014 L
s
.45451 .1426 m
.45287 .11645 L
s
.45462 .1889 m
.45276 .16277 L
s
.45478 .2352 m
.4526 .20909 L
s
.45499 .28149 m
.45239 .25542 L
s
.45532 .32776 m
.45207 .30177 L
s
.45584 .37399 m
.45154 .34815 L
s
.45687 .42009 m
.45051 .39467 L
s
.45955 .46541 m
.44783 .44198 L
s
.46679 .5 m
.44059 .5 L
s
.45955 .53459 m
.44783 .55802 L
s
.45687 .57991 m
.45051 .60533 L
s
.45584 .62601 m
.45154 .65185 L
s
.45532 .67224 m
.45207 .69823 L
s
.45499 .71851 m
.45239 .74458 L
s
.45478 .7648 m
.4526 .79091 L
s
.45462 .8111 m
.45276 .83723 L
s
.45451 .8574 m
.45287 .88355 L
s
.45442 .9037 m
.45296 .92986 L
s
.45434 .95001 m
.45304 .97617 L
s
.5 .05001 m
.5 .02381 L
s
.5 .09632 m
.5 .07012 L
s
.5 .14262 m
.5 .11643 L
s
.5 .18893 m
.5 .16274 L
s
.5 .23524 m
.5 .20905 L
s
.5 .28155 m
.5 .25536 L
s
.5 .32786 m
.5 .30166 L
s
.5 .37417 m
.5 .34797 L
s
.5 .42048 m
.5 .39428 L
s
.5 .46679 m
.5 .44059 L
s
newpath
.5 .5 .00655 0 365.73 arc
s
.5 .53321 m
.5 .55941 L
s
.5 .57952 m
.5 .60572 L
s
.5 .62583 m
.5 .65203 L
s
.5 .67214 m
.5 .69834 L
s
.5 .71845 m
.5 .74464 L
s
.5 .76476 m
.5 .79095 L
s
.5 .81107 m
.5 .83726 L
s
.5 .85738 m
.5 .88357 L
s
.5 .90368 m
.5 .92988 L
s
.5 .94999 m
.5 .97619 L
s
.54566 .04999 m
.54696 .02383 L
s
.54558 .0963 m
.54704 .07014 L
s
.54549 .1426 m
.54713 .11645 L
s
.54538 .1889 m
.54724 .16277 L
s
.54522 .2352 m
.5474 .20909 L
s
.54501 .28149 m
.54761 .25542 L
s
.54468 .32776 m
.54793 .30177 L
s
.54416 .37399 m
.54846 .34815 L
s
.54313 .42009 m
.54949 .39467 L
s
.54045 .46541 m
.55217 .44198 L
s
.53321 .5 m
.55941 .5 L
s
.54045 .53459 m
.55217 .55802 L
s
.54313 .57991 m
.54949 .60533 L
s
.54416 .62601 m
.54846 .65185 L
s
.54468 .67224 m
.54793 .69823 L
s
.54501 .71851 m
.54761 .74458 L
s
.54522 .7648 m
.5474 .79091 L
s
.54538 .8111 m
.54724 .83723 L
s
.54549 .8574 m
.54713 .88355 L
s
.54558 .9037 m
.54704 .92986 L
s
.54566 .95001 m
.54696 .97617 L
s
.59132 .04994 m
.59392 .02387 L
s
.59117 .09624 m
.59406 .0702 L
s
.59099 .14252 m
.59424 .11653 L
s
.59077 .1888 m
.59447 .16287 L
s
.59047 .23506 m
.59477 .20922 L
s
.59005 .2813 m
.59519 .25561 L
s
.58944 .32747 m
.5958 .30206 L
s
.58848 .3735 m
.59676 .34865 L
s
.58676 .4191 m
.59848 .39567 L
s
.58336 .46295 m
.60188 .44443 L
s
.57952 .5 m
.60572 .5 L
s
.58336 .53705 m
.60188 .55557 L
s
.58676 .5809 m
.59848 .60433 L
s
.58848 .6265 m
.59676 .65135 L
s
.58944 .67253 m
.5958 .69794 L
s
.59005 .7187 m
.59519 .74439 L
s
.59047 .76494 m
.59477 .79078 L
s
.59077 .8112 m
.59447 .83713 L
s
.59099 .85748 m
.59424 .88347 L
s
.59117 .90376 m
.59406 .9298 L
s
.59132 .95006 m
.59392 .97613 L
s
.63698 .04986 m
.64087 .02395 L
s
.63677 .09614 m
.64108 .0703 L
s
.63651 .1424 m
.64134 .11665 L
s
.63618 .18864 m
.64167 .16303 L
s
.63575 .23485 m
.6421 .20944 L
s
.63516 .281 m
.64269 .25591 L
s
.63433 .32703 m
.64353 .3025 L
s
.63307 .37279 m
.64479 .34936 L
s
.63107 .41786 m
.64679 .3969 L
s
.62803 .46096 m
.64983 .44643 L
s
.62583 .5 m
.65203 .5 L
s
.62803 .53904 m
.64983 .55357 L
s
.63107 .58214 m
.64679 .6031 L
s
.63307 .62721 m
.64479 .65064 L
s
.63433 .67297 m
.64353 .6975 L
s
.63516 .719 m
.64269 .74409 L
s
.63575 .76515 m
.6421 .79056 L
s
.63618 .81136 m
.64167 .83697 L
s
.63651 .8576 m
.64134 .88335 L
s
.63677 .90386 m
.64108 .9297 L
s
.63698 .95014 m
.64087 .97605 L
s
.68267 .04975 m
.68781 .02406 L
s
.6824 .096 m
.68808 .07043 L
s
.68206 .14223 m
.68841 .11682 L
s
.68164 .18843 m
.68884 .16324 L
s
.68109 .23457 m
.68938 .20972 L
s
.68037 .28062 m
.6901 .25629 L
s
.67938 .32648 m
.69109 .30305 L
s
.67797 .37197 m
.6925 .35017 L
s
.67598 .41664 m
.6945 .39812 L
s
.67352 .45955 m
.69695 .44783 L
s
.67214 .5 m
.69834 .5 L
s
.67352 .54045 m
.69695 .55217 L
s
.67598 .58336 m
.6945 .60188 L
s
.67797 .62803 m
.6925 .64983 L
s
.67938 .67352 m
.69109 .69695 L
s
.68037 .71938 m
.6901 .74371 L
s
.68109 .76543 m
.68938 .79028 L
s
.68164 .81157 m
.68884 .83676 L
s
.68206 .85777 m
.68841 .88318 L
s
.6824 .904 m
.68808 .92957 L
s
.68267 .95025 m
.68781 .97594 L
s
.72837 .04961 m
.73472 .0242 L
s
.72804 .09584 m
.73505 .0706 L
s
.72764 .14203 m
.73545 .11702 L
s
.72714 .18817 m
.73595 .1635 L
s
.72651 .23424 m
.73658 .21005 L
s
.72569 .28017 m
.7374 .25674 L
s
.7246 .32587 m
.73849 .30366 L
s
.72316 .37113 m
.73993 .35101 L
s
.72132 .41556 m
.74177 .3992 L
s
.71938 .45856 m
.74371 .44883 L
s
.71845 .5 m
.74464 .5 L
s
.71938 .54144 m
.74371 .55117 L
s
.72132 .58444 m
.74177 .6008 L
s
.72316 .62887 m
.73993 .64899 L
s
.7246 .67413 m
.73849 .69634 L
s
.72569 .71983 m
.7374 .74326 L
s
.72651 .76576 m
.73658 .78995 L
s
.72714 .81183 m
.73595 .8365 L
s
.72764 .85797 m
.73545 .88298 L
s
.72804 .90416 m
.73505 .9294 L
s
.72837 .95039 m
.73472 .9758 L
s
.77409 .04945 m
.78162 .02436 L
s
.77371 .09564 m
.782 .07079 L
s
.77326 .14179 m
.78245 .11726 L
s
.7727 .18787 m
.78301 .1638 L
s
.772 .23386 m
.78371 .21043 L
s
.77112 .27969 m
.78459 .25722 L
s
.77 .32524 m
.78571 .30428 L
s
.76859 .37033 m
.78712 .35181 L
s
.76696 .41465 m
.78875 .40012 L
s
.76543 .45783 m
.79028 .44955 L
s
.76476 .5 m
.79095 .5 L
s
.76543 .54217 m
.79028 .55045 L
s
.76696 .58535 m
.78875 .59988 L
s
.76859 .62967 m
.78712 .64819 L
s
.77 .67476 m
.78571 .69572 L
s
.77112 .72031 m
.78459 .74278 L
s
.772 .76614 m
.78371 .78957 L
s
.7727 .81213 m
.78301 .8362 L
s
.77326 .85821 m
.78245 .88274 L
s
.77371 .90436 m
.782 .92921 L
s
.77409 .95055 m
.78162 .97564 L
s
.81984 .04927 m
.82849 .02454 L
s
.81942 .09542 m
.82891 .07101 L
s
.81891 .14153 m
.82941 .11753 L
s
.81831 .18755 m
.83002 .16412 L
s
.81756 .23346 m
.83076 .21083 L
s
.81665 .27918 m
.83168 .25772 L
s
.81554 .32462 m
.83279 .30491 L
s
.81422 .3696 m
.83411 .35255 L
s
.81279 .41388 m
.83554 .40088 L
s
.81157 .45729 m
.83676 .45009 L
s
.81107 .5 m
.83726 .5 L
s
.81157 .54271 m
.83676 .54991 L
s
.81279 .58612 m
.83554 .59912 L
s
.81422 .6304 m
.83411 .64745 L
s
.81554 .67538 m
.83279 .69509 L
s
.81665 .72082 m
.83168 .74228 L
s
.81756 .76654 m
.83076 .78917 L
s
.81831 .81245 m
.83002 .83588 L
s
.81891 .85847 m
.82941 .88247 L
s
.81942 .90458 m
.82891 .92899 L
s
.81984 .95073 m
.82849 .97546 L
s
.86561 .04907 m
.87534 .02475 L
s
.86515 .09519 m
.87579 .07125 L
s
.86462 .14124 m
.87633 .11781 L
s
.86398 .18721 m
.87697 .16446 L
s
.86321 .23304 m
.87774 .21125 L
s
.86229 .27868 m
.87866 .25823 L
s
.86121 .32402 m
.87974 .3055 L
s
.86 .36893 m
.88095 .35321 L
s
.85876 .41324 m
.88219 .40152 L
s
.85777 .45687 m
.88318 .45051 L
s
.85738 .5 m
.88357 .5 L
s
.85777 .54313 m
.88318 .54949 L
s
.85876 .58676 m
.88219 .59848 L
s
.86 .63107 m
.88095 .64679 L
s
.86121 .67598 m
.87974 .6945 L
s
.86229 .72132 m
.87866 .74177 L
s
.86321 .76696 m
.87774 .78875 L
s
.86398 .81279 m
.87697 .83554 L
s
.86462 .85876 m
.87633 .88219 L
s
.86515 .90481 m
.87579 .92875 L
s
.86561 .95093 m
.87534 .97525 L
s
.91141 .04885 m
.92216 .02496 L
s
.91093 .09493 m
.92264 .0715 L
s
.91036 .14094 m
.9232 .11811 L
s
.9097 .18685 m
.92387 .16482 L
s
.90892 .23262 m
.92464 .21167 L
s
.90802 .27819 m
.92555 .25872 L
s
.90699 .32347 m
.92657 .30606 L
s
.90588 .36834 m
.92768 .35381 L
s
.90481 .4127 m
.92875 .40206 L
s
.904 .45653 m
.92957 .45085 L
s
.90368 .5 m
.92988 .5 L
s
.904 .54347 m
.92957 .54915 L
s
.90481 .5873 m
.92875 .59794 L
s
.90588 .63166 m
.92768 .64619 L
s
.90699 .67653 m
.92657 .69394 L
s
.90802 .72181 m
.92555 .74128 L
s
.90892 .76738 m
.92464 .78833 L
s
.9097 .81315 m
.92387 .83518 L
s
.91036 .85906 m
.9232 .88189 L
s
.91093 .90507 m
.92264 .9285 L
s
.91141 .95115 m
.92216 .97504 L
s
.95723 .04862 m
.96895 .02519 L
s
.95673 .09467 m
.96945 .07177 L
s
.95615 .14063 m
.97003 .11842 L
s
.95548 .18649 m
.97071 .16518 L
s
.95471 .23221 m
.97148 .21208 L
s
.95383 .27772 m
.97235 .25919 L
s
.95286 .32295 m
.97332 .30658 L
s
.95186 .36781 m
.97432 .35433 L
s
.95093 .41225 m
.97525 .40252 L
s
.95025 .45626 m
.97594 .45112 L
s
.94999 .5 m
.97619 .5 L
s
.95025 .54374 m
.97594 .54888 L
s
.95093 .58775 m
.97525 .59748 L
s
.95186 .63219 m
.97432 .64567 L
s
.95286 .67705 m
.97332 .69342 L
s
.95383 .72228 m
.97235 .74081 L
s
.95471 .76779 m
.97148 .78792 L
s
.95548 .81351 m
.97071 .83482 L
s
.95615 .85937 m
.97003 .88158 L
s
.95673 .90533 m
.96945 .92823 L
s
.95723 .95138 m
.96895 .97481 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00=?ooool3o`0002gooooo1Ol0000]ooooo`;o0000
;_ooool5o`0002oooooo0ol0000Sooooo`00=Oooool00ol0003oooooooooo`0]ooooo`04o`000?oo
ooooooooo`0002cooooo00Co0000oooooooooooo0000;_ooool01?l0003oooooooooool0000`oooo
o`03o`000?oooooooooo02;ooooo000/ooooo`Go000000?oooooo`000?l000000ol0000Wooooo`Go
00000oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0002oooooo00?o0000oooo
ooooool0;Oooool5o`0002?ooooo000booooo`04o`000?ooooooooooo`00037ooooo00?o0000oooo
ooooool0:oooool01?l0003oooooooooool0000`ooooo`03o`000?oooooooooo02cooooo00Co0000
oooooooooooo00009?ooool003?ooooo00?o0000ooooool00000;_ooool01Ol0003ooooooooooooo
oooo000002cooooo00Co0000oooooooooooo0000;Oooool01Ol0003ooooooooooooooooo000002ko
oooo00?o0000ooooool000009?ooool003Cooooo0_l0000^ooooo`05o`000?ooooooooooooooool0
0000;?ooool01?l0003oooooooooool0000]ooooo`05o`000?ooooooooooooooool00000;oooool2
o`0002Cooooo000eooooo`03o`000?oooooooooo02gooooo0ol0000^ooooo`;o0000;oooool3o`00
037ooooo00?o0000ooooooooool08_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000ooooooool0000Ao`00007ooooo000?ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool08?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Gooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Ooo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool01_ooool1
o`00007ooooo000?ooooo`;o00001oooool00ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00[o000000?o0ZRNooooooooool01Oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo00?o0000o`:XW_l000002ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo
000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o
000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_oooooooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o000000?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o
oooo00Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001`
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1]
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`00
0?l000002_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0000
00?o0ZRNooooooooool01_ooool1o`00007ooooo000?ooooo`;o00001oooool00ol0003o0ZRNolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`;o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0000o`:XW_ooool02?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l000000ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:X
W_ooool02?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<i]Wo
0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool02?ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@18olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0001Koc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0ColcVf@;o00002Oooool1o`00007ooooo0008ooooo`?o00001?oo
ool00ol0003oooooooooo`05ooooo`03o`:XW_l0003o000000[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<
i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@06
olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo0005o`000003ooooool0003o0000
00?o00001?ooool00ol0003oooooooooo`06ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Kooooo0Ol00001ooooo`001_ooool01?l0003o
ooooooooool00005ooooo`?o00001_ooool00ol0003o0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0000o`:XW_ooool01oooool2o`00007ooooo0007ooooo`03o`000?oooooo000000Go
oooo00?o0000ooooooooool01_ooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0000o`:XW_ooool02?ooool1o`00007ooooo0008ooooo`;o00001Oooool00ol0003ooooo
ooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_l0003ooooo00Sooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNo`000?l000002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`05ooooo`03o`:XW_l0003o000000[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2
o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05oooo
o`03o`:XW_l0003o000000[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`000003ooooool2Z9kooooo
00Kooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`:XW_l0003oc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Kooooo0Ol00001ooooo`00
3oooool2o`0000Oooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`00
0?l2Z9kooooo00Oooooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`000?l2
Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`08ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9ko0000o`000009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003oo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0lolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o
0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003coc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Gooooo00?o0ZRNo`000?l000002Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@;o0000
0_ooool00ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Ooo
ool00ol2Z9ko0000o`000009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l000000ooooooo0ZRNoooo
o`06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol2Z9ko0000olcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool0
00oooooo0_l00007ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0
003o0ZRNooooo`07ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9ko0000ooooo`08ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9ko0000o`000009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0000koc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0002?oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI01ooc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool01?l2
Z9koooooo`000?l00009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oooooo
oooo00Cooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003o0000
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol00001oooo
o`003oooool2o`0000Oooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o
000000?o0ZRNooooooooool01Oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Sooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_l0003o000000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000?oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI03coc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000Hoo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI05ooc>KI0_l00009ooooo`7o00000Oooool000Ko
oooo1Ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0000FolcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T04_o<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0003ooooo
ooooool00004ooooo`03o`000?oooooooooo00Cooooo0_l2Z9h2o`0000Woc>KI0_l2Z9h<olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPSoc>KI0_l000000ooooooo
0ZRNo`:XWP06ooooo`7o00000Oooool000Go00000oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0000
00?o0ZRNooooooooool01_ooool1o`00007ooooo0009ooooo`03o`000?oooooooooo00?ooooo0ol0
0006ooooo`03o`000?l2Z9ko0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNoooo
o`07ooooo`;o00000Oooool000Kooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo00Kooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNo`000?ooool02?ooool1o`00007ooooo0006ooooo`05o`000?ooooooooooooooool000001?oo
ool00ol0003oooooooooo`06ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNo`000?l000002Oooool1o`00007ooooo0007ooooo`?o00001Oooool0
0ol0003oooooooooo`06ooooo`;o00009oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T09?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0005Goc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T0D_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
00005Oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9hDolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Cooooo0_l2Z9h2o`0000Woc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T2o`:XWPOoc>KI0_l000000ooooooo0ZRNo`:XWP06ooooo`7o0000
0Oooool000oooooo0_l00007ooooo`;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2Oo<i]T00ol0003o0ZRNo`:XWP07ooooo`;o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0000;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI0_l2Z9h0
0ol0003oooooooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
00;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@04o`:XW_o<i]Wo0000
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00006oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI01Soc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0005Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0EOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0005Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0D_o<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o00005Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<
i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9hDolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo0ol2Z9h00ol0003oc>KIolcVf@06
olcVf@?o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h7
olcVf@;o000000Coooooo`:XW_l2Z9ko0ZRN1Oooool1o`00007ooooo000?ooooo`;o00001oooool0
1?l0003o0ZRNo`:XW_l2Z9h9olcVf@?o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<
i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<
i]T3o`:XWPWoc>KI0ol2Z9h7ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0000;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWP;o00002Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l0000KolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T06?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000COo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T0B_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
LOo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
K_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001^olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@1[olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001QolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0G_o<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000;_o<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN;Oo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`03ooooo`Go0ZRN2?o<i]T5o`:XWPSoc>KI1Ol2Z9h7olcV
f@?o0ZRN3?o<i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@;o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h<olcVf@?o0ZRN2Oo<i]T4o`:XWPSoc>KI1?l2Z9h7olcV
f@;o00001?l2Z9h5ooooo`7o00000Oooool000oooooo0_l00007ooooo`;o00000ol2Z9h:olcVf@?o
0ZRN2_o<i]T3o`:XWPOoc>KI0ol2Z9h<olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;o
0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o
0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@?o0ZRN2?o<i]T4o`:XWPSoc>KI1?l2Z9h9olcVf@Co
0ZRN2?ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000WolcVf@;o0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN9_o<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000F_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1GolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001bolcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@1^olcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo0008ooooo`;o
00001Oooool00ol0003oooooooooo`06ooooo`;o0000O?o<i]T2o`:XWW_oc>KI0_l00009ooooo`7o
00000Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`06ooooo`;o
0000Noo<i]T01?l2Z9koc>KIo`000?l2Z9ijolcVf@;o00002Oooool1o`00007ooooo0007ooooo`04
o`000?ooooooooooo`0000Cooooo0ol00003ooooo`So0ZRN1Ol00008o`:XWPGo00002?l2Z9h4o`00
00So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h5o`00
00So0ZRN1_l000001?l2Z9ko0000o`000?l2Z9h7o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4
o`0000So0ZRN1Ol00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5
o`0000So0ZRN1?ooool2o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool01_ooool2o`0007_oc>KI0_l2Z9h00ol0003o0ZRNolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Wo
c>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Sooooo0_l00005ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001VolcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0Hoo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000@?o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o0ZRN
2_o<i]T2o`:XWSooc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool00ol0003o0ZRNo`:XWP02o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2
Z9h7olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP[oc>KI0ol2
Z9h8olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T5o`:XWPSooooo0Ol0
0001ooooo`003oooool2o`0000Cooooo1?l2Z9h00ol0003oc>KIolcVf@08olcVf@?o0ZRN2_o<i]T3
o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2?o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2
o`:XWPWoc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h9olcVf@;o000000Cooooo
o`:XW_l2Z9ko0ZRN1?ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00008
olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:
olcVf@;o0ZRN1oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000E?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1AolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001^olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@1[olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000FOo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@1FolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
000colcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWS;oc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9ko
0ZRN00_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2
o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP;o00002Oooool1o`00007ooooo000?oooo
o`;o00001oooool00ol0003o0ZRNo`:XWP0:olcVf@?o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcV
f@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h:olcV
f@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN1oooool2o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo0_l2Z9h00ol0003oc>KIolcVf@07olcVf@;o0ZRN2oo<i]T2o`:XWP_o
c>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWPSo
c>KI0_l000000ooooooo0ZRNo`:XWP06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1?ooool01?l2Z9koooooo`000?l00008olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_l00003ooooo`03
o`:XW_oooooooooo00?ooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
>oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03Soc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006;oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@1OolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`00077oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI06goc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0003Coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0<?o<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2Z9h02_o<i]T2o`:X
WP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2_o<i]T2o`:X
WP_oc>KI0_l2Z9h:olcVf@;o0ZRN0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
0000ooooo`08ooooo`7o00000Oooool000oooooo0_l00007ooooo`;o0ZRN2oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@03o`000?l2Z9ko0ZRN00Oooooo
0_l00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003o000000[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`04ooooo`04o`:XW_oooooo0000o`0000Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<
i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0000lolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0>?o<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0
003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`00043oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0lolcV
f@;o00002Oooool1o`00007ooooo0006ooooo`Go00001?ooool00ol0003oooooooooo`06ooooo`;o
000000?oc>KIo`:XW_l2Z9h02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o000000Wo
oooo0Ol00001ooooo`001oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Ko
oooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?oo
ool02?ooool1o`00007ooooo0008ooooo`03o`000?oooooooooo00Cooooo0ol00006ooooo`03o`00
0?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07ooooo`;o0000
0Oooool000Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`03o`:XW_l0
003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Kooooo0Ol0
0001ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01Ooo
ool00ol2Z9ko0000o`00000:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNoooo
o`06ooooo`7o00000Oooool000Kooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oo
oooooooo00Cooooo00Co0ZRNooooool0003o00002Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o0000
0_ooool00ol2Z9koooooooooo`04ooooo`7o00000Oooool000Oooooo0ol00005ooooo`03o`000?oo
oooooooo00Kooooo0_l00019olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@15olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00003_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000oo<
i]Wo0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?l000002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool02?ooool1o`00007ooooo000?ooooo`;o0000
1oooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool0
1oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01_ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07
olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Cooooo00Co0ZRNooooool0003o00002Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000_ooool0
0ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
06?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1PolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003?oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T0<?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
000000?oc>KIo`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003o000000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003oooool2o`0000Oooooo00?o0000
o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01Oooool2
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01_ooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo00?o0ZRNo`000?l000002Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o
00000_ooool00ol2Z9koooooooooo`04ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0001Koc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0ColcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Wo
c>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI
00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`06ooooo`;o000000?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0
003o000000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KI
o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003o000000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`003oooool2o`0000Oo
oooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Oo
oooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`000?l2Z9koc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`08ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l0
00000ol2Z9koooooooooo`06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool0
0ol2Z9ko0000o`00000:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l000000ooooooo0ZRNooooo`06
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0003goc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0003;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0;oo<i]T2o`00
00Wooooo0Ol00001ooooo`002?ooool3o`0000Cooooo00?o0000ooooooooool01_ooool2o`000003
olcVfOl2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000o`000009ooooo`7o
00000Oooool000Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`;o0000
00?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003o000000Wooooo
0Ol00001ooooo`001_ooool5o`0000Cooooo00?o0000ooooooooool01_ooool2o`000003o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Ooo
ool000Kooooo00Co0000oooooooooooo00001Oooool3o`0000Kooooo00?o0000o`:XW_o<i]T02oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Oooooo0_l00001ooooo`001oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00Kooooo00?o0000o`:XW_o<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`002?ooool2o`00
00Gooooo00?o0000ooooooooool01_ooool00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI0_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool000Wooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003o000000[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01_o<i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`000003olcVfOl2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`08
ooooo`7o00000Oooool000oooooo0_l00007ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07ooooo`;o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool00ol0003o0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9ko
ooooooooo`06ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol2Z9ko0000
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`06ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01Oooool00ol2Z9ko0000o`00000;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI0_l000000ooooooo0ZRNooooo`06ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000oolcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T0>oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_l0003ooooo00Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
000000?oc>KIo`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00So
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Sooooo0Ol00001ooooo`003ooo
ool2o`0000Oooooo00?o0000o`:XW_l000002ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0
003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_oo
oooooooo00Kooooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`03o`000?l2Z9ko
000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9koooooooooo`06ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo
00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo
00[ooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo
00[ooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo
00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo
00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo
00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo
00[ooooo00?o0ZRNooooooooool01_ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Go
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wo
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wo
oooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[o
oooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Go
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`3oooooo`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3o
ooooo`gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`3oooooo`gooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo00?o0000oooooooo
ool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02oooooo00?o0000oooooooo
ool08?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0
2Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oooooo0Ol00001ooooo`003ooo
ooooo`00017o00000Oooool00?oooooo8Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-6.01076, -5.95359, 0.039771, \
0.039771}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 0.5. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{k, 2}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), 2}, {\(-4\), 2}, {\(-3\), 2}, {\(-2\), 2}, {\(-1\), 2}, {0, 
        2}, {1, 2}, {2, 2}, {3, 2}, {4, 2}, {5, 2}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t2 = Table[{k, \(-2\)}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), \(-2\)}, {\(-4\), \(-2\)}, {\(-3\), \(-2\)}, {\(-2\), \
\(-2\)}, {\(-1\), \(-2\)}, {0, \(-2\)}, {1, \(-2\)}, {2, \(-2\)}, {3, \
\(-2\)}, {4, \(-2\)}, {5, \(-2\)}}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(thePoints = Join[t1, t2];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Produce Final Output", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayAll;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[.1 -0.0125 -6 -9 ]
[.1 -0.0125 6 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7 -0.0125 -3 -9 ]
[.7 -0.0125 3 0 ]
[.9 -0.0125 -3 -9 ]
[.9 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .1 -12 -4.5 ]
[-0.0125 .1 0 4.5 ]
[-0.0125 .3 -12 -4.5 ]
[-0.0125 .3 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7 -6 -4.5 ]
[-0.0125 .7 0 4.5 ]
[-0.0125 .9 -6 -4.5 ]
[-0.0125 .9 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1 0 m
.1 .00625 L
s
[(-4)] .1 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-2)] .3 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(2)] .7 -0.0125 0 1 Mshowa
.9 0 m
.9 .00625 L
s
[(4)] .9 -0.0125 0 1 Mshowa
.125 Mabswid
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.25 0 m
.25 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.75 0 m
.75 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.05 0 m
.05 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .1 m
.00625 .1 L
s
[(-4)] -0.0125 .1 1 0 Mshowa
0 .3 m
.00625 .3 L
s
[(-2)] -0.0125 .3 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7 m
.00625 .7 L
s
[(2)] -0.0125 .7 1 0 Mshowa
0 .9 m
.00625 .9 L
s
[(4)] -0.0125 .9 1 0 Mshowa
.125 Mabswid
0 .15 m
.00375 .15 L
s
0 .2 m
.00375 .2 L
s
0 .25 m
.00375 .25 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .45 m
.00375 .45 L
s
0 .55 m
.00375 .55 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .75 m
.00375 .75 L
s
0 .8 m
.00375 .8 L
s
0 .85 m
.00375 .85 L
s
0 .05 m
.00375 .05 L
s
0 .95 m
.00375 .95 L
s
.25 Mabswid
0 0 m
0 1 L
s
.1 .99375 m
.1 1 L
s
.3 .99375 m
.3 1 L
s
.5 .99375 m
.5 1 L
s
.7 .99375 m
.7 1 L
s
.9 .99375 m
.9 1 L
s
.125 Mabswid
.15 .99625 m
.15 1 L
s
.2 .99625 m
.2 1 L
s
.25 .99625 m
.25 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.45 .99625 m
.45 1 L
s
.55 .99625 m
.55 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.75 .99625 m
.75 1 L
s
.8 .99625 m
.8 1 L
s
.85 .99625 m
.85 1 L
s
.05 .99625 m
.05 1 L
s
.95 .99625 m
.95 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .1 m
1 .1 L
s
.99375 .3 m
1 .3 L
s
.99375 .5 m
1 .5 L
s
.99375 .7 m
1 .7 L
s
.99375 .9 m
1 .9 L
s
.125 Mabswid
.99625 .15 m
1 .15 L
s
.99625 .2 m
1 .2 L
s
.99625 .25 m
1 .25 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .45 m
1 .45 L
s
.99625 .55 m
1 .55 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .75 m
1 .75 L
s
.99625 .8 m
1 .8 L
s
.99625 .85 m
1 .85 L
s
.99625 .05 m
1 .05 L
s
.99625 .95 m
1 .95 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
.00632 .01265 m
0 0 rlineto s
.00632 .01265 m
0 0 L
s
.00687 .06236 m
0 0 rlineto s
.00687 .06236 m
0 .05 L
s
.0075 .11199 m
0 0 rlineto s
.0075 .11199 m
0 .1 L
s
.00822 .16151 m
0 0 rlineto s
.00822 .16151 m
0 .15 L
s
.00905 .21086 m
0 0 rlineto s
.00905 .21086 m
0 .2 L
s
.01 .26 m
0 0 rlineto s
.01 .26 m
0 .25 L
s
.01104 .30883 m
0 0 rlineto s
.01104 .30883 m
0 .3 L
s
.01213 .35728 m
0 0 rlineto s
.01213 .35728 m
0 .35 L
s
.01313 .40525 m
0 0 rlineto s
.01313 .40525 m
0 .4 L
s
.01387 .45277 m
0 0 rlineto s
.01387 .45277 m
0 .45 L
s
.01414 .5 m
0 0 rlineto s
.01414 .5 m
0 .5 L
s
.01387 .54723 m
0 0 rlineto s
.01387 .54723 m
0 .55 L
s
.01313 .59475 m
0 0 rlineto s
.01313 .59475 m
0 .6 L
s
.01213 .64272 m
0 0 rlineto s
.01213 .64272 m
0 .65 L
s
.01104 .69117 m
0 0 rlineto s
.01104 .69117 m
0 .7 L
s
.01 .74 m
0 0 rlineto s
.01 .74 m
0 .75 L
s
.00905 .78914 m
0 0 rlineto s
.00905 .78914 m
0 .8 L
s
.00822 .83849 m
0 0 rlineto s
.00822 .83849 m
0 .85 L
s
.0075 .88801 m
0 0 rlineto s
.0075 .88801 m
0 .9 L
s
.00687 .93764 m
0 0 rlineto s
.00687 .93764 m
0 .95 L
s
.00632 .98735 m
0 0 rlineto s
.00632 .98735 m
0 1 L
s
.0558 .0129 m
0 0 rlineto s
.0558 .0129 m
.05 0 L
s
.05632 .06265 m
.04368 .03735 L
s
.05693 .11233 m
.04307 .08767 L
s
.05765 .1619 m
.04235 .1381 L
s
.05849 .21131 m
.04151 .18869 L
s
.05946 .26051 m
.04054 .23949 L
s
.06057 .3094 m
.03943 .2906 L
s
.06177 .35784 m
.03823 .34216 L
s
.06292 .40574 m
.03708 .39426 L
s
.06381 .45307 m
.03619 .44693 L
s
.06414 .5 m
.03586 .5 L
s
.06381 .54693 m
.03619 .55307 L
s
.06292 .59426 m
.03708 .60574 L
s
.06177 .64216 m
.03823 .65784 L
s
.06057 .6906 m
.03943 .7094 L
s
.05946 .73949 m
.04054 .76051 L
s
.05849 .78869 m
.04151 .81131 L
s
.05765 .8381 m
.04235 .8619 L
s
.05693 .88767 m
.04307 .91233 L
s
.05632 .93735 m
.04368 .96265 L
s
.0558 .9871 m
0 0 rlineto s
.0558 .9871 m
.05 1 L
s
.10525 .01313 m
0 0 rlineto s
.10525 .01313 m
.1 0 L
s
.10574 .06292 m
.09426 .03708 L
s
.10632 .11265 m
.09368 .08735 L
s
.10702 .16228 m
.09298 .13772 L
s
.10784 .21177 m
.09216 .18823 L
s
.10883 .26104 m
.09117 .23896 L
s
.11 .31 m
.09 .29 L
s
.11131 .35849 m
.08869 .34151 L
s
.11265 .40632 m
.08735 .39368 L
s
.11372 .45343 m
.08628 .44657 L
s
.11414 .5 m
.08586 .5 L
s
.11372 .54657 m
.08628 .55343 L
s
.11265 .59368 m
.08735 .60632 L
s
.11131 .64151 m
.08869 .65849 L
s
.11 .69 m
.09 .71 L
s
.10883 .73896 m
.09117 .76104 L
s
.10784 .78823 m
.09216 .81177 L
s
.10702 .83772 m
.09298 .86228 L
s
.10632 .88735 m
.09368 .91265 L
s
.10574 .93708 m
.09426 .96292 L
s
.10525 .98687 m
0 0 rlineto s
.10525 .98687 m
.1 1 L
s
.15467 .01335 m
0 0 rlineto s
.15467 .01335 m
.15 0 L
s
.15513 .06318 m
.14487 .03682 L
s
.15567 .11296 m
.14433 .08704 L
s
.15632 .16265 m
.14368 .13735 L
s
.15713 .21222 m
.14287 .18778 L
s
.15811 .26159 m
.14189 .23841 L
s
.15931 .31064 m
.14069 .28936 L
s
.16074 .3592 m
.13926 .3408 L
s
.16228 .40702 m
.13772 .39298 L
s
.1636 .45389 m
.1364 .44611 L
s
.16414 .5 m
.13586 .5 L
s
.1636 .54611 m
.1364 .55389 L
s
.16228 .59298 m
.13772 .60702 L
s
.16074 .6408 m
.13926 .6592 L
s
.15931 .68936 m
.14069 .71064 L
s
.15811 .73841 m
.14189 .76159 L
s
.15713 .78778 m
.14287 .81222 L
s
.15632 .83735 m
.14368 .86265 L
s
.15567 .88704 m
.14433 .91296 L
s
.15513 .93682 m
.14487 .96318 L
s
.15467 .98665 m
0 0 rlineto s
.15467 .98665 m
.15 1 L
s
.20406 .01355 m
0 0 rlineto s
.20406 .01355 m
.2 0 L
s
.20447 .06342 m
.19553 .03658 L
s
.20497 .11324 m
.19503 .08676 L
s
.20557 .163 m
.19443 .137 L
s
.20632 .21265 m
.19368 .18735 L
s
.20728 .26213 m
.19272 .23787 L
s
.20849 .31131 m
.19151 .28869 L
s
.21 .36 m
.19 .34 L
s
.21177 .40784 m
.18823 .39216 L
s
.21342 .45447 m
.18658 .44553 L
s
.21414 .5 m
.18586 .5 L
s
.21342 .54553 m
.18658 .55447 L
s
.21177 .59216 m
.18823 .60784 L
s
.21 .64 m
.19 .66 L
s
.20849 .68869 m
.19151 .71131 L
s
.20728 .73787 m
.19272 .76213 L
s
.20632 .78735 m
.19368 .81265 L
s
.20557 .837 m
.19443 .863 L
s
.20497 .88676 m
.19503 .91324 L
s
.20447 .93658 m
.19553 .96342 L
s
.20406 .98645 m
0 0 rlineto s
.20406 .98645 m
.2 1 L
s
.25343 .01372 m
0 0 rlineto s
.25343 .01372 m
.25 0 L
s
.25379 .06363 m
.24621 .03637 L
s
.25422 .1135 m
.24578 .0865 L
s
.25476 .16332 m
.24524 .13668 L
s
.25544 .21305 m
.24456 .18695 L
s
.25632 .26265 m
.24368 .23735 L
s
.2575 .31199 m
.2425 .28801 L
s
.25905 .36086 m
.24095 .33914 L
s
.26104 .40883 m
.23896 .39117 L
s
.26313 .45525 m
.23687 .44475 L
s
.26414 .5 m
.23586 .5 L
s
.26313 .54475 m
.23687 .55525 L
s
.26104 .59117 m
.23896 .60883 L
s
.25905 .63914 m
.24095 .66086 L
s
.2575 .68801 m
.2425 .71199 L
s
.25632 .73735 m
.24368 .76265 L
s
.25544 .78695 m
.24456 .81305 L
s
.25476 .83668 m
.24524 .86332 L
s
.25422 .8865 m
.24578 .9135 L
s
.25379 .93637 m
.24621 .96363 L
s
.25343 .98628 m
0 0 rlineto s
.25343 .98628 m
.25 1 L
s
.30277 .01387 m
0 0 rlineto s
.30277 .01387 m
.3 0 L
s
.30307 .06381 m
.29693 .03619 L
s
.30343 .11372 m
.29657 .08628 L
s
.30389 .1636 m
.29611 .1364 L
s
.30447 .21342 m
.29553 .18658 L
s
.30525 .26313 m
.29475 .23687 L
s
.30632 .31265 m
.29368 .28735 L
s
.30784 .36177 m
.29216 .33823 L
s
.31 .41 m
.29 .39 L
s
.31265 .45632 m
.28735 .44368 L
s
.31414 .5 m
.28586 .5 L
s
.31265 .54368 m
.28735 .55632 L
s
.31 .59 m
.29 .61 L
s
.30784 .63823 m
.29216 .66177 L
s
.30632 .68735 m
.29368 .71265 L
s
.30525 .73687 m
.29475 .76313 L
s
.30447 .78658 m
.29553 .81342 L
s
.30389 .8364 m
.29611 .8636 L
s
.30343 .88628 m
.29657 .91372 L
s
.30307 .93619 m
.29693 .96381 L
s
.30277 .98613 m
0 0 rlineto s
.30277 .98613 m
.3 1 L
s
.3521 .01399 m
0 0 rlineto s
.3521 .01399 m
.35 0 L
s
.35232 .06395 m
.34768 .03605 L
s
.35261 .1139 m
.34739 .0861 L
s
.35296 .16383 m
.34704 .13617 L
s
.35343 .21372 m
.34657 .18628 L
s
.35406 .26355 m
.34594 .23645 L
s
.35497 .31324 m
.34503 .28676 L
s
.35632 .36265 m
.34368 .33735 L
s
.35849 .41131 m
.34151 .38869 L
s
.36177 .45784 m
.33823 .44216 L
s
.36414 .5 m
.33586 .5 L
s
.36177 .54216 m
.33823 .55784 L
s
.35849 .58869 m
.34151 .61131 L
s
.35632 .63735 m
.34368 .66265 L
s
.35497 .68676 m
.34503 .71324 L
s
.35406 .73645 m
.34594 .76355 L
s
.35343 .78628 m
.34657 .81372 L
s
.35296 .83617 m
.34704 .86383 L
s
.35261 .8861 m
.34739 .9139 L
s
.35232 .93605 m
.34768 .96395 L
s
.3521 .98601 m
0 0 rlineto s
.3521 .98601 m
.35 1 L
s
.40141 .01407 m
0 0 rlineto s
.40141 .01407 m
.4 0 L
s
.40156 .06406 m
.39844 .03594 L
s
.40175 .11403 m
.39825 .08597 L
s
.402 .164 m
.398 .136 L
s
.40232 .21395 m
.39768 .18605 L
s
.40277 .26387 m
.39723 .23613 L
s
.40343 .31372 m
.39657 .28628 L
s
.40447 .36342 m
.39553 .33658 L
s
.40632 .41265 m
.39368 .38735 L
s
.41 .46 m
.39 .44 L
s
.41414 .5 m
.38586 .5 L
s
.41 .54 m
.39 .56 L
s
.40632 .58735 m
.39368 .61265 L
s
.40447 .63658 m
.39553 .66342 L
s
.40343 .68628 m
.39657 .71372 L
s
.40277 .73613 m
.39723 .76387 L
s
.40232 .78605 m
.39768 .81395 L
s
.402 .836 m
.398 .864 L
s
.40175 .88597 m
.39825 .91403 L
s
.40156 .93594 m
.39844 .96406 L
s
.40141 .98593 m
0 0 rlineto s
.40141 .98593 m
.4 1 L
s
.45071 .01412 m
0 0 rlineto s
.45071 .01412 m
.45 0 L
s
.45078 .06412 m
.44922 .03588 L
s
.45088 .11411 m
.44912 .08589 L
s
.45101 .16411 m
.44899 .13589 L
s
.45117 .21409 m
.44883 .18591 L
s
.45141 .26407 m
.44859 .23593 L
s
.45175 .31403 m
.44825 .28597 L
s
.45232 .36395 m
.44768 .33605 L
s
.45343 .41372 m
.44657 .38628 L
s
.45632 .46265 m
.44368 .43735 L
s
.46414 .5 m
.43586 .5 L
s
.45632 .53735 m
.44368 .56265 L
s
.45343 .58628 m
.44657 .61372 L
s
.45232 .63605 m
.44768 .66395 L
s
.45175 .68597 m
.44825 .71403 L
s
.45141 .73593 m
.44859 .76407 L
s
.45117 .78591 m
.44883 .81409 L
s
.45101 .83589 m
.44899 .86411 L
s
.45088 .88589 m
.44912 .91411 L
s
.45078 .93588 m
.44922 .96412 L
s
.45071 .98588 m
0 0 rlineto s
.45071 .98588 m
.45 1 L
s
.5 .01414 m
0 0 rlineto s
.5 .01414 m
.5 0 L
s
.5 .06414 m
.5 .03586 L
s
.5 .11414 m
.5 .08586 L
s
.5 .16414 m
.5 .13586 L
s
.5 .21414 m
.5 .18586 L
s
.5 .26414 m
.5 .23586 L
s
.5 .31414 m
.5 .28586 L
s
.5 .36414 m
.5 .33586 L
s
.5 .41414 m
.5 .38586 L
s
.5 .46414 m
.5 .43586 L
s
newpath
.5 .5 .00707 0 365.73 arc
s
.5 .53586 m
.5 .56414 L
s
.5 .58586 m
.5 .61414 L
s
.5 .63586 m
.5 .66414 L
s
.5 .68586 m
.5 .71414 L
s
.5 .73586 m
.5 .76414 L
s
.5 .78586 m
.5 .81414 L
s
.5 .83586 m
.5 .86414 L
s
.5 .88586 m
.5 .91414 L
s
.5 .93586 m
.5 .96414 L
s
.5 .98586 m
0 0 rlineto s
.5 .98586 m
.5 1 L
s
.54929 .01412 m
0 0 rlineto s
.54929 .01412 m
.55 0 L
s
.54922 .06412 m
.55078 .03588 L
s
.54912 .11411 m
.55088 .08589 L
s
.54899 .16411 m
.55101 .13589 L
s
.54883 .21409 m
.55117 .18591 L
s
.54859 .26407 m
.55141 .23593 L
s
.54825 .31403 m
.55175 .28597 L
s
.54768 .36395 m
.55232 .33605 L
s
.54657 .41372 m
.55343 .38628 L
s
.54368 .46265 m
.55632 .43735 L
s
.53586 .5 m
.56414 .5 L
s
.54368 .53735 m
.55632 .56265 L
s
.54657 .58628 m
.55343 .61372 L
s
.54768 .63605 m
.55232 .66395 L
s
.54825 .68597 m
.55175 .71403 L
s
.54859 .73593 m
.55141 .76407 L
s
.54883 .78591 m
.55117 .81409 L
s
.54899 .83589 m
.55101 .86411 L
s
.54912 .88589 m
.55088 .91411 L
s
.54922 .93588 m
.55078 .96412 L
s
.54929 .98588 m
0 0 rlineto s
.54929 .98588 m
.55 1 L
s
.59859 .01407 m
0 0 rlineto s
.59859 .01407 m
.6 0 L
s
.59844 .06406 m
.60156 .03594 L
s
.59825 .11403 m
.60175 .08597 L
s
.598 .164 m
.602 .136 L
s
.59768 .21395 m
.60232 .18605 L
s
.59723 .26387 m
.60277 .23613 L
s
.59657 .31372 m
.60343 .28628 L
s
.59553 .36342 m
.60447 .33658 L
s
.59368 .41265 m
.60632 .38735 L
s
.59 .46 m
.61 .44 L
s
.58586 .5 m
.61414 .5 L
s
.59 .54 m
.61 .56 L
s
.59368 .58735 m
.60632 .61265 L
s
.59553 .63658 m
.60447 .66342 L
s
.59657 .68628 m
.60343 .71372 L
s
.59723 .73613 m
.60277 .76387 L
s
.59768 .78605 m
.60232 .81395 L
s
.598 .836 m
.602 .864 L
s
.59825 .88597 m
.60175 .91403 L
s
.59844 .93594 m
.60156 .96406 L
s
.59859 .98593 m
0 0 rlineto s
.59859 .98593 m
.6 1 L
s
.6479 .01399 m
0 0 rlineto s
.6479 .01399 m
.65 0 L
s
.64768 .06395 m
.65232 .03605 L
s
.64739 .1139 m
.65261 .0861 L
s
.64704 .16383 m
.65296 .13617 L
s
.64657 .21372 m
.65343 .18628 L
s
.64594 .26355 m
.65406 .23645 L
s
.64503 .31324 m
.65497 .28676 L
s
.64368 .36265 m
.65632 .33735 L
s
.64151 .41131 m
.65849 .38869 L
s
.63823 .45784 m
.66177 .44216 L
s
.63586 .5 m
.66414 .5 L
s
.63823 .54216 m
.66177 .55784 L
s
.64151 .58869 m
.65849 .61131 L
s
.64368 .63735 m
.65632 .66265 L
s
.64503 .68676 m
.65497 .71324 L
s
.64594 .73645 m
.65406 .76355 L
s
.64657 .78628 m
.65343 .81372 L
s
.64704 .83617 m
.65296 .86383 L
s
.64739 .8861 m
.65261 .9139 L
s
.64768 .93605 m
.65232 .96395 L
s
.6479 .98601 m
0 0 rlineto s
.6479 .98601 m
.65 1 L
s
.69723 .01387 m
0 0 rlineto s
.69723 .01387 m
.7 0 L
s
.69693 .06381 m
.70307 .03619 L
s
.69657 .11372 m
.70343 .08628 L
s
.69611 .1636 m
.70389 .1364 L
s
.69553 .21342 m
.70447 .18658 L
s
.69475 .26313 m
.70525 .23687 L
s
.69368 .31265 m
.70632 .28735 L
s
.69216 .36177 m
.70784 .33823 L
s
.69 .41 m
.71 .39 L
s
.68735 .45632 m
.71265 .44368 L
s
.68586 .5 m
.71414 .5 L
s
.68735 .54368 m
.71265 .55632 L
s
.69 .59 m
.71 .61 L
s
.69216 .63823 m
.70784 .66177 L
s
.69368 .68735 m
.70632 .71265 L
s
.69475 .73687 m
.70525 .76313 L
s
.69553 .78658 m
.70447 .81342 L
s
.69611 .8364 m
.70389 .8636 L
s
.69657 .88628 m
.70343 .91372 L
s
.69693 .93619 m
.70307 .96381 L
s
.69723 .98613 m
0 0 rlineto s
.69723 .98613 m
.7 1 L
s
.74657 .01372 m
0 0 rlineto s
.74657 .01372 m
.75 0 L
s
.74621 .06363 m
.75379 .03637 L
s
.74578 .1135 m
.75422 .0865 L
s
.74524 .16332 m
.75476 .13668 L
s
.74456 .21305 m
.75544 .18695 L
s
.74368 .26265 m
.75632 .23735 L
s
.7425 .31199 m
.7575 .28801 L
s
.74095 .36086 m
.75905 .33914 L
s
.73896 .40883 m
.76104 .39117 L
s
.73687 .45525 m
.76313 .44475 L
s
.73586 .5 m
.76414 .5 L
s
.73687 .54475 m
.76313 .55525 L
s
.73896 .59117 m
.76104 .60883 L
s
.74095 .63914 m
.75905 .66086 L
s
.7425 .68801 m
.7575 .71199 L
s
.74368 .73735 m
.75632 .76265 L
s
.74456 .78695 m
.75544 .81305 L
s
.74524 .83668 m
.75476 .86332 L
s
.74578 .8865 m
.75422 .9135 L
s
.74621 .93637 m
.75379 .96363 L
s
.74657 .98628 m
0 0 rlineto s
.74657 .98628 m
.75 1 L
s
.79594 .01355 m
0 0 rlineto s
.79594 .01355 m
.8 0 L
s
.79553 .06342 m
.80447 .03658 L
s
.79503 .11324 m
.80497 .08676 L
s
.79443 .163 m
.80557 .137 L
s
.79368 .21265 m
.80632 .18735 L
s
.79272 .26213 m
.80728 .23787 L
s
.79151 .31131 m
.80849 .28869 L
s
.79 .36 m
.81 .34 L
s
.78823 .40784 m
.81177 .39216 L
s
.78658 .45447 m
.81342 .44553 L
s
.78586 .5 m
.81414 .5 L
s
.78658 .54553 m
.81342 .55447 L
s
.78823 .59216 m
.81177 .60784 L
s
.79 .64 m
.81 .66 L
s
.79151 .68869 m
.80849 .71131 L
s
.79272 .73787 m
.80728 .76213 L
s
.79368 .78735 m
.80632 .81265 L
s
.79443 .837 m
.80557 .863 L
s
.79503 .88676 m
.80497 .91324 L
s
.79553 .93658 m
.80447 .96342 L
s
.79594 .98645 m
0 0 rlineto s
.79594 .98645 m
.8 1 L
s
.84533 .01335 m
0 0 rlineto s
.84533 .01335 m
.85 0 L
s
.84487 .06318 m
.85513 .03682 L
s
.84433 .11296 m
.85567 .08704 L
s
.84368 .16265 m
.85632 .13735 L
s
.84287 .21222 m
.85713 .18778 L
s
.84189 .26159 m
.85811 .23841 L
s
.84069 .31064 m
.85931 .28936 L
s
.83926 .3592 m
.86074 .3408 L
s
.83772 .40702 m
.86228 .39298 L
s
.8364 .45389 m
.8636 .44611 L
s
.83586 .5 m
.86414 .5 L
s
.8364 .54611 m
.8636 .55389 L
s
.83772 .59298 m
.86228 .60702 L
s
.83926 .6408 m
.86074 .6592 L
s
.84069 .68936 m
.85931 .71064 L
s
.84189 .73841 m
.85811 .76159 L
s
.84287 .78778 m
.85713 .81222 L
s
.84368 .83735 m
.85632 .86265 L
s
.84433 .88704 m
.85567 .91296 L
s
.84487 .93682 m
.85513 .96318 L
s
.84533 .98665 m
0 0 rlineto s
.84533 .98665 m
.85 1 L
s
.89475 .01313 m
0 0 rlineto s
.89475 .01313 m
.9 0 L
s
.89426 .06292 m
.90574 .03708 L
s
.89368 .11265 m
.90632 .08735 L
s
.89298 .16228 m
.90702 .13772 L
s
.89216 .21177 m
.90784 .18823 L
s
.89117 .26104 m
.90883 .23896 L
s
.89 .31 m
.91 .29 L
s
.88869 .35849 m
.91131 .34151 L
s
.88735 .40632 m
.91265 .39368 L
s
.88628 .45343 m
.91372 .44657 L
s
.88586 .5 m
.91414 .5 L
s
.88628 .54657 m
.91372 .55343 L
s
.88735 .59368 m
.91265 .60632 L
s
.88869 .64151 m
.91131 .65849 L
s
.89 .69 m
.91 .71 L
s
.89117 .73896 m
.90883 .76104 L
s
.89216 .78823 m
.90784 .81177 L
s
.89298 .83772 m
.90702 .86228 L
s
.89368 .88735 m
.90632 .91265 L
s
.89426 .93708 m
.90574 .96292 L
s
.89475 .98687 m
0 0 rlineto s
.89475 .98687 m
.9 1 L
s
.9442 .0129 m
0 0 rlineto s
.9442 .0129 m
.95 0 L
s
.94368 .06265 m
.95632 .03735 L
s
.94307 .11233 m
.95693 .08767 L
s
.94235 .1619 m
.95765 .1381 L
s
.94151 .21131 m
.95849 .18869 L
s
.94054 .26051 m
.95946 .23949 L
s
.93943 .3094 m
.96057 .2906 L
s
.93823 .35784 m
.96177 .34216 L
s
.93708 .40574 m
.96292 .39426 L
s
.93619 .45307 m
.96381 .44693 L
s
.93586 .5 m
.96414 .5 L
s
.93619 .54693 m
.96381 .55307 L
s
.93708 .59426 m
.96292 .60574 L
s
.93823 .64216 m
.96177 .65784 L
s
.93943 .6906 m
.96057 .7094 L
s
.94054 .73949 m
.95946 .76051 L
s
.94151 .78869 m
.95849 .81131 L
s
.94235 .8381 m
.95765 .8619 L
s
.94307 .88767 m
.95693 .91233 L
s
.94368 .93735 m
.95632 .96265 L
s
.9442 .9871 m
0 0 rlineto s
.9442 .9871 m
.95 1 L
s
.99368 .01265 m
0 0 rlineto s
.99368 .01265 m
1 0 L
s
.99313 .06236 m
0 0 rlineto s
.99313 .06236 m
1 .05 L
s
.9925 .11199 m
0 0 rlineto s
.9925 .11199 m
1 .1 L
s
.99178 .16151 m
0 0 rlineto s
.99178 .16151 m
1 .15 L
s
.99095 .21086 m
0 0 rlineto s
.99095 .21086 m
1 .2 L
s
.99 .26 m
0 0 rlineto s
.99 .26 m
1 .25 L
s
.98896 .30883 m
0 0 rlineto s
.98896 .30883 m
1 .3 L
s
.98787 .35728 m
0 0 rlineto s
.98787 .35728 m
1 .35 L
s
.98687 .40525 m
0 0 rlineto s
.98687 .40525 m
1 .4 L
s
.98613 .45277 m
0 0 rlineto s
.98613 .45277 m
1 .45 L
s
.98586 .5 m
0 0 rlineto s
.98586 .5 m
1 .5 L
s
.98613 .54723 m
0 0 rlineto s
.98613 .54723 m
1 .55 L
s
.98687 .59475 m
0 0 rlineto s
.98687 .59475 m
1 .6 L
s
.98787 .64272 m
0 0 rlineto s
.98787 .64272 m
1 .65 L
s
.98896 .69117 m
0 0 rlineto s
.98896 .69117 m
1 .7 L
s
.99 .74 m
0 0 rlineto s
.99 .74 m
1 .75 L
s
.99095 .78914 m
0 0 rlineto s
.99095 .78914 m
1 .8 L
s
.99178 .83849 m
0 0 rlineto s
.99178 .83849 m
1 .85 L
s
.9925 .88801 m
0 0 rlineto s
.9925 .88801 m
1 .9 L
s
.99313 .93764 m
0 0 rlineto s
.99313 .93764 m
1 .95 L
s
.99368 .98735 m
0 0 rlineto s
.99368 .98735 m
1 1 L
s
.871 .722 .529 r
.005 w
.5 1 m
.5 .95833 L
.5 .91667 L
.5 .875 L
.5 .83333 L
.5 .79167 L
.5 .75 L
.5 .70833 L
.5 .66667 L
.5 .625 L
.5 .58333 L
.5 .54167 L
.5 .5 L
.5 .45833 L
.5 .41667 L
.5 .375 L
.5 .33333 L
.5 .29167 L
.5 .25 L
.5 .20833 L
.5 .16667 L
.5 .125 L
.5 .08333 L
.5 .04167 L
.5 0 L
s
.274 .51 .706 r
0 .5 m
.04167 .5 L
.08333 .5 L
.125 .5 L
.16667 .5 L
.20833 .5 L
.25 .5 L
.29167 .5 L
.33333 .5 L
.375 .5 L
.41667 .5 L
.45833 .5 L
.5 .5 L
.54167 .5 L
.58333 .5 L
.625 .5 L
.66667 .5 L
.70833 .5 L
.75 .5 L
.79167 .5 L
.83333 .5 L
.875 .5 L
.91667 .5 L
.95833 .5 L
1 .5 L
s
.89 .09 .05 r
.49998 .5 m
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49992 .5 L
.4999 .5 L
.49988 .5 L
.49985 .5 L
.49982 .5 L
.49973 .5 L
.49967 .5 L
.49959 .5 L
.49949 .5 L
.49937 .5 L
.49906 .5 L
.49885 .5 L
.49857 .5 L
.49822 .5 L
.49781 .5 L
.4967 .50001 L
.49597 .50001 L
.49498 .50002 L
.49384 .50003 L
.49228 .50005 L
.48831 .50011 L
.48566 .50016 L
.48213 .50026 L
.478 .50039 L
.47241 .50061 L
.45808 .50141 L
.44841 .50213 L
.43567 .50331 L
.40438 .50731 L
.38284 .51098 L
.35415 .51702 L
.32073 .52571 L
.27534 .54038 L
.22528 .56038 L
.15942 .5928 L
s
.15942 .5928 m
0 .70005 L
s
.49998 .5 m
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.49992 .5 L
.4999 .5 L
.49984 .5 L
.4998 .5 L
.49976 .5 L
.49963 .5 L
.49955 .5 L
.49943 .5 L
.4993 .5 L
.49912 .5 L
.49865 .5 L
.49833 .5 L
.49791 .50001 L
.49737 .50001 L
.49673 .50001 L
.49505 .50003 L
.49387 .50005 L
.49231 .50007 L
.48844 .50017 L
.48575 .50025 L
.48215 .5004 L
.47758 .50063 L
.47217 .50097 L
.45798 .50221 L
.44804 .50338 L
.43488 .5053 L
.4023 .51193 L
.37972 .51808 L
.34951 .52831 L
.31413 .54318 L
.26584 .56854 L
.21232 .60345 L
.14156 .6606 L
s
.14156 .6606 m
0 .81343 L
s
.49999 .5 m
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.49992 .5 L
.49987 .5 L
.49984 .5 L
.4998 .5 L
.4997 .5 L
.49963 .5 L
.49953 .5 L
.49941 .5 L
.49926 .5 L
.49888 .5 L
.4986 .5 L
.49824 .50001 L
.49777 .50001 L
.49721 .50002 L
.49573 .50004 L
.49468 .50006 L
.49328 .5001 L
.48978 .50023 L
.48732 .50036 L
.48402 .50057 L
.4798 .50091 L
.47477 .50141 L
.46147 .5033 L
.45206 .50511 L
.43954 .50812 L
.40825 .51871 L
.38638 .52869 L
.35694 .54548 L
.32149 .57081 L
.27463 .61287 L
.22375 .66958 L
.15665 .76198 L
s
.15665 .76198 m
.03044 1 L
s
.49999 .5 m
.49999 .5 L
.49999 .5 L
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49992 .5 L
.4999 .5 L
.49987 .5 L
.4998 .5 L
.49975 .5 L
.49969 .5 L
.49961 .5 L
.49951 .5 L
.49925 .5 L
.49907 .5 L
.49882 .50001 L
.49851 .50001 L
.49814 .50002 L
.49715 .50004 L
.49645 .50006 L
.49552 .5001 L
.49319 .50023 L
.49155 .50036 L
.48935 .50057 L
.48653 .50091 L
.48318 .50141 L
.47431 .5033 L
.46804 .50511 L
.45969 .50812 L
.43883 .51871 L
.42425 .52869 L
.40463 .54548 L
.38099 .57081 L
.34975 .61287 L
.31583 .66958 L
.2711 .76198 L
s
.2711 .76198 m
.18696 1 L
s
.5 .5 m
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.4999 .5 L
.49988 .5 L
.49984 .5 L
.4998 .5 L
.49975 .5 L
.49963 .5 L
.49953 .5 L
.49941 .50001 L
.49926 .50001 L
.49907 .50002 L
.49858 .50004 L
.49823 .50006 L
.49776 .5001 L
.49659 .50023 L
.49577 .50036 L
.49467 .50057 L
.49327 .50091 L
.49159 .50141 L
.48716 .5033 L
.48402 .50511 L
.47985 .50812 L
.46942 .51871 L
.46213 .52869 L
.45231 .54548 L
.4405 .57081 L
.42488 .61287 L
.40792 .66958 L
.38555 .76198 L
s
.38555 .76198 m
.34348 1 L
s
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .50001 L
.5 .50002 L
.5 .50004 L
.5 .50009 L
.5 .50022 L
.5 .50052 L
.5 .50121 L
.5 .50296 L
.5 .50704 L
.5 .51764 L
.5 .54275 L
.5 .60021 L
.5 .74794 L
s
.5 .74794 m
.5 1 L
s
.5 .5 m
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.5001 .5 L
.50012 .5 L
.50016 .5 L
.5002 .5 L
.50025 .5 L
.50037 .5 L
.50047 .5 L
.50059 .50001 L
.50074 .50001 L
.50093 .50002 L
.50142 .50004 L
.50177 .50006 L
.50224 .5001 L
.50341 .50023 L
.50423 .50036 L
.50533 .50057 L
.50673 .50091 L
.50841 .50141 L
.51284 .5033 L
.51598 .50511 L
.52015 .50812 L
.53058 .51871 L
.53787 .52869 L
.54769 .54548 L
.5595 .57081 L
.57512 .61287 L
.59208 .66958 L
.61445 .76198 L
s
.61445 .76198 m
.65652 1 L
s
.50001 .5 m
.50001 .5 L
.50001 .5 L
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50008 .5 L
.5001 .5 L
.50013 .5 L
.5002 .5 L
.50025 .5 L
.50031 .5 L
.50039 .5 L
.50049 .5 L
.50075 .5 L
.50093 .5 L
.50118 .50001 L
.50149 .50001 L
.50186 .50002 L
.50285 .50004 L
.50355 .50006 L
.50448 .5001 L
.50681 .50023 L
.50845 .50036 L
.51065 .50057 L
.51347 .50091 L
.51682 .50141 L
.52569 .5033 L
.53196 .50511 L
.54031 .50812 L
.56117 .51871 L
.57575 .52869 L
.59537 .54548 L
.61901 .57081 L
.65025 .61287 L
.68417 .66958 L
.7289 .76198 L
s
.7289 .76198 m
.81304 1 L
s
.50001 .5 m
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.50008 .5 L
.50013 .5 L
.50016 .5 L
.5002 .5 L
.5003 .5 L
.50037 .5 L
.50047 .5 L
.50059 .5 L
.50074 .5 L
.50112 .5 L
.5014 .5 L
.50176 .50001 L
.50223 .50001 L
.50279 .50002 L
.50427 .50004 L
.50532 .50006 L
.50672 .5001 L
.51022 .50023 L
.51268 .50036 L
.51598 .50057 L
.5202 .50091 L
.52523 .50141 L
.53853 .5033 L
.54794 .50511 L
.56046 .50812 L
.59175 .51871 L
.61362 .52869 L
.64306 .54548 L
.67851 .57081 L
.72537 .61287 L
.77625 .66958 L
.84335 .76198 L
s
.84335 .76198 m
.96956 1 L
s
.50002 .5 m
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.50008 .5 L
.5001 .5 L
.50016 .5 L
.5002 .5 L
.50024 .5 L
.50037 .5 L
.50045 .5 L
.50057 .5 L
.5007 .5 L
.50088 .5 L
.50135 .5 L
.50167 .5 L
.50209 .50001 L
.50263 .50001 L
.50327 .50001 L
.50495 .50003 L
.50613 .50005 L
.50769 .50007 L
.51156 .50017 L
.51425 .50025 L
.51785 .5004 L
.52242 .50063 L
.52783 .50097 L
.54202 .50221 L
.55196 .50338 L
.56512 .5053 L
.5977 .51193 L
.62028 .51808 L
.65049 .52831 L
.68587 .54318 L
.73416 .56854 L
.78768 .60345 L
.85844 .6606 L
s
.85844 .6606 m
1 .81343 L
s
.50002 .5 m
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50008 .5 L
.5001 .5 L
.50012 .5 L
.50015 .5 L
.50018 .5 L
.50027 .5 L
.50033 .5 L
.50041 .5 L
.50051 .5 L
.50063 .5 L
.50094 .5 L
.50115 .5 L
.50143 .5 L
.50178 .5 L
.50219 .5 L
.5033 .50001 L
.50403 .50001 L
.50502 .50002 L
.50616 .50003 L
.50772 .50005 L
.51169 .50011 L
.51434 .50016 L
.51787 .50026 L
.522 .50039 L
.52759 .50061 L
.54192 .50141 L
.55159 .50213 L
.56433 .50331 L
.59562 .50731 L
.61716 .51098 L
.64585 .51702 L
.67927 .52571 L
.72466 .54038 L
.77472 .56038 L
.84058 .5928 L
s
.84058 .5928 m
1 .70005 L
s
.49998 .5 m
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49992 .5 L
.4999 .5 L
.49988 .5 L
.49985 .5 L
.49982 .5 L
.49973 .5 L
.49967 .5 L
.49959 .5 L
.49949 .5 L
.49937 .5 L
.49906 .5 L
.49885 .5 L
.49857 .5 L
.49822 .5 L
.49781 .5 L
.4967 .49999 L
.49597 .49999 L
.49498 .49998 L
.49384 .49997 L
.49228 .49995 L
.48831 .49989 L
.48566 .49984 L
.48213 .49974 L
.478 .49961 L
.47241 .49939 L
.45808 .49859 L
.44841 .49787 L
.43567 .49669 L
.40438 .49269 L
.38284 .48902 L
.35415 .48298 L
.32073 .47429 L
.27534 .45962 L
.22528 .43962 L
.15942 .4072 L
s
.15942 .4072 m
0 .29995 L
s
.49998 .5 m
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.49992 .5 L
.4999 .5 L
.49984 .5 L
.4998 .5 L
.49976 .5 L
.49963 .5 L
.49955 .5 L
.49943 .5 L
.4993 .5 L
.49912 .5 L
.49865 .5 L
.49833 .5 L
.49791 .49999 L
.49737 .49999 L
.49673 .49999 L
.49505 .49997 L
.49387 .49995 L
.49231 .49993 L
.48844 .49983 L
.48575 .49975 L
.48215 .4996 L
.47758 .49937 L
.47217 .49903 L
.45798 .49779 L
.44804 .49662 L
.43488 .4947 L
.4023 .48807 L
.37972 .48192 L
.34951 .47169 L
.31413 .45682 L
.26584 .43146 L
.21232 .39655 L
.14156 .3394 L
s
.14156 .3394 m
0 .18657 L
s
.49999 .5 m
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.49992 .5 L
.49987 .5 L
.49984 .5 L
.4998 .5 L
.4997 .5 L
.49963 .5 L
.49953 .5 L
.49941 .5 L
.49926 .5 L
.49888 .5 L
.4986 .5 L
.49824 .49999 L
.49777 .49999 L
.49721 .49998 L
.49573 .49996 L
.49468 .49994 L
.49328 .4999 L
.48978 .49977 L
.48732 .49964 L
.48402 .49943 L
.4798 .49909 L
.47477 .49859 L
.46147 .4967 L
.45206 .49489 L
.43954 .49188 L
.40825 .48129 L
.38638 .47131 L
.35694 .45452 L
.32149 .42919 L
.27463 .38713 L
.22375 .33042 L
.15665 .23802 L
s
.15665 .23802 m
.03044 0 L
s
.49999 .5 m
.49999 .5 L
.49999 .5 L
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49992 .5 L
.4999 .5 L
.49987 .5 L
.4998 .5 L
.49975 .5 L
.49969 .5 L
.49961 .5 L
.49951 .5 L
.49925 .5 L
.49907 .5 L
.49882 .49999 L
.49851 .49999 L
.49814 .49998 L
.49715 .49996 L
.49645 .49994 L
.49552 .4999 L
.49319 .49977 L
.49155 .49964 L
.48935 .49943 L
.48653 .49909 L
.48318 .49859 L
.47431 .4967 L
.46804 .49489 L
.45969 .49188 L
.43883 .48129 L
.42425 .47131 L
.40463 .45452 L
.38099 .42919 L
.34975 .38713 L
.31583 .33042 L
.2711 .23802 L
s
.2711 .23802 m
.18696 0 L
s
.5 .5 m
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49999 .5 L
.49998 .5 L
.49998 .5 L
.49997 .5 L
.49996 .5 L
.49995 .5 L
.49993 .5 L
.4999 .5 L
.49988 .5 L
.49984 .5 L
.4998 .5 L
.49975 .5 L
.49963 .5 L
.49953 .5 L
.49941 .49999 L
.49926 .49999 L
.49907 .49998 L
.49858 .49996 L
.49823 .49994 L
.49776 .4999 L
.49659 .49977 L
.49577 .49964 L
.49467 .49943 L
.49327 .49909 L
.49159 .49859 L
.48716 .4967 L
.48402 .49489 L
.47985 .49188 L
.46942 .48129 L
.46213 .47131 L
.45231 .45452 L
.4405 .42919 L
.42488 .38713 L
.40792 .33042 L
.38555 .23802 L
s
.38555 .23802 m
.34348 0 L
s
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .49999 L
.5 .49998 L
.5 .49996 L
.5 .49991 L
.5 .49978 L
.5 .49948 L
.5 .49879 L
.5 .49704 L
.5 .49296 L
.5 .48236 L
.5 .45725 L
.5 .39979 L
.5 .25206 L
s
.5 .25206 m
.5 0 L
s
.5 .5 m
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50001 .5 L
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.5001 .5 L
.50012 .5 L
.50016 .5 L
.5002 .5 L
.50025 .5 L
.50037 .5 L
.50047 .5 L
.50059 .49999 L
.50074 .49999 L
.50093 .49998 L
.50142 .49996 L
.50177 .49994 L
.50224 .4999 L
.50341 .49977 L
.50423 .49964 L
.50533 .49943 L
.50673 .49909 L
.50841 .49859 L
.51284 .4967 L
.51598 .49489 L
.52015 .49188 L
.53058 .48129 L
.53787 .47131 L
.54769 .45452 L
.5595 .42919 L
.57512 .38713 L
.59208 .33042 L
.61445 .23802 L
s
.61445 .23802 m
.65652 0 L
s
.50001 .5 m
.50001 .5 L
.50001 .5 L
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50008 .5 L
.5001 .5 L
.50013 .5 L
.5002 .5 L
.50025 .5 L
.50031 .5 L
.50039 .5 L
.50049 .5 L
.50075 .5 L
.50093 .5 L
.50118 .49999 L
.50149 .49999 L
.50186 .49998 L
.50285 .49996 L
.50355 .49994 L
.50448 .4999 L
.50681 .49977 L
.50845 .49964 L
.51065 .49943 L
.51347 .49909 L
.51682 .49859 L
.52569 .4967 L
.53196 .49489 L
.54031 .49188 L
.56117 .48129 L
.57575 .47131 L
.59537 .45452 L
.61901 .42919 L
.65025 .38713 L
.68417 .33042 L
.7289 .23802 L
s
.7289 .23802 m
.81304 0 L
s
.50001 .5 m
.50002 .5 L
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.50008 .5 L
.50013 .5 L
.50016 .5 L
.5002 .5 L
.5003 .5 L
.50037 .5 L
.50047 .5 L
.50059 .5 L
.50074 .5 L
.50112 .5 L
.5014 .5 L
.50176 .49999 L
.50223 .49999 L
.50279 .49998 L
.50427 .49996 L
.50532 .49994 L
.50672 .4999 L
.51022 .49977 L
.51268 .49964 L
.51598 .49943 L
.5202 .49909 L
.52523 .49859 L
.53853 .4967 L
.54794 .49489 L
.56046 .49188 L
.59175 .48129 L
.61362 .47131 L
.64306 .45452 L
.67851 .42919 L
.72537 .38713 L
.77625 .33042 L
.84335 .23802 L
s
.84335 .23802 m
.96956 0 L
s
.50002 .5 m
.50002 .5 L
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50007 .5 L
.50008 .5 L
.5001 .5 L
.50016 .5 L
.5002 .5 L
.50024 .5 L
.50037 .5 L
.50045 .5 L
.50057 .5 L
.5007 .5 L
.50088 .5 L
.50135 .5 L
.50167 .5 L
.50209 .49999 L
.50263 .49999 L
.50327 .49999 L
.50495 .49997 L
.50613 .49995 L
.50769 .49993 L
.51156 .49983 L
.51425 .49975 L
.51785 .4996 L
.52242 .49937 L
.52783 .49903 L
.54202 .49779 L
.55196 .49662 L
.56512 .4947 L
.5977 .48807 L
.62028 .48192 L
.65049 .47169 L
.68587 .45682 L
.73416 .43146 L
.78768 .39655 L
.85844 .3394 L
s
.85844 .3394 m
1 .18657 L
s
.50002 .5 m
.50003 .5 L
.50003 .5 L
.50004 .5 L
.50005 .5 L
.50008 .5 L
.5001 .5 L
.50012 .5 L
.50015 .5 L
.50018 .5 L
.50027 .5 L
.50033 .5 L
.50041 .5 L
.50051 .5 L
.50063 .5 L
.50094 .5 L
.50115 .5 L
.50143 .5 L
.50178 .5 L
.50219 .5 L
.5033 .49999 L
.50403 .49999 L
.50502 .49998 L
.50616 .49997 L
.50772 .49995 L
.51169 .49989 L
.51434 .49984 L
.51787 .49974 L
.522 .49961 L
.52759 .49939 L
.54192 .49859 L
.55159 .49787 L
.56433 .49669 L
.59562 .49269 L
.61716 .48902 L
.64585 .48298 L
.67927 .47429 L
.72466 .45962 L
.77472 .43962 L
.84058 .4072 L
s
.84058 .4072 m
1 .29995 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00;?ooool3o`00037ooooo1Ol0000aooooo`;o0000
<_ooool5o`0003?ooooo0ol0000Kooooo`00;Oooool00ol0003oooooooooo`0aooooo`04o`000?oo
ooooooooo`00033ooooo00Co0000oooooooooooo0000<_ooool01?l0003oooooooooool0000doooo
o`03o`000?oooooooooo01[ooooo000Tooooo`Go000000?oooooo`000?l000000ol0000[ooooo`Go
00000oooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0003?ooooo00?o0000oooo
ooooool0<Oooool5o`0001_ooooo000Zooooo`04o`000?ooooooooooo`0003Gooooo00?o0000oooo
ooooool0;oooool01?l0003oooooooooool0000dooooo`03o`000?oooooooooo033ooooo00Co0000
oooooooooooo00007?ooool002_ooooo00?o0000ooooool00000<_ooool01Ol0003ooooooooooooo
oooo0000033ooooo00Co0000oooooooooooo0000<Oooool01Ol0003ooooooooooooooooo000003;o
oooo00?o0000ooooool000007?ooool002cooooo0_l0000booooo`05o`000?ooooooooooooooool0
0000<?ooool01?l0003oooooooooool0000aooooo`05o`000?ooooooooooooooool00000<oooool2
o`0001cooooo000]ooooo`03o`000?oooooooooo037ooooo0ol0000booooo`;o0000<oooool3o`00
03Gooooo00?o0000ooooooooool06_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000kooooo00?o0000o`:XW_l000001_l000000ooS5`co0000o`000002o`00
0003o`:XW_l0003o000000_o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000007o`00
0004on<G3?l0003o0000o`:XWPgo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009
o`000003on<G3?l0003o0ZRN00co000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000H
o`000003o`:XW_l0003o000000_o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000on<G300;
o`000003o`:XW_l0003o000000_o000000?o0ZRNo`000?l000002_l000001Ol2Z9ko0000o`000?l0
003ohaL<00Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0
003o000000;o000000?ohaL<o`000?l000001Ol00001o`:XWP7ooooo000>ooooo`03o`000?l2Z9ko
000000Ko000000?ohaL<o`000?l000000_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o
000000_o000000?o0ZRNo`000?l000001ol000001?oS5`co0000o`000?l2Z9h=o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002Ol000000ooS5`co0000o`:XWP0<o`000003o`:XW_l0
003o000000_o000000?o0ZRNo`000?l000006?l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?oS5``02ol000000ol2Z9ko0000o`00000;o`000003o`:XW_l0
003o000000[o000000Go0ZRNo`000?l0003o0000on<G3009o`000003o`:XW_l0003o000000[o0000
00?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000002o`000003on<G3?l0003o000000Go0000
0Ol2Z9h1ooooo`003_ooool2o`000003o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ooS5`coc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI0Ol00001o`:XWP7ooooo
000>ooooo`;o000000?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<
i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G
3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`00
0?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:X
W_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@7o0ZRN0Ol00001ooooo`00
3_ooool2o`000003olcVfOl2Z9koc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00;o0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_l2Z9h0
3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN3?o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI0Ol2Z9h1o`00007ooooo000>ooooo`;o00002Oo<i]T00ooS5`coc>KIolcVf@0XolcVf@03on<G
3?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T09oo<i]T00ol0003oc>KIolcVf@0VolcVf@03on<G
3?o<i]Woc>KI02Ooc>KI00?ohaL<olcVfOo<i]T09oo<i]T00ooS5`coc>KIolcVf@06olcVf@;o0000
0Oooool000kooooo0_l0000:olcVf@03on<G3?o<i]Woc>KI02Ooc>KI00?ohaL<olcVfOo<i]T09_o<
i]T00ooS5`coc>KIolcVf@0WolcVf@03o`000?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T09oo<
i]T00ooS5`coc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI00Ooc>KI0_l00001ooooo`003_ooool2
o`0000[oc>KI00?ohaL<olcVfOo<i]T09oo<i]T00ooS5`coc>KIolcVf@0VolcVf@03on<G3?o<i]Wo
c>KI02Ooc>KI00?o0000olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0WolcVf@03on<G3?o<i]Wo
c>KI02Koc>KI00?ohaL<olcVfOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T00ooS
5`coc>KIolcVf@0WolcVf@03on<G3?o<i]Woc>KI02Goc>KI00?ohaL<olcVfOo<i]T09oo<i]T00ol0
003oc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T09_o<i]T00ooS
5`coc>KIolcVf@08olcVf@;o00000Oooool000kooooo0_l0000;olcVf@03on<G3?o<i]Woc>KI02Oo
c>KI00?ohaL<olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0VolcVf@03o`000?o<i]Woc>KI02Ko
c>KI00?ohaL<olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI00So
c>KI0_l00001ooooo`003_ooool2o`0000coc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T05oo<i]T00ooS5`coc>KI
olcVf@09olcVf@;o00000Oooool000kooooo0_l0000;olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00Woc>KI0_l0
0001ooooo`003_ooool2o`0000_oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9koc>KIolcVf@0<
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN2Oo<i]T2o`00007ooooo000>
ooooo`;o00003?o<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h:olcVf@;o00000Oooool000kooooo00?o0000
o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0;olcVf@7o00000Ol2Z9h1ooooo`003_ooool00ol0
003o0ZRNolcVf@0<olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI0Ol00001o`:XWP7ooooo000>oooo
o`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0<olcVf@7o0ZRN0Ol00001oooo
o`003_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T1o`:XWP7o
00000Oooool000kooooo0_l0000@olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00goc>KI0_l00001ooooo`003_oo
ool2o`00017oc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<
i]Woc>KI02Goc>KI00?o0000olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<
i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T03_o<i]T2o`00007ooooo000>ooooo`;o00004Oo<i]T0
0ooS5`coc>KIolcVf@0UolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T09?o<i]T0
0ol0003oc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T09?o<i]T0
0ooS5`coc>KIolcVf@0>olcVf@;o00000Oooool000kooooo0_l0000BolcVf@03on<G3?o<i]Woc>KI
02Coc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcVf@03o`000?o<i]Woc>KI
02Coc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0SolcVf@03on<G3?o<i]Woc>KI
00ooc>KI0_l00001ooooo`003_ooool2o`0001;oc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`co
c>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?o0000olcVfOo<i]T08oo<i]T00ooS5`co
c>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T03oo<i]T2o`00007o
oooo000>ooooo`;o00004oo<i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02?oc>KI
00?ohaL<olcVfOo<i]T09?o<i]T00ol0003oc>KIolcVf@0SolcVf@03on<G3?o<i]Woc>KI02Coc>KI
00?ohaL<olcVfOo<i]T08oo<i]T00ooS5`coc>KIolcVf@0@olcVf@;o00000Oooool000kooooo0_l0
000;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcV
f@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcV
fOoS5``:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KI
olcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`00007o
oooo0008ooooo`?o00000oooool2o`0000_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KI
olcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03
on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05
o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l0
0001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o00003?o<i]T00ol2Z9koc>KIolcVf@05
olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G
3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00007ooooo0005o`000003ooooool0
003o000000?o00000oooool2o`0000coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcV
fOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G
3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:X
W_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04
on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcV
f@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o00000Oooool0
00Kooooo00Co0000oooooooooooo00001?ooool00ol0003o0ZRNolcVf@0<olcVf@03o`:XW_o<i]Wo
c>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G
3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T1o`00007o0ZRN0Oooool000Oooooo00?o
0000ooooool000001?ooool00ol0003o0ZRNolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?o
haL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T1o`00007o0ZRN0Oooool000Sooooo0_l00004ooooo`;o000000?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOoS
5``02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<
i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcV
fOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcV
fOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0Ol2Z9h1o`00007ooooo0009oooo
o`03o`000?oooooooooo00;ooooo0_l000000oo<i]Wo0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP7o00000Oooool000kooooo0_l0000GolcVf@03on<G3?o<
i]Woc>KI02?oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03o`000?o<
i]Woc>KI02;oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03on<G3?o<
i]Woc>KI01Coc>KI0_l00001ooooo`003_ooool2o`0001Soc>KI00?ohaL<olcVfOo<i]T08_o<i]T0
0ooS5`coc>KIolcVf@0RolcVf@03on<G3?o<i]Woc>KI02;oc>KI00?o0000olcVfOo<i]T08Oo<i]T0
0ooS5`coc>KIolcVf@0RolcVf@03on<G3?o<i]Woc>KI02;oc>KI00?ohaL<olcVfOo<i]T05Oo<i]T2
o`00007ooooo000>ooooo`;o00006Oo<i]T00ooS5`coc>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI
02;oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ol0003oc>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI
02;oc>KI00?ohaL<olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@;o00000Oooool000ko
oooo0_l0000IolcVf@03on<G3?o<i]Woc>KI02;oc>KI00?ohaL<olcVfOo<i]T08Oo<i]T00ooS5`co
c>KIolcVf@0RolcVf@03o`000?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ooS5`co
c>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI01Koc>KI0_l00001ooooo`003_ooool2o`0001[oc>KI
00?ohaL<olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0RolcVf@03on<G3?o<i]Woc>KI027oc>KI
00?o0000olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI027oc>KI
00?ohaL<olcVfOo<i]T05oo<i]T2o`00007ooooo000>ooooo`;o00006_o<i]T00ooS5`coc>KIolcV
f@0QolcVf@03on<G3?o<i]Woc>KI00koc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0>olcVf@03on<G3?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T05oo<i]T2o`00007ooooo000>
ooooo`;o00002_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgo
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`00
007ooooo000>ooooo`;o00002oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G
30[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KI
o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Wo
c>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<
i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00007ooooo000>ooooo`03o`000?l2
Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0Ol00001o`:XWP7ooooo000>ooooo`03o`000?l2Z9koc>KI00co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0Ol00001o`:XWP7ooooo000>ooooo`;o000000?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T1o`:XWP7o00000Oooool000kooooo0_l000000oo<i]Wo0ZRNolcVf@0<olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_l0003o0000007ooooo000>ooooo`;o00007?o<i]T00ol2Z9koc>KIon<G300:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS
5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:X
WP0KolcVf@;o00000Oooool000kooooo0_l0000OolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<
olcVfOo<i]T08?o<i]T00ooS5`coc>KIolcVf@0PolcVf@03o`000?o<i]Woc>KI01ooc>KI00?ohaL<
olcVfOo<i]T08?o<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01coc>KI0_l00001
ooooo`003_ooool2o`0001ooc>KI00?ohaL<olcVfOo<i]T08?o<i]T00ooS5`coc>KIolcVf@0PolcV
f@03on<G3?o<i]Woc>KI01ooc>KI00?o0000olcVfOo<i]T07oo<i]T00ooS5`coc>KIolcVf@0PolcV
f@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07?o<i]T2o`00007ooooo000>ooooo`;o
00008?o<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI023oc>KI00?ohaL<olcVfOo<
i]T07oo<i]T00ol0003oc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<
i]T07oo<i]T00ooS5`coc>KIolcVf@0MolcVf@;o00000Oooool000kooooo0_l0000PolcVf@03on<G
3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T08?o<i]T00ooS5`coc>KIolcVf@0OolcVf@03o`00
0?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07oo<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G
3?o<i]Woc>KI01goc>KI0_l00001ooooo`003_ooool2o`00027oc>KI00?ohaL<olcVfOo<i]T07oo<
i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?o0000olcVfOo<i]T07oo<
i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07_o<
i]T2o`00007ooooo000>ooooo`03o`000?oS5`coc>KI023oc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOoS5``02oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``08?o<i]T1o`00007ohaL<0Ooo
ool000kooooo00?o0000on<G3?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?o
haL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
haL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@7o00000OoS5``1ooooo`003_oo
ool2o`000003on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@07olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@7ohaL<
0Ol00001ooooo`003_ooool2o`000003olcVfOoS5`coc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KI
olcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`co
0000o`000001ooooo`003_ooool01Ol0003o0ZRNolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2
Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T0
1?oS5`coc>KIo`000?l2Z9h1ooooo`003_ooool00ol0003o0ZRNolcVf@02olcVf@03on<G3?o<i]Wo
c>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@03on<G3?o<i]Wo
c>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
haL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo
0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIo`000?l2Z9h0
0Oooool000kooooo0_l000001Ol2Z9koc>KIo`:XW_o<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9ko
c>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS
5`coc>KIolcVf@02o`:XWP7o00000Oooool000kooooo0_l000000oo<i]Wo0ZRNolcVf@02olcVf@03
on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03
on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03
on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03
on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<
00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h00_l00001ooooo`003_ooool2o`0000Koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS
5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS
5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T00oo<i]T2o`00
007ooooo000>ooooo`;o00001oo<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01go
c>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0MolcVf@03o`000?o<i]Woc>KI01go
c>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01co
c>KI00?ohaL<olcVfOo<i]T01?o<i]T2o`00007ooooo000>ooooo`;o00002?o<i]T00ooS5`coc>KI
olcVf@0LolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KI
olcVf@0MolcVf@03o`000?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KI
olcVf@0LolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2o`00007ooooo
000>ooooo`;o00002Oo<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o
haL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03o`000?o<i]Woc>KI01goc>KI00?o
haL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?o
haL<olcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o00002Oo<i]T00ooS5`coc>KIolcVf@0L
olcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0L
olcVf@03o`000?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0L
olcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T01_o<i]T2o`00007ooooo000>oooo
o`;o00002_o<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcV
fOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0LolcVf@03o`000?o<i]Woc>KI01coc>KI00?ohaL<olcV
fOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcV
fOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<
i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00Soc>KI
0_l00001ooooo`003_ooool2o`0000[oc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo
0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP09olcVf@;o00000Oooool0
00kooooo0_l0000;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04
olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08
olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h02_o<i]T2o`00007ooooo000>ooooo`03o`00
0?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:X
W_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Co
c>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0;olcVf@7o00000Ol2Z9h1ooooo`003_ooool2o`00
0003o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00go
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0<olcVf@7o00000Ol2Z9h1ooooo`00
3_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0
003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI0Ol2Z9h1o`00007ooooo000>
ooooo`;o00000_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``8olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS
5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<
i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNo`00
0?l000000Oooool000kooooo0_l0000BolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<
i]T01_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2
Z9h03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI00ooc>KI0_l00001oooo
o`003_ooool2o`0001;oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0JolcVf@03
on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ol0003oc>KIolcVf@0JolcVf@03
on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0IolcVf@03
on<G3?o<i]Woc>KI00ooc>KI0_l00001ooooo`003_ooool2o`0001?oc>KI00?ohaL<olcVfOo<i]T0
6Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T0
6_o<i]T00ol0003oc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T0
6_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI013oc>KI0_l00001ooooo`003_oo
ool2o`0001Coc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<
i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ol0003oc>KIolcVf@0JolcVf@03on<G3?o<
i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<
i]Woc>KI017oc>KI0_l00001ooooo`003_ooool2o`0001Goc>KI00?ohaL<olcVfOo<i]T06Oo<i]T0
0ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T0
0ol0003oc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T0
0ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01;oc>KI0_l00001ooooo`003_ooool2o`00
01Koc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI
01[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ol0003oc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI
01Woc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI
01?oc>KI0_l00001ooooo`003_ooool2o`0001Ooc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`co
c>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01Soc>KI00?ohaL<olcVfOo<i]T05?o<i]T2o`00007o
oooo0006ooooo`Go00000oooool2o`0000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI0_l2Z9h8olcVf@;o00000Oooool000Oooooo00Co
0000oooooooooooo00000oooool2o`0000_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0<olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03on<G3?o<i]Wo0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00007ooooo
0005o`0000?ooooo00?o0000ooooooooool00oooool2o`0000coc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`00007ooooo0009ooooo`03o`000?oooooooooo00;ooooo00?o0000on<G3?oS5``03?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@;ohaL<0Oooool000Kooooo00Go0000ooooooooooooooooo`000003
ooooo`;o000000?oc>KIon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`co
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`co
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?ohaL<olcVfOl2Z9h02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l0003o
0000007ooooo0006ooooo`05o`000?ooooooooooooooool000000oooool2o`0000;oc>KI0_oS5``;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_oS5``00ol2Z9ko0000o`000001ooooo`001oooool3o`00
00Cooooo0_l00004olcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS
5`co0ZRNolcVf@0FolcVf@04on<G3?o<i]Woc>KIolcVf@;o00000Oooool000kooooo0_l00005olcV
f@;ohaL<5oo<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcV
fOo<i]T05_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcV
fOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Goc>KI0_oS5``4olcV
f@;o00000Oooool000kooooo0_l00007olcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<
i]T05oo<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<
i]T05oo<i]T00ol0003oc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<
i]T05oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<
i]T01?o<i]T2o`00007ooooo000>ooooo`;o00002?o<i]T2on<G31Koc>KI00?ohaL<olcVfOo<i]T0
5oo<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
5oo<i]T00ol0003oc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T0
5oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Coc>KI0_oS5``7olcVf@;o0000
0Oooool000kooooo0_l0000:olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05oo<
i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05_o<
i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05_o<
i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T01oo<
i]T2o`00007ooooo000>ooooo`;o00002oo<i]T2on<G31Goc>KI00?ohaL<olcVfOo<i]T05oo<i]T0
0ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01?oc>KI0_oS5``:olcVf@;o00000Oooool0
00kooooo0_l0000=olcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0
003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS
5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T02_o<i]T2o`00
007ooooo000>ooooo`;o00003_o<i]T2on<G31Coc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`co
c>KIolcVf@0>olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=
olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0?
olcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T04_o<i]T2on<G30goc>KI0_l00001
ooooo`003_ooool2o`0000Woc>KI0_l2Z9h5olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h<olcV
f@;ohaL<2oo<i]T2o`:XWP[oc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@05olcV
f@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcV
f@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Wo
c>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI0_l2Z9h;olcVf@;ohaL<00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPKoc>KI00?o
haL<olcVfOo<i]T00oo<i]T2o`:XWPSoc>KI0_l00001ooooo`003_ooool2o`0000_oc>KI00?o0ZRN
olcVfOo<i]T00oo<i]T2on<G30Koc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@05
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<
i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00Coc>KI
00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Co
c>KI0_oS5``5olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l00001ooooo`003_ooool00ol0003o0ZRN
o`:XWP0;olcVf@;o0ZRN1Oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI
00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcV
fOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcV
fOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h1
ooooo`003_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T2on<G
30Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T2on<G30_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS
5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KI
o`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co
0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI0_oS5``6olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNo`000?l000000Oooool000kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPco
c>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T0
0ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
1?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_oS5``00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@04o`:XW_o<i]Wo0000o`00007ooooo000>ooooo`;o00004?o<i]T00ol2Z9koc>KIolcV
f@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9kohaL<olcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN2oo<i]T00ol2Z9koc>KI
olcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KI
olcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@02olcV
f@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KIolcVfOoS5``9
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@03
olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T2o`00007ooooo000>oooo
o`;o00006?o<i]T2on<G31?oc>KI0_oS5``DolcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcV
fOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcV
fOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T00oo<
i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T04_o<
i]T00ooS5`coc>KIolcVf@0AolcVf@;ohaL<5oo<i]T2o`00007ooooo000>ooooo`;o00006_o<i]T0
0ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04Oo<i]T2
on<G31?oc>KI00?ohaL<olcVfOo<i]T05oo<i]T2o`00007ooooo000>ooooo`;o00006oo<i]T2on<G
31?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI
01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ol0003oc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI
01;oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI
017oc>KI0_oS5``JolcVf@;o00000Oooool000kooooo0_l0000MolcVf@03on<G3?o<i]Woc>KI017o
c>KI0_oS5``BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03o`000?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`co
c>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`co
c>KIolcVf@0JolcVf@;o00000Oooool000kooooo0_l0000NolcVf@;ohaL<4oo<i]T00ooS5`coc>KI
olcVf@0@olcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KI
olcVf@0ColcVf@03o`000?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KI
olcVf@0ColcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T2on<G31goc>KI
0_l00001ooooo`003_ooool2o`00023oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcV
f@0@olcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcV
f@0ColcVf@03o`000?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcV
f@0BolcVf@03on<G3?o<i]Woc>KI013oc>KI0_oS5``BolcVf@03on<G3?o<i]Woc>KI01goc>KI0_l0
0001ooooo`003_ooool2o`00027oc>KI0_oS5``BolcVf@;ohaL<4Oo<i]T00ooS5`coc>KIolcVf@0B
olcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0<
olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@0B
olcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@
olcVf@;ohaL<8?o<i]T2o`00007ooooo000>ooooo`;o00008oo<i]T00ooS5`coc>KIolcVf@0AolcV
f@03on<G3?o<i]Woc>KI00ooc>KI0_oS5``3olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOoS5``02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcV
fOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcV
fOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRN
olcVfOo<i]T00_oS5``BolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T08?o<i]T2
o`00007ooooo000>ooooo`;o00002Oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;ohaL<3?o<i]T2o`:X
WPCoc>KI00?ohaL<olcVfOo<i]T01Oo<i]T2o`:XWPWoc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T0
0ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
0ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T0
0ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<
i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@;o0ZRN1oo<i]T01?oS5`coc>KIolcVfOo<i]T2o`:XWPco
c>KI0_oS5``<olcVf@;o0ZRN2oo<i]T2o`:XWPSoc>KI0_l00001ooooo`003_ooool2o`0000_oc>KI
0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KI
olcVf@02olcVf@;ohaL<1oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgo
c>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?o
c>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@04on<G3?o<i]Woc>KIo`:X
WPcoc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@05olcVf@;ohaL<0oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2
o`00007ooooo000>ooooo`04o`000?l2Z9ko0ZRNo`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2
o`:XWP_oc>KI0_oS5``<olcVf@;o0ZRN1?o<i]T00ooS5`coc>KIolcVf@05olcVf@;o0ZRN2?o<i]T0
1?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<
i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI0_l2Z9h7olcVf@04
on<G3?o<i]Woc>KIolcVf@;o0ZRN3?o<i]T2on<G30coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@;o0ZRN0Oooool000kooooo0_l00002olcVf@;o0ZRN2_o<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00;o
c>KI0_oS5``7olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T01?l2
Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T0
0ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<
i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_oS5``3olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN
0_l00001ooooo`003_ooool2o`00013oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;ohaL<3?o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T2on<G3003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcVfOoS5``02_o<
i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00Co0ZRNolcVfOoS5`cohaL<
2Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T2on<G30coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0=olcVf@;o0000
0Oooool000kooooo0_l0000/olcVf@;ohaL<4Oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<
i]Wo0ZRN00coc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<
i]Wo0ZRN00coc>KI00?o0ZRNolcVfOoS5``04Oo<i]T2on<G313oc>KI0_oS5``[olcVf@;o00000Ooo
ool000kooooo0_l0000^olcVf@;ohaL<4?o<i]T2on<G313oc>KI00?ohaL<olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03_o<i]T2
on<G32goc>KI0_l00001ooooo`003_ooool2o`00033oc>KI0_oS5``@olcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI
00ooc>KI00?o0000olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI
00goc>KI00?ohaL<olcVfOo<i]T03_o<i]T2on<G30ooc>KI0_oS5``_olcVf@;o00000Oooool000ko
oooo0_l0000bolcVf@;ohaL<3oo<i]T2on<G30ooc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?o0000olcVfOo<i]T03_o<i]T00ooS5`co
c>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`co
c>KIolcVf@0=olcVf@;ohaL<<Oo<i]T2o`00007ooooo000>ooooo`;o0000=?o<i]T2on<G30ooc>KI
00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI
00?ohaL<olcVfOo<i]T03oo<i]T00ol0003oc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI
00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@;ohaL<3_o<i]T2on<G33?oc>KI
0_l00001ooooo`003_ooool2o`0003Koc>KI0_oS5``>olcVf@03on<G3?o<i]Woc>KI00goc>KI0_oS
5``>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ol0003oc>KIolcV
f@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<i]T2on<G30ooc>KI00?o
haL<olcVfOo<i]T03?o<i]T2on<G33Goc>KI0_l00001ooooo`003_ooool2o`0003Soc>KI0_oS5``=
olcVf@;ohaL<3oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<
olcVfOo<i]T03_o<i]T00ol0003oc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0=olcVf@;ohaL<3Oo<i]T2on<G33Ooc>KI0_l00001
ooooo`003_ooool2o`0003[oc>KI0_oS5``=olcVf@;ohaL<3_o<i]T2on<G30goc>KI00?ohaL<olcV
fOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcV
fOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0:olcVf@;ohaL<3_o<i]T2on<G30goc>KI0_oS5``iolcV
f@;o00000Oooool000kooooo0_l0000lolcVf@;ohaL<3Oo<i]T2on<G30koc>KI00?ohaL<o`:XW_o<
i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00goc>KI00?o0000olcVfOo<
i]T03?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?ohaL<o`:XW_o<
i]T03?o<i]T2on<G30goc>KI0_oS5``kolcVf@;o00000Oooool000kooooo0_l0000bolcVf@;o0ZRN
2_o<i]T3on<G30coc>KI0ooS5``<olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
2oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI0ooS5``<olcVf@?ohaL<
2oo<i]T2o`:XWS3oc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI1Ol2Z9h8olcVf@?o0ZRN2oo<
i]T3o`:XWPgoc>KI0ol2Z9h:olcVf@?ohaL<2oo<i]T00ol2Z9kohaL<on<G300;olcVf@;ohaL<3?o<
i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00coc>KI00?o0000olcVfOo<i]T02oo<
i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI0_oS5``;olcVf@;ohaL<00?o
0ZRNolcVfOo<i]T02Oo<i]T3on<G30_oc>KI0ol2Z9h<olcVf@?o0ZRN2oo<i]T3o`:XWPWoc>KI1Ol2
Z9h7olcVf@;o00000Oooool000kooooo00?o0000o`:XW_l2Z9h00ol2Z9h:olcVf@?o0ZRN2?o<i]T4
o`:XWP[oc>KI0ol2Z9h=olcVf@;o0ZRN2oo<i]T3on<G30_oc>KI0_oS5``;olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03on<G3?o<i]Wo
c>KI00Woc>KI0_oS5``<olcVf@;ohaL<2oo<i]T3o`:XWPcoc>KI0ol2Z9h;olcVf@?o0ZRN2?o<i]T4
o`:XWP[oc>KI1?l2Z9h1ooooo`003_ooool2o`0001goc>KI0_l2Z9h;olcVf@;o0ZRN3Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@04o`:XW_oS5`cohaL<on<G30[oc>KI0_oS5``:olcVf@;ohaL<2oo<i]T2
on<G30_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_oS5`co
c>KI00[oc>KI0_oS5``:olcVf@;ohaL<2_o<i]T2on<G30_oc>KI0ooS5``<olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI0_l2Z9h<olcVf@;o0ZRN6oo<i]T2o`00007ooooo000>ooooo`;o0000B_o<i]T3on<G
30Woc>KI0_oS5``9olcVf@03o`:XW_oS5`cohaL<00[oc>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS
5`coc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<i]T02Oo<i]T00ooS
5`coc>KIolcVf@08olcVf@;ohaL<00?o0ZRNolcVfOo<i]T01oo<i]T2on<G30[oc>KI0ooS5`a8olcV
f@;o00000Oooool000kooooo0_l0001=olcVf@?ohaL<2?o<i]T2on<G30[oc>KI0_oS5``:olcVf@03
on<G3?o<i]Woc>KI00Soc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol0003oc>KIolcVf@08olcVf@03
o`:XW_oS5`coc>KI00Soc>KI0_oS5``9olcVf@;ohaL<2_o<i]T2on<G30Woc>KI0ooS5`a;olcVf@;o
00000Oooool000kooooo0_l0001@olcVf@?ohaL<1oo<i]T2on<G30[oc>KI0_oS5``9olcVf@03on<G
3?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol0003oc>KIolcVf@08olcVf@03on<G
3?o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T01oo<i]T2on<G30[oc>KI0_oS5``8olcVf@?ohaL<
C_o<i]T2o`00007ooooo000>ooooo`;o0000Doo<i]T3on<G30Koc>KI0_oS5``:olcVf@;ohaL<2?o<
i]T2on<G30Soc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ol0003oc>KIolcVf@07olcVf@03on<G3?o<
i]Woc>KI00Koc>KI0_oS5``8olcVf@;ohaL<2_o<i]T2on<G30Ooc>KI0ooS5`aAolcVf@;o00000Ooo
ool000kooooo0_l0001FolcVf@?ohaL<1Oo<i]T3on<G30Woc>KI0_oS5``8olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ol0003oc>KIolcVf@07olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?ohaL<olcVfOo<i]T01_o<i]T2on<G30Woc>KI0ooS5``6olcVf@?ohaL<E?o<i]T2
o`00007ooooo000>ooooo`;o0000FOo<i]T3on<G30Goc>KI1?oS5``7olcVf@;ohaL<1oo<i]T00ooS
5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?o0000olcVfOo<i]T01_o<i]T00ooS
5`coc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01Oo<i]T4on<G
30Koc>KI0ooS5`aGolcVf@;o00000Oooool000kooooo0_l0001LolcVf@?ohaL<1_o<i]T4on<G30Go
c>KI0_oS5``6olcVf@;ohaL<1_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`000?o<i]Woc>KI00Go
c>KI00?ohaL<olcVfOo<i]T01?o<i]T2on<G30Ooc>KI0_oS5``5olcVf@?ohaL<1oo<i]T3on<G35[o
c>KI0_l00001ooooo`003_ooool2o`0005ooc>KI1OoS5``5olcVf@?ohaL<1?o<i]T3on<G30Goc>KI
0_oS5``5olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0000olcVfOo<i]T01?o<i]T00ooS5`coc>KI
olcVf@03olcVf@;ohaL<1_o<i]T3on<G30Coc>KI0ooS5``4olcVf@KohaL<GOo<i]T2o`00007ooooo
000>ooooo`;o0000I?o<i]T7on<G3004olcVfOoS5`cohaL<on<G30Coc>KI0ooS5``4olcVf@;ohaL<
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`000?o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@03olcVf@?ohaL<0oo<i]T4on<G3003olcVfOoS5`cohaL<00CohaL<
Hoo<i]T2o`00007ooooo0008ooooo`;o00001?ooool2o`0006_oc>KI2OoS5``2olcVf@?ohaL<0oo<
i]T2on<G30?oc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9ko0000olcVf@03olcVf@03on<G3?o<
i]Woc>KI00;oc>KI0_oS5``3olcVf@?ohaL<00?oc>KIon<G3?oS5``02?oS5`aYolcVf@;o00000Ooo
ool000Oooooo00Co0000oooooooooooo00000oooool2o`0007;oc>KI4_oS5``01_o<i]Wo0ZRNolcV
fOl0003o0ZRNolcVf@;ohaL<00?oc>KIon<G3?oS5``03_oS5`a`olcVf@;o00000Oooool000Oooooo
00Co0000oooooooooooo00000oooooooo`0001;o00000Oooool000Oooooo00Co0000oooooooooooo
00000oooool2o`00077oc>KI5?oS5``01?l2Z9koc>KIo`000?o<i]TEon<G36ooc>KI0_l00001oooo
o`001oooool01?l0003oooooooooool00003ooooo`;o0000J_o<i]TEon<G30;oc>KI0_oS5``2olcV
f@;o0ZRN00Co0000o`:XW_o<i]Woc>KI0_oS5``2olcVfAKohaL<J?o<i]T2o`00007ooooo0007oooo
o`04o`000?ooooooooooo`0000?ooooo0_l0001UolcVf@GohaL<00?oc>KIon<G3?oS5``01?oS5``0
1?o<i]WohaL<on<G3?oS5``4olcVf@;ohaL<1Oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`000?o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T2on<G30Coc>KI0ooS5``00oo<i]WohaL<on<G
3004on<G3003olcVfOoS5`cohaL<00;ohaL<I?o<i]T2o`00007ooooo0008ooooo`;o00001?ooool2
o`00067oc>KI1?oS5``3olcVf@?ohaL<1?o<i]T3on<G30Goc>KI0_oS5``6olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?o0000olcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI0ooS5``4olcVf@?ohaL<0_o<i]T4on<G363oc>KI0_l00001ooooo`003_ooool2o`00
05goc>KI1?oS5``4olcVf@?ohaL<1Oo<i]T2on<G30Koc>KI0_oS5``7olcVf@03on<G3?o<i]Woc>KI
00Koc>KI00?o0000olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@05olcVf@;ohaL<1oo<i]T2on<G
30Goc>KI0_oS5``4olcVf@CohaL<G?o<i]T2o`00007ooooo000>ooooo`;o0000F?o<i]T5on<G30Go
c>KI0ooS5``6olcVf@;ohaL<1oo<i]T00ooS5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI00?o0000olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI0_oS5``5olcVf@?ohaL<1Oo<i]T5on<G35Ooc>KI0_l00001ooooo`003_ooool2o`0005Goc>KI
0ooS5``7olcVf@?ohaL<1oo<i]T2on<G30Soc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ooS5`coc>KI
olcVf@07olcVf@03o`000?o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ooS5`coc>KI
olcVf@07olcVf@03on<G3?o<i]Woc>KI00Goc>KI0ooS5``7olcVf@CohaL<Doo<i]T2o`00007ooooo
000>ooooo`;o0000D_o<i]T3on<G30Soc>KI0_oS5``8olcVf@;ohaL<2Oo<i]T00ooS5`coc>KIolcV
f@07olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?o0000olcVfOo<i]T01oo<i]T00ooS5`coc>KIolcV
f@07olcVf@;ohaL<2?o<i]T2on<G30Soc>KI0_oS5``9olcVf@?ohaL<D?o<i]T2o`00007ooooo000>
ooooo`;o0000Coo<i]T3on<G30Soc>KI0ooS5``9olcVf@03on<G3?o<i]Woc>KI00Soc>KI00?ohaL<
olcVfOo<i]T02?o<i]T00ooS5`coc>KIolcVf@08olcVf@03o`000?o<i]Woc>KI00Ooc>KI00?ohaL<
olcVfOo<i]T02Oo<i]T00ooS5`coc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00Ooc>KI0ooS5``9
olcVf@?ohaL<COo<i]T2o`00007ooooo000>ooooo`;o0000C?o<i]T3on<G30Woc>KI0_oS5``:olcV
f@;ohaL<2_o<i]T00ooS5`coc>KIolcVf@08olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?o0000olcV
fOo<i]T02?o<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?o<i]Woc>KI00Ooc>KI0_oS5``:olcV
f@;ohaL<2_o<i]T3on<G34[oc>KI0_l00001ooooo`003_ooool2o`0004Woc>KI0ooS5``9olcVf@?o
haL<2_o<i]T2on<G30[oc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ooS5`coc>KIolcVf@09olcVf@03
o`000?o<i]Woc>KI00Soc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ooS5`coc>KIolcVf@08olcVf@;o
haL<2_o<i]T3on<G30[oc>KI0ooS5`a7olcVf@;o00000Oooool000kooooo0_l00015olcVf@04o`:X
W_oS5`cohaL<on<G30[oc>KI0_oS5``;olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNon<G3?o<
i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<
i]T02_o<i]T00ooS5`coc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00[oc>KI0_oS5``;olcVf@;o
haL<00?o0ZRNolcVfOo<i]T0@_o<i]T2o`00007ooooo000>ooooo`;o000000Coc>KIo`:XW_l2Z9ko
0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWPSoc>KI0_l2Z9h2on<G30[o
c>KI00?o0ZRNon<G3?oS5``03?o<i]T2on<G30_oc>KI0_oS5``<olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03on<G3?o<i]Woc>KI00Wo
c>KI0_oS5``00ol2Z9koc>KIolcVf@09olcVf@;ohaL<00?o0ZRNolcVfOo<i]T02?o<i]T2on<G30;o
0ZRN2?o<i]T3o`:XWP_oc>KI0ol2Z9h;olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h1o`00007o
oooo000>ooooo`03o`000?l2Z9ko0ZRN00[oc>KI0ol2Z9h:olcVf@Co0ZRN2_o<i]T3o`:XWP_oc>KI
0ol2Z9h9olcVf@;o0ZRN0_oS5``:olcVf@03o`:XW_oS5`cohaL<00coc>KI0_oS5``<olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G
3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T2on<G30coc>KI0_oS5``00ol2Z9koc>KI
olcVf@08olcVf@?ohaL<00?o0ZRNolcVfOo<i]T01oo<i]T4o`:XWP[oc>KI0ol2Z9h;olcVf@?o0ZRN
2_o<i]T4o`:XWPWoc>KI0Ol00001o`:XWP7ooooo000>ooooo`;o00002Oo<i]T2o`:XWP_oc>KI0_l2
Z9h<olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0ooS5``;olcVf@;ohaL<3Oo<i]T00ooS5`coc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol0003oc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`co0ZRNolcV
f@0;olcVf@;ohaL<3?o<i]T2on<G30coc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWPcoc>KI0_l2
Z9h7olcVf@;o00000Oooool000kooooo0_l0000molcVf@;ohaL<3Oo<i]T00ooS5`coc>KIolcVf@0;
olcVf@;ohaL<3Oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0000
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00_oc>KI0_oS5``=
olcVf@03on<G3?o<i]Woc>KI00_oc>KI0_oS5``lolcVf@;o00000Oooool000kooooo0_l0000kolcV
f@;ohaL<3Oo<i]T2on<G30coc>KI0_oS5``>olcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNon<G
3?o<i]T03Oo<i]T00ol0003oc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcV
fOo<i]T03?o<i]T2on<G30coc>KI0_oS5``=olcVf@;ohaL<>_o<i]T2o`00007ooooo000>ooooo`;o
0000>Oo<i]T2on<G30goc>KI0_oS5``=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<
i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<
i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00_oc>KI0_oS5``=olcVf@;o
haL<>?o<i]T2o`00007ooooo000>ooooo`;o0000=_o<i]T3on<G30goc>KI0_oS5``=olcVf@;ohaL<
3oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00koc>KI00?o0000olcVfOo<i]T0
3Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI0_oS5``=olcVf@;ohaL<
3Oo<i]T3on<G33Goc>KI0_l00001ooooo`003_ooool2o`0003Coc>KI0_oS5``?olcVf@03on<G3?o<
i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<
i]Woc>KI00koc>KI00?o0000olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<
i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03?o<i]T2on<G30koc>KI0_oS5``colcVf@;o00000Ooo
ool000kooooo0_l0000bolcVf@;ohaL<3oo<i]T2on<G30koc>KI00?ohaL<olcVfOo<i]T03oo<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?o0000olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03Oo<i]T0
0ooS5`coc>KIolcVf@0=olcVf@;ohaL<<Oo<i]T2o`00007ooooo000>ooooo`;o0000<?o<i]T2on<G
313oc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ol0003oc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0=olcVf@;ohaL<3oo<i]T2on<G
32ooc>KI0_l00001ooooo`003_ooool2o`0002goc>KI0ooS5``@olcVf@;ohaL<3oo<i]T00ooS5`co
c>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ol0003o
c>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`co
c>KIolcVf@0>olcVf@;ohaL<3oo<i]T3on<G32coc>KI0_l00001ooooo`003_ooool2o`0002_oc>KI
0_oS5``AolcVf@;ohaL<4?o<i]T00ooS5`coc>KIolcVf@0=olcVf@04o`:XW_o<i]Woc>KIon<G30Wo
c>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Co
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h?olcVf@03on<G3?o<i]Woc>KI
00ooc>KI00?ohaL<olcVfOo<i]T03oo<i]T2on<G32[oc>KI0_l00001ooooo`003_ooool2o`0002Wo
c>KI0_oS5``00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN1?o<i]T00ooS5`coc>KIolcVf@05olcVf@;o
0ZRN2?o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2
Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0
003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2
Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI0_l2Z9h2olcVf@03on<G3?o<i]Woc>KI
00Ooc>KI0_l2Z9h6olcVf@;ohaL<0oo<i]T2o`:XWP_oc>KI00?o0ZRNon<G3?oS5``0:?o<i]T2o`00
007ooooo000>ooooo`;o000000Coc>KIo`:XW_l2Z9ko0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcV
f@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T2on<G30Ooc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<
i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<
i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00Co0ZRNolcVfOo<i]Wo
haL<2_o<i]T00ol2Z9koc>KIolcVf@05olcVf@;ohaL<0oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_oS5`coc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T3o`:XWP7o00000Oooool000kooooo
00?o0000o`:XW_l2Z9h02oo<i]T3o`:XWP_oc>KI0_l2Z9h:olcVf@;ohaL<3?o<i]T2o`:XWPCoc>KI
00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2
Z9h03?o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcV
fOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcV
fOo<i]Wo0ZRN3Oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00Co
haL<olcVfOo<i]Woc>KI0_l2Z9h<olcVf@;ohaL<2_o<i]T3o`:XWP[oc>KI0ol2Z9h;olcVf@7o0000
0Ol2Z9h1ooooo`003_ooool2o`0000[oc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T00ooS5`co0ZRNolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI0_oS5``8olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T0
1Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcV
fOo<i]T01_o<i]T2on<G30?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcV
f@;o0ZRN2oo<i]T2o`:XWPWoc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T00_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<
i]Woc>KIo`:XWP0=olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
1OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KI
olcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o0000
8_o<i]T2on<G31;oc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G
3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T01?l2Z9koc>KIolcVfOoS5``;olcVf@03o`:XW_o<i]Woc>KI
00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@0?olcVf@;ohaL<8Oo<i]T2o`00007ooooo000>
ooooo`;o00008Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<
olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<
olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<
olcVfOo<i]T07_o<i]T2o`00007ooooo000>ooooo`;o00007oo<i]T2on<G31;oc>KI0_oS5``DolcV
f@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0BolcV
f@03o`000?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0BolcV
f@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04?o<i]T2on<G31koc>KI0_l00001oooo
o`003_ooool2o`0001koc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0ColcVf@03
on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03
o`000?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0BolcVf@03
on<G3?o<i]Woc>KI01?oc>KI0_oS5``BolcVf@03on<G3?o<i]Woc>KI01_oc>KI0_l00001ooooo`00
3_ooool2o`0001coc>KI0_oS5``ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T0
4_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T0
4_o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T0
5?o<i]T00ooS5`coc>KIolcVf@0@olcVf@;ohaL<6oo<i]T2o`00007ooooo000>ooooo`;o00006oo<
i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T04oo<
i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T04_o<
i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<
i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI01Soc>KI0_l00001ooooo`003_ooool2
o`0001[oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T2on<G31Goc>KI00?ohaL<olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0ColcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o0000olcVfOo<i]T04oo<i]T0
0ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<i]T0
0ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI01Ooc>KI0_l00001ooooo`003_ooool2o`00
01Soc>KI0_oS5``ColcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS
5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06
olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<
i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0AolcVf@;ohaL<5oo<
i]T2o`00007ooooo000>ooooo`;o00005oo<i]T00ooS5`coc>KIolcVf@0@olcVf@;o0ZRN00?ohaL<
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRN
olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRN
olcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T0
0_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@04on<G3?o<i]Wo0ZRNo`:XWQ7oc>KI00?ohaL<olcVfOo<
i]T05?o<i]T2o`00007ooooo000>ooooo`;o000000?oc>KIo`:XW_l2Z9h03?o<i]T2o`:XWPCoc>KI
0_oS5``5olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00?o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcV
fOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_oS
5``00oo<i]Wo0ZRNolcVf@09olcVf@;o0ZRN1Oo<i]T2on<G30Goc>KI0_l2Z9h;olcVf@;o0ZRN0_l0
0001ooooo`003_ooool2o`000003o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h5olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<on<G300;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ooS5`coc>KIo`:XWP0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<
i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@7o0ZRN0Ol00001ooooo`003_ooool00ol0003o0ZRN
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI0_oS5``5olcVf@;o0ZRN3?o<i]T00ol2Z9kohaL<
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KI
olcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KI
olcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@02olcV
f@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOl2Z9h02oo<i]T2o`:XWPGoc>KI0_oS5``5
olcVf@;o0ZRN2_o<i]T1o`00007o0ZRN0Oooool000kooooo0_l0000:olcVf@;o0ZRN1Oo<i]T00ooS
5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07
olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcV
f@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KI
olcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T2on<G30Koc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9kohaL<olcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcV
f@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03
on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@04olcV
f@;ohaL<1Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000Oooool000kooooo0_l0000>olcVf@03
on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00coc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI
00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
haL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0;olcVf@;o00000Oooool000kooooo0_l0000=
olcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0F
olcVf@03on<G3?o<i]Woc>KI017oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<
i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<
i]Woc>KIo`:XWQCoc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G
3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T02_o<i]T2o`00007ooooo000>ooooo`;o00002oo<
i]T2on<G31Ooc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<
i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<
i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0DolcVf@03on<G3?o<
i]Woc>KI01Goc>KI0_oS5``:olcVf@;o00000Oooool000kooooo0_l0000:olcVf@03on<G3?o<i]Wo
c>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Wo
c>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Wo
c>KI01Koc>KI00?ohaL<olcVfOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00002?o<i]T2on<G
31Soc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI
01Ooc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI
01Ooc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI
01Koc>KI0_oS5``7olcVf@;o00000Oooool000kooooo0_l00007olcVf@03on<G3?o<i]Woc>KI01Oo
c>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ko
c>KI00?ohaL<olcVfOo<i]T05oo<i]T00ol0003oc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ko
c>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Oo
c>KI00?ohaL<olcVfOo<i]T01?o<i]T2o`00007ooooo000>ooooo`;o00001Oo<i]T2on<G31Woc>KI
00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI
00?ohaL<olcVfOo<i]T05oo<i]T00ol0003oc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Ooc>KI
00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Ooc>KI
0_oS5``4olcVf@;o00000Oooool000kooooo0_l00004olcVf@03on<G3?o<i]Woc>KI01Soc>KI00?o
haL<olcVfOo<i]T05Oo<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
haL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Soc>KI00Co
haL<olcVfOo<i]Woc>KI0_l00001ooooo`001_ooool5o`0000?ooooo0_l000001?o<i]Wo0ZRNo`:X
W_oS5``;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h00ooS5`coc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G
3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G
3?o<i]Wo0ZRN00coc>KI0_l2Z9h:olcVf@03on<G3?l2Z9ko0ZRN00;o00000Oooool000Oooooo00Co
0000oooooooooooo00000oooool2o`000003o`:XW_oS5`cohaL<00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T2on<G307o0ZRN0Ol00001ooooo`002?ooool00ol0003oooooooooo`03ooooo`03o`000?l2
Z9kohaL<00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<
i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T1on<G307o0ZRN0Oooool000Wooooo00?o0000
ooooooooool00_ooool00ol0003ohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
on<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0Ol00001
on<G307ooooo0006ooooo`05o`000?ooooooooooooooool000000oooool2o`0000_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
on<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRN
olcVfOo<i]T01oo<i]T2o`00007ooooo0006ooooo`05o`000?ooooooooooooooool000000oooool2
o`0000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Wo
c>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo
0ZRN00goc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`00007ooooo0007ooooo`?o00001?ooool2o`00
01Soc>KI00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI
01Goc>KI0_l00001ooooo`003_ooool2o`0001Soc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`co
c>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ol0003o
c>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`co
c>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Goc>KI0_l00001ooooo`003_ooool2o`0001Ooc>KI
00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T06Oo<i]T00ol0003oc>KIolcVf@0IolcVf@03on<G3?o<i]Woc>KI01Woc>KI
00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0GolcVf@03on<G3?o<i]Woc>KI01Coc>KI
0_l00001ooooo`003_ooool2o`0001Koc>KI00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcV
f@0IolcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ol0003oc>KIolcV
f@0IolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06Oo<i]T00ooS5`coc>KIolcV
f@0HolcVf@03on<G3?o<i]Woc>KI01?oc>KI0_l00001ooooo`003_ooool2o`0001Goc>KI00?ohaL<
olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<
olcVfOo<i]T06_o<i]T00ol0003oc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01Woc>KI00?ohaL<
olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI01;oc>KI0_l00001
ooooo`003_ooool2o`0001Coc>KI00?ohaL<olcVfOo<i]T06?o<i]T00ooS5`coc>KIolcVf@0JolcV
f@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ol0003oc>KIolcVf@0JolcV
f@03on<G3?o<i]Woc>KI01[oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0HolcV
f@03on<G3?o<i]Woc>KI017oc>KI0_l00001ooooo`003_ooool2o`0001?oc>KI00?ohaL<olcVfOo<
i]T06Oo<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<
i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcV
fOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0HolcVf@03on<G3?o<i]Woc>KI013oc>KI0_l00001oooo
o`003_ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0<olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<
i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgo
c>KI00?o0ZRNo`000?l000000Oooool000kooooo0_l000000oo<i]Wo0ZRNolcVf@0<olcVf@03o`:X
W_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<
i]Wo0ZRN00goc>KI00?o0ZRNo`000?l000000Oooool000kooooo0_l000000ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS
5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcV
f@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcV
fOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS
5`coc>KIo`:XWP0=olcVf@7o0ZRN0Ol00001ooooo`003_ooool00ol0003o0ZRNolcVf@0<olcVf@03
o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<
00Soc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI
00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KI
o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00?ohaL<olcVfOl2Z9h03?o<i]T1o`00007o0ZRN0Oooool000kooooo0_l0000<olcVf@03o`:XW_o<
i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Co
c>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Oo
c>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOl2Z9h02oo<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T00ol2Z9koc>KIon<G300;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Wo
c>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?o
haL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h0
2_o<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G
30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI
00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00Woc>KI0_l00001
ooooo`003_ooool2o`0000coc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0LolcV
f@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcV
f@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcV
f@0JolcVf@03on<G3?o<i]Woc>KI00Woc>KI0_l00001ooooo`003_ooool2o`0000_oc>KI00?ohaL<
olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<
olcVfOo<i]T07?o<i]T00ol0003oc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<
olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI00Soc>KI0_l00001
ooooo`003_ooool2o`0000[oc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0LolcV
f@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ol0003oc>KIolcVf@0LolcV
f@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0KolcV
f@03on<G3?o<i]Woc>KI00Ooc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?ohaL<olcVfOo<
i]T06oo<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<
i]T07Oo<i]T00ol0003oc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<
i]T07Oo<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI00Koc>KI0_l00001ooooo`00
3_ooool2o`0000Soc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G
3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ol0003oc>KIolcVf@0MolcVf@03on<G
3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G
3?o<i]Woc>KI00Goc>KI0_l00001ooooo`003_ooool2o`0000Ooc>KI00?ohaL<olcVfOo<i]T07?o<
i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01koc>KI00?ohaL<olcVfOo<i]T07Oo<
i]T00ol0003oc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07Oo<
i]T00ooS5`coc>KIolcVf@0LolcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l00001ooooo`003_ooool2
o`0000;oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G300EolcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T0
0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h0
3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcVfOo<
i]T04oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_l0003o0000007ooooo000>ooooo`;o0000
00?oc>KIo`:XW_o<i]T00_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00;o00000Oooool000kooooo0_l000001Oo<i]Wo
0ZRNolcVfOo<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcV
f@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
haL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Wo
c>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo
0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h2o`00007ooooo
000>ooooo`;o000000Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:X
W_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00GohaL<olcVfOo<i]Wo0ZRNo`000001ooooo`003_ooool01Ol0003o0ZRNolcVfOo<i]WohaL<
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIo`000?l2Z9h1ooooo`003_ooool2o`000003olcVfOoS
5`coc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<
i]Woc>KIolcVfOl2Z9h03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00goc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`co0000o`000001ooooo`003_ooool2o`000003on<G
3?o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`00
0?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G
3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G
3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00So
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@7ohaL<0Ol00001ooooo`00
3_ooool00ol0003ohaL<olcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`co
c>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003o
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co
c>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0Ol00001on<G307ooooo000>ooooo`;o
00008Oo<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<
i]T07oo<i]T00ol0003oc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<
i]T07oo<i]T00ooS5`coc>KIolcVf@0NolcVf@;o00000Oooool000kooooo0_l0000QolcVf@03on<G
3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07oo<i]T00ooS5`coc>KIolcVf@0OolcVf@03o`00
0?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G
3?o<i]Woc>KI01koc>KI0_l00001ooooo`003_ooool2o`00023oc>KI00?ohaL<olcVfOo<i]T07oo<
i]T00ooS5`coc>KIolcVf@0PolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?o0000olcVfOo<i]T07oo<
i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T07Oo<
i]T2o`00007ooooo000>ooooo`;o00008?o<i]T00ooS5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Wo
c>KI023oc>KI00?ohaL<olcVfOo<i]T07oo<i]T00ol0003oc>KIolcVf@0OolcVf@03on<G3?o<i]Wo
c>KI01ooc>KI00?ohaL<olcVfOo<i]T07oo<i]T00ooS5`coc>KIolcVf@0MolcVf@;o00000Oooool0
00kooooo0_l0000OolcVf@03on<G3?o<i]Woc>KI023oc>KI00?ohaL<olcVfOo<i]T08?o<i]T00ooS
5`coc>KIolcVf@0OolcVf@03o`000?o<i]Woc>KI01ooc>KI00?ohaL<olcVfOo<i]T08?o<i]T00ooS
5`coc>KIolcVf@0OolcVf@03on<G3?o<i]Woc>KI01coc>KI0_l00001ooooo`003_ooool2o`0001oo
c>KI00?ohaL<olcVfOo<i]T07oo<i]T00ooS5`coc>KIolcVf@0KolcVf@03o`:XW_o<i]Woc>KI00;o
c>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Go
c>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01oo
c>KI00?ohaL<olcVfOo<i]T07?o<i]T2o`00007ooooo000>ooooo`;o000000?oc>KIo`:XW_o<i]T0
3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9ko0000o`000001ooooo`003_ooool2o`000003olcVfOl2Z9koc>KI00co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN00goc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9ko0000o`000001ooooo`003_ooool2o`000003o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI0Ol2Z9h1o`00007ooooo000>ooooo`03o`000?l2Z9koc>KI00coc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0>olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
0Ol00001o`:XWP7ooooo000>ooooo`;o00003?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<
i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<
i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<
i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G
3?o<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`00007ooooo000>ooooo`;o00002oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcV
f@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03
olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05
olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03on<G3?o<i]Wo0ZRN00koc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`00007ooooo000>
ooooo`;o00006?o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9hGolcVf@;o00000Oooool000kooooo
0_l0000JolcVf@03on<G3?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ooS5`coc>KI
olcVf@0QolcVf@03o`000?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T08Oo<i]T00ooS5`coc>KI
olcVf@0QolcVf@03on<G3?o<i]Woc>KI01Ooc>KI0_l00001ooooo`003_ooool2o`0001[oc>KI00?o
haL<olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0RolcVf@03on<G3?o<i]Woc>KI027oc>KI00?o
0000olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI027oc>KI00?o
haL<olcVfOo<i]T05oo<i]T2o`00007ooooo000>ooooo`;o00006Oo<i]T00ooS5`coc>KIolcVf@0R
olcVf@03on<G3?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ol0003oc>KIolcVf@0Q
olcVf@03on<G3?o<i]Woc>KI02;oc>KI00?ohaL<olcVfOo<i]T08Oo<i]T00ooS5`coc>KIolcVf@0F
olcVf@;o00000Oooool000kooooo0_l0000IolcVf@03on<G3?o<i]Woc>KI027oc>KI00?ohaL<olcV
fOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03o`000?o<i]Woc>KI027oc>KI00?ohaL<olcV
fOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0QolcVf@03on<G3?o<i]Woc>KI01Koc>KI0_l00001oooo
o`003_ooool2o`0001Soc>KI00?ohaL<olcVfOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03
on<G3?o<i]Woc>KI02;oc>KI00?o0000olcVfOo<i]T08_o<i]T00ooS5`coc>KIolcVf@0RolcVf@03
on<G3?o<i]Woc>KI027oc>KI00?ohaL<olcVfOo<i]T05Oo<i]T2o`00007ooooo000>ooooo`;o0000
00?oc>KIo`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI
00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0Ol2Z9h1
o`00007ooooo0008ooooo`?o00000oooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``0
2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o0000007ooooo0009ooooo`03o`000?oo
oooooooo00;ooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?o
haL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9ko0000o`000001ooooo`001_ooool5o`0000?ooooo0_l000000ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KI
olcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KI
olcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003o
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`co
c>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T1o`:XWP7o00000Oooool0
00Kooooo00Co0000oooooooooooo00001?ooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00So
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T1o`00007o0ZRN0Oooool000Oooooo00?o0000ooooool00000
1?ooool2o`0000coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00go
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Go
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G
30Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KI
o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Wo
c>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Wo
c>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o00000Oooool000Sooooo0_l00004
ooooo`;o00003?o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<
olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRN
olcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00Co
haL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
0_l00001ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o00002oo<i]T00ol2Z9koc>KIolcV
f@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRN
olcVfOo<i]T01oo<i]T2o`00007ooooo000>ooooo`;o00004oo<i]T00ooS5`coc>KIolcVf@0TolcV
f@03on<G3?o<i]Woc>KI01;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2
Z9h=olcVf@03o`:XW_o<i]Woc>KI01?oc>KI00?ohaL<olcVfOo<i]T08oo<i]T00ooS5`coc>KIolcV
f@0@olcVf@;o00000Oooool000kooooo0_l0000ColcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<
olcVfOo<i]T08oo<i]T00ooS5`coc>KIolcVf@0TolcVf@03o`000?o<i]Woc>KI02?oc>KI00?ohaL<
olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0SolcVf@03on<G3?o<i]Woc>KI013oc>KI0_l00001
ooooo`003_ooool2o`0001;oc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcV
f@03on<G3?o<i]Woc>KI02Coc>KI00?o0000olcVfOo<i]T08oo<i]T00ooS5`coc>KIolcVf@0TolcV
f@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T03oo<i]T2o`00007ooooo000>ooooo`;o
00004_o<i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<
i]T09?o<i]T00ol0003oc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<
i]T08oo<i]T00ooS5`coc>KIolcVf@0?olcVf@;o00000Oooool000kooooo0_l0000AolcVf@03on<G
3?o<i]Woc>KI02Goc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcVf@03o`00
0?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G
3?o<i]Woc>KI00koc>KI0_l00001ooooo`003_ooool2o`00017oc>KI00?ohaL<olcVfOo<i]T09?o<
i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Goc>KI00?o0000olcVfOo<i]T09?o<
i]T00ooS5`coc>KIolcVf@0TolcVf@03on<G3?o<i]Woc>KI02Coc>KI00?ohaL<olcVfOo<i]T03_o<
i]T2o`00007ooooo000>ooooo`;o000000?oc>KIo`:XW_o<i]T02oo<i]T00ol2Z9koc>KIon<G300;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=
olcVf@7o0ZRN0Ol00001ooooo`003_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:X
W_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:X
W_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcV
fOl2Z9h03Oo<i]T1o`:XWP7o00000Oooool000kooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03
on<G3?o<i]Wo0ZRN00coc>KI0Ol00001o`:XWP7ooooo000>ooooo`03o`000?l2Z9koc>KI00coc>KI
00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00?ohaL<olcVfOl2Z9h03?o<i]T1o`00007o0ZRN0Oooool000kooooo0_l0000<olcVf@03o`:XW_o<
i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2
Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2
Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<
i]Wo0ZRN00_oc>KI0_l00001ooooo`003_ooool2o`0000coc>KI00?o0ZRNolcVfOoS5``02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN2_o<
i]T2o`00007ooooo000>ooooo`;o00003?o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`coc>KIo`:XWP0:olcVf@;o00000Oooool0
00kooooo0_l0000;olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00Woc>KI0_l00001ooooo`003_ooool2o`0000co
c>KI00?ohaL<olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI02Ko
c>KI00?o0000olcVfOo<i]T09Oo<i]T00ooS5`coc>KIolcVf@0WolcVf@03on<G3?o<i]Woc>KI02Go
c>KI00?ohaL<olcVfOo<i]T02Oo<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T00ooS5`coc>KI
olcVf@0WolcVf@03on<G3?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T09_o<i]T00ol0003oc>KI
olcVf@0VolcVf@03on<G3?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T09_o<i]T00ooS5`coc>KI
olcVf@08olcVf@;o00000Oooool000kooooo0_l0000;olcVf@03on<G3?o<i]Woc>KI02Ooc>KI00?o
haL<olcVfOo<i]T09Oo<i]T00ooS5`coc>KIolcVf@0WolcVf@03o`000?o<i]Woc>KI02Koc>KI00?o
haL<olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI00Soc>KI0_l0
0001ooooo`003_ooool2o`0000[oc>KI00?ohaL<olcVfOo<i]T09oo<i]T00ooS5`coc>KIolcVf@0V
olcVf@03on<G3?o<i]Woc>KI02Ooc>KI00?o0000olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0W
olcVf@03on<G3?o<i]Woc>KI02Koc>KI00?ohaL<olcVfOo<i]T01oo<i]T2o`00007ooooo000>oooo
o`;o00002_o<i]T00ooS5`coc>KIolcVf@0WolcVf@03on<G3?o<i]Woc>KI02Koc>KI00?ohaL<olcV
fOo<i]T09oo<i]T00ol0003oc>KIolcVf@0VolcVf@03on<G3?o<i]Woc>KI02Ooc>KI00?ohaL<olcV
fOo<i]T09_o<i]T00ooS5`coc>KIolcVf@07olcVf@;o00000Oooool000kooooo0_l000000oo<i]Wo
0ZRNolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIo`:XW_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI0_l2Z9h<olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:X
WPcoc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI0Ol2Z9h1o`00007ooooo000>oooo
o`;o000000?oc>KIo`:XW_o<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KI
o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9ko
c>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_oS5`co
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Wo
c>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@7o0ZRN0Ol00001ooooo`003_ooool2
o`000003o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2
Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:X
WP0=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIon<G
300:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T1o`:XWP7o00000Oooool000kooooo0_l0
00000ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h03Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03?o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS5``02oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<
2Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
0_o<i]T00ooS5`coc>KIolcVf@05olcVf@7o00000Ol2Z9h1ooooo`003_ooool00ol0003o0ZRNo`00
0006o`000003on<G3?l0003o000000;o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00
000;o`000003o`:XW_l0003o000000Oo000000CohaL<o`000?l0003o0ZRN3Ol000000ol2Z9ko0000
o`00000:o`000003o`:XW_l0003o000000Wo000000?ohaL<o`000?l2Z9h03?l000000ol2Z9ko0000
o`00000;o`000003o`:XW_l0003o000001So000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000
o`00000:o`000003o`:XW_l0003ohaL<00_o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000
o`00000:o`000005o`:XW_l0003o0000o`000?oS5``02Ol000000ol2Z9ko0000o`00000:o`000003
o`:XW_l0003o000000_o000000?o0ZRNo`000?l000000_l000000ooS5`co0000o`000005o`00007o
0ZRN0Oooool000koooooool0000Bo`00007ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.56707, -5.51412, 0.0368353, \
0.0368353}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Saddle Point", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = 2  y\)], "Input"],

Cell[BoxData[
    \(2\ y\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = \(-3\) x\)], "Input"],

Cell[BoxData[
    \(\(-3\)\ x\)], "Output"]
}, Closed]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-5\) \[LessEqual] x \[LessEqual] 5\)},
          {\(\(-5\) \[LessEqual] y \[LessEqual] 5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -5, x, 5], 
        LessEqual[ -5, y, 5]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx == \(-\(\(2\ y\)\/\(3\ x\)\)\)\)], "Output"]
}, Closed]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(2\ \(y(t)\)\)}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(\(-3\)\ \(x(t)\)\)}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 
            Times[ 2, 
              y[ t]]], 
          Equal[ 
            Derivative[ 1][ x][ t], 
            Times[ -3, 
              x[ t]]]}],
        Editable->False], TraditionalForm]], "Output"]
}, Closed]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0926184 0.5 0.0926184 [
[.12953 -0.0125 -6 -9 ]
[.12953 -0.0125 6 0 ]
[.31476 -0.0125 -6 -9 ]
[.31476 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68524 -0.0125 -3 -9 ]
[.68524 -0.0125 3 0 ]
[.87047 -0.0125 -3 -9 ]
[.87047 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12953 -12 -4.5 ]
[-0.0125 .12953 0 4.5 ]
[-0.0125 .31476 -12 -4.5 ]
[-0.0125 .31476 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68524 -6 -4.5 ]
[-0.0125 .68524 0 4.5 ]
[-0.0125 .87047 -6 -4.5 ]
[-0.0125 .87047 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12953 0 m
.12953 .00625 L
s
[(-4)] .12953 -0.0125 0 1 Mshowa
.31476 0 m
.31476 .00625 L
s
[(-2)] .31476 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68524 0 m
.68524 .00625 L
s
[(2)] .68524 -0.0125 0 1 Mshowa
.87047 0 m
.87047 .00625 L
s
[(4)] .87047 -0.0125 0 1 Mshowa
.125 Mabswid
.17584 0 m
.17584 .00375 L
s
.22214 0 m
.22214 .00375 L
s
.26845 0 m
.26845 .00375 L
s
.36107 0 m
.36107 .00375 L
s
.40738 0 m
.40738 .00375 L
s
.45369 0 m
.45369 .00375 L
s
.54631 0 m
.54631 .00375 L
s
.59262 0 m
.59262 .00375 L
s
.63893 0 m
.63893 .00375 L
s
.73155 0 m
.73155 .00375 L
s
.77786 0 m
.77786 .00375 L
s
.82416 0 m
.82416 .00375 L
s
.08322 0 m
.08322 .00375 L
s
.03691 0 m
.03691 .00375 L
s
.91678 0 m
.91678 .00375 L
s
.96309 0 m
.96309 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12953 m
.00625 .12953 L
s
[(-4)] -0.0125 .12953 1 0 Mshowa
0 .31476 m
.00625 .31476 L
s
[(-2)] -0.0125 .31476 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68524 m
.00625 .68524 L
s
[(2)] -0.0125 .68524 1 0 Mshowa
0 .87047 m
.00625 .87047 L
s
[(4)] -0.0125 .87047 1 0 Mshowa
.125 Mabswid
0 .17584 m
.00375 .17584 L
s
0 .22214 m
.00375 .22214 L
s
0 .26845 m
.00375 .26845 L
s
0 .36107 m
.00375 .36107 L
s
0 .40738 m
.00375 .40738 L
s
0 .45369 m
.00375 .45369 L
s
0 .54631 m
.00375 .54631 L
s
0 .59262 m
.00375 .59262 L
s
0 .63893 m
.00375 .63893 L
s
0 .73155 m
.00375 .73155 L
s
0 .77786 m
.00375 .77786 L
s
0 .82416 m
.00375 .82416 L
s
0 .08322 m
.00375 .08322 L
s
0 .03691 m
.00375 .03691 L
s
0 .91678 m
.00375 .91678 L
s
0 .96309 m
.00375 .96309 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12953 .99375 m
.12953 1 L
s
.31476 .99375 m
.31476 1 L
s
.5 .99375 m
.5 1 L
s
.68524 .99375 m
.68524 1 L
s
.87047 .99375 m
.87047 1 L
s
.125 Mabswid
.17584 .99625 m
.17584 1 L
s
.22214 .99625 m
.22214 1 L
s
.26845 .99625 m
.26845 1 L
s
.36107 .99625 m
.36107 1 L
s
.40738 .99625 m
.40738 1 L
s
.45369 .99625 m
.45369 1 L
s
.54631 .99625 m
.54631 1 L
s
.59262 .99625 m
.59262 1 L
s
.63893 .99625 m
.63893 1 L
s
.73155 .99625 m
.73155 1 L
s
.77786 .99625 m
.77786 1 L
s
.82416 .99625 m
.82416 1 L
s
.08322 .99625 m
.08322 1 L
s
.03691 .99625 m
.03691 1 L
s
.91678 .99625 m
.91678 1 L
s
.96309 .99625 m
.96309 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12953 m
1 .12953 L
s
.99375 .31476 m
1 .31476 L
s
.99375 .5 m
1 .5 L
s
.99375 .68524 m
1 .68524 L
s
.99375 .87047 m
1 .87047 L
s
.125 Mabswid
.99625 .17584 m
1 .17584 L
s
.99625 .22214 m
1 .22214 L
s
.99625 .26845 m
1 .26845 L
s
.99625 .36107 m
1 .36107 L
s
.99625 .40738 m
1 .40738 L
s
.99625 .45369 m
1 .45369 L
s
.99625 .54631 m
1 .54631 L
s
.99625 .59262 m
1 .59262 L
s
.99625 .63893 m
1 .63893 L
s
.99625 .73155 m
1 .73155 L
s
.99625 .77786 m
1 .77786 L
s
.99625 .82416 m
1 .82416 L
s
.99625 .08322 m
1 .08322 L
s
.99625 .03691 m
1 .03691 L
s
.99625 .91678 m
1 .91678 L
s
.99625 .96309 m
1 .96309 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.03691 .03691 m
.03691 .96309 L
.96309 .96309 L
.96309 .03691 L
F
0 0 0 r
.01 w
.03691 .03691 m
.96309 .03691 L
.96309 .96309 L
.03691 .96309 L
.03691 .03691 L
s
0 g
.5 Mabswid
.03691 .5 m
.96309 .5 L
s
.5 .03691 m
.5 .96309 L
s
.01 .66 .62 r
.02601 .04417 m
.04781 .02964 L
s
.02568 .08996 m
.04814 .07648 L
s
.02535 .13569 m
.04847 .12336 L
s
.02504 .18137 m
.04878 .1703 L
s
.02475 .22701 m
.04907 .21728 L
s
.02448 .2726 m
.04933 .26431 L
s
.02425 .31814 m
.04956 .31139 L
s
.02406 .36364 m
.04975 .3585 L
s
.02392 .40911 m
.04989 .40565 L
s
.02384 .45456 m
.04998 .45282 L
s
.02381 .5 m
.05001 .5 L
s
.02384 .54544 m
.04998 .54718 L
s
.02392 .59089 m
.04989 .59435 L
s
.02406 .63636 m
.04975 .6415 L
s
.02425 .68186 m
.04956 .68861 L
s
.02448 .7274 m
.04933 .73569 L
s
.02475 .77299 m
.04907 .78272 L
s
.02504 .81863 m
.04878 .8297 L
s
.02535 .86431 m
.04847 .87664 L
s
.02568 .91004 m
.04814 .92352 L
s
.02601 .95583 m
.04781 .97036 L
s
.07269 .0447 m
.09374 .02911 L
s
.07232 .09048 m
.09412 .07595 L
s
.07195 .1362 m
.09449 .12285 L
s
.07159 .18186 m
.09484 .16981 L
s
.07125 .22746 m
.09519 .21682 L
s
.07093 .273 m
.0955 .2639 L
s
.07066 .31848 m
.09578 .31104 L
s
.07043 .36391 m
.096 .35823 L
s
.07026 .4093 m
.09617 .40546 L
s
.07015 .45466 m
.09628 .45272 L
s
.07012 .5 m
.09632 .5 L
s
.07015 .54534 m
.09628 .54728 L
s
.07026 .5907 m
.09617 .59454 L
s
.07043 .63609 m
.096 .64177 L
s
.07066 .68152 m
.09578 .68896 L
s
.07093 .727 m
.0955 .7361 L
s
.07125 .77254 m
.09519 .78318 L
s
.07159 .81814 m
.09484 .83019 L
s
.07195 .8638 m
.09449 .87715 L
s
.07232 .90952 m
.09412 .92405 L
s
.07269 .9553 m
.09374 .97089 L
s
.11946 .04529 m
.13959 .02852 L
s
.11905 .09108 m
.14 .07536 L
s
.11863 .13679 m
.14042 .12226 L
s
.11821 .18244 m
.14084 .16924 L
s
.11781 .228 m
.14124 .21629 L
s
.11744 .27349 m
.14162 .26342 L
s
.1171 .31891 m
.14195 .31062 L
s
.11682 .36425 m
.14223 .3579 L
s
.11661 .40953 m
.14245 .40523 L
s
.11647 .45478 m
.14258 .4526 L
s
.11643 .5 m
.14262 .5 L
s
.11647 .54522 m
.14258 .5474 L
s
.11661 .59047 m
.14245 .59477 L
s
.11682 .63575 m
.14223 .6421 L
s
.1171 .68109 m
.14195 .68938 L
s
.11744 .72651 m
.14162 .73658 L
s
.11781 .772 m
.14124 .78371 L
s
.11821 .81756 m
.14084 .83076 L
s
.11863 .86321 m
.14042 .87774 L
s
.11905 .90892 m
.14 .92464 L
s
.11946 .95471 m
.13959 .97148 L
s
.16635 .04594 m
.18532 .02787 L
s
.16589 .09174 m
.18578 .07469 L
s
.16542 .13746 m
.18625 .12159 L
s
.16494 .1831 m
.18673 .16857 L
s
.16446 .22864 m
.18721 .21565 L
s
.16401 .27409 m
.18766 .26282 L
s
.1636 .31943 m
.18808 .3101 L
s
.16324 .36467 m
.18843 .35747 L
s
.16297 .40983 m
.1887 .40493 L
s
.1628 .45493 m
.18887 .45245 L
s
.16274 .5 m
.18893 .5 L
s
.1628 .54507 m
.18887 .54755 L
s
.16297 .59017 m
.1887 .59507 L
s
.16324 .63533 m
.18843 .64253 L
s
.1636 .68057 m
.18808 .6899 L
s
.16401 .72591 m
.18766 .73718 L
s
.16446 .77136 m
.18721 .78435 L
s
.16494 .8169 m
.18673 .83143 L
s
.16542 .86254 m
.18625 .87841 L
s
.16589 .90826 m
.18578 .92531 L
s
.16635 .95406 m
.18532 .97213 L
s
.21338 .04664 m
.23091 .02717 L
s
.21288 .09248 m
.23141 .07396 L
s
.21235 .13823 m
.23193 .12082 L
s
.21181 .18388 m
.23248 .16779 L
s
.21125 .22941 m
.23304 .21488 L
s
.21069 .27481 m
.23359 .26209 L
s
.21018 .32008 m
.23411 .30944 L
s
.20972 .36521 m
.23457 .35693 L
s
.20936 .41022 m
.23493 .40454 L
s
.20913 .45514 m
.23516 .45224 L
s
.20905 .5 m
.23524 .5 L
s
.20913 .54486 m
.23516 .54776 L
s
.20936 .58978 m
.23493 .59546 L
s
.20972 .63479 m
.23457 .64307 L
s
.21018 .67992 m
.23411 .69056 L
s
.21069 .72519 m
.23359 .73791 L
s
.21125 .77059 m
.23304 .78512 L
s
.21181 .81612 m
.23248 .83221 L
s
.21235 .86177 m
.23193 .87918 L
s
.21288 .90752 m
.23141 .92604 L
s
.21338 .95336 m
.23091 .97283 L
s
.26059 .04739 m
.27631 .02643 L
s
.26007 .09328 m
.27684 .07315 L
s
.2595 .13908 m
.27741 .11997 L
s
.25888 .18477 m
.27803 .1669 L
s
.25823 .23033 m
.27868 .21396 L
s
.25756 .27572 m
.27935 .26119 L
s
.2569 .32093 m
.28001 .3086 L
s
.25629 .36594 m
.28062 .35621 L
s
.2558 .41076 m
.28111 .40401 L
s
.25547 .45542 m
.28144 .45196 L
s
.25536 .5 m
.28155 .5 L
s
.25547 .54458 m
.28144 .54804 L
s
.2558 .58924 m
.28111 .59599 L
s
.25629 .63406 m
.28062 .64379 L
s
.2569 .67907 m
.28001 .6914 L
s
.25756 .72428 m
.27935 .73881 L
s
.25823 .76967 m
.27868 .78604 L
s
.25888 .81523 m
.27803 .8331 L
s
.2595 .86092 m
.27741 .88003 L
s
.26007 .90672 m
.27684 .92685 L
s
.26059 .95261 m
.27631 .97357 L
s
.30802 .04814 m
.3215 .02568 L
s
.3075 .09412 m
.32203 .07232 L
s
.3069 .14 m
.32262 .11905 L
s
.30624 .18578 m
.32329 .16589 L
s
.3055 .23141 m
.32402 .21288 L
s
.3047 .27684 m
.32483 .26007 L
s
.30386 .32203 m
.32566 .3075 L
s
.30305 .36693 m
.32648 .35521 L
s
.30234 .41152 m
.32719 .40324 L
s
.30184 .45584 m
.32768 .45154 L
s
.30166 .5 m
.32786 .5 L
s
.30184 .54416 m
.32768 .54846 L
s
.30234 .58848 m
.32719 .59676 L
s
.30305 .63307 m
.32648 .64479 L
s
.30386 .67797 m
.32566 .6925 L
s
.3047 .72316 m
.32483 .73993 L
s
.3055 .76859 m
.32402 .78712 L
s
.30624 .81422 m
.32329 .83411 L
s
.3069 .86 m
.32262 .88095 L
s
.3075 .90588 m
.32203 .92768 L
s
.30802 .95186 m
.3215 .97432 L
s
.3557 .04885 m
.36645 .02496 L
s
.35521 .09493 m
.36693 .0715 L
s
.35465 .14094 m
.36749 .11811 L
s
.35399 .18685 m
.36816 .16482 L
s
.35321 .23262 m
.36893 .21167 L
s
.35231 .27819 m
.36983 .25872 L
s
.35128 .32347 m
.37086 .30606 L
s
.35017 .36834 m
.37197 .35381 L
s
.3491 .4127 m
.37304 .40206 L
s
.34829 .45653 m
.37386 .45085 L
s
.34797 .5 m
.37417 .5 L
s
.34829 .54347 m
.37386 .54915 L
s
.3491 .5873 m
.37304 .59794 L
s
.35017 .63166 m
.37197 .64619 L
s
.35128 .67653 m
.37086 .69394 L
s
.35231 .72181 m
.36983 .74128 L
s
.35321 .76738 m
.36893 .78833 L
s
.35399 .81315 m
.36816 .83518 L
s
.35465 .85906 m
.36749 .88189 L
s
.35521 .90507 m
.36693 .9285 L
s
.3557 .95115 m
.36645 .97504 L
s
.40362 .04945 m
.41115 .02436 L
s
.40324 .09564 m
.41152 .07079 L
s
.40278 .14179 m
.41198 .11726 L
s
.40222 .18787 m
.41254 .1638 L
s
.40152 .23386 m
.41324 .21043 L
s
.40064 .27969 m
.41412 .25722 L
s
.39952 .32524 m
.41524 .30428 L
s
.39812 .37033 m
.41664 .35181 L
s
.39648 .41465 m
.41828 .40012 L
s
.39496 .45783 m
.41981 .44955 L
s
.39428 .5 m
.42048 .5 L
s
.39496 .54217 m
.41981 .55045 L
s
.39648 .58535 m
.41828 .59988 L
s
.39812 .62967 m
.41664 .64819 L
s
.39952 .67476 m
.41524 .69572 L
s
.40064 .72031 m
.41412 .74278 L
s
.40152 .76614 m
.41324 .78957 L
s
.40222 .81213 m
.41254 .8362 L
s
.40278 .85821 m
.41198 .88274 L
s
.40324 .90436 m
.41152 .92921 L
s
.40362 .95055 m
.41115 .97564 L
s
.45175 .04986 m
.45563 .02395 L
s
.45154 .09614 m
.45584 .0703 L
s
.45128 .1424 m
.4561 .11665 L
s
.45095 .18864 m
.45644 .16303 L
s
.45051 .23485 m
.45687 .20944 L
s
.44993 .281 m
.45745 .25591 L
s
.44909 .32703 m
.45829 .3025 L
s
.44783 .37279 m
.45955 .34936 L
s
.44583 .41786 m
.46155 .3969 L
s
.44279 .46096 m
.46459 .44643 L
s
.44059 .5 m
.46679 .5 L
s
.44279 .53904 m
.46459 .55357 L
s
.44583 .58214 m
.46155 .6031 L
s
.44783 .62721 m
.45955 .65064 L
s
.44909 .67297 m
.45829 .6975 L
s
.44993 .719 m
.45745 .74409 L
s
.45051 .76515 m
.45687 .79056 L
s
.45095 .81136 m
.45644 .83697 L
s
.45128 .8576 m
.4561 .88335 L
s
.45154 .90386 m
.45584 .9297 L
s
.45175 .95014 m
.45563 .97605 L
s
.5 .05001 m
.5 .02381 L
s
.5 .09632 m
.5 .07012 L
s
.5 .14262 m
.5 .11643 L
s
.5 .18893 m
.5 .16274 L
s
.5 .23524 m
.5 .20905 L
s
.5 .28155 m
.5 .25536 L
s
.5 .32786 m
.5 .30166 L
s
.5 .37417 m
.5 .34797 L
s
.5 .42048 m
.5 .39428 L
s
.5 .46679 m
.5 .44059 L
s
newpath
.5 .5 .00655 0 365.73 arc
s
.5 .53321 m
.5 .55941 L
s
.5 .57952 m
.5 .60572 L
s
.5 .62583 m
.5 .65203 L
s
.5 .67214 m
.5 .69834 L
s
.5 .71845 m
.5 .74464 L
s
.5 .76476 m
.5 .79095 L
s
.5 .81107 m
.5 .83726 L
s
.5 .85738 m
.5 .88357 L
s
.5 .90368 m
.5 .92988 L
s
.5 .94999 m
.5 .97619 L
s
.54825 .04986 m
.54437 .02395 L
s
.54846 .09614 m
.54416 .0703 L
s
.54872 .1424 m
.5439 .11665 L
s
.54905 .18864 m
.54356 .16303 L
s
.54949 .23485 m
.54313 .20944 L
s
.55007 .281 m
.54255 .25591 L
s
.55091 .32703 m
.54171 .3025 L
s
.55217 .37279 m
.54045 .34936 L
s
.55417 .41786 m
.53845 .3969 L
s
.55721 .46096 m
.53541 .44643 L
s
.55941 .5 m
.53321 .5 L
s
.55721 .53904 m
.53541 .55357 L
s
.55417 .58214 m
.53845 .6031 L
s
.55217 .62721 m
.54045 .65064 L
s
.55091 .67297 m
.54171 .6975 L
s
.55007 .719 m
.54255 .74409 L
s
.54949 .76515 m
.54313 .79056 L
s
.54905 .81136 m
.54356 .83697 L
s
.54872 .8576 m
.5439 .88335 L
s
.54846 .90386 m
.54416 .9297 L
s
.54825 .95014 m
.54437 .97605 L
s
.59638 .04945 m
.58885 .02436 L
s
.59676 .09564 m
.58848 .07079 L
s
.59722 .14179 m
.58802 .11726 L
s
.59778 .18787 m
.58746 .1638 L
s
.59848 .23386 m
.58676 .21043 L
s
.59936 .27969 m
.58588 .25722 L
s
.60048 .32524 m
.58476 .30428 L
s
.60188 .37033 m
.58336 .35181 L
s
.60352 .41465 m
.58172 .40012 L
s
.60504 .45783 m
.58019 .44955 L
s
.60572 .5 m
.57952 .5 L
s
.60504 .54217 m
.58019 .55045 L
s
.60352 .58535 m
.58172 .59988 L
s
.60188 .62967 m
.58336 .64819 L
s
.60048 .67476 m
.58476 .69572 L
s
.59936 .72031 m
.58588 .74278 L
s
.59848 .76614 m
.58676 .78957 L
s
.59778 .81213 m
.58746 .8362 L
s
.59722 .85821 m
.58802 .88274 L
s
.59676 .90436 m
.58848 .92921 L
s
.59638 .95055 m
.58885 .97564 L
s
.6443 .04885 m
.63355 .02496 L
s
.64479 .09493 m
.63307 .0715 L
s
.64535 .14094 m
.63251 .11811 L
s
.64601 .18685 m
.63184 .16482 L
s
.64679 .23262 m
.63107 .21167 L
s
.64769 .27819 m
.63017 .25872 L
s
.64872 .32347 m
.62914 .30606 L
s
.64983 .36834 m
.62803 .35381 L
s
.6509 .4127 m
.62696 .40206 L
s
.65171 .45653 m
.62614 .45085 L
s
.65203 .5 m
.62583 .5 L
s
.65171 .54347 m
.62614 .54915 L
s
.6509 .5873 m
.62696 .59794 L
s
.64983 .63166 m
.62803 .64619 L
s
.64872 .67653 m
.62914 .69394 L
s
.64769 .72181 m
.63017 .74128 L
s
.64679 .76738 m
.63107 .78833 L
s
.64601 .81315 m
.63184 .83518 L
s
.64535 .85906 m
.63251 .88189 L
s
.64479 .90507 m
.63307 .9285 L
s
.6443 .95115 m
.63355 .97504 L
s
.69198 .04814 m
.6785 .02568 L
s
.6925 .09412 m
.67797 .07232 L
s
.6931 .14 m
.67738 .11905 L
s
.69376 .18578 m
.67671 .16589 L
s
.6945 .23141 m
.67598 .21288 L
s
.6953 .27684 m
.67517 .26007 L
s
.69614 .32203 m
.67434 .3075 L
s
.69695 .36693 m
.67352 .35521 L
s
.69766 .41152 m
.67281 .40324 L
s
.69816 .45584 m
.67232 .45154 L
s
.69834 .5 m
.67214 .5 L
s
.69816 .54416 m
.67232 .54846 L
s
.69766 .58848 m
.67281 .59676 L
s
.69695 .63307 m
.67352 .64479 L
s
.69614 .67797 m
.67434 .6925 L
s
.6953 .72316 m
.67517 .73993 L
s
.6945 .76859 m
.67598 .78712 L
s
.69376 .81422 m
.67671 .83411 L
s
.6931 .86 m
.67738 .88095 L
s
.6925 .90588 m
.67797 .92768 L
s
.69198 .95186 m
.6785 .97432 L
s
.73941 .04739 m
.72369 .02643 L
s
.73993 .09328 m
.72316 .07315 L
s
.7405 .13908 m
.72259 .11997 L
s
.74112 .18477 m
.72197 .1669 L
s
.74177 .23033 m
.72132 .21396 L
s
.74244 .27572 m
.72065 .26119 L
s
.7431 .32093 m
.71999 .3086 L
s
.74371 .36594 m
.71938 .35621 L
s
.7442 .41076 m
.71889 .40401 L
s
.74453 .45542 m
.71856 .45196 L
s
.74464 .5 m
.71845 .5 L
s
.74453 .54458 m
.71856 .54804 L
s
.7442 .58924 m
.71889 .59599 L
s
.74371 .63406 m
.71938 .64379 L
s
.7431 .67907 m
.71999 .6914 L
s
.74244 .72428 m
.72065 .73881 L
s
.74177 .76967 m
.72132 .78604 L
s
.74112 .81523 m
.72197 .8331 L
s
.7405 .86092 m
.72259 .88003 L
s
.73993 .90672 m
.72316 .92685 L
s
.73941 .95261 m
.72369 .97357 L
s
.78662 .04664 m
.76909 .02717 L
s
.78712 .09248 m
.76859 .07396 L
s
.78765 .13823 m
.76807 .12082 L
s
.78819 .18388 m
.76752 .16779 L
s
.78875 .22941 m
.76696 .21488 L
s
.78931 .27481 m
.76641 .26209 L
s
.78982 .32008 m
.76589 .30944 L
s
.79028 .36521 m
.76543 .35693 L
s
.79064 .41022 m
.76507 .40454 L
s
.79087 .45514 m
.76484 .45224 L
s
.79095 .5 m
.76476 .5 L
s
.79087 .54486 m
.76484 .54776 L
s
.79064 .58978 m
.76507 .59546 L
s
.79028 .63479 m
.76543 .64307 L
s
.78982 .67992 m
.76589 .69056 L
s
.78931 .72519 m
.76641 .73791 L
s
.78875 .77059 m
.76696 .78512 L
s
.78819 .81612 m
.76752 .83221 L
s
.78765 .86177 m
.76807 .87918 L
s
.78712 .90752 m
.76859 .92604 L
s
.78662 .95336 m
.76909 .97283 L
s
.83365 .04594 m
.81468 .02787 L
s
.83411 .09174 m
.81422 .07469 L
s
.83458 .13746 m
.81375 .12159 L
s
.83506 .1831 m
.81327 .16857 L
s
.83554 .22864 m
.81279 .21565 L
s
.83599 .27409 m
.81234 .26282 L
s
.8364 .31943 m
.81192 .3101 L
s
.83676 .36467 m
.81157 .35747 L
s
.83703 .40983 m
.8113 .40493 L
s
.8372 .45493 m
.81113 .45245 L
s
.83726 .5 m
.81107 .5 L
s
.8372 .54507 m
.81113 .54755 L
s
.83703 .59017 m
.8113 .59507 L
s
.83676 .63533 m
.81157 .64253 L
s
.8364 .68057 m
.81192 .6899 L
s
.83599 .72591 m
.81234 .73718 L
s
.83554 .77136 m
.81279 .78435 L
s
.83506 .8169 m
.81327 .83143 L
s
.83458 .86254 m
.81375 .87841 L
s
.83411 .90826 m
.81422 .92531 L
s
.83365 .95406 m
.81468 .97213 L
s
.88054 .04529 m
.86041 .02852 L
s
.88095 .09108 m
.86 .07536 L
s
.88137 .13679 m
.85958 .12226 L
s
.88179 .18244 m
.85916 .16924 L
s
.88219 .228 m
.85876 .21629 L
s
.88256 .27349 m
.85838 .26342 L
s
.8829 .31891 m
.85805 .31062 L
s
.88318 .36425 m
.85777 .3579 L
s
.88339 .40953 m
.85755 .40523 L
s
.88353 .45478 m
.85742 .4526 L
s
.88357 .5 m
.85738 .5 L
s
.88353 .54522 m
.85742 .5474 L
s
.88339 .59047 m
.85755 .59477 L
s
.88318 .63575 m
.85777 .6421 L
s
.8829 .68109 m
.85805 .68938 L
s
.88256 .72651 m
.85838 .73658 L
s
.88219 .772 m
.85876 .78371 L
s
.88179 .81756 m
.85916 .83076 L
s
.88137 .86321 m
.85958 .87774 L
s
.88095 .90892 m
.86 .92464 L
s
.88054 .95471 m
.86041 .97148 L
s
.92731 .0447 m
.90626 .02911 L
s
.92768 .09048 m
.90588 .07595 L
s
.92805 .1362 m
.90551 .12285 L
s
.92841 .18186 m
.90516 .16981 L
s
.92875 .22746 m
.90481 .21682 L
s
.92907 .273 m
.9045 .2639 L
s
.92934 .31848 m
.90422 .31104 L
s
.92957 .36391 m
.904 .35823 L
s
.92974 .4093 m
.90383 .40546 L
s
.92985 .45466 m
.90372 .45272 L
s
.92988 .5 m
.90368 .5 L
s
.92985 .54534 m
.90372 .54728 L
s
.92974 .5907 m
.90383 .59454 L
s
.92957 .63609 m
.904 .64177 L
s
.92934 .68152 m
.90422 .68896 L
s
.92907 .727 m
.9045 .7361 L
s
.92875 .77254 m
.90481 .78318 L
s
.92841 .81814 m
.90516 .83019 L
s
.92805 .8638 m
.90551 .87715 L
s
.92768 .90952 m
.90588 .92405 L
s
.92731 .9553 m
.90626 .97089 L
s
.97399 .04417 m
.95219 .02964 L
s
.97432 .08996 m
.95186 .07648 L
s
.97465 .13569 m
.95153 .12336 L
s
.97496 .18137 m
.95122 .1703 L
s
.97525 .22701 m
.95093 .21728 L
s
.97552 .2726 m
.95067 .26431 L
s
.97575 .31814 m
.95044 .31139 L
s
.97594 .36364 m
.95025 .3585 L
s
.97608 .40911 m
.95011 .40565 L
s
.97616 .45456 m
.95002 .45282 L
s
.97619 .5 m
.94999 .5 L
s
.97616 .54544 m
.95002 .54718 L
s
.97608 .59089 m
.95011 .59435 L
s
.97594 .63636 m
.95025 .6415 L
s
.97575 .68186 m
.95044 .68861 L
s
.97552 .7274 m
.95067 .73569 L
s
.97525 .77299 m
.95093 .78272 L
s
.97496 .81863 m
.95122 .8297 L
s
.97465 .86431 m
.95153 .87664 L
s
.97432 .91004 m
.95186 .92352 L
s
.97399 .95583 m
.95219 .97036 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00=?ooool3o`0002gooooo1Ol0000]ooooo`;o0000
;_ooool5o`0002oooooo0ol0000Sooooo`00=Oooool00ol0003oooooooooo`0]ooooo`04o`000?oo
ooooooooo`0002cooooo00Co0000oooooooooooo0000;_ooool01?l0003oooooooooool0000`oooo
o`03o`000?oooooooooo02;ooooo000/ooooo`Go000000?oooooo`000?l000000ol0000Wooooo`Go
00000oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0002oooooo00?o0000oooo
ooooool0;Oooool5o`0002?ooooo000booooo`04o`000?ooooooooooo`00037ooooo00?o0000oooo
ooooool0:oooool01?l0003oooooooooool0000`ooooo`03o`000?oooooooooo02cooooo00Co0000
oooooooooooo00009?ooool003?ooooo00?o0000ooooool00000;_ooool01Ol0003ooooooooooooo
oooo000002cooooo00Co0000oooooooooooo0000;Oooool01Ol0003ooooooooooooooooo000002ko
oooo00?o0000ooooool000009?ooool003Cooooo0_l0000^ooooo`05o`000?ooooooooooooooool0
0000;?ooool01?l0003oooooooooool0000]ooooo`05o`000?ooooooooooooooool00000;oooool2
o`0002Cooooo000eooooo`03o`000?oooooooooo02gooooo0ol0000^ooooo`;o0000;oooool3o`00
037ooooo00?o0000ooooooooool08_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000ooooooool0000Ao`00007ooooo000?ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo02oooooo
00?o0000ooooooooool08?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo05Cooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0
2Oooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo05Cooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`0Fooooo`03o`:XW_oooooooooo00Wooooo0_l2Z9h;ooooo`03o`:XW_oo
oooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oo
oooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oo
oooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oo
oooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03o`:XW_oo
oooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`;o0ZRN2ooo
ool2o`:XWQOooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`09ooooo`;o0ZRN2_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Sooooo00?o0ZRNooooooooool02Oooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`09ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool0
0ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool0
0ol2Z9koooooooooo`07ooooo`;o0ZRN2oooool1o`00007ooooo000?ooooo`;o00001oooool00ol0
003o0ZRNo`:XWP0;o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2
Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`000009o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`00000:o`000003o`:XW_l0003o000000So00000_l2Z9h8ooooo`;o00000Oooool000oo
oooo00?o0000ooooooooool01Oooool2o`:XWPco000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`000009o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko
0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol00002o`:XWPOo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`04o`:XW_oooooo0000o`0000[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00009olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI
0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0004Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI04Goc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<
i]T00ol2Z9koc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Kooooo0_l00010olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0?Oo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:X
W_l2Z9h02_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9ko0000ooooo`08ooooo`7o00000Oooool000oooooo0_l00007ooooo`;o0ZRN
2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@03o`00
0?l2Z9ko0ZRN00Oooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0
003o000000[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`000003ooooool2Z9kooooo00Kooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`04ooooo`04o`:XW_oooooo0000o`0000Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01Oo<i]T2o`0000;ooooo00?o0ZRNooooooooool01?ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Kooooo0_l0000_olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI02_oc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006ooc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI06coc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000IOo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI067oc>KI0_l00009ooooo`7o00000Oooool000So
oooo0ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0000WolcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI02Coc>KI0_l00009ooooo`7o00000Oooool000Wooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`06ooooo`;o000000?oc>KIo`:XW_l2Z9h0
2oo<i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h2o`0000Wooooo
0Ol00001ooooo`001Ol000000ooooooo0000o`000003o`0000Cooooo00?o0000ooooooooool01_oo
ool00ol0003o0ZRNo`:XWP0:olcVf@?o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI0_l2Z9h:olcVf@;o0ZRN2Oooool1o`00007ooooo0006ooooo`04o`000?oooooo
ooooo`0000Gooooo0ol00005ooooo`;o0ZRN00?o0000olcVfOo<i]T01oo<i]T2o`:XWPcoc>KI0_l2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@;o0ZRN3?o<i]T2o`:XWPSoc>KI0_l00002o`:XWPKooooo0_l00001ooooo`001oooool0
0ol0003oooooo`000005ooooo`03o`000?oooooooooo00Cooooo00Co0ZRNooooool0003o00002?o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@05olcVf@;o00000_ooool00ol2Z9koooooooooo`04ooooo`7o00000Ooo
ool000Sooooo0_l00005ooooo`03o`000?oooooooooo00Kooooo0_l0000EolcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T04_o<i]T2o`0000Wooooo0Ol00001ooooo`002Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo00Kooooo0_l0001EolcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
05;oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@19olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0000JolcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN
6Oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o000000?o
c>KIo`:XW_l2Z9h02oo<i]T2o`:XWPWoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@;o0ZRN2_o<i]T2o`:XWP;o00002Oooool1o`00007ooooo000?ooooo`;o00001oooool0
0ol0003o0ZRNo`:XWP0:olcVf@?o0ZRN2Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN3?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2
o`:XWP[oc>KI0_l2Z9h:olcVf@?o0ZRN1oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo
00Gooooo0_l2Z9h00ol0003oc>KIolcVf@07olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h8olcVf@;o000000?oooooo`:XW_l2Z9h01_ooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Cooooo00Co0ZRNooooool0003o00002?o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@05olcVf@;o00000oooool00ol2Z9koooooooooo`03ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0003_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0holcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001_olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@1/olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`00077oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:X
W_o<i]Woc>KI06koc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0004goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI04[oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`000003olcVfOl2Z9ko0ZRN00_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:
olcVf@;o0ZRN0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol0
003o0ZRNo`:XWP0:olcVf@?o0ZRN2_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T3o`:X
WPSooooo0Ol00001ooooo`003oooool2o`0000Kooooo0_l2Z9h00ol0003oc>KIolcVf@07olcVf@;o
0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWPSoc>KI0_l000000ooooooo
0ZRNo`:XWP05ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01?ooool01?l2Z9kooooo
o`000?l00008olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI0_l00003ooooo`03o`:XW_oooooooooo00?o
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00008_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T07_o<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000EOo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@1BolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000IOo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI06;oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
043oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:X
WP_oc>KI0_l2Z9hnolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l000000oo<i]Wo0ZRNo`:XWP0;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o
0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l2Z9h:olcVf@;o
0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@?o0ZRN00?o0000ooooooooool01oooool1o`00007o
oooo000?ooooo`;o00001oooool3o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T3o`:XWP[oc>KI
0_l2Z9h:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2_o<i]T3o`:XWP[oc>KI
0_l2Z9h:olcVf@?o0ZRN2_o<i]T01?l0003o0ZRNo`:XW_l2Z9h6ooooo`;o00000Oooool000oooooo
00?o0000ooooooooool01?ooool2o`:XWP;o00002Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN
2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN
2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2?o<i]T2o`0000;ooooo0_l2Z9h5ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0000Soc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000B?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0A?o<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000Koo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0K?o<i]T2o`00
00Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003o
c>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Kooooo1Ol00004ooooo`03
o`000?oooooooooo00Kooooo0_l0001VolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T0H_o<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0003oooooooooool00004ooooo`03
o`000?oooooooooo00Kooooo0_l0000colcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o
0ZRN2oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o
0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9hbolcVf@;o00002Oooool1o`00007ooooo0005o`0000?ooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`06ooooo`;o00000ol2Z9h:olcVf@?o0ZRN
2_o<i]T2o`:XWP[oc>KI0ol2Z9h8olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN
2oo<i]T2o`:XWPSoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h00ol0003ooooo
ooooo`07ooooo`7o00000Oooool000Wooooo00?o0000ooooooooool00oooool3o`0000Gooooo0ol2
Z9h:olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h9olcVf@;o0ZRN3?o<i]T2o`:XWP[oc>KI0_l2
Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPWoc>KI0ol2
Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWPWoc>KI00Co0000o`:XW_l2Z9ko0ZRN1_ooool2o`00007ooooo
0006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`03ooooo`;o0ZRN
00?oooooo`000?l000002?o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWPOoc>KI0_l00002ooooo`;o0ZRN1Oooool1o`00007ooooo
0006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`06ooooo`;o0000
>oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03Ooc>KI0_l00009ooooo`7o0000
0Oooool000Oooooo0ol00005ooooo`03o`000?oooooooooo00Kooooo0_l0001QolcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0G_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007;oc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI06koc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006Koc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@1SolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0000dolcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o
0ZRN2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o
0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9hbolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o0000
1oooool00ol0003o0ZRNo`:XWP02o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPSoc>KI
0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWPSoc>KI
1Ol2Z9h8olcVf@Go0ZRN1oo<i]T5o`:XWPSoc>KI1Ol2Z9h7ooooo`;o00000Oooool000oooooo00?o
0000ooooooooool00oooool4o`:XWP03o`000?o<i]Woc>KI00Koc>KI1?l2Z9h9olcVf@Co0ZRN2?o<
i]T4o`:XWP[oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2o`:XWP_oc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:X
W_l2Z9h5ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0002koc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T0:oo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000HOo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI05koc>KI0_l00009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0006koc>KI00?o0ZRNolcV
fOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI06_oc>KI0_l00009oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<
i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000
OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2
Z9koc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001bolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9ko
c>KIolcVf@1_olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001UolcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWVCoc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0001[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2
Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWPWoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@07olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2
Z9hHolcVf@;o00002Oooool1o`00007ooooo000?ooooo`;o00001oooool00ol0003o0ZRNo`:XWP02
o`:XWPWoc>KI1?l2Z9h7olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3
o`:XWP[oc>KI0ol2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T3
o`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h6olcVf@Go0ZRN2?o<i]T5
o`:XWPOooooo0_l00001ooooo`003oooool00ol0003oooooooooo`03ooooo`Co0ZRN00?o0000olcV
fOo<i]T01_o<i]T4o`:XWPWoc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcV
f@;o0ZRN2oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcV
f@;o0ZRN2Oo<i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`00067oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2
Z9koc>KIolcVf@1MolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001^olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@1[olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001molcVf@03o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1i
olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcV
f@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1iolcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`:XW_o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2
o`0006Koc>KI0_l2Z9h:olcVf@;o0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o0ZRN2_o<i]T2
o`:XWVGoc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol0
003o0ZRNo`:XWP02o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8olcV
f@Co0ZRN2Oo<i]T4o`:XWPSoc>KI1?l2Z9h8olcVf@?o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T3o`:XWPSoc>KI1Ol2Z9h7olcV
f@Go0ZRN2?o<i]T5o`:XWPSoc>KI1Ol2Z9h7olcVf@Go0ZRN2?o<i]T5o`:XWPOoc>KI1Ol2Z9h8olcV
f@Go0ZRN2?ooool1o`00007ooooo000?ooooo`;o00001?ooool4o`:XWP03o`000?o<i]Woc>KI00Ko
c>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8olcVf@Co0ZRN2Oo<i]T4o`:XWPSo
c>KI1?l2Z9h:olcVf@;o0ZRN3?o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPco
c>KI0_l2Z9h;olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[o
c>KI0ol2Z9h9olcVf@?o0ZRN1oo<i]T2o`000004ooooool2Z9ko0ZRNo`:XWPCooooo0_l00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000H?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI05goc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0006goc>KI00?o0ZRNolcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:X
W_o<i]Woc>KI06[oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007go
c>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000oooo
ooooool01_ooool2o`0007coc>KI0_l2Z9ikolcVf@;o00002Oooool1o`00007ooooo0007ooooo`04
o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01_ooool2o`0007_oc>KI00Co0ZRNolcV
fOl0003o0ZRNN_o<i]T2o`0000Wooooo0Ol00001ooooo`001oooool01?l0003oooooooooool00004
ooooo`?o00000oooool8o`:XWPGo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4
o`0000So0ZRN1Ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1Ol00008o`:XWPKo000000Co0ZRN
o`000?l0003o0ZRN1ol00008o`:XWPCo00002?l2Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2
Z9h5o`0000So0ZRN1?l00008o`:XWPGo00002?l2Z9h4o`0000So0ZRN1Ol00008o`:XWPCooooo0_l0
0001ooooo`001oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo0_l0
001kolcVf@;o0ZRN00?o0000o`:XW_o<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`001oooool0
1?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`:XW_o<
i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000Oooooo00Co0000oooooooooooo00001?oo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo0008ooooo`;o00001Oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001]olcVf@;o
0ZRN3_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o0ZRNK?o<i]T2o`0000Wooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`06ooooo`;o00005Oo<i]T5o`:XWPOoc>KI1Ol2Z9h8olcVf@Go0ZRN
1oo<i]T5o`:XWPSoc>KI1Ol2Z9h7olcVf@?o0ZRN2_o<i]T3o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0ol2Z9h:olcVf@?o0ZRN
2?o<i]T4o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9hColcVf@;o0000
2Oooool1o`00007ooooo000?ooooo`;o00001?ooool8o`:XWPGoc>KI2?l2Z9h:olcVf@?o0ZRN2Oo<
i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPOoc>KI0ol2Z9h:olcVf@?o0ZRN2_o<
i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN1oo<
i]T4o`:XWPWoc>KI1?l2Z9h9olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8olcVf@So0ZRN1Oo<
i]T8o`:XWPCooooo0_l00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000FOo<i]T2
o`:XWP_oc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T01oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWUSoc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01_ooool2o`0007?oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2
Z9koc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI073oc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0ZRNolcVfOo<i]T0NOo<i]T2o`0000Wo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KI
olcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0006koc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI06_oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`00067oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRNGoo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000>_o<i]T3o`:XWP[oc>KI0ol2Z9h:olcVf@;o0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T3
o`:XWSWoc>KI0_l00009ooooo`7o00000Oooool000oooooo0_l00004ooooo`Go0ZRN2?o<i]T5o`:X
WPSoc>KI1Ol2Z9h7olcVf@Go0ZRN2?o<i]T5o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T2o`:X
WPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0ol2Z9h9olcVf@?o0ZRN2Oo<i]T3o`:X
WPcoc>KI1?l2Z9h8olcVf@Co0ZRN2Oo<i]T4o`:XWPSoc>KI1?l2Z9h7olcVf@;o00001?l2Z9h4oooo
o`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0000?o0ZRN2_o<i]T3o`:XWP[o
c>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T2o`:XWP_o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWP[o
c>KI0_l2Z9h;olcVf@Co0ZRN2?o<i]T4o`:XWPWoc>KI1?l2Z9h8olcVf@Co0ZRN2Oo<i]T4o`:XWPWo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000F_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@1GolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001bolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcV
f@1_olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol2Z9koc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001QolcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T0G_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000Aoo<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9i6olcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00?ooooo0ol2Z9h2o`0000Soc>KI0ol2Z9h:olcVf@?o0ZRN
2Oo<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN3?o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN
2Oo<i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o00000Oooool000oooooo
0_l00007ooooo`?o0ZRN2_o<i]T3o`:XWP[oc>KI0ol2Z9h9olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI
0ol2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI
0ol2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h7ooooo`;o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`000003olcVfOl2Z9ko0ZRN00_oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<
i]T2o`:XWP_oc>KI0_l2Z9h2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06
ooooo`;o0000C_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T0B_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000L_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcV
fOo<i]T0K_o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o
0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T0
0ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`0006ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI06coc>KI0_l00009ooooo`7o00000Oooool000Kooooo
1Ol00004ooooo`03o`000?oooooooooo00Kooooo0_l0001DolcVf@;o0ZRN2oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0DOo<i]T2o`0000Wooooo
0Ol00001ooooo`001oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Kooooo
0_l00008olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI
0_l2Z9h;olcVf@;o0ZRN2Oo<i]T3o`:XWPOoc>KI0_l00009ooooo`7o00000Oooool000Sooooo00?o
0000ooooooooool01?ooool3o`0000?ooooo1Ol2Z9h;olcVf@?o0ZRN2Oo<i]T2o`:XWP[oc>KI0ol2
Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2
Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN2?o<i]T3o`:XWP[oc>KI0_l0
0004o`:XWPCooooo0_l00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo00Kooooo0_l00003o`:XWP_oc>KI0_l2Z9h9olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;o0ZRN2oo<i]T4o`:XWPWooooo0Ol00001
ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01_ooool2
o`0001_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0HolcVf@;o00002Oooool1
o`00007ooooo0006ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`06
ooooo`;o0000F_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1FolcVf@;o00002Oooool1o`00007ooooo0007oooo
o`?o00001Oooool00ol0003oooooooooo`06ooooo`;o0000LOo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0K_o<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o
00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`00
0?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_oo
ool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`:XW_o<i]Woc>KI
07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0005Go
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T0DOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`06ooooo`;o0000;_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h]olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Cooooo0ol2Z9h00ol0003oc>KIolcVf@06olcVf@?o0ZRN2_o<
i]T3o`:XWPWoc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<
i]T3o`:XWPOoc>KI0_l000001?oooooo0ZRNo`:XW_l2Z9h5ooooo`7o00000Oooool000oooooo0_l0
0007ooooo`04o`000?l2Z9ko0ZRNo`:XWPWoc>KI0ol2Z9h:olcVf@?o0ZRN2?o<i]T3o`:XWP_oc>KI
0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@?o0ZRN2Oo<i]T3o`:XWPWoc>KI
0ol2Z9h:olcVf@?o0ZRN1oooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
0002olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2
Z9h2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000:?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T09Oo<i]T2
o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000FOo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@1FolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo0_l0001molcVf@03o`:XW_o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcV
f@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001m
olcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000H_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI05ooc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0003_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI03Soc>KI0_l00009ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01?ooool2o`:XWP;o00002?o<i]T2o`:XWP_oc>KI0_l2
Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN1oo<i]T2o`0000;ooooo0_l2
Z9h5ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`:XWP[oc>KI0ol2Z9h:
olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@;o0ZRN2Oo<i]T01?l0003o0ZRNo`:XW_l2Z9h7ooooo`7o00000Oooool000oooooo0_l00007
ooooo`;o00000_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0_l2Z9h9olcVf@;o0ZRN3?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T2
o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN00?o0000ooooooooool01_ooool2o`00007ooooo000?oooo
o`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T01?l2Z9koc>KIo`000?l00009ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01_ooool2o`0003Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0<Oo<i]T2o`0000Wooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`06ooooo`;o0000IOo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI06;oc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Wo
c>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`00
07goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00018olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@15olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0000EolcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2
Z9h:olcVf@;o0ZRN5?o<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04
ooooo`;o0ZRN0_l00008olcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI0_l2Z9h7olcVf@;o00000_ooool2o`:XWPGooooo0Ol00001ooooo`003oooool2o`00
00Oooooo0_l2Z9h:olcVf@?o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:X
WPcoc>KI0_l2Z9h9olcVf@04o`000?l2Z9ko0ZRNo`:XWPKooooo0_l00001ooooo`003oooool00ol0
003oooooooooo`06ooooo`;o00000_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h:olcVf@;o0ZRN00?o0000ooooooooool01oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KIo`000?l00009ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01_ooool2o`00043oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0molcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo
0_l0001aolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KI
olcVf@1^olcVf@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0
001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0006;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1OolcVf@;o0000
2Oooool1o`00007ooooo0008ooooo`?o00001?ooool00ol0003oooooooooo`06ooooo`;o0000;oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWRgoc>KI0_l00009ooooo`7o00000Oooool000Wooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`04ooooo`;o0ZRN0_l00008olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h<
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWPOoc>KI0_l00000
0ooooooo0ZRNo`:XWP06ooooo`7o00000Oooool000Kooooo1Ol00004ooooo`03o`000?oooooooooo
00Kooooo0_l2Z9h:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ol0003o0ZRNo`:XWP08ooooo`7o00000Oooool000Ko
oooo00Co0000oooooooooooo00001Oooool3o`0000Kooooo0_l00002o`:XWP[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T2o`:XWP03o`000?oooooooooo
00Kooooo0_l00001ooooo`001oooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00Ko
oooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04o`:XW_o<i]Wo0000o`00
00Wooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000ooooooooool01_ooool2o`0000oo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T2o`0000Wooooo0Ol00001ooooo`002Oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo00Kooooo0_l0001<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@19olcVf@;o00002Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l0
0009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000
olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06oooo
o`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Kooooo0_l0001molcVf@03o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0
NOo<i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000B?o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0AOo<
i]T2o`0000Wooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`06ooooo`;o00002Oo<i]T2
o`:XWP[oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWPOoc>KI0_l00009ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01?ooool2o`:XWP;o00002oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcV
f@;o000000?oooooo`:XW_l2Z9h01_ooool1o`00007ooooo000?ooooo`;o00001oooool2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T00ol0003o
0ZRNo`:XWP07ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool2o`0000;o0ZRN
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN00?o0000ooooooooool01oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Kooooo0_l00002olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KIo`000?l00009ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01_ooool2o`0002Ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI02Coc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01_ooool2o`0005Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0EOo<i]T2o`0000Wooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcV
f@;o00002Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001molcVf@03
o`000?o<i]Woc>KI07Woc>KI0_l00009ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1_ooool2o`0007goc>KI00?o0000olcVfOo<i]T0NOo<i]T2o`0000Wooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`06ooooo`;o0000OOo<i]T00ol0003oc>KIolcVf@1iolcVf@;o00002Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0001`olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1/olcVf@;o00002Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Kooooo0_l0000RolcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0OolcVf@;o00002Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Cooooo0_l2Z9h2o`0000Woc>KI0_l2Z9h:olcVf@;o
0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h7olcVf@;o000000?oooooo`:XW_l2Z9h01_ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Kooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@07olcVf@;o000000?o0ZRNooooooooool01_ooool1o`00007ooooo000?ooooo`;o00001ooo
ool00ol0003o0ZRNo`:XWP0;o`000003o`:XW_l0003o000000Wo00000_l2Z9h;o`000003o`:XW_l0
003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0
003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0
003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0
003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0
003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009o`0000;o0ZRN2ol0
0002o`:XWP[o00000_l2Z9h8ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01_ooool3
o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009
o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:
o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:
o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:
o`000003o`:XW_l0003o000000Wo000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009
o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002?l000000ol2Z9ko0000o`000009
o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`000009
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool02_ooool00ol2Z9koooooooooo`09oooo
o`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09oooo
o`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09oooo
o`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09oooo
o`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:oooo
o`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:oooo
o`03o`:XW_oooooooooo00Sooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`0:oooo
o`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo03cooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02Oooool00ol2Z9koooooooooo`09ooooo`03
o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool0>oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo023o
oooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo02oo
oooo00?o0000ooooooooool0;oooool00ol0003oooooooooo`0Pooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool01oooool1o`00007ooooo000?oooooooo00004Ol00001ooooo`00oooooolQ
ooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-6.01076, -5.95359, 0.039771, \
0.039771}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 0.5. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{k, 3}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), 3}, {\(-4\), 3}, {\(-3\), 3}, {\(-2\), 3}, {\(-1\), 3}, {0, 
        3}, {1, 3}, {2, 3}, {3, 3}, {4, 3}, {5, 3}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(t2 = Table[{k, \(-3\)}, {k, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), \(-3\)}, {\(-4\), \(-3\)}, {\(-3\), \(-3\)}, {\(-2\), \
\(-3\)}, {\(-1\), \(-3\)}, {0, \(-3\)}, {1, \(-3\)}, {2, \(-3\)}, {3, \
\(-3\)}, {4, \(-3\)}, {5, \(-3\)}}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(thePoints = Join[t1, t2];\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Produce Final Output", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayAll;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[.1 -0.0125 -6 -9 ]
[.1 -0.0125 6 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7 -0.0125 -3 -9 ]
[.7 -0.0125 3 0 ]
[.9 -0.0125 -3 -9 ]
[.9 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .1 -12 -4.5 ]
[-0.0125 .1 0 4.5 ]
[-0.0125 .3 -12 -4.5 ]
[-0.0125 .3 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7 -6 -4.5 ]
[-0.0125 .7 0 4.5 ]
[-0.0125 .9 -6 -4.5 ]
[-0.0125 .9 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1 0 m
.1 .00625 L
s
[(-4)] .1 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-2)] .3 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(2)] .7 -0.0125 0 1 Mshowa
.9 0 m
.9 .00625 L
s
[(4)] .9 -0.0125 0 1 Mshowa
.125 Mabswid
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.25 0 m
.25 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.75 0 m
.75 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.05 0 m
.05 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .1 m
.00625 .1 L
s
[(-4)] -0.0125 .1 1 0 Mshowa
0 .3 m
.00625 .3 L
s
[(-2)] -0.0125 .3 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7 m
.00625 .7 L
s
[(2)] -0.0125 .7 1 0 Mshowa
0 .9 m
.00625 .9 L
s
[(4)] -0.0125 .9 1 0 Mshowa
.125 Mabswid
0 .15 m
.00375 .15 L
s
0 .2 m
.00375 .2 L
s
0 .25 m
.00375 .25 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .45 m
.00375 .45 L
s
0 .55 m
.00375 .55 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .75 m
.00375 .75 L
s
0 .8 m
.00375 .8 L
s
0 .85 m
.00375 .85 L
s
0 .05 m
.00375 .05 L
s
0 .95 m
.00375 .95 L
s
.25 Mabswid
0 0 m
0 1 L
s
.1 .99375 m
.1 1 L
s
.3 .99375 m
.3 1 L
s
.5 .99375 m
.5 1 L
s
.7 .99375 m
.7 1 L
s
.9 .99375 m
.9 1 L
s
.125 Mabswid
.15 .99625 m
.15 1 L
s
.2 .99625 m
.2 1 L
s
.25 .99625 m
.25 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.45 .99625 m
.45 1 L
s
.55 .99625 m
.55 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.75 .99625 m
.75 1 L
s
.8 .99625 m
.8 1 L
s
.85 .99625 m
.85 1 L
s
.05 .99625 m
.05 1 L
s
.95 .99625 m
.95 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .1 m
1 .1 L
s
.99375 .3 m
1 .3 L
s
.99375 .5 m
1 .5 L
s
.99375 .7 m
1 .7 L
s
.99375 .9 m
1 .9 L
s
.125 Mabswid
.99625 .15 m
1 .15 L
s
.99625 .2 m
1 .2 L
s
.99625 .25 m
1 .25 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .45 m
1 .45 L
s
.99625 .55 m
1 .55 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .75 m
1 .75 L
s
.99625 .8 m
1 .8 L
s
.99625 .85 m
1 .85 L
s
.99625 .05 m
1 .05 L
s
.99625 .95 m
1 .95 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
0 .05 m
.01213 .04272 L
s
0 .1 m
.01248 .09334 L
s
0 .15 m
.01282 .14402 L
s
0 .2 m
.01313 .19475 L
s
0 .25 m
.01342 .24553 L
s
0 .3 m
.01366 .29636 L
s
0 .35 m
.01387 .34723 L
s
0 .4 m
.01402 .39813 L
s
0 .45 m
.01411 .44906 L
s
0 .5 m
.01414 .5 L
s
0 .55 m
.01411 .55094 L
s
0 .6 m
.01402 .60187 L
s
0 .65 m
.01387 .65277 L
s
0 .7 m
.01366 .70364 L
s
0 .75 m
.01342 .75447 L
s
0 .8 m
.01313 .80525 L
s
0 .85 m
.01282 .85598 L
s
0 .9 m
.01248 .90666 L
s
0 .95 m
.01213 .95728 L
s
0 1 m
0 1 L
s
.03864 .00842 m
0 0 rlineto s
.03864 .00842 m
.05 0 L
s
.03823 .05784 m
.06177 .04216 L
s
.03783 .10721 m
.06217 .09279 L
s
.03745 .15651 m
.06255 .14349 L
s
.03708 .20574 m
.06292 .19426 L
s
.03674 .25491 m
.06326 .24509 L
s
.03644 .30402 m
.06356 .29598 L
s
.03619 .35307 m
.06381 .34693 L
s
.03601 .40207 m
.06399 .39793 L
s
.0359 .45104 m
.0641 .44896 L
s
.03586 .5 m
.06414 .5 L
s
.0359 .54896 m
.0641 .55104 L
s
.03601 .59793 m
.06399 .60207 L
s
.03619 .64693 m
.06381 .65307 L
s
.03644 .69598 m
.06356 .70402 L
s
.03674 .74509 m
.06326 .75491 L
s
.03708 .79426 m
.06292 .80574 L
s
.03745 .84349 m
.06255 .85651 L
s
.03783 .89279 m
.06217 .90721 L
s
.03823 .94216 m
.06177 .95784 L
s
.03864 .99158 m
0 0 rlineto s
.03864 .99158 m
.05 1 L
s
.08914 .00905 m
0 0 rlineto s
.08914 .00905 m
.1 0 L
s
.08869 .05849 m
.11131 .04151 L
s
.08823 .10784 m
.11177 .09216 L
s
.08778 .15713 m
.11222 .14287 L
s
.08735 .20632 m
.11265 .19368 L
s
.08695 .25544 m
.11305 .24456 L
s
.08658 .30447 m
.11342 .29553 L
s
.08628 .35343 m
.11372 .34657 L
s
.08605 .40232 m
.11395 .39768 L
s
.08591 .45117 m
.11409 .44883 L
s
.08586 .5 m
.11414 .5 L
s
.08591 .54883 m
.11409 .55117 L
s
.08605 .59768 m
.11395 .60232 L
s
.08628 .64657 m
.11372 .65343 L
s
.08658 .69553 m
.11342 .70447 L
s
.08695 .74456 m
.11305 .75544 L
s
.08735 .79368 m
.11265 .80632 L
s
.08778 .84287 m
.11222 .85713 L
s
.08823 .89216 m
.11177 .90784 L
s
.08869 .94151 m
.11131 .95849 L
s
.08914 .99095 m
0 0 rlineto s
.08914 .99095 m
.1 1 L
s
.13976 .00975 m
0 0 rlineto s
.13976 .00975 m
.15 0 L
s
.13926 .0592 m
.16074 .0408 L
s
.13875 .10857 m
.16125 .09143 L
s
.13823 .15784 m
.16177 .14216 L
s
.13772 .20702 m
.16228 .19298 L
s
.13723 .25608 m
.16277 .24392 L
s
.13678 .30503 m
.16322 .29497 L
s
.1364 .35389 m
.1636 .34611 L
s
.13611 .40265 m
.16389 .39735 L
s
.13592 .45134 m
.16408 .44866 L
s
.13586 .5 m
.16414 .5 L
s
.13592 .54866 m
.16408 .55134 L
s
.13611 .59735 m
.16389 .60265 L
s
.1364 .64611 m
.1636 .65389 L
s
.13678 .69497 m
.16322 .70503 L
s
.13723 .74392 m
.16277 .75608 L
s
.13772 .79298 m
.16228 .80702 L
s
.13823 .84216 m
.16177 .85784 L
s
.13875 .89143 m
.16125 .90857 L
s
.13926 .9408 m
.16074 .9592 L
s
.13976 .99025 m
0 0 rlineto s
.13976 .99025 m
.15 1 L
s
.19054 .01051 m
0 0 rlineto s
.19054 .01051 m
.2 0 L
s
.19 .06 m
.21 .04 L
s
.18943 .1094 m
.21057 .0906 L
s
.18884 .15868 m
.21116 .14132 L
s
.18823 .20784 m
.21177 .19216 L
s
.18764 .25687 m
.21236 .24313 L
s
.18708 .30574 m
.21292 .29426 L
s
.18658 .35447 m
.21342 .34553 L
s
.18619 .40307 m
.21381 .39693 L
s
.18594 .45156 m
.21406 .44844 L
s
.18586 .5 m
.21414 .5 L
s
.18594 .54844 m
.21406 .55156 L
s
.18619 .59693 m
.21381 .60307 L
s
.18658 .64553 m
.21342 .65447 L
s
.18708 .69426 m
.21292 .70574 L
s
.18764 .74313 m
.21236 .75687 L
s
.18823 .79216 m
.21177 .80784 L
s
.18884 .84132 m
.21116 .85868 L
s
.18943 .8906 m
.21057 .9094 L
s
.19 .94 m
.21 .96 L
s
.19054 .98949 m
0 0 rlineto s
.19054 .98949 m
.2 1 L
s
.24151 .01131 m
0 0 rlineto s
.24151 .01131 m
.25 0 L
s
.24095 .06086 m
.25905 .03914 L
s
.24033 .11032 m
.25967 .08968 L
s
.23966 .15965 m
.26034 .14035 L
s
.23896 .20883 m
.26104 .19117 L
s
.23823 .25784 m
.26177 .24216 L
s
.23752 .30666 m
.26248 .29334 L
s
.23687 .35525 m
.26313 .34475 L
s
.23634 .40364 m
.26366 .39636 L
s
.23598 .45187 m
.26402 .44813 L
s
.23586 .5 m
.26414 .5 L
s
.23598 .54813 m
.26402 .55187 L
s
.23634 .59636 m
.26366 .60364 L
s
.23687 .64475 m
.26313 .65525 L
s
.23752 .69334 m
.26248 .70666 L
s
.23823 .74216 m
.26177 .75784 L
s
.23896 .79117 m
.26104 .80883 L
s
.23966 .84035 m
.26034 .85965 L
s
.24033 .88968 m
.25967 .91032 L
s
.24095 .93914 m
.25905 .96086 L
s
.24151 .98869 m
0 0 rlineto s
.24151 .98869 m
.25 1 L
s
.29272 .01213 m
0 0 rlineto s
.29272 .01213 m
.3 0 L
s
.29216 .06177 m
.30784 .03823 L
s
.29151 .11131 m
.30849 .08869 L
s
.2908 .16074 m
.3092 .13926 L
s
.29 .21 m
.31 .19 L
s
.28914 .25905 m
.31086 .24095 L
s
.28823 .30784 m
.31177 .29216 L
s
.28735 .35632 m
.31265 .34368 L
s
.28658 .40447 m
.31342 .39553 L
s
.28605 .45232 m
.31395 .44768 L
s
.28586 .5 m
.31414 .5 L
s
.28605 .54768 m
.31395 .55232 L
s
.28658 .59553 m
.31342 .60447 L
s
.28735 .64368 m
.31265 .65632 L
s
.28823 .69216 m
.31177 .70784 L
s
.28914 .74095 m
.31086 .75905 L
s
.29 .79 m
.31 .81 L
s
.2908 .83926 m
.3092 .86074 L
s
.29151 .88869 m
.30849 .91131 L
s
.29216 .93823 m
.30784 .96177 L
s
.29272 .98787 m
0 0 rlineto s
.29272 .98787 m
.3 1 L
s
.3442 .0129 m
0 0 rlineto s
.3442 .0129 m
.35 0 L
s
.34368 .06265 m
.35632 .03735 L
s
.34307 .11233 m
.35693 .08767 L
s
.34235 .1619 m
.35765 .1381 L
s
.34151 .21131 m
.35849 .18869 L
s
.34054 .26051 m
.35946 .23949 L
s
.33943 .3094 m
.36057 .2906 L
s
.33823 .35784 m
.36177 .34216 L
s
.33708 .40574 m
.36292 .39426 L
s
.33619 .45307 m
.36381 .44693 L
s
.33586 .5 m
.36414 .5 L
s
.33619 .54693 m
.36381 .55307 L
s
.33708 .59426 m
.36292 .60574 L
s
.33823 .64216 m
.36177 .65784 L
s
.33943 .6906 m
.36057 .7094 L
s
.34054 .73949 m
.35946 .76051 L
s
.34151 .78869 m
.35849 .81131 L
s
.34235 .8381 m
.35765 .8619 L
s
.34307 .88767 m
.35693 .91233 L
s
.34368 .93735 m
.35632 .96265 L
s
.3442 .9871 m
0 0 rlineto s
.3442 .9871 m
.35 1 L
s
.39594 .01355 m
0 0 rlineto s
.39594 .01355 m
.4 0 L
s
.39553 .06342 m
.40447 .03658 L
s
.39503 .11324 m
.40497 .08676 L
s
.39443 .163 m
.40557 .137 L
s
.39368 .21265 m
.40632 .18735 L
s
.39272 .26213 m
.40728 .23787 L
s
.39151 .31131 m
.40849 .28869 L
s
.39 .36 m
.41 .34 L
s
.38823 .40784 m
.41177 .39216 L
s
.38658 .45447 m
.41342 .44553 L
s
.38586 .5 m
.41414 .5 L
s
.38658 .54553 m
.41342 .55447 L
s
.38823 .59216 m
.41177 .60784 L
s
.39 .64 m
.41 .66 L
s
.39151 .68869 m
.40849 .71131 L
s
.39272 .73787 m
.40728 .76213 L
s
.39368 .78735 m
.40632 .81265 L
s
.39443 .837 m
.40557 .863 L
s
.39503 .88676 m
.40497 .91324 L
s
.39553 .93658 m
.40447 .96342 L
s
.39594 .98645 m
0 0 rlineto s
.39594 .98645 m
.4 1 L
s
.4479 .01399 m
0 0 rlineto s
.4479 .01399 m
.45 0 L
s
.44768 .06395 m
.45232 .03605 L
s
.44739 .1139 m
.45261 .0861 L
s
.44704 .16383 m
.45296 .13617 L
s
.44657 .21372 m
.45343 .18628 L
s
.44594 .26355 m
.45406 .23645 L
s
.44503 .31324 m
.45497 .28676 L
s
.44368 .36265 m
.45632 .33735 L
s
.44151 .41131 m
.45849 .38869 L
s
.43823 .45784 m
.46177 .44216 L
s
.43586 .5 m
.46414 .5 L
s
.43823 .54216 m
.46177 .55784 L
s
.44151 .58869 m
.45849 .61131 L
s
.44368 .63735 m
.45632 .66265 L
s
.44503 .68676 m
.45497 .71324 L
s
.44594 .73645 m
.45406 .76355 L
s
.44657 .78628 m
.45343 .81372 L
s
.44704 .83617 m
.45296 .86383 L
s
.44739 .8861 m
.45261 .9139 L
s
.44768 .93605 m
.45232 .96395 L
s
.4479 .98601 m
0 0 rlineto s
.4479 .98601 m
.45 1 L
s
.5 .01414 m
0 0 rlineto s
.5 .01414 m
.5 0 L
s
.5 .06414 m
.5 .03586 L
s
.5 .11414 m
.5 .08586 L
s
.5 .16414 m
.5 .13586 L
s
.5 .21414 m
.5 .18586 L
s
.5 .26414 m
.5 .23586 L
s
.5 .31414 m
.5 .28586 L
s
.5 .36414 m
.5 .33586 L
s
.5 .41414 m
.5 .38586 L
s
.5 .46414 m
.5 .43586 L
s
newpath
.5 .5 .00707 0 365.73 arc
s
.5 .53586 m
.5 .56414 L
s
.5 .58586 m
.5 .61414 L
s
.5 .63586 m
.5 .66414 L
s
.5 .68586 m
.5 .71414 L
s
.5 .73586 m
.5 .76414 L
s
.5 .78586 m
.5 .81414 L
s
.5 .83586 m
.5 .86414 L
s
.5 .88586 m
.5 .91414 L
s
.5 .93586 m
.5 .96414 L
s
.5 .98586 m
0 0 rlineto s
.5 .98586 m
.5 1 L
s
.5521 .01399 m
0 0 rlineto s
.5521 .01399 m
.55 0 L
s
.55232 .06395 m
.54768 .03605 L
s
.55261 .1139 m
.54739 .0861 L
s
.55296 .16383 m
.54704 .13617 L
s
.55343 .21372 m
.54657 .18628 L
s
.55406 .26355 m
.54594 .23645 L
s
.55497 .31324 m
.54503 .28676 L
s
.55632 .36265 m
.54368 .33735 L
s
.55849 .41131 m
.54151 .38869 L
s
.56177 .45784 m
.53823 .44216 L
s
.56414 .5 m
.53586 .5 L
s
.56177 .54216 m
.53823 .55784 L
s
.55849 .58869 m
.54151 .61131 L
s
.55632 .63735 m
.54368 .66265 L
s
.55497 .68676 m
.54503 .71324 L
s
.55406 .73645 m
.54594 .76355 L
s
.55343 .78628 m
.54657 .81372 L
s
.55296 .83617 m
.54704 .86383 L
s
.55261 .8861 m
.54739 .9139 L
s
.55232 .93605 m
.54768 .96395 L
s
.5521 .98601 m
0 0 rlineto s
.5521 .98601 m
.55 1 L
s
.60406 .01355 m
0 0 rlineto s
.60406 .01355 m
.6 0 L
s
.60447 .06342 m
.59553 .03658 L
s
.60497 .11324 m
.59503 .08676 L
s
.60557 .163 m
.59443 .137 L
s
.60632 .21265 m
.59368 .18735 L
s
.60728 .26213 m
.59272 .23787 L
s
.60849 .31131 m
.59151 .28869 L
s
.61 .36 m
.59 .34 L
s
.61177 .40784 m
.58823 .39216 L
s
.61342 .45447 m
.58658 .44553 L
s
.61414 .5 m
.58586 .5 L
s
.61342 .54553 m
.58658 .55447 L
s
.61177 .59216 m
.58823 .60784 L
s
.61 .64 m
.59 .66 L
s
.60849 .68869 m
.59151 .71131 L
s
.60728 .73787 m
.59272 .76213 L
s
.60632 .78735 m
.59368 .81265 L
s
.60557 .837 m
.59443 .863 L
s
.60497 .88676 m
.59503 .91324 L
s
.60447 .93658 m
.59553 .96342 L
s
.60406 .98645 m
0 0 rlineto s
.60406 .98645 m
.6 1 L
s
.6558 .0129 m
0 0 rlineto s
.6558 .0129 m
.65 0 L
s
.65632 .06265 m
.64368 .03735 L
s
.65693 .11233 m
.64307 .08767 L
s
.65765 .1619 m
.64235 .1381 L
s
.65849 .21131 m
.64151 .18869 L
s
.65946 .26051 m
.64054 .23949 L
s
.66057 .3094 m
.63943 .2906 L
s
.66177 .35784 m
.63823 .34216 L
s
.66292 .40574 m
.63708 .39426 L
s
.66381 .45307 m
.63619 .44693 L
s
.66414 .5 m
.63586 .5 L
s
.66381 .54693 m
.63619 .55307 L
s
.66292 .59426 m
.63708 .60574 L
s
.66177 .64216 m
.63823 .65784 L
s
.66057 .6906 m
.63943 .7094 L
s
.65946 .73949 m
.64054 .76051 L
s
.65849 .78869 m
.64151 .81131 L
s
.65765 .8381 m
.64235 .8619 L
s
.65693 .88767 m
.64307 .91233 L
s
.65632 .93735 m
.64368 .96265 L
s
.6558 .9871 m
0 0 rlineto s
.6558 .9871 m
.65 1 L
s
.70728 .01213 m
0 0 rlineto s
.70728 .01213 m
.7 0 L
s
.70784 .06177 m
.69216 .03823 L
s
.70849 .11131 m
.69151 .08869 L
s
.7092 .16074 m
.6908 .13926 L
s
.71 .21 m
.69 .19 L
s
.71086 .25905 m
.68914 .24095 L
s
.71177 .30784 m
.68823 .29216 L
s
.71265 .35632 m
.68735 .34368 L
s
.71342 .40447 m
.68658 .39553 L
s
.71395 .45232 m
.68605 .44768 L
s
.71414 .5 m
.68586 .5 L
s
.71395 .54768 m
.68605 .55232 L
s
.71342 .59553 m
.68658 .60447 L
s
.71265 .64368 m
.68735 .65632 L
s
.71177 .69216 m
.68823 .70784 L
s
.71086 .74095 m
.68914 .75905 L
s
.71 .79 m
.69 .81 L
s
.7092 .83926 m
.6908 .86074 L
s
.70849 .88869 m
.69151 .91131 L
s
.70784 .93823 m
.69216 .96177 L
s
.70728 .98787 m
0 0 rlineto s
.70728 .98787 m
.7 1 L
s
.75849 .01131 m
0 0 rlineto s
.75849 .01131 m
.75 0 L
s
.75905 .06086 m
.74095 .03914 L
s
.75967 .11032 m
.74033 .08968 L
s
.76034 .15965 m
.73966 .14035 L
s
.76104 .20883 m
.73896 .19117 L
s
.76177 .25784 m
.73823 .24216 L
s
.76248 .30666 m
.73752 .29334 L
s
.76313 .35525 m
.73687 .34475 L
s
.76366 .40364 m
.73634 .39636 L
s
.76402 .45187 m
.73598 .44813 L
s
.76414 .5 m
.73586 .5 L
s
.76402 .54813 m
.73598 .55187 L
s
.76366 .59636 m
.73634 .60364 L
s
.76313 .64475 m
.73687 .65525 L
s
.76248 .69334 m
.73752 .70666 L
s
.76177 .74216 m
.73823 .75784 L
s
.76104 .79117 m
.73896 .80883 L
s
.76034 .84035 m
.73966 .85965 L
s
.75967 .88968 m
.74033 .91032 L
s
.75905 .93914 m
.74095 .96086 L
s
.75849 .98869 m
0 0 rlineto s
.75849 .98869 m
.75 1 L
s
.80946 .01051 m
0 0 rlineto s
.80946 .01051 m
.8 0 L
s
.81 .06 m
.79 .04 L
s
.81057 .1094 m
.78943 .0906 L
s
.81116 .15868 m
.78884 .14132 L
s
.81177 .20784 m
.78823 .19216 L
s
.81236 .25687 m
.78764 .24313 L
s
.81292 .30574 m
.78708 .29426 L
s
.81342 .35447 m
.78658 .34553 L
s
.81381 .40307 m
.78619 .39693 L
s
.81406 .45156 m
.78594 .44844 L
s
.81414 .5 m
.78586 .5 L
s
.81406 .54844 m
.78594 .55156 L
s
.81381 .59693 m
.78619 .60307 L
s
.81342 .64553 m
.78658 .65447 L
s
.81292 .69426 m
.78708 .70574 L
s
.81236 .74313 m
.78764 .75687 L
s
.81177 .79216 m
.78823 .80784 L
s
.81116 .84132 m
.78884 .85868 L
s
.81057 .8906 m
.78943 .9094 L
s
.81 .94 m
.79 .96 L
s
.80946 .98949 m
0 0 rlineto s
.80946 .98949 m
.8 1 L
s
.86024 .00975 m
0 0 rlineto s
.86024 .00975 m
.85 0 L
s
.86074 .0592 m
.83926 .0408 L
s
.86125 .10857 m
.83875 .09143 L
s
.86177 .15784 m
.83823 .14216 L
s
.86228 .20702 m
.83772 .19298 L
s
.86277 .25608 m
.83723 .24392 L
s
.86322 .30503 m
.83678 .29497 L
s
.8636 .35389 m
.8364 .34611 L
s
.86389 .40265 m
.83611 .39735 L
s
.86408 .45134 m
.83592 .44866 L
s
.86414 .5 m
.83586 .5 L
s
.86408 .54866 m
.83592 .55134 L
s
.86389 .59735 m
.83611 .60265 L
s
.8636 .64611 m
.8364 .65389 L
s
.86322 .69497 m
.83678 .70503 L
s
.86277 .74392 m
.83723 .75608 L
s
.86228 .79298 m
.83772 .80702 L
s
.86177 .84216 m
.83823 .85784 L
s
.86125 .89143 m
.83875 .90857 L
s
.86074 .9408 m
.83926 .9592 L
s
.86024 .99025 m
0 0 rlineto s
.86024 .99025 m
.85 1 L
s
.91086 .00905 m
0 0 rlineto s
.91086 .00905 m
.9 0 L
s
.91131 .05849 m
.88869 .04151 L
s
.91177 .10784 m
.88823 .09216 L
s
.91222 .15713 m
.88778 .14287 L
s
.91265 .20632 m
.88735 .19368 L
s
.91305 .25544 m
.88695 .24456 L
s
.91342 .30447 m
.88658 .29553 L
s
.91372 .35343 m
.88628 .34657 L
s
.91395 .40232 m
.88605 .39768 L
s
.91409 .45117 m
.88591 .44883 L
s
.91414 .5 m
.88586 .5 L
s
.91409 .54883 m
.88591 .55117 L
s
.91395 .59768 m
.88605 .60232 L
s
.91372 .64657 m
.88628 .65343 L
s
.91342 .69553 m
.88658 .70447 L
s
.91305 .74456 m
.88695 .75544 L
s
.91265 .79368 m
.88735 .80632 L
s
.91222 .84287 m
.88778 .85713 L
s
.91177 .89216 m
.88823 .90784 L
s
.91131 .94151 m
.88869 .95849 L
s
.91086 .99095 m
0 0 rlineto s
.91086 .99095 m
.9 1 L
s
.96136 .00842 m
0 0 rlineto s
.96136 .00842 m
.95 0 L
s
.96177 .05784 m
.93823 .04216 L
s
.96217 .10721 m
.93783 .09279 L
s
.96255 .15651 m
.93745 .14349 L
s
.96292 .20574 m
.93708 .19426 L
s
.96326 .25491 m
.93674 .24509 L
s
.96356 .30402 m
.93644 .29598 L
s
.96381 .35307 m
.93619 .34693 L
s
.96399 .40207 m
.93601 .39793 L
s
.9641 .45104 m
.9359 .44896 L
s
.96414 .5 m
.93586 .5 L
s
.9641 .54896 m
.9359 .55104 L
s
.96399 .59793 m
.93601 .60207 L
s
.96381 .64693 m
.93619 .65307 L
s
.96356 .69598 m
.93644 .70402 L
s
.96326 .74509 m
.93674 .75491 L
s
.96292 .79426 m
.93708 .80574 L
s
.96255 .84349 m
.93745 .85651 L
s
.96217 .89279 m
.93783 .90721 L
s
.96177 .94216 m
.93823 .95784 L
s
.96136 .99158 m
0 0 rlineto s
.96136 .99158 m
.95 1 L
s
1 .05 m
.98787 .04272 L
s
1 .1 m
.98752 .09334 L
s
1 .15 m
.98718 .14402 L
s
1 .2 m
.98687 .19475 L
s
1 .25 m
.98658 .24553 L
s
1 .3 m
.98634 .29636 L
s
1 .35 m
.98613 .34723 L
s
1 .4 m
.98598 .39813 L
s
1 .45 m
.98589 .44906 L
s
1 .5 m
.98586 .5 L
s
1 .55 m
.98589 .55094 L
s
1 .6 m
.98598 .60187 L
s
1 .65 m
.98613 .65277 L
s
1 .7 m
.98634 .70364 L
s
1 .75 m
.98658 .75447 L
s
1 .8 m
.98687 .80525 L
s
1 .85 m
.98718 .85598 L
s
1 .9 m
.98752 .90666 L
s
1 .95 m
.98787 .95728 L
s
1 1 m
1 1 L
s
.871 .722 .529 r
.005 w
.5 1 m
.5 .95833 L
.5 .91667 L
.5 .875 L
.5 .83333 L
.5 .79167 L
.5 .75 L
.5 .70833 L
.5 .66667 L
.5 .625 L
.5 .58333 L
.5 .54167 L
.5 .5 L
.5 .45833 L
.5 .41667 L
.5 .375 L
.5 .33333 L
.5 .29167 L
.5 .25 L
.5 .20833 L
.5 .16667 L
.5 .125 L
.5 .08333 L
.5 .04167 L
.5 0 L
s
.274 .51 .706 r
0 .5 m
.04167 .5 L
.08333 .5 L
.125 .5 L
.16667 .5 L
.20833 .5 L
.25 .5 L
.29167 .5 L
.33333 .5 L
.375 .5 L
.41667 .5 L
.45833 .5 L
.5 .5 L
.54167 .5 L
.58333 .5 L
.625 .5 L
.66667 .5 L
.70833 .5 L
.75 .5 L
.79167 .5 L
.83333 .5 L
.875 .5 L
.91667 .5 L
.95833 .5 L
1 .5 L
s
.89 .09 .05 r
0 .80001 m
.01716 .80707 L
.0358 .81523 L
.05266 .82311 L
.06829 .83086 L
.08434 .83932 L
.09921 .84766 L
.11444 .85676 L
.12857 .86575 L
.14167 .87461 L
.1551 .88427 L
.16756 .89381 L
.17911 .90321 L
.19097 .91346 L
.20197 .92357 L
.21324 .9346 L
.22368 .94548 L
.23338 .95621 L
.24332 .96792 L
.25253 .97947 L
.26197 .99205 L
s
.26197 .99205 m
.26756 1 L
s
0 .75856 m
.00188 .75918 L
.02693 .76825 L
.04931 .77706 L
.06983 .78581 L
.09065 .79542 L
.10974 .80497 L
.12905 .81547 L
.14676 .82592 L
.16299 .8363 L
.17944 .84771 L
.19452 .85907 L
.20835 .87033 L
.22239 .88271 L
.23526 .89502 L
.2483 .90854 L
.26024 .922 L
.2712 .93537 L
.28231 .95006 L
.29249 .96467 L
.3028 .98071 L
.31224 .9967 L
s
.31224 .9967 m
.31404 1 L
s
0 .71351 m
.01172 .71681 L
.04232 .72637 L
.06931 .73574 L
.09377 .74511 L
.11828 .75549 L
.14047 .7659 L
.16265 .77742 L
.18272 .789 L
.2009 .8006 L
.2191 .81345 L
.23557 .82634 L
.2505 .83923 L
.26548 .85352 L
.27904 .86784 L
.29259 .8837 L
.30487 .89962 L
.31599 .91556 L
.32712 .93323 L
.33721 .95094 L
.34728 .97056 L
.3564 .99027 L
s
.3564 .99027 m
.36047 1 L
s
0 .66304 m
.02068 .66752 L
.05874 .67702 L
.09248 .68666 L
.12557 .6975 L
.15488 .70853 L
.18353 .72093 L
.20887 .73357 L
.23134 .74642 L
.25334 .76086 L
.27282 .77557 L
.29009 .79049 L
.30705 .80726 L
.32207 .82432 L
.33676 .8435 L
.34977 .86305 L
.3613 .8829 L
.37259 .90521 L
.3826 .92793 L
.39238 .95346 L
.40102 .9795 L
s
.40102 .9795 m
.40696 1 L
s
0 .60261 m
.0013 .60278 L
.05401 .61072 L
.09844 .61875 L
.13698 .62701 L
.17395 .63644 L
.20598 .64618 L
.23658 .65729 L
.26305 .66879 L
.28599 .68065 L
.30797 .69418 L
.327 .70817 L
.34351 .72257 L
.35937 .739 L
.37311 .75596 L
.38625 .7753 L
.39761 .79532 L
.40748 .81595 L
.41693 .83949 L
.42512 .8638 L
.43293 .89155 L
.43969 .92029 L
.44555 .94993 L
.45116 .98375 L
s
.45116 .98375 m
.45343 1 L
s
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .50001 L
.5 .50002 L
.5 .50004 L
.5 .5001 L
.5 .50024 L
.5 .50056 L
.5 .50128 L
.5 .50306 L
.5 .50713 L
.5 .51748 L
.5 .54149 L
.5 .59531 L
.5 .73085 L
s
.5 .73085 m
.5 1 L
s
1 .60261 m
.9987 .60278 L
.94599 .61072 L
.90156 .61875 L
.86302 .62701 L
.82605 .63644 L
.79402 .64618 L
.76342 .65729 L
.73695 .66879 L
.71401 .68065 L
.69203 .69418 L
.673 .70817 L
.65649 .72257 L
.64063 .739 L
.62689 .75596 L
.61375 .7753 L
.60239 .79532 L
.59252 .81595 L
.58307 .83949 L
.57488 .8638 L
.56707 .89155 L
.56031 .92029 L
.55445 .94993 L
.54884 .98375 L
s
.54884 .98375 m
.54657 1 L
s
1 .66304 m
.97932 .66752 L
.94126 .67702 L
.90752 .68666 L
.87443 .6975 L
.84512 .70853 L
.81647 .72093 L
.79113 .73357 L
.76866 .74642 L
.74666 .76086 L
.72718 .77557 L
.70991 .79049 L
.69295 .80726 L
.67793 .82432 L
.66324 .8435 L
.65023 .86305 L
.6387 .8829 L
.62741 .90521 L
.6174 .92793 L
.60762 .95346 L
.59898 .9795 L
s
.59898 .9795 m
.59304 1 L
s
1 .71351 m
.98828 .71681 L
.95768 .72637 L
.93069 .73574 L
.90623 .74511 L
.88172 .75549 L
.85953 .7659 L
.83735 .77742 L
.81728 .789 L
.7991 .8006 L
.7809 .81345 L
.76443 .82634 L
.7495 .83923 L
.73452 .85352 L
.72096 .86784 L
.70741 .8837 L
.69513 .89962 L
.68401 .91556 L
.67288 .93323 L
.66279 .95094 L
.65272 .97056 L
.6436 .99027 L
s
.6436 .99027 m
.63953 1 L
s
1 .75856 m
.99812 .75918 L
.97307 .76825 L
.95069 .77706 L
.93017 .78581 L
.90935 .79542 L
.89026 .80497 L
.87095 .81547 L
.85324 .82592 L
.83701 .8363 L
.82056 .84771 L
.80548 .85907 L
.79165 .87033 L
.77761 .88271 L
.76474 .89502 L
.7517 .90854 L
.73976 .922 L
.7288 .93537 L
.71769 .95006 L
.70751 .96467 L
.6972 .98071 L
.68776 .9967 L
s
.68776 .9967 m
.68596 1 L
s
1 .80001 m
.98284 .80707 L
.9642 .81523 L
.94734 .82311 L
.93171 .83086 L
.91566 .83932 L
.90079 .84766 L
.88556 .85676 L
.87143 .86575 L
.85833 .87461 L
.8449 .88427 L
.83244 .89381 L
.82089 .90321 L
.80903 .91346 L
.79803 .92357 L
.78676 .9346 L
.77632 .94548 L
.76662 .95621 L
.75668 .96792 L
.74747 .97947 L
.73803 .99205 L
s
.73803 .99205 m
.73244 1 L
s
0 .19999 m
.01716 .19293 L
.0358 .18477 L
.05266 .17689 L
.06829 .16914 L
.08434 .16068 L
.09921 .15234 L
.11444 .14324 L
.12857 .13425 L
.14167 .12539 L
.1551 .11573 L
.16756 .10619 L
.17911 .09679 L
.19097 .08654 L
.20197 .07643 L
.21324 .0654 L
.22368 .05452 L
.23338 .04379 L
.24332 .03208 L
.25253 .02053 L
.26197 .00795 L
s
.26197 .00795 m
.26756 0 L
s
0 .24144 m
.00188 .24082 L
.02693 .23175 L
.04931 .22294 L
.06983 .21419 L
.09065 .20458 L
.10974 .19503 L
.12905 .18453 L
.14676 .17408 L
.16299 .1637 L
.17944 .15229 L
.19452 .14093 L
.20835 .12967 L
.22239 .11729 L
.23526 .10498 L
.2483 .09146 L
.26024 .078 L
.2712 .06463 L
.28231 .04994 L
.29249 .03533 L
.3028 .01929 L
.31224 .0033 L
s
.31224 .0033 m
.31404 0 L
s
0 .28649 m
.01172 .28319 L
.04232 .27363 L
.06931 .26426 L
.09377 .25489 L
.11828 .24451 L
.14047 .2341 L
.16265 .22258 L
.18272 .211 L
.2009 .1994 L
.2191 .18655 L
.23557 .17366 L
.2505 .16077 L
.26548 .14648 L
.27904 .13216 L
.29259 .1163 L
.30487 .10038 L
.31599 .08444 L
.32712 .06677 L
.33721 .04906 L
.34728 .02944 L
.3564 .00973 L
s
.3564 .00973 m
.36047 0 L
s
0 .33696 m
.02068 .33248 L
.05874 .32298 L
.09248 .31334 L
.12557 .3025 L
.15488 .29147 L
.18353 .27907 L
.20887 .26643 L
.23134 .25358 L
.25334 .23914 L
.27282 .22443 L
.29009 .20951 L
.30705 .19274 L
.32207 .17568 L
.33676 .1565 L
.34977 .13695 L
.3613 .1171 L
.37259 .09479 L
.3826 .07207 L
.39238 .04654 L
.40102 .0205 L
s
.40102 .0205 m
.40696 0 L
s
0 .39739 m
.0013 .39722 L
.05401 .38928 L
.09844 .38125 L
.13698 .37299 L
.17395 .36356 L
.20598 .35382 L
.23658 .34271 L
.26305 .33121 L
.28599 .31935 L
.30797 .30582 L
.327 .29183 L
.34351 .27743 L
.35937 .261 L
.37311 .24404 L
.38625 .2247 L
.39761 .20468 L
.40748 .18405 L
.41693 .16051 L
.42512 .1362 L
.43293 .10845 L
.43969 .07971 L
.44555 .05007 L
.45116 .01625 L
s
.45116 .01625 m
.45343 0 L
s
.5 .5 m
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .5 L
.5 .49999 L
.5 .49998 L
.5 .49996 L
.5 .4999 L
.5 .49976 L
.5 .49944 L
.5 .49872 L
.5 .49694 L
.5 .49287 L
.5 .48252 L
.5 .45851 L
.5 .40469 L
.5 .26915 L
s
.5 .26915 m
.5 0 L
s
1 .39739 m
.9987 .39722 L
.94599 .38928 L
.90156 .38125 L
.86302 .37299 L
.82605 .36356 L
.79402 .35382 L
.76342 .34271 L
.73695 .33121 L
.71401 .31935 L
.69203 .30582 L
.673 .29183 L
.65649 .27743 L
.64063 .261 L
.62689 .24404 L
.61375 .2247 L
.60239 .20468 L
.59252 .18405 L
.58307 .16051 L
.57488 .1362 L
.56707 .10845 L
.56031 .07971 L
.55445 .05007 L
.54884 .01625 L
s
.54884 .01625 m
.54657 0 L
s
1 .33696 m
.97932 .33248 L
.94126 .32298 L
.90752 .31334 L
.87443 .3025 L
.84512 .29147 L
.81647 .27907 L
.79113 .26643 L
.76866 .25358 L
.74666 .23914 L
.72718 .22443 L
.70991 .20951 L
.69295 .19274 L
.67793 .17568 L
.66324 .1565 L
.65023 .13695 L
.6387 .1171 L
.62741 .09479 L
.6174 .07207 L
.60762 .04654 L
.59898 .0205 L
s
.59898 .0205 m
.59304 0 L
s
1 .28649 m
.98828 .28319 L
.95768 .27363 L
.93069 .26426 L
.90623 .25489 L
.88172 .24451 L
.85953 .2341 L
.83735 .22258 L
.81728 .211 L
.7991 .1994 L
.7809 .18655 L
.76443 .17366 L
.7495 .16077 L
.73452 .14648 L
.72096 .13216 L
.70741 .1163 L
.69513 .10038 L
.68401 .08444 L
.67288 .06677 L
.66279 .04906 L
.65272 .02944 L
.6436 .00973 L
s
.6436 .00973 m
.63953 0 L
s
1 .24144 m
.99812 .24082 L
.97307 .23175 L
.95069 .22294 L
.93017 .21419 L
.90935 .20458 L
.89026 .19503 L
.87095 .18453 L
.85324 .17408 L
.83701 .1637 L
.82056 .15229 L
.80548 .14093 L
.79165 .12967 L
.77761 .11729 L
.76474 .10498 L
.7517 .09146 L
.73976 .078 L
.7288 .06463 L
.71769 .04994 L
.70751 .03533 L
.6972 .01929 L
.68776 .0033 L
s
.68776 .0033 m
.68596 0 L
s
1 .19999 m
.98284 .19293 L
.9642 .18477 L
.94734 .17689 L
.93171 .16914 L
.91566 .16068 L
.90079 .15234 L
.88556 .14324 L
.87143 .13425 L
.85833 .12539 L
.8449 .11573 L
.83244 .10619 L
.82089 .09679 L
.80903 .08654 L
.79803 .07643 L
.78676 .0654 L
.77632 .05452 L
.76662 .04379 L
.75668 .03208 L
.74747 .02053 L
.73803 .00795 L
s
.73803 .00795 m
.73244 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00;?ooool3o`00037ooooo1Ol0000aooooo`;o0000
<_ooool5o`0003?ooooo0ol0000Kooooo`00;Oooool00ol0003oooooooooo`0aooooo`04o`000?oo
ooooooooo`00033ooooo00Co0000oooooooooooo0000<_ooool01?l0003oooooooooool0000doooo
o`03o`000?oooooooooo01[ooooo000Tooooo`Go000000?oooooo`000?l000000ol0000[ooooo`Go
00000oooool00ol0003oooooooooo`0`ooooo`04o`000?ooooooooooo`0003?ooooo00?o0000oooo
ooooool0<Oooool5o`0001_ooooo000Zooooo`04o`000?ooooooooooo`0003Gooooo00?o0000oooo
ooooool0;oooool01?l0003oooooooooool0000dooooo`03o`000?oooooooooo033ooooo00Co0000
oooooooooooo00007?ooool002_ooooo00?o0000ooooool00000<_ooool01Ol0003ooooooooooooo
oooo0000033ooooo00Co0000oooooooooooo0000<Oooool01Ol0003ooooooooooooooooo000003;o
oooo00?o0000ooooool000007?ooool002cooooo0_l0000booooo`05o`000?ooooooooooooooool0
0000<?ooool01?l0003oooooooooool0000aooooo`05o`000?ooooooooooooooool00000<oooool2
o`0001cooooo000]ooooo`03o`000?oooooooooo037ooooo0ol0000booooo`;o0000<oooool3o`00
03Gooooo00?o0000ooooooooool06_ooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000kooooo3_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o0000
00_o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o0000
00;o000000?ohaL<o`000?l000001Ol000001Ol2Z9ko0000o`000?l0003ohaL<00Wo000000Co0ZRN
o`000?l0003ohaL<2Ol000000ol2Z9ko0000on<G300;o`000003o`:XW_oS5`co000001Oo000000?o
haL<o`:XW_l000002_l000000ooS5`co0000o`:XWP0:o`000003on<G3?l0003o0ZRN00Wo000000Go
haL<o`000?l0003o0000o`:XWP08o`000003on<G3?l0003o000000;o000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2ol000000ol2Z9ko0000o`00000;o`00007ooooo000>ooooo`go000000?o0ZRNo`000?l000002ol0
00000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o000000_o000000?o0ZRNo`000?l000002ol0
00000ol2Z9ko0000o`000002o`000003on<G3?l0003o000000Go000000Go0ZRNo`000?l0003o0000
on<G3009o`000004o`:XW_l0003o0000on<G30Wo000000?o0ZRNo`000?oS5``02ol000000ol2Z9ko
haL<o`00000Go`000003on<G3?l2Z9ko000000[o000000?ohaL<o`000?l2Z9h02_l000000ooS5`co
0000o`:XWP0:o`000004on<G3?l0003o0000o`:XWPSo000000?ohaL<o`000?l000000_l000000ol2
Z9ko0000o`00000;o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002ol000000ol2
Z9ko0000o`00000;o`000003o`:XW_l0003o000000[o00000Oooool000kooooo0_l0000:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03
o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcV
f@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol0003oc>KIolcVf@09olcV
f@03on<G3?l2Z9koc>KI00_oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ooS5`coc>KIo`:XWP09olcV
f@05on<G3?o<i]Woc>KIolcVfOl2Z9h02?o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI0_l2Z9h8olcVf@;o00000Oooool000kooooo0_l00009olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@05o`:XW_o<i]Woc>KI
olcVfOoS5``02Oo<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI
00?o0ZRNon<G3?o<i]T03?o<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI
00?ohaL<olcVfOl2Z9h02_o<i]T00ooS5`coc>KIo`:XWP0:olcVf@03on<G3?o<i]Woc>KI00;o0ZRN
1oo<i]T00ooS5`coc>KIolcVf@02olcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00001ooooo`003_oo
ool2o`00043oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@05o`:XW_o<
i]Woc>KIolcVfOoS5``02Oo<i]T2o`:XWP;oc>KI00?ohaL<olcVfOo<i]T01oo<i]T2o`:XWP03on<G
3?o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<i]T03?o<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G
3?l2Z9koc>KI00[oc>KI00?ohaL<olcVfOl2Z9h02_o<i]T01?oS5`coc>KIolcVfOl2Z9h9olcVf@05
on<G3?o<i]Woc>KIolcVfOl2Z9h02?o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI
03goc>KI0_l00001ooooo`003_ooool2o`0004Coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`co
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@11olcVf@;o00000Oooool000kooooo0_l00013olcVf@03on<G3?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI
00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI
00?ohaL<olcVfOo<i]T0@?o<i]T2o`00007ooooo000>ooooo`;o0000@oo<i]T00ooS5`coc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcV
f@0;olcVf@03on<G3?o<i]Woc>KI043oc>KI0_l00001ooooo`003_ooool2o`0004;oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0oolcVf@;o00000Oooool000kooooo0_l00011olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcV
f@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T0?_o<i]T2o`00007ooooo000>ooooo`;o
0000@?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<
i]T02oo<i]T01?oS5`coc>KIolcVfOl2Z9h:olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0000olcV
fOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]WohaL<00goc>KI00?ohaL<olcV
fOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI03goc>KI0_l00001oooo
o`003_ooool2o`0003Soc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP09olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h02Oo<i]T01?oS5`coc>KIolcVfOl2Z9h:olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]WohaL<00[oc>KI00Co
0ZRNolcVfOo<i]WohaL<2Oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<
i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI03Goc>KI0_l00001ooooo`00
3_ooool2o`000003olcVfOl2Z9ko0ZRN00coc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Goc>KI
00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI
00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`coc>KIo`:XWP0;olcVf@03on<G3?o<i]Wo0ZRN00coc>KI
00?o0000olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30Wo
c>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcV
fOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWP;o00000Oooool000ko
oooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP09olcVf@05on<G3?o<i]Woc>KI
olcVfOl2Z9h02Oo<i]T01?oS5`coc>KIolcVfOl2Z9h;olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]WohaL<00[oc>KI00Co
0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
0Ol2Z9h1o`00007ooooo000>ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<
i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Woc>KI
00GohaL<olcVfOo<i]Woc>KIo`:XWP0:olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?ohaL<o`:X
W_o<i]T03?o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcV
fOoS5``02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T00_o<i]T0
0ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T01?o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@;o0ZRN2_o<i]T1
o`00007o0ZRN0Oooool000kooooo0_l0000:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP09olcVf@05on<G3?o<i]Wo
c>KIolcVfOl2Z9h02_o<i]T00ooS5`coc>KIo`:XWP0<olcVf@03on<G3?l2Z9koc>KI00coc>KI00?o
0000olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI
00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ko
c>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Oo
c>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KI
olcVf@03olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP09olcVf@05
on<G3?o<i]Woc>KIolcVfOl2Z9h02_o<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03on<G3?l2Z9ko
c>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@04o`:XW_o<i]Wo
c>KIon<G30[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00;oc>KI
00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o00009Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcV
f@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02_o<i]T01?oS5`coc>KIolcVfOl2Z9h;olcVf@04
on<G3?o<i]Woc>KIo`:XWP_oc>KI00?ohaL<o`:XW_o<i]T03Oo<i]T00ol0003oc>KIolcVf@0;olcV
f@03o`:XW_oS5`coc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T01Ol2Z9koc>KIolcVfOo<
i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<
i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI027oc>KI0_l00001ooooo`003_ooool2o`0003Woc>KI00?ohaL<olcVfOo<i]T03Oo<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOl2Z9h03?o<i]T0
0ooS5`co0ZRNolcVf@0=olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T0
1?l2Z9koc>KIolcVfOoS5``>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<
i]T2on<G33Ooc>KI0_l00001ooooo`003_ooool2o`0003Soc>KI00?ohaL<olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03Oo<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03Oo<i]T0
0ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T03_o<i]T0
0ooS5`coc>KIolcVf@0dolcVf@;o00000Oooool000kooooo0_l0000golcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI
00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ol0003oc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI
00koc>KI00?ohaL<olcVfOo<i]T0<oo<i]T2o`00007ooooo000>ooooo`;o0000=_o<i]T00ooS5`co
c>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00koc>KI00?o0000olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI03;oc>KI0_l00001ooooo`003_ooool2o`0003Goc>KI
00?ohaL<olcVfOo<i]T03Oo<i]T2on<G30ooc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0=olcVf@03on<G3?o<i]Woc>KI00koc>KI00?o0000olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KI
olcVf@0>olcVf@03on<G3?o<i]Woc>KI037oc>KI0_l00001ooooo`003_ooool2o`0003Coc>KI00?o
haL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00koc>KI00?o
haL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`000?o<i]Woc>KI00goc>KI00?o
haL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00goc>KI00?o
haL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0`olcVf@;o00000Oooool000kooooo0_l0000c
olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@08
olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@06
olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol0003oc>KIolcVf@0:olcVf@04o`:XW_o<
i]Woc>KIon<G30Soc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G
3?o<i]Woc>KI02ooc>KI0_l00001ooooo`002?ooool3o`0000?ooooo0_l0000LolcVf@;o0ZRN3?o<
i]T2o`:XWPKoc>KI00?ohaL<olcVfOo<i]T00_o<i]T2o`:XWPWoc>KI00CohaL<olcVfOo<i]Wo0ZRN
3Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol0003oc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<i]T00ol2Z9ko
c>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ooS5`co0ZRNolcVf@0;olcV
f@04o`:XW_o<i]Woc>KIon<G30Woc>KI0_l2Z9h5olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h;
olcVf@;o0ZRN6oo<i]T2o`00007ooooo0009ooooo`03o`000?oooooooooo00;ooooo0_l000000oo<
i]Wo0ZRNo`:XWP0<olcVf@;o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI
00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN
00koc>KI00?ohaL<olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI
00Goc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0000olcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRN
olcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?o
haL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2
Z9h<olcVf@;o0ZRN0_l00001ooooo`001Ol000000ooooooo0000o`000003o`0000?ooooo0_l00000
0ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00Coc>KI0_oS5``4olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03_o<i]T0
0ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol0003oc>KIolcV
f@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0<olcVf@04o`:X
W_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T2on<G30Koc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN3?o<i]T1o`:XWP7o00000Oooool000Kooooo
00Co0000oooooooooooo00001?ooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@;ohaL<1Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00koc>KI00?o0ZRNon<G3?o<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`co
c>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0000olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``9
olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03on<G3?l2Z9koc>KI00coc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcV
f@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0Ol00001o`:XWP7ooooo0007ooooo`03o`000?oooooo
000000Cooooo0_l0000:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@08olcVf@;ohaL<00?oc>KI
o`:XW_o<i]T03Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<
olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<
i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ooS5`co0ZRNolcVf@0=olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T0
1?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T2o`:XWPWoc>KI0_l00001ooooo`002?ooool2o`0000Cooooo0_l00009olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h>olcVf@03o`:X
W_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:X
W_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0>olcVf@03o`000?o<i]Woc>KI00_o
c>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcV
fOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00goc>KI00Co0ZRNolcV
fOo<i]WohaL<2_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00001
ooooo`002Oooool00ol0003oooooooooo`02ooooo`;o0000:_o<i]T00ooS5`coc>KIolcVf@0?olcV
f@03on<G3?o<i]Woc>KI00ooc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@03olcV
f@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo
0ZRN00koc>KI00?o0000olcVfOo<i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o
0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
haL<o`:XW_o<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@03on<G3?o<i]Woc>KI02Ooc>KI0_l0
0001ooooo`003_ooool2o`0002Soc>KI0_oS5``AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<
olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?o0000
olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<
olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0?olcVf@;ohaL<9oo<i]T2o`00007ooooo000>oooo
o`;o00009_o<i]T2on<G31;oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0@olcV
f@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ol0003oc>KIolcVf@0@olcV
f@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0@olcV
f@03on<G3?o<i]Woc>KI013oc>KI0_oS5``UolcVf@;o00000Oooool000kooooo0_l0000UolcVf@03
on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03
on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ol0003oc>KIolcVf@0@olcVf@03
on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03
on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T08_o<i]T2o`00007ooooo000>ooooo`;o0000
9?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T0
4Oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI017oc>KI00?o0000olcVfOo<i]T0
4?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T0
4?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI027oc>KI0_l00001ooooo`003_oo
ool2o`0002?oc>KI00?ohaL<olcVfOo<i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<
i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0BolcVf@03o`000?o<
i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<
i]Woc>KI013oc>KI0_oS5``BolcVf@03on<G3?o<i]Woc>KI023oc>KI0_l00001ooooo`003_ooool2
o`00027oc>KI0_oS5``ColcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04_o<i]T0
0ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T04?o<i]T0
0ooS5`coc>KIolcVf@0BolcVf@03on<G3?o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T04?o<i]T2
on<G323oc>KI0_l00001ooooo`003_ooool2o`0001ooc>KI0_oS5``DolcVf@03on<G3?o<i]Woc>KI
017oc>KI00?ohaL<olcVfOo<i]T01oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03on<G3?o<i]Wo0ZRN
00coc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI
00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIon<G300:olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0AolcVf@;ohaL<7_o<i]T2o`00
007ooooo000>ooooo`;o00003oo<i]T2o`:XWP_oc>KI00?o0ZRNon<G3?oS5``02oo<i]T2o`:XWPOo
c>KI0_oS5``2olcVf@;o0ZRN3?o<i]T2o`:XWP03olcVfOoS5`coc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T00ooS5`coc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<
i]T01Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOoS
5``02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI0_l2Z9h3olcV
f@;ohaL<1_o<i]T2o`:XWP_oc>KI0_oS5``00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN3_o<i]T2o`00
007ooooo000>ooooo`;o000000?oc>KIo`:XW_l2Z9h02_o<i]T2o`:XWPcoc>KI00?o0ZRNon<G3?o<
i]T02_o<i]T2o`:XWPSoc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@04o`:XW_o<i]Woc>KI
on<G30[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0<olcVf@03o`:XW_o<i]Wo
c>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOoS5``02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Wo
c>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@;o0ZRN2oo<
i]T00ooS5`co0ZRNo`:XWP0;olcVf@;o0ZRN2_o<i]T3o`:XWP7o00000Oooool000kooooo00?o0000
o`:XW_l2Z9h02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN00?ohaL<olcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T01?l2Z9koc>KIolcV
fOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KI
olcVf@02olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]WohaL<00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KI
olcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T1o`00007o
0ZRN0Oooool000kooooo0_l0000:olcVf@;o0ZRN3?o<i]T00ol2Z9kohaL<on<G300:olcVf@;o0ZRN
2?o<i]T2on<G30?oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ol2Z9koc>KIolcVf@03olcV
f@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T01?oS5`coc>KIolcVfOl2
Z9h=olcVf@03o`:XW_o<i]Woc>KI00;oc>KI0_oS5``7olcVf@;o0ZRN2_o<i]T2on<G30;o0ZRN2oo<
i]T2o`:XWPWoc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T2
on<G30_oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2on<G30Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
1?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN
3Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T0
0_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G30[oc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T01?oS5`coc>KIolcVfOl2Z9h=olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcV
fOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;ohaL<00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@06olcVf@;o00000Oooool000kooooo0_l0000EolcVf@;ohaL<5Oo<i]T00ooS5`co
c>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcVfOo<i]WohaL<2_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03on<G3?o<i]Wo0ZRN00koc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS
5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2
Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3Oo<i]T0
0ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI01?oc>KI0_oS5``DolcVf@;o00000Oooool0
00kooooo0_l0000BolcVf@?ohaL<5Oo<i]T2on<G31Koc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS
5`coc>KIolcVf@0>olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS
5`coc>KIolcVf@0DolcVf@;ohaL<5Oo<i]T3on<G317oc>KI0_l00001ooooo`003_ooool2o`00013o
c>KI0_oS5``GolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`co
c>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?o0000olcVfOo<i]T05?o<i]T00ooS5`co
c>KIolcVf@0DolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05Oo<i]T2on<G31Ko
c>KI0_oS5``?olcVf@;o00000Oooool000kooooo0_l0000>olcVf@;ohaL<6?o<i]T00ooS5`coc>KI
olcVf@0EolcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KI
olcVf@0EolcVf@03o`000?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KI
olcVf@0DolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05Oo<i]T2on<G30goc>KI
0_l00001ooooo`003_ooool2o`0000coc>KI0_oS5``HolcVf@;ohaL<5_o<i]T2on<G31Koc>KI00?o
haL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03o`000?o<i]Woc>KI01Goc>KI00?o
haL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0DolcVf@;ohaL<5oo<i]T2on<G31Ooc>KI0_oS
5``;olcVf@;o00000Oooool000kooooo0_l0000;olcVf@03on<G3?o<i]Woc>KI01Koc>KI0_oS5``F
olcVf@;ohaL<6?o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?o0000
olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Koc>KI0_oS5``G
olcVf@03on<G3?o<i]Woc>KI01Koc>KI0_oS5``9olcVf@;o00000Oooool000kooooo0_l0000:olcV
f@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0GolcV
f@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0003oc>KIolcVf@0FolcV
f@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05oo<i]T00ooS5`coc>KIolcVf@0EolcV
f@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o
00002?o<i]T2on<G31Ooc>KI0_oS5``FolcVf@;ohaL<6Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03
o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0GolcVf@;o
haL<5_o<i]T3on<G31Ooc>KI0_oS5``6olcVf@;o00000Oooool000kooooo0_l00005olcVf@?ohaL<
5_o<i]T3on<G31Ooc>KI00?ohaL<olcVfOo<i]T02_o<i]T2o`:XWPcoc>KI00?ohaL<olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00_oc>KI0_l2Z9h;olcVf@03on<G
3?o<i]Woc>KI01Koc>KI0ooS5``FolcVf@?ohaL<0oo<i]T2o`00007ooooo000>ooooo`;o000000?o
c>KIo`:XW_l2Z9h00_oS5``:olcVf@;o0ZRN2oo<i]T2on<G30coc>KI0_l2Z9h;olcVf@03on<G3?l2
Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI0_oS5``=olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNon<G3?o<i]T02_o<
i]T2o`:XWPcoc>KI00?o0ZRNon<G3?oS5``02_o<i]T2o`:XWP_oc>KI0_oS5``00ol2Z9ko0000o`00
0001ooooo`003_ooool2o`0000?ohaL<2Oo<i]T3o`:XWP_oc>KI0_oS5``<olcVf@;o0ZRN3?o<i]T0
0ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ooS5`coc>KIolcVf@0:olcVf@;o0ZRN3?o<i]T00ol2Z9kohaL<on<G300:olcVf@?o0ZRN2_o<i]T2
on<G307o00000Oooool000kooooo00?o0000on<G3?o<i]T02Oo<i]T2o`:XWPcoc>KI00?o0ZRNon<G
3?o<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;ohaL<3?o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0_oS5``<olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?ohaL<o`:X
W_o<i]T02_o<i]T2o`:XWPWoc>KI0Ol00001on<G307ooooo000>ooooo`;o00002Oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@;ohaL<3?o<i]T2o`:XWPcoc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ooS5`co
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_oS5``;olcVf@;o0ZRN3Oo<i]T2on<G30co
c>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`00007ooooo000>ooooo`;o00005Oo<i]T2on<G30goc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
0_oS5``>olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0<olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T2on<G31?oc>KI
0_l00001ooooo`003_ooool2o`0001?oc>KI0_oS5``KolcVf@;ohaL<6_o<i]T00ooS5`coc>KIolcV
f@0=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcV
f@0<olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T06Oo<i]T2on<G31_oc>KI00?o
haL<olcVfOo<i]T04?o<i]T2o`00007ooooo000>ooooo`;o00004Oo<i]T2on<G31_oc>KI0_oS5``K
olcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ol0003oc>KIolcVf@0J
olcVf@03on<G3?o<i]Woc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T2on<G31[oc>KI0ooS5``?
olcVf@;o00000Oooool000kooooo0_l0000>olcVf@?ohaL<6oo<i]T2on<G31coc>KI00?ohaL<olcV
fOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0KolcVf@03o`000?o<i]Woc>KI01_oc>KI00?ohaL<olcV
fOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01[oc>KI0ooS5``<olcV
f@;o00000Oooool000kooooo0_l0000;olcVf@?ohaL<7?o<i]T2on<G31coc>KI0_oS5``NolcVf@03
on<G3?o<i]Woc>KI01coc>KI00?o0000olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0KolcVf@;o
haL<7?o<i]T2on<G31goc>KI0ooS5``9olcVf@;o00000Oooool000kooooo0_l00008olcVf@?ohaL<
7Oo<i]T2on<G31goc>KI00?ohaL<olcVfOo<i]T07_o<i]T00ooS5`coc>KIolcVf@0LolcVf@03o`00
0?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07Oo<i]T00ooS5`coc>KIolcVf@0KolcVf@;ohaL<
7_o<i]T3on<G30Koc>KI0_l00001ooooo`003_ooool2o`0000Goc>KI0ooS5``NolcVf@;ohaL<7_o<
i]T00ooS5`coc>KIolcVf@0NolcVf@03on<G3?o<i]Woc>KI01goc>KI00?o0000olcVfOo<i]T07Oo<
i]T00ooS5`coc>KIolcVf@0MolcVf@;ohaL<7Oo<i]T2on<G31ooc>KI0_oS5``4olcVf@;o00000Ooo
ool000kooooo0_l00002olcVf@?ohaL<7oo<i]T2on<G31ooc>KI00?ohaL<olcVfOo<i]T07_o<i]T0
0ooS5`coc>KIolcVf@0NolcVf@03o`000?o<i]Woc>KI01goc>KI00?ohaL<olcVfOo<i]T07oo<i]T0
0ooS5`coc>KIolcVf@0LolcVf@;ohaL<7oo<i]T3on<G3003olcVfOl0003o0000007ooooo000>oooo
o`;o00000_oS5``PolcVf@;ohaL<7oo<i]T2on<G31_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS
5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0
003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS
5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI01[oc>KI0_oS5``NolcVf@;ohaL<8?o<i]T2on<G
307o00000Oooool000kooooo00?o0000on<G3?o<i]T07oo<i]T2on<G31Koc>KI0_l2Z9h8olcVf@03
on<G3?o<i]Woc>KI00;o0ZRN2oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`co
c>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003o
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN0oo<i]T00ooS5`co
c>KIolcVf@06olcVf@;o0ZRN5Oo<i]T2on<G31ooc>KI0Ol00001on<G307ooooo000>ooooo`;o0000
00Coc>KIo`:XW_l2Z9ko0ZRN2oo<i]T2o`:XWPcoc>KI00?o0ZRNon<G3?oS5``02_o<i]T2o`:XWP[o
c>KI0_l2Z9h8olcVf@;ohaL<0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP;oc>KI0_oS5``8olcVf@03o`:XW_o<i]Woc>KI00So
c>KI0_l2Z9h:olcVf@;ohaL<0_l2Z9h;olcVf@;o0ZRN3?o<i]T3o`:XWP7o00000Oooool000kooooo
00?o0000o`:XW_l2Z9h02oo<i]T3o`:XWP_oc>KI00Co0ZRNon<G3?oS5`cohaL<2Oo<i]T3o`:XWP_o
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS5`coc>KIolcVf@02o`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T2o`:X
WP[oc>KI0ol2Z9h9olcVf@?ohaL<0_l2Z9h:olcVf@?o0ZRN2oo<i]T1o`00007o0ZRN0Oooool000ko
oooo0_l0000:olcVf@;o0ZRN3?o<i]T00ol2Z9kohaL<on<G300:olcVf@;o0ZRN3?o<i]T2o`:XWPSo
c>KI0_oS5``2olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@;o0ZRN0_o<i]T2on<G30Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP[o
c>KI0_oS5``2o`:XWP_oc>KI0_l2Z9h9olcVf@;o00000Oooool000kooooo0_l00009olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI0_oS5``;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
1oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9ko
c>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0<olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0ooS5``<olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00001oooo
o`003_ooool2o`0001Coc>KI0ooS5``SolcVf@;ohaL<4Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03
o`:XW_o<i]Woc>KI013oc>KI0_oS5``SolcVf@?ohaL<4_o<i]T2o`00007ooooo000>ooooo`;o0000
4Oo<i]T3on<G32Goc>KI00?ohaL<olcVfOo<i]T09?o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@0UolcVf@03on<G
3?o<i]Woc>KI02?oc>KI0ooS5``?olcVf@;o00000Oooool000kooooo0_l0000>olcVf@?ohaL<9_o<
i]T2on<G32Koc>KI00?ohaL<olcVfOo<i]T09Oo<i]T00ol0003oc>KIolcVf@0TolcVf@03on<G3?o<
i]Woc>KI02Goc>KI0_oS5``VolcVf@?ohaL<3?o<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T3
on<G32Koc>KI0ooS5``WolcVf@03on<G3?o<i]Woc>KI02Koc>KI00?o0000olcVfOo<i]T09Oo<i]T0
0ooS5`coc>KIolcVf@0VolcVf@?ohaL<9_o<i]T2on<G30[oc>KI0_l00001ooooo`003_ooool2o`00
00Soc>KI0ooS5``WolcVf@;ohaL<:Oo<i]T00ooS5`coc>KIolcVf@0WolcVf@03o`000?o<i]Woc>KI
02Koc>KI00?ohaL<olcVfOo<i]T0:?o<i]T2on<G32Koc>KI0ooS5``7olcVf@;o00000Oooool000ko
oooo0_l00004olcVf@CohaL<:?o<i]T2on<G32[oc>KI00?ohaL<olcVfOo<i]T0:?o<i]T00ol0003o
c>KIolcVf@0WolcVf@;ohaL<:_o<i]T2on<G32Ooc>KI1?oS5``3olcVf@;o00000Oooool000kooooo
0_l000001?o<i]WohaL<on<G3?oS5``ZolcVf@;ohaL<:oo<i]T00ooS5`coc>KIolcVf@0YolcVf@03
o`000?o<i]Woc>KI02Woc>KI00?ohaL<olcVfOo<i]T0:Oo<i]T2on<G32Woc>KI1?oS5``1o`00007o
oooo000>ooooo`03o`000?oS5`cohaL<02_oc>KI0_oS5``/olcVf@03on<G3?o<i]Woc>KI01goc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI01koc>KI
00?ohaL<olcVfOo<i]T0:_o<i]T00ooS5`coc>KIolcVf@0YolcVf@7o00000OoS5``1ooooo`001_oo
ool5o`0000?ooooo0_l0000ZolcVf@;ohaL<;Oo<i]T00ooS5`coc>KIolcVf@04olcVf@;o0ZRN3?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h7olcVf@03on<G3?o<
i]Woc>KI02[oc>KI0_oS5``YolcVf@;o00000Oooool000Oooooo00Co0000oooooooooooo00000ooo
ool2o`0002Soc>KI0_oS5``>olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h2olcVf@;ohaL<1_o<
i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T03?o<
i]T00ol2Z9koc>KIolcVf@05olcVf@;ohaL<0_o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN3Oo<
i]T2on<G32Ooc>KI0_l00001ooooo`001Ol00003ooooo`03o`000?oooooooooo00?ooooo0_l00000
1?o<i]Wo0ZRNo`:XW_l2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWPKoc>KI0ooS5``01?o<i]Wo0ZRNo`:X
W_l2Z9h9olcVf@?o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h2olcVf@;ohaL<1oo<i]T00ol2Z9koc>KI
olcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KI
olcVf@06olcVf@;ohaL<0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN3?o<i]T3o`:XWPSoc>KI
0ol2Z9h01?o<i]WohaL<on<G3?oS5``7olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h1o`00007o
oooo0009ooooo`03o`000?oooooooooo00;ooooo00?o0000o`:XW_l2Z9h02_o<i]T3o`:XWP[oc>KI
1?l2Z9h6olcVf@?ohaL<00Coc>KIo`:XW_l2Z9ko0ZRN2_o<i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS
5`coc>KIolcVf@02o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T03?o<i]T2o`:XWPWoc>KI0ol2Z9h01?o<
i]WohaL<on<G3?oS5``7olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0Ol00001o`:XWP7ooooo0006oooo
o`05o`000?ooooooooooooooool000000oooool2o`0000Woc>KI0_l2Z9h;olcVf@;o0ZRN2?o<i]T2
on<G30;oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h<olcVf@;o0ZRN0_o<i]T2
on<G30Soc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00coc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2on<G30;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2
o`:XWPkoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP;oc>KI0ooS5``7olcVf@;o0ZRN2oo<i]T2
o`:XWPSoc>KI0_l00001ooooo`001_ooool01Ol0003ooooooooooooooooo000000?ooooo0_l0000M
olcVf@?ohaL<7oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<
i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<
i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<
i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRNolcVfOo<i]T0
7_o<i]T3on<G31_oc>KI0_l00001ooooo`001oooool3o`0000Cooooo0_l0000JolcVf@?ohaL<<_o<
i]T2on<G31Soc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<
i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0GolcVf@;ohaL<<_o<
i]T3on<G31Soc>KI0_l00001ooooo`003_ooool2o`0001Koc>KI1?oS5``dolcVf@03on<G3?o<i]Wo
c>KI03Koc>KI00?o0000olcVfOo<i]T0=_o<i]T00ooS5`coc>KIolcVf@0bolcVf@?ohaL<5Oo<i]T2
o`00007ooooo000>ooooo`;o00004Oo<i]T5on<G33Koc>KI0_oS5``iolcVf@03o`000?o<i]Woc>KI
03Ooc>KI0_oS5``eolcVf@GohaL<4?o<i]T2o`00007ooooo000>ooooo`;o00003Oo<i]T4on<G33So
c>KI0ooS5``kolcVf@03o`000?o<i]Woc>KI03Woc>KI0_oS5``holcVf@CohaL<3?o<i]T2o`00007o
oooo000>ooooo`;o00002_o<i]T3on<G33[oc>KI0_oS5``nolcVf@03o`000?o<i]Woc>KI03_oc>KI
0_oS5``jolcVf@CohaL<2?o<i]T2o`00007ooooo000>ooooo`;o00001oo<i]T3on<G33_oc>KI0_oS
5`a0olcVf@03o`000?o<i]Woc>KI03goc>KI0_oS5``lolcVf@?ohaL<1Oo<i]T2o`00007ooooo000>
ooooo`;o00000_o<i]T5on<G33_oc>KI0ooS5`a2olcVf@03o`000?o<i]Woc>KI03ooc>KI0ooS5``l
olcVf@GohaL<0_l00001ooooo`003_ooool01?l0003ohaL<on<G3?oS5``nolcVf@;ohaL<>Oo<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`000?o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T0=oo<i]T2
on<G33ooc>KI0_oS5``1ooooo`003_ooool2o`0003koc>KI0_oS5``PolcVf@;o0ZRN3?o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T02?o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9hPolcVf@;ohaL<?Oo<i]T2o`00
007ooooo000>ooooo`;o0000:_o<i]T2o`:XWPcoc>KI0_l2Z9h2olcVf@;ohaL<1oo<i]T2o`:XWPco
c>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h<olcVf@;o0ZRN1oo<i]T2on<G30;o
c>KI0_l2Z9h<olcVf@;o0ZRN:Oo<i]T2o`00007ooooo000>ooooo`03o`000?l2Z9ko0ZRN00?o0ZRN
2Oo<i]T4o`:XWPWoc>KI1Ol2Z9h8olcVf@?o0ZRN2oo<i]T3o`:XWP;oc>KI0_oS5``6olcVf@?o0ZRN
2oo<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI0_l2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWPKoc>KI0_oS5``2olcVf@?o0ZRN
2oo<i]T3o`:XWPWoc>KI1Ol2Z9h8olcVf@Go0ZRN2Oo<i]T4o`:XWP7ooooo000>ooooo`;o00002Oo<
i]T4o`:XWPWoc>KI1?l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP?oc>KI0_oS5``6olcVf@;o0ZRN3?o<
i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPcoc>KI0_l2Z9h6olcVf@;ohaL<0oo<
i]T3o`:XWP_oc>KI0_l2Z9h<olcVf@?o0ZRN2_o<i]T4o`:XWPOoc>KI0_l00001ooooo`003_ooool2
o`0002Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@03on<G30Ooc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@?ohaL<0oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI027oc>KI0_l00001ooooo`003_ooool2o`00033oc>KI1OoS5``VolcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0<olcV
f@03o`:XW_o<i]Woc>KI02?oc>KI1OoS5``_olcVf@;o00000Oooool000kooooo0_l0000/olcVf@Co
haL<Aoo<i]T00ol2Z9koc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<
i]T0AOo<i]T4on<G32_oc>KI0_l00001ooooo`003_ooool2o`0002Woc>KI0ooS5`aKolcVf@03o`00
0?o<i]Woc>KI05Soc>KI0ooS5``XolcVf@;o00000Oooool000kooooo0_l0000VolcVf@?ohaL<G_o<
i]T00ol0003oc>KIolcVf@1KolcVf@?ohaL<9Oo<i]T2o`00007ooooo000>ooooo`;o00008_o<i]T4
on<G367oc>KI00?o0000olcVfOo<i]T0G_o<i]T5on<G323oc>KI0_l00001ooooo`003_ooool2o`00
01goc>KI1OoS5`aUolcVf@03o`000?o<i]Woc>KI06?oc>KI1OoS5``KolcVf@;o00000Oooool000ko
oooo0_l0000GolcVf@KohaL<J_o<i]T00ol0003oc>KIolcVf@1XolcVf@KohaL<5Oo<i]T2o`00007o
oooo000>ooooo`;o00004Oo<i]T6on<G373oc>KI00?o0000olcVfOo<i]T0K_o<i]T6on<G30ooc>KI
0_l00001ooooo`003_ooool2o`0000[oc>KI1ooS5`aZolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0000olcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@1YolcVf@OohaL<2?o<i]T2o`00007ooooo000>
ooooo`;o00000oo<i]T7on<G35Koc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`000?o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9iG
olcVf@OohaL<00?oc>KIo`000?l000000Oooool000kooooo00?o0000on<G3?oS5``00_oS5``;olcV
f@?o0ZRN2oo<i]T3o`:XWP[oc>KI0ol2Z9h;olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h9olcV
f@;o0ZRN3?o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPWoc>KI0ol2Z9h;olcV
f@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWPcoc>KI0ooS5``1oooo
o`003_ooool00ol0003o0ZRNo`:XWP03o`:XWPOoc>KI0ol2Z9h:olcVf@Co0ZRN2_o<i]T3o`:XWP[o
c>KI1?l2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@Co0ZRN2_o<i]T3o`:XWP[o
c>KI1?l2Z9h:olcVf@?o0ZRN2_o<i]T4o`:XWP[oc>KI1?l2Z9h7olcVf@Co0ZRN0Oooool000kooooo
0_l00009olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWPcoc>KI
0_l2Z9h<olcVf@;o0ZRN3?o<i]T2o`:XWPkoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPgoc>KI
0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN3?o<i]T2o`:XWPOoc>KI
0_l00001ooooo`003_ooool2o`0005[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0=olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcV
f@0<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0Eoo<i]T2o`00007ooooo000>
ooooo`;o0000Moo<i]T00ol2Z9koc>KIolcVf@0=olcVf@03o`000?o<i]Woc>KI00goc>KI00?o0ZRN
olcVfOo<i]T0Loo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcV
f@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`00
3_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<
i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Wo
c>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00
007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo
0_l0001kolcVf@;o0ZRN2_o<i]T00ol0003oc>KIolcVf@07olcVf@;o0ZRNN_o<i]T2o`00007ooooo
000>ooooo`;o0000K_o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9i]olcVf@;o00000Oooool000kooooo0_l00000
1?o<i]Wo0ZRNo`:XW_l2Z9h9olcVf@Co0ZRN2Oo<i]T5o`:XWPWoc>KI1?l2Z9h9olcVf@Go0ZRN2Oo<
i]T5o`:XWPWoc>KI1?l2Z9h9olcVf@Go0ZRN2?o<i]T3o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0ol2Z9h9olcVf@Go0ZRN2?o<
i]T5o`:XWPWoc>KI1Ol2Z9h8olcVf@Go0ZRN2Oo<i]T5o`:XWPSoc>KI1Ol2Z9h9olcVf@Go0ZRN2Oo<
i]T3o`:XWP7o00000Oooool000kooooo00?o0000o`:XW_l2Z9h02?o<i]T4o`:XWPWoc>KI1?l2Z9h:
olcVf@Co0ZRN2Oo<i]T4o`:XWP[oc>KI1?l2Z9h:olcVf@Co0ZRN2Oo<i]T4o`:XWP_oc>KI0_l2Z9h=
olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;
olcVf@;o0ZRN3?o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@?o0ZRN2_o<i]T4o`:XWP[oc>KI0ol2Z9h:
olcVf@Co0ZRN2_o<i]T4o`:XWPOoc>KI0Ol00001o`:XWP7ooooo000>ooooo`;o0000J?o<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI06Goc>KI0_l00001ooooo`003_ooool2o`0007Ko
c>KI00?o0ZRNolcVfOo<i]T03_o<i]T00ol0003oc>KIolcVf@0=olcVf@03o`:XW_o<i]Woc>KI07?o
c>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo
000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027
olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcV
fOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o
00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_oo
ool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T0
0ol0003oc>KIolcVf@23olcVf@;o00000Oooool000Sooooo0_l00004ooooo`;o0000Q_o<i]T00ol2
Z9ko0000olcVf@24olcVf@;o00000Oooool000Oooooo00Co0000oooooooooooo00000oooool2o`00
08Goc>KI00Co0ZRNolcVfOl0003o0ZRNQ?o<i]T2o`00007ooooo0007ooooo`04o`000?oooooooooo
o`0000?oooooool0000Bo`00007ooooo0007ooooo`04o`000?ooooooooooo`0000?ooooo0_l00025
olcVf@05o`:XW_o<i]Wo0000olcVfOl2Z9h0Poo<i]T2o`00007ooooo0007ooooo`04o`000?oooooo
ooooo`0000?ooooo0_l00025olcVf@;o0ZRN00?o0000o`:XW_o<i]T0Poo<i]T2o`00007ooooo0007
ooooo`04o`000?ooooooooooo`0000?ooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l0
0001ooooo`002?ooool2o`0000Cooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001
ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o
0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`00
0?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<
i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool0
00kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Oo
c>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000M_o<i]T2o`:XWPooc>KI
00?o0000olcVfOo<i]T03?o<i]T2o`:XWWGoc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI1Ol2
Z9h8olcVf@Go0ZRN2Oo<i]T5o`:XWPSoc>KI1Ol2Z9h9olcVf@Go0ZRN2Oo<i]T5o`:XWPSoc>KI0ol2
Z9h;olcVf@?o0ZRN3Oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T3o`:XWP_oc>KI0ol2Z9h9olcVf@Go0ZRN2Oo<i]T4o`:XWPWoc>KI1Ol2
Z9h9olcVf@Co0ZRN2Oo<i]T5o`:XWPWoc>KI1Ol2Z9h7olcVf@;o00000Oooool000kooooo00?o0000
o`:XW_l2Z9h00ol2Z9h:olcVf@?o0ZRN2_o<i]T4o`:XWP[oc>KI0ol2Z9h:olcVf@Co0ZRN2_o<i]T4
o`:XWP[oc>KI0ol2Z9h8olcVf@Co0ZRN2_o<i]T3o`:XWP_oc>KI0_l2Z9h<olcVf@03o`000?o<i]Wo
c>KI00Woc>KI0_l2Z9h;olcVf@?o0ZRN2oo<i]T3o`:XWPSoc>KI1?l2Z9h:olcVf@Co0ZRN2Oo<i]T4
o`:XWP[oc>KI1?l2Z9h9olcVf@Co0ZRN2_o<i]T4o`:XWP[oc>KI1?l2Z9h1ooooo`003_ooool2o`00
067oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPcoc>KI0_l2Z9iOolcVf@;o00000Oooool000ko
oooo0_l0001lolcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000olcVfOo<i]T01oo<i]T00ol2Z9ko
c>KIolcVf@1iolcVf@;o00000Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI
0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<i]T0Poo<i]T2o`00007ooooo000>
ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o00000Oooool000kooooo0_l00027olcV
f@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2o`0008Ooc>KI00?o0000olcVfOo<
i]T0Poo<i]T2o`00007ooooo000>ooooo`;o0000Qoo<i]T00ol0003oc>KIolcVf@23olcVf@;o0000
0Oooool000kooooo0_l00027olcVf@03o`000?o<i]Woc>KI08?oc>KI0_l00001ooooo`003_ooool2
o`0007Ooc>KI00?o0ZRNolcVfOo<i]T03Oo<i]T00ol0003oc>KIolcVf@0=olcVf@03o`:XW_o<i]Wo
c>KI07?oc>KI0_l00001ooooo`003_ooool2o`0006Soc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI
00goc>KI00?o0000olcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRNIoo<i]T2o`00
007ooooo000>ooooo`;o0000?oo<i]T3o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN3_o<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T03?o<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@?o0ZRN?_o<i]T2o`00007o
oooo000>ooooo`04o`000?l2Z9ko0ZRNo`:XWPOoc>KI1Ol2Z9h8olcVf@Go0ZRN2Oo<i]T5o`:XWPSo
c>KI1Ol2Z9h<olcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0ol2Z9h=olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI0_l2Z9h<olcVf@?o0ZRN2oo<i]T3o`:XWPWoc>KI0ol2Z9h<olcVf@Go0ZRN2Oo<i]T4o`:XWPWo
c>KI1Ol2Z9h9olcVf@Go0ZRN1oo<i]T2o`:XWP7ooooo000>ooooo`03o`000?oS5`cohaL<00?ohaL<
2_o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@?o0ZRN2_o<i]T4o`:XWP_oc>KI0_l2Z9h;olcVf@;o0ZRN
2oo<i]T2o`:XWPcoc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@?o0ZRN
2_o<i]T2o`:XWP_oc>KI1?l2Z9h:olcVf@Co0ZRN2Oo<i]T4o`:XWP[oc>KI1?l2Z9h:olcVf@CohaL<
0Oooool000kooooo0_l00004olcVf@OohaL<BOo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0B?o<i]T7on<G30;oc>KI0_l00001ooooo`003_ooool2
o`0000_oc>KI1ooS5`aYolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@1XolcVf@OohaL<2Oo<i]T2o`00007ooooo000>ooooo`;o00004_o<i]T6on<G
36ooc>KI00?o0000olcVfOo<i]T0KOo<i]T6on<G313oc>KI0_l00001ooooo`003_ooool2o`0001So
c>KI1OoS5`aZolcVf@03o`000?o<i]Woc>KI06Soc>KI1OoS5``FolcVf@;o00000Oooool000kooooo
0_l0000MolcVf@?ohaL<Ioo<i]T00ol0003oc>KIolcVf@1TolcVf@CohaL<6oo<i]T2o`00007ooooo
000>ooooo`;o00008?o<i]T3on<G36Coc>KI00?o0000olcVfOo<i]T0HOo<i]T3on<G31ooc>KI0_l0
0001ooooo`003_ooool2o`0002?oc>KI1OoS5`aOolcVf@03o`000?o<i]Woc>KI05goc>KI1?oS5``R
olcVf@;o00000Oooool000kooooo0_l0000XolcVf@GohaL<F_o<i]T00ol0003oc>KIolcVf@1HolcV
f@GohaL<9_o<i]T2o`00007ooooo000>ooooo`;o0000;Oo<i]T4on<G34Koc>KI00?o0ZRNolcVfOo<
i]T03Oo<i]T00ol0003oc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI04Goc>KI1?oS5``[olcVf@;o
00000Oooool000kooooo0_l0000aolcVf@?ohaL<=Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI03Coc>KI0ooS5``_olcVf@;o00000Oooool000kooooo0_l0000dolcVf@?ohaL<2?o<
i]T2o`:XWPcoc>KI0_l2Z9h<olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<
i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWPWoc>KI0ooS5``bolcVf@;o00000Ooo
ool000kooooo0_l00009olcVf@?o0ZRN2_o<i]T3o`:XWP_oc>KI0ol2Z9h;olcVf@?o0ZRN0_o<i]T2
on<G30Soc>KI0ol2Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@?o0ZRN2?o<i]T3
on<G30;oc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWP_oc>KI0ol2Z9h7olcVf@;o00000Oooool0
00kooooo00Co0000o`:XW_l2Z9ko0ZRN2_o<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@?o0ZRN2oo<i]T3
o`:XWP04olcVfOoS5`cohaL<on<G30Soc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2
Z9h;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h8olcVf@?ohaL<00?oc>KIo`:XW_l2Z9h00_l2
Z9h:olcVf@?o0ZRN2oo<i]T3o`:XWP[oc>KI1?l2Z9h:olcVf@;o0ZRN0Oooool000kooooo0_l00002
olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP;oc>KI0ooS5``7
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRN
olcVfOo<i]T01Oo<i]T3on<G30;oc>KI0_l2Z9h<olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h<
olcVf@;o0ZRN0_l00001ooooo`003_ooool2o`0003ooc>KI0_oS5``ColcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0AolcVf@;ohaL<?_o<i]T2o`00
007ooooo000>ooooo`04o`000?oS5`cohaL<on<G33ooc>KI0ooS5``ZolcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003oc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T0:?o<i]T3on<G343oc>KI0_oS5``1ooooo`003_ooool2o`0000;o
c>KI0ooS5``oolcVf@;ohaL<@Oo<i]T00ol0003oc>KIolcVf@0nolcVf@;ohaL<@?o<i]T3on<G30;o
00000Oooool000kooooo0_l00005olcVf@CohaL<?Oo<i]T2on<G33ooc>KI00?o0000olcVfOo<i]T0
??o<i]T2on<G33koc>KI1?oS5``3olcVf@;o00000Oooool000kooooo0_l00009olcVf@GohaL<>_o<
i]T3on<G33coc>KI00?o0000olcVfOo<i]T0>_o<i]T2on<G33_oc>KI1OoS5``7olcVf@;o00000Ooo
ool000kooooo0_l0000>olcVf@CohaL<>Oo<i]T2on<G33[oc>KI00?o0000olcVfOo<i]T0>?o<i]T2
on<G33Woc>KI1?oS5``<olcVf@;o00000Oooool000kooooo0_l0000BolcVf@?ohaL<>?o<i]T2on<G
33Soc>KI00?o0000olcVfOo<i]T0=_o<i]T2on<G33Soc>KI0ooS5``@olcVf@;o00000Oooool000ko
oooo0_l0000EolcVf@?ohaL<=oo<i]T00ooS5`coc>KIolcVf@0eolcVf@03o`000?o<i]Woc>KI03Go
c>KI00?ohaL<olcVfOo<i]T0=Oo<i]T3on<G31?oc>KI0_l00001ooooo`003_ooool2o`0001Soc>KI
0ooS5``eolcVf@;ohaL<5oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00coc>KI
00?o0000olcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI01Koc>KI
0_oS5``eolcVf@?ohaL<5_o<i]T2o`00007ooooo0006ooooo`Go00000oooool2o`0001_oc>KI0ooS
5``_olcVf@;o0ZRN0oo<i]T00ooS5`coc>KIolcVf@06olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcV
f@0<olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h9olcVf@03on<G3?o<i]Woc>KI00;o0ZRN<?o<
i]T3on<G31Woc>KI0_l00001ooooo`001oooool01?l0003oooooooooool00003ooooo`;o00002Oo<
i]T2o`:XWP_oc>KI0_l2Z9h6olcVf@?ohaL<0oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3_o<
i]T01?l2Z9koc>KIolcVfOo<i]T2on<G30Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2on<G30;oc>KI
00?o0ZRNolcVfOo<i]T03?o<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN1?o<i]T3on<G30Goc>KI
0_l2Z9h;olcVf@;o0ZRN2?o<i]T2o`00007ooooo0008ooooo`03o`000?oooooooooo00?ooooo00Co
0000o`:XW_l2Z9ko0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9h6olcVf@;ohaL<0oo<i]T3o`:XWP_oc>KI
0ol2Z9h:olcVf@?o0ZRN3?o<i]T2o`:XWP?oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@?o
0ZRN0oo<i]T3on<G30Goc>KI0ol2Z9h:olcVf@?o0ZRN2_o<i]T2o`:XWP7ooooo0009ooooo`03o`00
0?oooooooooo00;ooooo0_l00002olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI0ol2Z9h5olcVf@?ohaL<
0oo<i]T2o`:XWPcoc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI0_l2Z9h<olcV
f@;o0ZRN2oo<i]T2o`:XWP?oc>KI0ooS5``6olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI0_l2Z9h2o`00
007ooooo0006ooooo`05o`000?ooooooooooooooool000000oooool2o`00013oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@?ohaL<0_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T01Ol2Z9koc>KIolcVfOo<i]Wo
haL<00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00?ohaL<2?o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00goc>KI0_l00001ooooo`001_ooool0
1Ol0003ooooooooooooooooo000000?ooooo0_l0000YolcVf@;ohaL<:Oo<i]T01Ol2Z9koc>KIolcV
fOo<i]WohaL<00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2on<G30?oc>KI00?o0ZRNolcVfOo<i]T0
9_o<i]T2on<G32Soc>KI0_l00001ooooo`001oooool3o`0000Cooooo00Co0000on<G3?oS5`cohaL<
:Oo<i]T3on<G32_oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI01;oc>KI00?ohaL<olcVfOo<i]T0:Oo<i]T3on<G32[oc>KI0_oS5``1ooooo`003_oo
ool2o`0000;oc>KI0_oS5``ZolcVf@?ohaL<:Oo<i]T00ooS5`coc>KIolcVf@0ZolcVf@03o`000?o<
i]Woc>KI02Woc>KI00?ohaL<olcVfOo<i]T0:?o<i]T2on<G32[oc>KI0ooS5``2o`00007ooooo000>
ooooo`;o00001?o<i]T3on<G32[oc>KI0_oS5``XolcVf@03on<G3?o<i]Woc>KI02Woc>KI00?o0000
olcVfOo<i]T0:?o<i]T00ooS5`coc>KIolcVf@0WolcVf@;ohaL<:Oo<i]T3on<G30?oc>KI0_l00001
ooooo`003_ooool2o`0000Ooc>KI0ooS5``YolcVf@;ohaL<9oo<i]T00ooS5`coc>KIolcVf@0XolcV
f@03o`000?o<i]Woc>KI02Ooc>KI00?ohaL<olcVfOo<i]T09_o<i]T2on<G32Soc>KI0ooS5``6olcV
f@;o00000Oooool000kooooo0_l0000:olcVf@?ohaL<:?o<i]T00ooS5`coc>KIolcVf@0UolcVf@03
on<G3?o<i]Woc>KI02Ooc>KI00?o0000olcVfOo<i]T09_o<i]T00ooS5`coc>KIolcVf@0VolcVf@03
on<G3?o<i]Woc>KI02Goc>KI0ooS5``9olcVf@;o00000Oooool000kooooo0_l0000=olcVf@CohaL<
9Oo<i]T2on<G32Koc>KI00?ohaL<olcVfOo<i]T09_o<i]T00ol0003oc>KIolcVf@0UolcVf@03on<G
3?o<i]Woc>KI02Goc>KI0_oS5``UolcVf@?ohaL<3?o<i]T2o`00007ooooo000>ooooo`;o00004Oo<
i]T3on<G32Coc>KI0_oS5``UolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?o0ZRNolcVfOo<i]T03?o<
i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T09?o<
i]T2on<G32Coc>KI0ooS5``?olcVf@;o00000Oooool000kooooo0_l0000DolcVf@;ohaL<9?o<i]T2
on<G31ooc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00coc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Wo
c>KI01koc>KI0_oS5``SolcVf@?ohaL<4_o<i]T2o`00007ooooo000>ooooo`;o00005_o<i]T2on<G
30coc>KI0_l2Z9h<olcVf@;o0ZRN2?o<i]T2on<G30;oc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T00ol2
Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2
Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2
Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:X
WPcoc>KI0_l2Z9h2olcVf@;ohaL<1oo<i]T2o`:XWPcoc>KI0_l2Z9h<olcVf@;ohaL<5Oo<i]T2o`00
007ooooo000>ooooo`;o00002Oo<i]T3o`:XWP_oc>KI00?o0ZRNon<G3?oS5``03?o<i]T2o`:XWPco
c>KI0_l2Z9h8olcVf@;ohaL<0_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00co
c>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP;oc>KI0_oS5``8olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI0_l2Z9h<olcVf@;ohaL<0_l2Z9h:olcVf@?o0ZRN2?o<i]T2o`00007ooooo000>ooooo`04o`00
0?l2Z9ko0ZRNo`:XWP[oc>KI0ol2Z9h:olcVf@04o`:XW_oS5`cohaL<on<G30_oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@07olcVf@03on<G3?o<i]Woc>KI00;o0ZRN2oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008
olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@?ohaL<0_l2Z9h9olcVf@?o0ZRN2oo<i]T2
o`:XWP7ooooo000>ooooo`;o00000_o<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:XW_oS5`cohaL<
00[oc>KI0_l2Z9h<olcVf@;o0ZRN2?o<i]T2on<G30;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h2olcVf@;ohaL<2?o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@;o0ZRN2_o<i]T2on<G30;o0ZRN2_o<i]T2o`:XWPcoc>KI0_l2Z9h2o`00
007ooooo000>ooooo`03o`000?oS5`coc>KI01goc>KI00Co0ZRNon<G3?oS5`cohaL<2Oo<i]T00ol2
Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN2oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G
3009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2on<G3003olcVfOl2
Z9koc>KI01_oc>KI0Ol00001on<G307ooooo000>ooooo`04o`000?oS5`cohaL<on<G323oc>KI0ooS
5``OolcVf@;ohaL<3Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``0
2?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Wo
c>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00coc>KI0_oS5``OolcVf@?ohaL<7oo<i]T3on<G307o
oooo000>ooooo`;o00000_o<i]T3on<G323oc>KI0_oS5``OolcVf@03on<G3?o<i]Woc>KI01coc>KI
00?ohaL<olcVfOo<i]T04_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI
0ooS5``OolcVf@?ohaL<00?oc>KIo`000?l000000Oooool000kooooo0_l00005olcVf@CohaL<7_o<
i]T00ooS5`coc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T07_o<
i]T00ol0003oc>KIolcVf@0MolcVf@03on<G3?o<i]Woc>KI01coc>KI0_oS5``NolcVf@03on<G3?o<
i]Woc>KI01goc>KI0ooS5``4olcVf@;o00000Oooool000kooooo0_l00009olcVf@?ohaL<7?o<i]T2
on<G31koc>KI00?ohaL<olcVfOo<i]T07?o<i]T00ooS5`coc>KIolcVf@0MolcVf@03o`000?o<i]Wo
c>KI01goc>KI00?ohaL<olcVfOo<i]T06oo<i]T00ooS5`coc>KIolcVf@0LolcVf@;ohaL<7Oo<i]T3
on<G30Ooc>KI0_l00001ooooo`003_ooool2o`0000coc>KI0_oS5``LolcVf@03on<G3?o<i]Woc>KI
01coc>KI0_oS5``MolcVf@03on<G3?o<i]Woc>KI01coc>KI00?o0000olcVfOo<i]T07?o<i]T00ooS
5`coc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01coc>KI00?ohaL<olcVfOo<i]T06_o<i]T3on<G
30[oc>KI0_l00001ooooo`003_ooool2o`0000koc>KI0_oS5``KolcVf@;ohaL<7_o<i]T00ooS5`co
c>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01coc>KI00?o0000olcVfOo<i]T07?o<i]T00ooS5`co
c>KIolcVf@0JolcVf@03on<G3?o<i]Woc>KI01_oc>KI0_oS5``KolcVf@;ohaL<3Oo<i]T2o`00007o
oooo000>ooooo`;o00004?o<i]T2on<G31_oc>KI0_oS5``MolcVf@03on<G3?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T06oo<i]T00ol0003oc>KIolcVf@0KolcVf@03on<G3?o<i]Woc>KI01[oc>KI
00?ohaL<olcVfOo<i]T06_o<i]T2on<G31_oc>KI0_oS5``?olcVf@;o00000Oooool000kooooo0_l0
000BolcVf@?ohaL<6_o<i]T2on<G31coc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0;olcVf@03o`:XW_oS5`coc>KI01_oc>KI00?ohaL<olcVfOo<i]T06_o<i]T00ooS5`coc>KIolcV
f@0IolcVf@;ohaL<4Oo<i]T2o`00007ooooo000>ooooo`;o00005Oo<i]T3on<G31Woc>KI0_oS5``=
olcVf@;o0ZRN3?o<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
on<G3?o<i]T02oo<i]T2o`:XWPgoc>KI0_oS5``IolcVf@?ohaL<4oo<i]T2o`00007ooooo000>oooo
o`;o00002Oo<i]T2o`:XWPcoc>KI00?o0ZRNon<G3?oS5``02_o<i]T2o`:XWPcoc>KI00?o0ZRNon<G
3?o<i]T03Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000olcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00goc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI0_oS5``<olcV
f@;o0ZRN2oo<i]T2on<G3003o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h8olcVf@;o00000Oooool000ko
oooo0_l0000;olcVf@?o0ZRN2oo<i]T00ol2Z9kohaL<on<G300:olcVf@;o0ZRN3?o<i]T00ooS5`co
c>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<i]T02oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol0003o
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@;o0ZRN2oo<i]T2on<G3003o`:XW_o<i]Woc>KI00Soc>KI0ol2Z9h:olcVf@;o
00000Oooool000kooooo00Co0000on<G3?oS5`co0ZRN3?o<i]T2o`:XWP_oc>KI00?o0ZRNon<G3?o<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;ohaL<3Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
on<G3?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9kohaL<olcVf@0;olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI0_oS5``<olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<
i]T02_o<i]T2o`:XWPgoc>KI0_oS5``1ooooo`003_ooool2o`000004olcVfOoS5`cohaL<on<G30co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T2on<G30[oc>KI0_l2Z9h<olcVf@;ohaL<3?o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ooS5`co
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
haL<olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_oS5``<olcVf@;o0ZRN2oo<i]T2on<G30_o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T2on<G30;o00000Oooool000kooooo0_l00004olcVf@;ohaL<
6Oo<i]T2on<G30[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<olcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_oS5``IolcVf@;ohaL<0_o<i]T2o`00007ooooo000>ooooo`;o00001_o<
i]T3on<G31Soc>KI00?ohaL<olcVfOo<i]T05_o<i]T2on<G31Ooc>KI00?ohaL<olcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol0003oc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI01Goc>KI0_oS5``HolcVf@;ohaL<6?o<
i]T3on<G30Coc>KI0_l00001ooooo`003_ooool2o`0000Woc>KI0_oS5``GolcVf@;ohaL<6?o<i]T0
0ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Ooc>KI00?ohaL<olcVfOo<i]T05_o<i]T0
0ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05Oo<i]T0
0ooS5`coc>KIolcVf@0FolcVf@;ohaL<6?o<i]T2on<G30Ooc>KI0_l00001ooooo`003_ooool2o`00
00_oc>KI0_oS5``GolcVf@;ohaL<5oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI
01Koc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ol0003oc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI
01Goc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0FolcVf@03on<G3?o<i]Woc>KI
01Goc>KI0ooS5``9olcVf@;o00000Oooool000kooooo0_l0000=olcVf@;ohaL<5oo<i]T00ooS5`co
c>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`co
c>KIolcVf@0EolcVf@03o`000?o<i]Woc>KI01Goc>KI00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`co
c>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Koc>KI00?ohaL<olcVfOo<i]T05?o<i]T2on<G30co
c>KI0_l00001ooooo`003_ooool2o`0000ooc>KI0_oS5``FolcVf@;ohaL<5_o<i]T2on<G31Goc>KI
00?ohaL<olcVfOo<i]T05_o<i]T00ooS5`coc>KIolcVf@0EolcVf@03o`000?o<i]Woc>KI01Goc>KI
00?ohaL<olcVfOo<i]T05Oo<i]T00ooS5`coc>KIolcVf@0ColcVf@;ohaL<5oo<i]T2on<G31Goc>KI
0_oS5``>olcVf@;o00000Oooool000kooooo0_l0000AolcVf@;ohaL<5_o<i]T2on<G31Koc>KI00?o
haL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01Goc>KI00?o
0000olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0EolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?o
haL<olcVfOo<i]T05?o<i]T3on<G31Goc>KI0_oS5``@olcVf@;o00000Oooool000kooooo0_l0000C
olcVf@?ohaL<5Oo<i]T2on<G31Goc>KI00?ohaL<olcVfOo<i]T04oo<i]T00ooS5`coc>KIolcVf@0E
olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0C
olcVf@03on<G3?o<i]Woc>KI01Coc>KI00?ohaL<olcVfOo<i]T04oo<i]T3on<G31;oc>KI0_l00001
ooooo`003_ooool2o`0001Koc>KI0_oS5``EolcVf@03on<G3?o<i]Woc>KI01?oc>KI00?ohaL<olcV
fOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgoc>KI00?o0ZRN
olcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0000
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o
haL<olcVfOo<i]T05?o<i]T00ooS5`coc>KIolcVf@0BolcVf@;ohaL<5Oo<i]T2o`00007ooooo000>
ooooo`;o00002Oo<i]T2o`:XWPcoc>KI00?o0ZRNon<G3?o<i]T02_o<i]T2o`:XWPSoc>KI00CohaL<
olcVfOo<i]Woc>KI0_l2Z9h<olcVf@;o0ZRN0_o<i]T00ooS5`coc>KIolcVf@07olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<
i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]WohaL<00_oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00coc>KI
0_l2Z9h4olcVf@03on<G3?o<i]Woc>KI00Goc>KI0_l2Z9h;olcVf@03on<G3?l2Z9ko0ZRN00_oc>KI
0_l2Z9h8olcVf@;o00000Oooool000kooooo0_l0000;olcVf@;o0ZRN3?o<i]T00ooS5`coc>KIolcV
f@0:olcVf@;o0ZRN1oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co
0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPgo
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00_o
c>KI00?o0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<
olcVfOo<i]T01?o<i]T2o`:XWPcoc>KI00?ohaL<o`:XW_o<i]T02_o<i]T2o`:XWP[oc>KI0_l00001
ooooo`003_ooool00ol0003o0ZRNo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_oS5``<olcV
f@03o`:XW_o<i]Woc>KI00Goc>KI0_oS5``3olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00Co0ZRNolcV
fOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0000olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI
00GohaL<olcVfOo<i]Woc>KIo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00;oc>KI0_oS5``6olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI0_oS5``<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h1ooooo`00
3_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI0_l2Z9h<olcVf@;ohaL<2oo<i]T2o`:XWPOoc>KI
00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@04o`:XW_o<i]Woc>KIon<G30Woc>KI00?o0ZRNolcV
fOo<i]T02?o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcV
fOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOoS5``02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T0
0ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Coc>KI0_l2Z9h;olcVf@;ohaL<00?o0ZRN
olcVfOo<i]T02Oo<i]T2o`:XWPcoc>KI00?o0ZRNo`000?l000000Oooool000kooooo0_l00002olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9kohaL<on<G300;olcV
f@03o`:XW_o<i]Woc>KI00Goc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=olcVf@04o`:XW_o<i]Wo
c>KIon<G30Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01?oS5`coc>KIolcVfOl2Z9h<olcVf@03o`:X
W_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`00
0?o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@04
on<G3?o<i]Woc>KIo`:XWPcoc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@04olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI0_oS5``00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00Co0ZRNolcVfOl0003o00000Oooool000kooooo0_l0000PolcVf@;ohaL<4_o<i]T01OoS
5`coc>KIolcVfOo<i]Wo0ZRN00goc>KI00Co0ZRNolcVfOo<i]WohaL<2Oo<i]T00ol2Z9koc>KIolcV
f@07olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KI
olcVf@05olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T01?l2Z9koc>KI
olcVfOoS5``9olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T01?l2
Z9koc>KIolcVfOo<i]T2on<G317oc>KI0_oS5``OolcVf@;o00000Oooool000kooooo0_l0000RolcV
f@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04_o<i]T00ooS5`coc>KIolcVf@0AolcV
f@03on<G3?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@05olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@05olcV
f@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0BolcV
f@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0OolcV
f@;o00000Oooool000kooooo0_l0000SolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<
i]T04_o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<
i]T04_o<i]T00ol0003oc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI017oc>KI00?ohaL<olcVfOo<
i]T04Oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<
i]T08?o<i]T2o`00007ooooo000>ooooo`;o00009?o<i]T00ooS5`coc>KIolcVf@0@olcVf@;ohaL<
4_o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T0
4_o<i]T00ol0003oc>KIolcVf@0AolcVf@03on<G3?o<i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T0
4Oo<i]T00ooS5`coc>KIolcVf@0@olcVf@;ohaL<4_o<i]T00ooS5`coc>KIolcVf@0QolcVf@;o0000
0Oooool000kooooo0_l0000UolcVf@;ohaL<4_o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<
i]Woc>KI017oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<
i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03on<G3?o<
i]Woc>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T2on<G32Coc>KI0_l00001ooooo`003_ooool2
o`0002Ooc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Wo
c>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<i]Wo
c>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Wo
c>KI013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0TolcVf@;o00000Oooool0
00kooooo0_l0000XolcVf@03on<G3?o<i]Woc>KI013oc>KI0_oS5``AolcVf@03on<G3?o<i]Woc>KI
013oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0AolcVf@03o`000?o<i]Woc>KI
013oc>KI00?ohaL<olcVfOo<i]T03oo<i]T00ooS5`coc>KIolcVf@0@olcVf@03on<G3?o<i]Woc>KI
013oc>KI00?ohaL<olcVfOo<i]T04?o<i]T00ooS5`coc>KIolcVf@0UolcVf@;o00000Oooool000ko
oooo0_l0000YolcVf@;ohaL<4_o<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`coc>KIolcVf@06olcVf@03o`:XW_o<i]Woc>KI00Oo
c>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0>olcVf@03o`000?o<i]Woc>KI00_oc>KI00Go0ZRNolcV
fOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00?ohaL<olcVfOo<i]T00_o<i]T0
0ol2Z9koc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00ooc>KI00?ohaL<olcVfOo<i]T03oo<i]T2
on<G32Soc>KI0_l00001ooooo`002?ooool3o`0000?ooooo0_l0000UolcVf@;o0ZRN1?o<i]T00ooS
5`coc>KIolcVf@04olcVf@;o0ZRN2_o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03o`:XW_oS5`coc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0>olcVf@03o`000?o<i]Woc>KI00_oc>KI00Go0ZRN
olcVfOo<i]Woc>KIon<G3009olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00coc>KI00Co0ZRNolcVfOo<i]WohaL<
2Oo<i]T2o`:XWPKoc>KI00?ohaL<olcVfOo<i]T00oo<i]T2o`:XWR?oc>KI0_l00001ooooo`002Ooo
ool00ol0003oooooooooo`02ooooo`;o00002Oo<i]T2o`:XWPcoc>KI0_l2Z9h>olcVf@03o`:XW_o<
i]Woc>KI00;oc>KI0_oS5``6olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?ohaL<o`:XW_o<i]T03?o<
i]T00ol2Z9koc>KIon<G300<olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<
i]T00ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03_o<i]T00ol0003oc>KI
olcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@06olcVf@03
on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`coc>KIo`:XWP0=olcVf@03
o`:XW_o<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`coc>KIolcVf@03olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI0_l2Z9h<olcVf@;o0ZRN2?o<i]T2o`00007ooooo0006ooooo`Go0000
0oooool2o`0000_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T0
0oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h0
3Oo<i]T00ol2Z9koc>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T0
1Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol0003oc>KIolcVf@0;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9ko
c>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00?oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co
0ZRNolcVf@0<olcVf@03o`:XW_o<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T00ooS5`co
c>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP[o
c>KI0_l00001ooooo`001_ooool01?l0003oooooooooool00004ooooo`03o`000?l2Z9ko0ZRN00co
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9ko
c>KIon<G300;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9ko
c>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol0003oc>KIolcVf@0;olcV
f@04o`:XW_o<i]Woc>KIon<G30Soc>KI00?o0ZRNolcVfOo<i]T01_o<i]T00ooS5`coc>KIolcVf@02
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T03?o<i]T00ol2Z9koc>KIon<G3009
olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN0Oooool000Oooooo00?o0000oooo
ool000001?ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T00oo<i]T2on<G30Goc>KI00?o0ZRNolcVfOo<i]T01oo<i]T00ooS
5`coc>KIo`:XWP0=olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS
5`coc>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00Koc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP0=
olcVf@03o`000?o<i]Woc>KI00[oc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008olcVf@03o`:XW_o<
i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03on<G3?l2
Z9koc>KI00_oc>KI00?o0ZRNolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@04olcVf@;ohaL<1Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h<olcVf@03o`:XW_l0
003o0000007ooooo0008ooooo`;o00001?ooool2o`0000;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T01?o<i]T0
0ooS5`coc>KIolcVf@03olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T0
0ol2Z9kohaL<olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T0
0ol2Z9koc>KIolcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03Oo<i]T00ol0003oc>KIolcV
f@0:olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@03o`:X
W_o<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@04o`:X
W_o<i]Wo0000o`00007ooooo0009ooooo`03o`000?oooooooooo00;ooooo0_l0000colcVf@03on<G
3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOl2Z9h03Oo<i]T00ol2Z9kohaL<olcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@0:olcVf@05o`:X
W_o<i]Woc>KIolcVfOoS5``01oo<i]T00ol2Z9koc>KIolcVf@05olcVf@03on<G3?o<i]Woc>KI00;o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ooS5`co0ZRNolcVf@0;olcVf@04o`:XW_o<i]Woc>KIon<G
30ooc>KI00?ohaL<olcVfOo<i]T0;oo<i]T2o`00007ooooo000>ooooo`;o0000=?o<i]T00ooS5`co
c>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`co
c>KIolcVf@0>olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h03?o<i]T00ol0003oc>KIolcVf@0:olcV
f@04o`:XW_o<i]Woc>KIon<G313oc>KI00?ohaL<olcVfOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0>
olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T0<?o<i]T2o`00007ooooo000>oooo
o`;o0000=Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcV
fOo<i]T03_o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00koc>KI00?o0000olcV
fOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcV
fOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI037oc>KI0_l00001oooo
o`003_ooool2o`0003Koc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03
on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03
o`000?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0>olcVf@03
on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<i]T2on<G33Coc>KI0_l00001ooooo`00
3_ooool2o`0003Ooc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0>olcVf@03o`00
0?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G
3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0dolcVf@;o0000
0Oooool000kooooo0_l0000holcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<
i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Woc>KI00goc>KI00?ohaL<olcVfOo<i]T03Oo<
i]T00ol0003oc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00koc>KI00?ohaL<olcVfOo<i]T03Oo<
i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00coc>KI00?ohaL<olcVfOo<i]T0=Oo<
i]T2o`00007ooooo000>ooooo`;o0000>Oo<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Wo
c>KI00coc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Wo
c>KI00goc>KI00?o0000olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0=olcVf@03on<G3?o<i]Wo
c>KI00goc>KI00?ohaL<olcVfOo<i]T03?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Wo
c>KI03Koc>KI0_l00001ooooo`003_ooool2o`0003[oc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@06olcVf@03on<G3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T01OoS
5`coc>KIolcVfOo<i]Wo0ZRN00_oc>KI00?ohaL<olcVfOl2Z9h03?o<i]T00ooS5`co0ZRNolcVf@0=
olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T01?l2Z9koc>KIolcVfOoS
5``:olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcV
f@03olcVf@03on<G3?o<i]Woc>KI00Goc>KI00?o0ZRNolcVfOo<i]T01?o<i]T00ooS5`coc>KIolcV
f@0folcVf@;o00000Oooool000kooooo0_l00009olcVf@;o0ZRN3?o<i]T2o`:XWPcoc>KI0_l2Z9h;
olcVf@;o0ZRN1oo<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI00GohaL<
olcVfOo<i]Woc>KIo`:XWP0:olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?ohaL<olcVfOl2Z9h0
3?o<i]T00ooS5`co0ZRNolcVf@0=olcVf@03o`000?o<i]Woc>KI00_oc>KI00?o0ZRNon<G3?o<i]T0
2oo<i]T00ol2Z9koc>KIon<G300;olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`co
c>KIolcVf@04olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2Z9h<olcVf@;o0ZRN2?o<i]T2o`00007o
oooo000>ooooo`;o00002oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Goc>KI00?ohaL<olcVfOo<i]T00_o<i]T00ol2Z9koc>KI
olcVf@07olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02Oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN
00[oc>KI00CohaL<olcVfOo<i]Wo0ZRN3?o<i]T00ooS5`coc>KIolcVf@0<olcVf@03o`000?o<i]Wo
c>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol2Z9koc>KIon<G300:olcVf@05o`:XW_o<i]Wo
c>KIolcVfOoS5``02Oo<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00?o
0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l0
0001ooooo`003_ooool00ol0003o0ZRNo`:XWP0<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<
olcVfOo<i]T00oo<i]T00ol2Z9koc>KIolcVf@07olcVf@04on<G3?o<i]Woc>KIo`:XWPWoc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0;olcVf@03on<G3?o<i]Wo0ZRN00coc>KI00?ohaL<o`:XW_o<i]T0
3?o<i]T00ol0003oc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00Co0ZRNolcVfOo<i]Wo
haL<2_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3008
olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h1
ooooo`003_ooool2o`000003olcVfOl2Z9koc>KI00_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI
00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Woc>KI
00?oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Woc>KI00GohaL<
olcVfOo<i]Woc>KIo`:XWP0:olcVf@04on<G3?o<i]Woc>KIo`:XWP_oc>KI00?ohaL<o`:XW_o<i]T0
3?o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00_oc>KI00?o0ZRNolcVfOoS5``0
2_o<i]T01Ol2Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOo<i]T00_o<i]T00ooS5`co
c>KIolcVf@05olcVf@03o`:XW_o<i]Woc>KI00?oc>KI00?ohaL<olcVfOo<i]T01?o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_l0003o0000007ooooo000>ooooo`;o00000_o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Coc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2Z9koc>KI
olcVf@06olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02?o<i]T00ooS5`coc>KIolcVf@02olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI00CohaL<olcVfOo<i]Wo0ZRN2oo<i]T00ooS5`co0ZRNolcVf@0<olcV
f@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol2Z9koc>KIon<G300:olcV
f@05o`:XW_o<i]Woc>KIolcVfOoS5``02?o<i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Wo
c>KI00Goc>KI00?o0ZRNolcVfOo<i]T00oo<i]T00ooS5`coc>KIolcVf@04olcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00Co0ZRNolcVfOl0003o00000Oooool000kooooo0_l0000MolcVf@03o`:XW_o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@04olcVf@03on<G3?o<i]Wo
c>KI00?oc>KI00?o0ZRNolcVfOo<i]T01Oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Woc>KI00Go
haL<olcVfOo<i]Woc>KIo`:XWP0:olcVf@03on<G3?o<i]Wo0ZRN00_oc>KI00?ohaL<olcVfOl2Z9h0
3?o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00Co0ZRNolcVfOo<i]Wo
haL<2_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``01oo<i]T0
0ol2Z9koc>KIolcVf@03olcVf@03on<G3?o<i]Woc>KI00Coc>KI00?o0ZRNolcVfOo<i]T02oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI01[oc>KI0_l00001ooooo`003_ooool2o`00
043oc>KI00?ohaL<olcVfOo<i]T02oo<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Woc>KI00GohaL<
olcVfOo<i]Woc>KIo`:XWP09olcVf@04on<G3?o<i]Woc>KIo`:XWP[oc>KI00?ohaL<olcVfOl2Z9h0
3?o<i]T00ol0003oc>KIolcVf@0:olcVf@03o`:XW_oS5`coc>KI00[oc>KI00?o0ZRNolcVfOoS5``0
2_o<i]T01?l2Z9koc>KIolcVfOoS5``9olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``03Oo<i]T00ooS
5`coc>KIolcVf@0molcVf@;o00000Oooool000kooooo0_l00011olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0<olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?ohaL<olcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_o
c>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[o
c>KI00?ohaL<olcVfOo<i]T0?_o<i]T2o`00007ooooo000>ooooo`;o0000@Oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0000olcVfOo<i]T02_o<i]T00ooS5`coc>KI
olcVf@0<olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KI
olcVf@0;olcVf@03on<G3?o<i]Woc>KI03koc>KI0_l00001ooooo`003_ooool2o`0004;oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?o
haL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0oolcVf@;o00000Oooool000kooooo0_l00013
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ooS5`coc>KIolcVf@0;
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T02oo<i]T00ol0003oc>KIolcVf@0:
olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcVfOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;
olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcVfOo<i]T0@?o<i]T2o`00007ooooo000>oooo
o`;o0000@oo<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0:olcVf@03on<G3?o<i]Woc>KI00_oc>KI00?o0000olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI00[oc>KI00?ohaL<olcV
fOo<i]T02_o<i]T00ooS5`coc>KIolcVf@0;olcVf@03on<G3?o<i]Woc>KI043oc>KI0_l00001oooo
o`003_ooool2o`0004Coc>KI00?ohaL<olcVfOo<i]T02?o<i]T00ol2Z9koc>KIon<G300:olcVf@;o
0ZRN00?oc>KIon<G3?o<i]T02Oo<i]T2o`:XWP03on<G3?o<i]Woc>KI00Woc>KI00?o0ZRNon<G3?o<
i]T03?o<i]T00ol0003oc>KIolcVf@0:olcVf@03on<G3?l2Z9koc>KI00[oc>KI00?ohaL<olcVfOl2
Z9h02oo<i]T00ooS5`coc>KIo`:XWP0:olcVf@04on<G3?o<i]Woc>KIo`:XWPWoc>KI00?ohaL<olcV
fOo<i]T0@Oo<i]T2o`00007ooooo000>ooooo`;o00002_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o
0ZRN0oo<i]T00ooS5`coc>KIolcVf@06olcVf@05o`:XW_o<i]Woc>KIolcVfOoS5``02Oo<i]T01Ol2
Z9koc>KIolcVfOo<i]WohaL<00Woc>KI00?o0ZRNolcVfOoS5``02oo<i]T00ol2Z9kohaL<olcVf@0<
olcVf@03o`000?o<i]Woc>KI00[oc>KI00?ohaL<o`:XW_o<i]T02_o<i]T00ooS5`coc>KIo`:XWP0:
olcVf@04on<G3?o<i]Woc>KIo`:XWPWoc>KI00GohaL<olcVfOo<i]Woc>KIo`:XWP08olcVf@03on<G
3?o<i]Woc>KI00;oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN
3?o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00001ooooo`003_oo
ool2o`0000Woc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<
i]T00ol2Z9koc>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Ooc>KI00Co0ZRNolcVfOo<i]WohaL<
2Oo<i]T01?l2Z9koc>KIolcVfOoS5``:olcVf@03o`:XW_oS5`coc>KI00coc>KI00?o0000olcVfOo<
i]T02_o<i]T00ooS5`co0ZRNolcVf@0:olcVf@03on<G3?o<i]Wo0ZRN00[oc>KI00?ohaL<olcVfOl2
Z9h02_o<i]T01OoS5`coc>KIolcVfOo<i]Wo0ZRN00Ooc>KI00?ohaL<olcVfOo<i]T00oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0;olcVf@;o0ZRN2?o<i]T2o`00007ooooo000>ooooo`;o00002oo<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00;oc>KI00?ohaL<olcVfOo<i]T01Oo<i]T00ol2Z9ko
c>KIolcVf@02olcVf@03on<G3?o<i]Woc>KI00Koc>KI00Go0ZRNolcVfOo<i]Woc>KIon<G3009olcV
f@03o`:XW_o<i]WohaL<00_oc>KI00?o0ZRNon<G3?o<i]T02oo<i]T00ol0003oc>KIolcVf@09olcV
f@03on<G3?l2Z9koc>KI00[oc>KI00?ohaL<olcVfOl2Z9h02_o<i]T01?oS5`coc>KIolcVfOl2Z9h9
olcVf@05on<G3?o<i]Woc>KIolcVfOl2Z9h02?o<i]T00ooS5`coc>KIolcVf@02olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`00007ooooo000>ooooo`03o`000?l2Z9ko
000000_o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`00000;o`000003o`:XW_l0003o
000000[o000000?o0ZRNo`000?l000002ol000000ol2Z9ko0000o`000002o`000003on<G3?l0003o
000000Go000000Go0ZRNo`000?l0003o0000on<G3009o`000004o`:XW_l0003o0000on<G30Wo0000
00?o0ZRNo`000?oS5``02ol000000ol2Z9kohaL<o`00000Go`000003on<G3?l2Z9ko000000[o0000
00?ohaL<o`000?l2Z9h02_l000000ooS5`co0000o`:XWP09o`000005on<G3?l0003o0000o`000?l2
Z9h02?l000000ooS5`co0000o`000002o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o000000_o000000?o0ZRNo`000?l0
00002ol00001o`:XWP003_ooooooo`0001;o00000Oooool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.56707, -5.51412, 0.0368353, \
0.0368353}}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Center", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(yf[x_, y_] = \(-x\)\)], "Input"],

Cell[BoxData[
    \(\(-x\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(xf[x_, y_] = y\)], "Input"],

Cell[BoxData[
    \(y\)], "Output"]
}, Closed]],

Cell["\<\
Define the intervals containing x and y:   Change the  appropriate \
items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extents[{x, \(-5\), 5}, {y, \(-5\), 5}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {\(\(-5\) \[LessEqual] x \[LessEqual] 5\)},
          {\(\(-5\) \[LessEqual] y \[LessEqual] 5\)}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        LessEqual[ -5, x, 5], 
        LessEqual[ -5, y, 5]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection"],

Cell["Verify that either this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dy\/dx == yf[x, y]\/xf[x, y] // TraditionalForm\)], "Input"],

Cell[BoxData[
    \(TraditionalForm\`dy\/dx == \(-\(x\/y\)\)\)], "Output"]
}, Closed]],

Cell["or this:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{\(y'\)[t] == yf[x[t], y[t]], \(x'\)[t] == xf[x[t], y[t]]}] // 
      TraditionalForm\)], "Input"],

Cell[BoxData[
    FormBox[
      InterpretationBox[GridBox[{
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["y", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(-\(x(t)\)\)}]},
            {
              RowBox[{
                RowBox[{
                  SuperscriptBox["x", "\[Prime]",
                    MultilineFunction->None], "(", "t", ")"}], 
                "==", \(y(t)\)}]}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {
          Equal[ 
            Derivative[ 1][ y][ t], 
            Times[ -1, 
              x[ t]]], 
          Equal[ 
            Derivative[ 1][ x][ t], 
            y[ t]]}],
        Editable->False], TraditionalForm]], "Output"]
}, Closed]],

Cell["is a correct representation of your differential equation.", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Vector Field", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DirFld = 
        PlotVectorField[xf[x, y], 
          yf[x, y], {x, xL, xR, 20}, {y, yB, yT, 20}];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0933707 0.5 0.0933707 [
[.12652 -0.0125 -6 -9 ]
[.12652 -0.0125 6 0 ]
[.31326 -0.0125 -6 -9 ]
[.31326 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.68674 -0.0125 -3 -9 ]
[.68674 -0.0125 3 0 ]
[.87348 -0.0125 -3 -9 ]
[.87348 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .12652 -12 -4.5 ]
[-0.0125 .12652 0 4.5 ]
[-0.0125 .31326 -12 -4.5 ]
[-0.0125 .31326 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .68674 -6 -4.5 ]
[-0.0125 .68674 0 4.5 ]
[-0.0125 .87348 -6 -4.5 ]
[-0.0125 .87348 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.12652 0 m
.12652 .00625 L
s
[(-4)] .12652 -0.0125 0 1 Mshowa
.31326 0 m
.31326 .00625 L
s
[(-2)] .31326 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.68674 0 m
.68674 .00625 L
s
[(2)] .68674 -0.0125 0 1 Mshowa
.87348 0 m
.87348 .00625 L
s
[(4)] .87348 -0.0125 0 1 Mshowa
.125 Mabswid
.1732 0 m
.1732 .00375 L
s
.21989 0 m
.21989 .00375 L
s
.26657 0 m
.26657 .00375 L
s
.35994 0 m
.35994 .00375 L
s
.40663 0 m
.40663 .00375 L
s
.45331 0 m
.45331 .00375 L
s
.54669 0 m
.54669 .00375 L
s
.59337 0 m
.59337 .00375 L
s
.64006 0 m
.64006 .00375 L
s
.73343 0 m
.73343 .00375 L
s
.78011 0 m
.78011 .00375 L
s
.8268 0 m
.8268 .00375 L
s
.07983 0 m
.07983 .00375 L
s
.03315 0 m
.03315 .00375 L
s
.92017 0 m
.92017 .00375 L
s
.96685 0 m
.96685 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .12652 m
.00625 .12652 L
s
[(-4)] -0.0125 .12652 1 0 Mshowa
0 .31326 m
.00625 .31326 L
s
[(-2)] -0.0125 .31326 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .68674 m
.00625 .68674 L
s
[(2)] -0.0125 .68674 1 0 Mshowa
0 .87348 m
.00625 .87348 L
s
[(4)] -0.0125 .87348 1 0 Mshowa
.125 Mabswid
0 .1732 m
.00375 .1732 L
s
0 .21989 m
.00375 .21989 L
s
0 .26657 m
.00375 .26657 L
s
0 .35994 m
.00375 .35994 L
s
0 .40663 m
.00375 .40663 L
s
0 .45331 m
.00375 .45331 L
s
0 .54669 m
.00375 .54669 L
s
0 .59337 m
.00375 .59337 L
s
0 .64006 m
.00375 .64006 L
s
0 .73343 m
.00375 .73343 L
s
0 .78011 m
.00375 .78011 L
s
0 .8268 m
.00375 .8268 L
s
0 .07983 m
.00375 .07983 L
s
0 .03315 m
.00375 .03315 L
s
0 .92017 m
.00375 .92017 L
s
0 .96685 m
.00375 .96685 L
s
.25 Mabswid
0 0 m
0 1 L
s
.12652 .99375 m
.12652 1 L
s
.31326 .99375 m
.31326 1 L
s
.5 .99375 m
.5 1 L
s
.68674 .99375 m
.68674 1 L
s
.87348 .99375 m
.87348 1 L
s
.125 Mabswid
.1732 .99625 m
.1732 1 L
s
.21989 .99625 m
.21989 1 L
s
.26657 .99625 m
.26657 1 L
s
.35994 .99625 m
.35994 1 L
s
.40663 .99625 m
.40663 1 L
s
.45331 .99625 m
.45331 1 L
s
.54669 .99625 m
.54669 1 L
s
.59337 .99625 m
.59337 1 L
s
.64006 .99625 m
.64006 1 L
s
.73343 .99625 m
.73343 1 L
s
.78011 .99625 m
.78011 1 L
s
.8268 .99625 m
.8268 1 L
s
.07983 .99625 m
.07983 1 L
s
.03315 .99625 m
.03315 1 L
s
.92017 .99625 m
.92017 1 L
s
.96685 .99625 m
.96685 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .12652 m
1 .12652 L
s
.99375 .31326 m
1 .31326 L
s
.99375 .5 m
1 .5 L
s
.99375 .68674 m
1 .68674 L
s
.99375 .87348 m
1 .87348 L
s
.125 Mabswid
.99625 .1732 m
1 .1732 L
s
.99625 .21989 m
1 .21989 L
s
.99625 .26657 m
1 .26657 L
s
.99625 .35994 m
1 .35994 L
s
.99625 .40663 m
1 .40663 L
s
.99625 .45331 m
1 .45331 L
s
.99625 .54669 m
1 .54669 L
s
.99625 .59337 m
1 .59337 L
s
.99625 .64006 m
1 .64006 L
s
.99625 .73343 m
1 .73343 L
s
.99625 .78011 m
1 .78011 L
s
.99625 .8268 m
1 .8268 L
s
.99625 .07983 m
1 .07983 L
s
.99625 .03315 m
1 .03315 L
s
.99625 .92017 m
1 .92017 L
s
.99625 .96685 m
1 .96685 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
.03315 .03315 m
.03315 .96685 L
.96685 .96685 L
.96685 .03315 L
F
0 0 0 r
.01 w
.03315 .03315 m
.96685 .03315 L
.96685 .96685 L
.03315 .96685 L
.03315 .03315 L
s
0 g
.5 Mabswid
.03315 .5 m
.96685 .5 L
s
.5 .03315 m
.5 .96685 L
s
.01 .66 .62 r
.04248 .02381 m
.02381 .04248 L
s
.04198 .07002 m
.02431 .08965 L
s
.0414 .11621 m
.0249 .13683 L
s
.04072 .16238 m
.02557 .18402 L
s
.03994 .20857 m
.02635 .23121 L
s
.03905 .25476 m
.02724 .27838 L
s
.03805 .301 m
.02824 .32552 L
s
.03694 .3473 m
.02935 .37259 L
s
.03574 .39368 m
.03056 .41958 L
s
.03446 .44018 m
.03183 .46645 L
s
.03315 .4868 m
.03315 .5132 L
s
.03183 .53355 m
.03446 .55982 L
s
.03056 .58042 m
.03574 .60632 L
s
.02935 .62741 m
.03694 .6527 L
s
.02824 .67448 m
.03805 .699 L
s
.02724 .72162 m
.03905 .74524 L
s
.02635 .76879 m
.03994 .79143 L
s
.02557 .81598 m
.04072 .83762 L
s
.0249 .86317 m
.0414 .88379 L
s
.02431 .91035 m
.04198 .92998 L
s
.02381 .95752 m
.04248 .97619 L
s
.08965 .02431 m
.07002 .04198 L
s
.08917 .07049 m
.07049 .08917 L
s
.0886 .11665 m
.07106 .13639 L
s
.08794 .16278 m
.07173 .18363 L
s
.08716 .2089 m
.07251 .23087 L
s
.08624 .25503 m
.07342 .27812 L
s
.08519 .30119 m
.07447 .32533 L
s
.08401 .34742 m
.07566 .37247 L
s
.0827 .39374 m
.07697 .41952 L
s
.08129 .44019 m
.07837 .46644 L
s
.07983 .4868 m
.07983 .5132 L
s
.07837 .53356 m
.08129 .55981 L
s
.07697 .58048 m
.0827 .60626 L
s
.07566 .62753 m
.08401 .65258 L
s
.07447 .67467 m
.08519 .69881 L
s
.07342 .72188 m
.08624 .74497 L
s
.07251 .76913 m
.08716 .7911 L
s
.07173 .81637 m
.08794 .83722 L
s
.07106 .86361 m
.0886 .88335 L
s
.07049 .91083 m
.08917 .92951 L
s
.07002 .95802 m
.08965 .97569 L
s
.13683 .0249 m
.11621 .0414 L
s
.13639 .07106 m
.11665 .0886 L
s
.13585 .11718 m
.11718 .13585 L
s
.13521 .16327 m
.11782 .18314 L
s
.13444 .20932 m
.11859 .23045 L
s
.13352 .25538 m
.11952 .27777 L
s
.13242 .30145 m
.12061 .32507 L
s
.13115 .34758 m
.12188 .37231 L
s
.12972 .39382 m
.12331 .41944 L
s
.12816 .44021 m
.12488 .46642 L
s
.12652 .4868 m
.12652 .5132 L
s
.12488 .53358 m
.12816 .55979 L
s
.12331 .58056 m
.12972 .60618 L
s
.12188 .62769 m
.13115 .65242 L
s
.12061 .67493 m
.13242 .69855 L
s
.11952 .72223 m
.13352 .74462 L
s
.11859 .76955 m
.13444 .79068 L
s
.11782 .81686 m
.13521 .83673 L
s
.11718 .86415 m
.13585 .88282 L
s
.11665 .9114 m
.13639 .92894 L
s
.11621 .9586 m
.13683 .9751 L
s
.18402 .02557 m
.16238 .04072 L
s
.18363 .07173 m
.16278 .08794 L
s
.18314 .11782 m
.16327 .13521 L
s
.18254 .16387 m
.16387 .18254 L
s
.1818 .20986 m
.16461 .22991 L
s
.18088 .25583 m
.16553 .27732 L
s
.17975 .30179 m
.16665 .32472 L
s
.1784 .34781 m
.168 .37208 L
s
.17683 .39393 m
.16958 .41933 L
s
.17507 .44024 m
.17134 .46639 L
s
.1732 .4868 m
.1732 .5132 L
s
.17134 .53361 m
.17507 .55976 L
s
.16958 .58067 m
.17683 .60607 L
s
.168 .62792 m
.1784 .65219 L
s
.16665 .67528 m
.17975 .69821 L
s
.16553 .72268 m
.18088 .74417 L
s
.16461 .77009 m
.1818 .79014 L
s
.16387 .81746 m
.18254 .83613 L
s
.16327 .86479 m
.18314 .88218 L
s
.16278 .91206 m
.18363 .92827 L
s
.16238 .95928 m
.18402 .97443 L
s
.23121 .02635 m
.20857 .03994 L
s
.23087 .07251 m
.2089 .08716 L
s
.23045 .11859 m
.20932 .13444 L
s
.22991 .16461 m
.20986 .1818 L
s
.22923 .21055 m
.21055 .22923 L
s
.22834 .25643 m
.21143 .27672 L
s
.22721 .30227 m
.21256 .32425 L
s
.22579 .34813 m
.21398 .37175 L
s
.22406 .3941 m
.21571 .41916 L
s
.22206 .44029 m
.21772 .46634 L
s
.21989 .4868 m
.21989 .5132 L
s
.21772 .53366 m
.22206 .55971 L
s
.21571 .58084 m
.22406 .6059 L
s
.21398 .62825 m
.22579 .65187 L
s
.21256 .67575 m
.22721 .69773 L
s
.21143 .72328 m
.22834 .74357 L
s
.21055 .77077 m
.22923 .78945 L
s
.20986 .8182 m
.22991 .83539 L
s
.20932 .86556 m
.23045 .88141 L
s
.2089 .91284 m
.23087 .92749 L
s
.20857 .96006 m
.23121 .97365 L
s
.27838 .02724 m
.25476 .03905 L
s
.27812 .07342 m
.25503 .08624 L
s
.27777 .11952 m
.25538 .13352 L
s
.27732 .16553 m
.25583 .18088 L
s
.27672 .21143 m
.25643 .22834 L
s
.27591 .25724 m
.25724 .27591 L
s
.27482 .30295 m
.25832 .32357 L
s
.27337 .34862 m
.25978 .37127 L
s
.27148 .39437 m
.26167 .41889 L
s
.26916 .44037 m
.26398 .46626 L
s
.26657 .4868 m
.26657 .5132 L
s
.26398 .53374 m
.26916 .55963 L
s
.26167 .58111 m
.27148 .60563 L
s
.25978 .62873 m
.27337 .65138 L
s
.25832 .67643 m
.27482 .69705 L
s
.25724 .72409 m
.27591 .74276 L
s
.25643 .77166 m
.27672 .78857 L
s
.25583 .81912 m
.27732 .83447 L
s
.25538 .86648 m
.27777 .88048 L
s
.25503 .91376 m
.27812 .92658 L
s
.25476 .96095 m
.27838 .97276 L
s
.32552 .02824 m
.301 .03805 L
s
.32533 .07447 m
.30119 .08519 L
s
.32507 .12061 m
.30145 .13242 L
s
.32472 .16665 m
.30179 .17975 L
s
.32425 .21256 m
.30227 .22721 L
s
.32357 .25832 m
.30295 .27482 L
s
.3226 .30392 m
.30392 .3226 L
s
.32118 .34938 m
.30534 .37051 L
s
.31916 .39482 m
.30735 .41844 L
s
.31646 .4405 m
.31006 .46613 L
s
.31326 .4868 m
.31326 .5132 L
s
.31006 .53387 m
.31646 .5595 L
s
.30735 .58156 m
.31916 .60518 L
s
.30534 .62949 m
.32118 .65062 L
s
.30392 .6774 m
.3226 .69608 L
s
.30295 .72518 m
.32357 .74168 L
s
.30227 .77279 m
.32425 .78744 L
s
.30179 .82025 m
.32472 .83335 L
s
.30145 .86758 m
.32507 .87939 L
s
.30119 .91481 m
.32533 .92553 L
s
.301 .96195 m
.32552 .97176 L
s
.37259 .02935 m
.3473 .03694 L
s
.37247 .07566 m
.34742 .08401 L
s
.37231 .12188 m
.34758 .13115 L
s
.37208 .168 m
.34781 .1784 L
s
.37175 .21398 m
.34813 .22579 L
s
.37127 .25978 m
.34862 .27337 L
s
.37051 .30534 m
.34938 .32118 L
s
.36928 .35061 m
.35061 .36928 L
s
.36727 .39564 m
.35262 .41762 L
s
.36412 .44079 m
.35577 .46584 L
s
.35994 .4868 m
.35994 .5132 L
s
.35577 .53416 m
.36412 .55921 L
s
.35262 .58238 m
.36727 .60436 L
s
.35061 .63072 m
.36928 .64939 L
s
.34938 .67882 m
.37051 .69466 L
s
.34862 .72663 m
.37127 .74022 L
s
.34813 .77421 m
.37175 .78602 L
s
.34781 .8216 m
.37208 .832 L
s
.34758 .86885 m
.37231 .87812 L
s
.34742 .91599 m
.37247 .92434 L
s
.3473 .96306 m
.37259 .97065 L
s
.41958 .03056 m
.39368 .03574 L
s
.41952 .07697 m
.39374 .0827 L
s
.41944 .12331 m
.39382 .12972 L
s
.41933 .16958 m
.39393 .17683 L
s
.41916 .21571 m
.3941 .22406 L
s
.41889 .26167 m
.39437 .27148 L
s
.41844 .30735 m
.39482 .31916 L
s
.41762 .35262 m
.39564 .36727 L
s
.41597 .39729 m
.39729 .41597 L
s
.41253 .4415 m
.40072 .46513 L
s
.40663 .4868 m
.40663 .5132 L
s
.40072 .53487 m
.41253 .5585 L
s
.39729 .58403 m
.41597 .60271 L
s
.39564 .63273 m
.41762 .64738 L
s
.39482 .68084 m
.41844 .69265 L
s
.39437 .72852 m
.41889 .73833 L
s
.3941 .77594 m
.41916 .78429 L
s
.39393 .82317 m
.41933 .83042 L
s
.39382 .87028 m
.41944 .87669 L
s
.39374 .9173 m
.41952 .92303 L
s
.39368 .96426 m
.41958 .96944 L
s
.46645 .03183 m
.44018 .03446 L
s
.46644 .07837 m
.44019 .08129 L
s
.46642 .12488 m
.44021 .12816 L
s
.46639 .17134 m
.44024 .17507 L
s
.46634 .21772 m
.44029 .22206 L
s
.46626 .26398 m
.44037 .26916 L
s
.46613 .31006 m
.4405 .31646 L
s
.46584 .35577 m
.44079 .36412 L
s
.46513 .40072 m
.4415 .41253 L
s
.46265 .44398 m
.44398 .46265 L
s
.45331 .4868 m
.45331 .5132 L
s
.44398 .53735 m
.46265 .55602 L
s
.4415 .58747 m
.46513 .59928 L
s
.44079 .63588 m
.46584 .64423 L
s
.4405 .68354 m
.46613 .68994 L
s
.44037 .73084 m
.46626 .73602 L
s
.44029 .77794 m
.46634 .78228 L
s
.44024 .82493 m
.46639 .82866 L
s
.44021 .87184 m
.46642 .87512 L
s
.44019 .91871 m
.46644 .92163 L
s
.44018 .96554 m
.46645 .96817 L
s
.5132 .03315 m
.4868 .03315 L
s
.5132 .07983 m
.4868 .07983 L
s
.5132 .12652 m
.4868 .12652 L
s
.5132 .1732 m
.4868 .1732 L
s
.5132 .21989 m
.4868 .21989 L
s
.5132 .26657 m
.4868 .26657 L
s
.5132 .31326 m
.4868 .31326 L
s
.5132 .35994 m
.4868 .35994 L
s
.5132 .40663 m
.4868 .40663 L
s
.5132 .45331 m
.4868 .45331 L
s
newpath
.5 .5 .0066 0 365.73 arc
s
.4868 .54669 m
.5132 .54669 L
s
.4868 .59337 m
.5132 .59337 L
s
.4868 .64006 m
.5132 .64006 L
s
.4868 .68674 m
.5132 .68674 L
s
.4868 .73343 m
.5132 .73343 L
s
.4868 .78011 m
.5132 .78011 L
s
.4868 .8268 m
.5132 .8268 L
s
.4868 .87348 m
.5132 .87348 L
s
.4868 .92017 m
.5132 .92017 L
s
.4868 .96685 m
.5132 .96685 L
s
.55982 .03446 m
.53355 .03183 L
s
.55981 .08129 m
.53356 .07837 L
s
.55979 .12816 m
.53358 .12488 L
s
.55976 .17507 m
.53361 .17134 L
s
.55971 .22206 m
.53366 .21772 L
s
.55963 .26916 m
.53374 .26398 L
s
.5595 .31646 m
.53387 .31006 L
s
.55921 .36412 m
.53416 .35577 L
s
.5585 .41253 m
.53487 .40072 L
s
.55602 .46265 m
.53735 .44398 L
s
.54669 .5132 m
.54669 .4868 L
s
.53735 .55602 m
.55602 .53735 L
s
.53487 .59928 m
.5585 .58747 L
s
.53416 .64423 m
.55921 .63588 L
s
.53387 .68994 m
.5595 .68354 L
s
.53374 .73602 m
.55963 .73084 L
s
.53366 .78228 m
.55971 .77794 L
s
.53361 .82866 m
.55976 .82493 L
s
.53358 .87512 m
.55979 .87184 L
s
.53356 .92163 m
.55981 .91871 L
s
.53355 .96817 m
.55982 .96554 L
s
.60632 .03574 m
.58042 .03056 L
s
.60626 .0827 m
.58048 .07697 L
s
.60618 .12972 m
.58056 .12331 L
s
.60607 .17683 m
.58067 .16958 L
s
.6059 .22406 m
.58084 .21571 L
s
.60563 .27148 m
.58111 .26167 L
s
.60518 .31916 m
.58156 .30735 L
s
.60436 .36727 m
.58238 .35262 L
s
.60271 .41597 m
.58403 .39729 L
s
.59928 .46513 m
.58747 .4415 L
s
.59337 .5132 m
.59337 .4868 L
s
.58747 .5585 m
.59928 .53487 L
s
.58403 .60271 m
.60271 .58403 L
s
.58238 .64738 m
.60436 .63273 L
s
.58156 .69265 m
.60518 .68084 L
s
.58111 .73833 m
.60563 .72852 L
s
.58084 .78429 m
.6059 .77594 L
s
.58067 .83042 m
.60607 .82317 L
s
.58056 .87669 m
.60618 .87028 L
s
.58048 .92303 m
.60626 .9173 L
s
.58042 .96944 m
.60632 .96426 L
s
.6527 .03694 m
.62741 .02935 L
s
.65258 .08401 m
.62753 .07566 L
s
.65242 .13115 m
.62769 .12188 L
s
.65219 .1784 m
.62792 .168 L
s
.65187 .22579 m
.62825 .21398 L
s
.65138 .27337 m
.62873 .25978 L
s
.65062 .32118 m
.62949 .30534 L
s
.64939 .36928 m
.63072 .35061 L
s
.64738 .41762 m
.63273 .39564 L
s
.64423 .46584 m
.63588 .44079 L
s
.64006 .5132 m
.64006 .4868 L
s
.63588 .55921 m
.64423 .53416 L
s
.63273 .60436 m
.64738 .58238 L
s
.63072 .64939 m
.64939 .63072 L
s
.62949 .69466 m
.65062 .67882 L
s
.62873 .74022 m
.65138 .72663 L
s
.62825 .78602 m
.65187 .77421 L
s
.62792 .832 m
.65219 .8216 L
s
.62769 .87812 m
.65242 .86885 L
s
.62753 .92434 m
.65258 .91599 L
s
.62741 .97065 m
.6527 .96306 L
s
.699 .03805 m
.67448 .02824 L
s
.69881 .08519 m
.67467 .07447 L
s
.69855 .13242 m
.67493 .12061 L
s
.69821 .17975 m
.67528 .16665 L
s
.69773 .22721 m
.67575 .21256 L
s
.69705 .27482 m
.67643 .25832 L
s
.69608 .3226 m
.6774 .30392 L
s
.69466 .37051 m
.67882 .34938 L
s
.69265 .41844 m
.68084 .39482 L
s
.68994 .46613 m
.68354 .4405 L
s
.68674 .5132 m
.68674 .4868 L
s
.68354 .5595 m
.68994 .53387 L
s
.68084 .60518 m
.69265 .58156 L
s
.67882 .65062 m
.69466 .62949 L
s
.6774 .69608 m
.69608 .6774 L
s
.67643 .74168 m
.69705 .72518 L
s
.67575 .78744 m
.69773 .77279 L
s
.67528 .83335 m
.69821 .82025 L
s
.67493 .87939 m
.69855 .86758 L
s
.67467 .92553 m
.69881 .91481 L
s
.67448 .97176 m
.699 .96195 L
s
.74524 .03905 m
.72162 .02724 L
s
.74497 .08624 m
.72188 .07342 L
s
.74462 .13352 m
.72223 .11952 L
s
.74417 .18088 m
.72268 .16553 L
s
.74357 .22834 m
.72328 .21143 L
s
.74276 .27591 m
.72409 .25724 L
s
.74168 .32357 m
.72518 .30295 L
s
.74022 .37127 m
.72663 .34862 L
s
.73833 .41889 m
.72852 .39437 L
s
.73602 .46626 m
.73084 .44037 L
s
.73343 .5132 m
.73343 .4868 L
s
.73084 .55963 m
.73602 .53374 L
s
.72852 .60563 m
.73833 .58111 L
s
.72663 .65138 m
.74022 .62873 L
s
.72518 .69705 m
.74168 .67643 L
s
.72409 .74276 m
.74276 .72409 L
s
.72328 .78857 m
.74357 .77166 L
s
.72268 .83447 m
.74417 .81912 L
s
.72223 .88048 m
.74462 .86648 L
s
.72188 .92658 m
.74497 .91376 L
s
.72162 .97276 m
.74524 .96095 L
s
.79143 .03994 m
.76879 .02635 L
s
.7911 .08716 m
.76913 .07251 L
s
.79068 .13444 m
.76955 .11859 L
s
.79014 .1818 m
.77009 .16461 L
s
.78945 .22923 m
.77077 .21055 L
s
.78857 .27672 m
.77166 .25643 L
s
.78744 .32425 m
.77279 .30227 L
s
.78602 .37175 m
.77421 .34813 L
s
.78429 .41916 m
.77594 .3941 L
s
.78228 .46634 m
.77794 .44029 L
s
.78011 .5132 m
.78011 .4868 L
s
.77794 .55971 m
.78228 .53366 L
s
.77594 .6059 m
.78429 .58084 L
s
.77421 .65187 m
.78602 .62825 L
s
.77279 .69773 m
.78744 .67575 L
s
.77166 .74357 m
.78857 .72328 L
s
.77077 .78945 m
.78945 .77077 L
s
.77009 .83539 m
.79014 .8182 L
s
.76955 .88141 m
.79068 .86556 L
s
.76913 .92749 m
.7911 .91284 L
s
.76879 .97365 m
.79143 .96006 L
s
.83762 .04072 m
.81598 .02557 L
s
.83722 .08794 m
.81637 .07173 L
s
.83673 .13521 m
.81686 .11782 L
s
.83613 .18254 m
.81746 .16387 L
s
.83539 .22991 m
.8182 .20986 L
s
.83447 .27732 m
.81912 .25583 L
s
.83335 .32472 m
.82025 .30179 L
s
.832 .37208 m
.8216 .34781 L
s
.83042 .41933 m
.82317 .39393 L
s
.82866 .46639 m
.82493 .44024 L
s
.8268 .5132 m
.8268 .4868 L
s
.82493 .55976 m
.82866 .53361 L
s
.82317 .60607 m
.83042 .58067 L
s
.8216 .65219 m
.832 .62792 L
s
.82025 .69821 m
.83335 .67528 L
s
.81912 .74417 m
.83447 .72268 L
s
.8182 .79014 m
.83539 .77009 L
s
.81746 .83613 m
.83613 .81746 L
s
.81686 .88218 m
.83673 .86479 L
s
.81637 .92827 m
.83722 .91206 L
s
.81598 .97443 m
.83762 .95928 L
s
.88379 .0414 m
.86317 .0249 L
s
.88335 .0886 m
.86361 .07106 L
s
.88282 .13585 m
.86415 .11718 L
s
.88218 .18314 m
.86479 .16327 L
s
.88141 .23045 m
.86556 .20932 L
s
.88048 .27777 m
.86648 .25538 L
s
.87939 .32507 m
.86758 .30145 L
s
.87812 .37231 m
.86885 .34758 L
s
.87669 .41944 m
.87028 .39382 L
s
.87512 .46642 m
.87184 .44021 L
s
.87348 .5132 m
.87348 .4868 L
s
.87184 .55979 m
.87512 .53358 L
s
.87028 .60618 m
.87669 .58056 L
s
.86885 .65242 m
.87812 .62769 L
s
.86758 .69855 m
.87939 .67493 L
s
.86648 .74462 m
.88048 .72223 L
s
.86556 .79068 m
.88141 .76955 L
s
.86479 .83673 m
.88218 .81686 L
s
.86415 .88282 m
.88282 .86415 L
s
.86361 .92894 m
.88335 .9114 L
s
.86317 .9751 m
.88379 .9586 L
s
.92998 .04198 m
.91035 .02431 L
s
.92951 .08917 m
.91083 .07049 L
s
.92894 .13639 m
.9114 .11665 L
s
.92827 .18363 m
.91206 .16278 L
s
.92749 .23087 m
.91284 .2089 L
s
.92658 .27812 m
.91376 .25503 L
s
.92553 .32533 m
.91481 .30119 L
s
.92434 .37247 m
.91599 .34742 L
s
.92303 .41952 m
.9173 .39374 L
s
.92163 .46644 m
.91871 .44019 L
s
.92017 .5132 m
.92017 .4868 L
s
.91871 .55981 m
.92163 .53356 L
s
.9173 .60626 m
.92303 .58048 L
s
.91599 .65258 m
.92434 .62753 L
s
.91481 .69881 m
.92553 .67467 L
s
.91376 .74497 m
.92658 .72188 L
s
.91284 .7911 m
.92749 .76913 L
s
.91206 .83722 m
.92827 .81637 L
s
.9114 .88335 m
.92894 .86361 L
s
.91083 .92951 m
.92951 .91083 L
s
.91035 .97569 m
.92998 .95802 L
s
.97619 .04248 m
.95752 .02381 L
s
.97569 .08965 m
.95802 .07002 L
s
.9751 .13683 m
.9586 .11621 L
s
.97443 .18402 m
.95928 .16238 L
s
.97365 .23121 m
.96006 .20857 L
s
.97276 .27838 m
.96095 .25476 L
s
.97176 .32552 m
.96195 .301 L
s
.97065 .37259 m
.96306 .3473 L
s
.96944 .41958 m
.96426 .39368 L
s
.96817 .46645 m
.96554 .44018 L
s
.96685 .5132 m
.96685 .4868 L
s
.96554 .55982 m
.96817 .53355 L
s
.96426 .60632 m
.96944 .58042 L
s
.96306 .6527 m
.97065 .62741 L
s
.96195 .699 m
.97176 .67448 L
s
.96095 .74524 m
.97276 .72162 L
s
.96006 .79143 m
.97365 .76879 L
s
.95928 .83762 m
.97443 .81598 L
s
.9586 .88379 m
.9751 .86317 L
s
.95802 .92998 m
.97569 .91035 L
s
.95752 .97619 m
.97619 .95752 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00oooooolQooooo`00<oooool3o`0002kooooo1Ol0000]ooooo`;o0000
;_ooool5o`00033ooooo0ol0000Rooooo`00=?ooool00ol0003oooooooooo`0^ooooo`04o`000?oo
ooooooooo`0002cooooo00Co0000oooooooooooo0000;_ooool01?l0003oooooooooool0000aoooo
o`03o`000?oooooooooo027ooooo000[ooooo`Go000000?oooooo`000?l000000ol0000Xooooo`Go
00000oooool00ol0003oooooooooo`0/ooooo`04o`000?ooooooooooo`0002oooooo00?o0000oooo
ooooool0;_ooool5o`0002;ooooo000aooooo`04o`000?ooooooooooo`0003;ooooo00?o0000oooo
ooooool0:oooool01?l0003oooooooooool0000`ooooo`03o`000?oooooooooo02gooooo00Co0000
oooooooooooo00008oooool003;ooooo00?o0000ooooool00000;oooool01Ol0003ooooooooooooo
oooo000002cooooo00Co0000oooooooooooo0000;Oooool01Ol0003ooooooooooooooooo000002oo
oooo00?o0000ooooool000008oooool003?ooooo0_l0000_ooooo`05o`000?ooooooooooooooool0
0000;?ooool01?l0003oooooooooool0000]ooooo`05o`000?ooooooooooooooool00000<?ooool2
o`0002?ooooo000dooooo`03o`000?oooooooooo02kooooo0ol0000^ooooo`;o0000;oooool3o`00
03;ooooo00?o0000ooooooooool08Oooool00?oooooo8Oooool00?oooooo8Oooool00?oooooo8Ooo
ool00?oooooo8Oooool000ooooooool0000Ao`00007ooooo000?ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Ko
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo033ooooo
00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo033ooooo
00?o0000ooooooooool07oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Ooo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oo
oooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Sooooo00?o0ZRNooooooooool0
2_ooool00ol2Z9koooooooooo`09ooooo`;o0ZRN2oooool2o`:XWZ[ooooo0_l2Z9h;ooooo`;o0ZRN
2oooool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`07ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02Ooo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00_ooooo0_l2Z9h:ooooo`;o0ZRN2ooo
ool2o`:XWP[ooooo0ol2Z9i4ooooo`?o0ZRN2_ooool2o`:XWP_ooooo0_l2Z9h;ooooo`;o0ZRN3?oo
ool00ol2Z9koooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_oo
ool00ol2Z9koooooooooo`07ooooo`7o00000Oooool000oooooo0_l00006ooooo`03o`000?l2Z9ko
000000_o000000?o0ZRNo`000?l000002Ol000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o
000000[o00000_l2Z9h:o`0000;o0ZRN2ol00002o`:XWPWo00000ol2Z9h<o`0000Co0ZRN2?l00005
o`:XWPCo00002?l2Z9h5o`0000Go0ZRN1ol00005o`:XWP_o00000ol2Z9h9o`0000?o0ZRN2_l00002
o`:XWP_o00000_l2Z9h;o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol00000
0ol2Z9ko0000o`00000:o`000003o`:XW_oooooooooo00Gooooo0_l00001ooooo`003oooool00ol0
003oooooooooo`05ooooo`03o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2
Z9ko0000o`00000:o`000003o`:XW_l0003o000000Wo00000_l2Z9h:o`0000;o0ZRN2ol00002o`:X
WPWo00000_l2Z9h;o`0000Co0ZRN2?l00004o`:XWQ_o00000ol2Z9h9o`0000?o0ZRN2ol00002o`:X
WP[o00000_l2Z9h:o`0000;o0ZRN2ol00002o`:XWP[o000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNooooooooool01Oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Cooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0<oo<i]T00ol0003o
c>KIolcVf@0colcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01Oooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00?ooooo00Co0ZRNooooool0003o00002Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0FOo<i]T00ol0003oc>KIolcVf@1HolcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o
00000_ooool00ol2Z9koooooooooo`03ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Wo
c>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`00
07koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI
0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`000003olcVfOl2
Z9koc>KI07_oc>KI00?o0000olcVfOo<i]T0NOo<i]T00ol2Z9ko0000o`000008ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9hl
olcVf@03o`000?o<i]Woc>KI03Woc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?l000002?ooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T2o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN5Oo<i]T00ol0
003oc>KIolcVf@0BolcVf@?o0ZRN2_o<i]T3o`:XWP[oc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000ooooo`07ooooo`7o00000Oooool000oo
oooo0_l00006ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h<olcVf@;o0ZRN2Oo<i]T3o`:XWP[o
c>KI0ol2Z9h;olcVf@Go0ZRN1?o<i]T8o`:XWPGoc>KI1Ol2Z9h:olcVf@?o0ZRN2_o<i]T3o`:XWPWo
c>KI0ol2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool01_ooool2o`00007o
oooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h9olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
1?l2Z9h=olcVf@03o`000?o<i]Woc>KI00_oc>KI0ol2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:X
W_oooooooooo00Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`03o`:XW_l0
003o000000[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI03?oc>KI00?o0000olcVfOo<i]T0<oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003ooooool2Z9kooooo00Gooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`03ooooo`04o`:XW_oooooo0000o`0000Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1UolcVf@03o`000?o<i]Woc>KI06Goc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000_ooool00ol2Z9kooooooooo
o`03ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000
olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05oooo
o`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0
N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<
i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool0
00Sooooo0ol00004ooooo`03o`000?oooooooooo00Gooooo0_l000000oo<i]Wo0ZRNolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWUGoc>KI00?o0000olcV
fOo<i]T0Doo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_l0003o000000Sooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo00Gooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T2o`:XWP_o
c>KI0_l2Z9h_olcVf@03o`000?o<i]Woc>KI02coc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWPco
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNo`000?l000002?ooool1o`00007ooooo0005o`000003ooooool0003o000000?o0000
1?ooool00ol0003oooooooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@?o0ZRN2_o<i]T3o`:XWPSoc>KI
1Ol2Z9h8olcVf@03o`000?o<i]Woc>KI00Koc>KI1Ol2Z9h8olcVf@?o0ZRN2Oo<i]T3o`:XWPcoc>KI
0ol2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000
ooooo`07ooooo`7o00000Oooool000Kooooo00Co0000oooooooooooo00001Oooool3o`0000Gooooo
00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI
0ol2Z9h:olcVf@?o0ZRN1oo<i]T4o`:XWPWoc>KI2?l2Z9h:olcVf@?o0ZRN2?o<i]T3o`:XWPWoc>KI
0ol2Z9h<olcVf@;o0ZRN2Oo<i]T2o`:XWP_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Kooooo
0_l00001ooooo`001oooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00Gooooo00?o
0000o`:XW_o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9hKolcVf@03o`000?o<i]Woc>KI01Woc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Ooo
ool000Sooooo0_l00005ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?o<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI043oc>KI00?o0000olcVfOo<i]T0?oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l000000ooooooo0ZRNooooo`05
ooooo`7o00000Oooool000Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04oooo
o`03o`:XW_l0003o000007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000;ooooo00?o0ZRNoooo
ooooool00oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03
o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Wo
c>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`00
07koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Gooooo0_l000000oo<i]Wo0ZRNolcVf@0;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_l2Z9hlolcVf@03o`000?o<i]Woc>KI03Woc>KI0_l2Z9h;olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?l000002?ooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Gooooo0_l000000oo<i]Wo0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@?o0ZRN5Oo<i]T00ol0003oc>KIolcV
f@0ColcVf@?o0ZRN2Oo<i]T2o`:XWP_oc>KI0_l2Z9h=olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko0000o`000008ooooo`7o00000Oooool000oooooo0_l00006
ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI0_l2Z9h:olcVf@?o0ZRN2Oo<i]T3o`:XWP_oc>KI1Ol2Z9h4olcVf@So0ZRN1Oo<i]T5
o`:XWP_oc>KI0ol2Z9h8olcVf@?o0ZRN2_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003ooooo00Kooooo0_l00001ooooo`003oooool00ol0
003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@;o0ZRN2_o<i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@Co0ZRN3Oo<i]T00ol0
003oc>KIolcVf@0;olcVf@?o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2_o<i]T2o`:X
WP_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo
00Oooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T09oo<i]T00ol0003oc>KIolcVf@0VolcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Oo
c>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1?ooool00ol2Z9ko0000o`000009olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
@?o<i]T00ol0003oc>KIolcVf@0oolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
1_o<i]T2o`000003ooooool2Z9kooooo00Gooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcV
fOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o
0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o0000
0Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<
i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o000000?oc>KI
o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T0E?o<i]T00ol0003oc>KIolcVf@1ColcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00Oooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o000000?oc>KIo`:XW_o<i]T02oo<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWRooc>KI00?o0000olcVfOo<i]T0;?o<i]T2o`:X
WP_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool01oooool1o`00
007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@;o
0ZRN2_o<i]T3o`:XWQGoc>KI00?o0000olcVfOo<i]T04oo<i]T3o`:XWPWoc>KI0_l2Z9h=olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool2o`0000Kooooo00?o0000o`:XW_o<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@?o0ZRN
2Oo<i]T3o`:XWP_oc>KI1?l2Z9h5olcVf@So0ZRN1Oo<i]T5o`:XWP_oc>KI0ol2Z9h8olcVf@?o0ZRN
2oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_ooool0
1_ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWP[oc>KI0_l2Z9h:olcVf@Co0ZRN3Oo<i]T00ol0003oc>KIolcVf@0;olcVf@?o0ZRN2oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T09oo<i]T00ol0003oc>KIolcVf@0VolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l00000
0ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool00ol2
Z9ko0000o`00000:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI04coc>KI00?o0000olcVfOo<i]T0Boo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@06olcVf@;o000000?oooooo`:XW_ooool01Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0
N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<
i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`00
00Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003o
c>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo
0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
>_o<i]T00ol0003oc>KIolcVf@0iolcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_l0003ooooo00Oooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o000000?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2
Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWQGoc>KI00?o0000olcVfOo<i]T04oo<i]T2o`:XWP_oc>KI0_l2
Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNo`000?ooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000
o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@?o0ZRN2oo<i]T3o`:XWPWoc>KI00?o0000
olcVfOo<i]T01_o<i]T3o`:XWPcoc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000
o`:XW_ooool01oooool1o`00007ooooo000?ooooo`;o00001_ooool00ol0003o0ZRNolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWP_oc>KI0_l2Z9h9olcV
f@;o0ZRN2oo<i]T3o`:XWPSoc>KI2?l2Z9h8olcVf@?o0ZRN2oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`000?l2Z9kooooo00Kooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03
o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o
0ZRN3oo<i]T00ol0003oc>KIolcVf@0<olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01Oooool00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI02Koc>KI
00?o0000olcVfOo<i]T09_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool0
1Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo00?o0ZRNo`000?l000002_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@1<olcVf@03o`000?o<i]Woc>KI04_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T01oo<
i]T2o`000003ooooool2Z9kooooo00Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05
ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<
i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000
O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool2o`000003o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI05Coc>KI00?o0000
olcVfOo<i]T0E?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9ko0000ooooo`07ooooo`7o00000Oooool000Kooooo1Ol00004oooo
o`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
027oc>KI00?o0000olcVfOo<i]T08?o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool01oooool1o`00
007ooooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01Oooool2o`00
0003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWQKoc>KI00?o0000olcV
fOo<i]T04oo<i]T2o`:XWPgoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07oooo
o`7o00000Oooool000Go00000oooool00ol0003oooooooooo`04ooooo`?o00001Oooool00ol0003o
0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@Co0ZRN1Oo<i]T8o`:XWPGo
c>KI1Ol2Z9h:olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Ko
oooo0_l00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Gooooo
00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2Oo<i]T4o`:XWPgoc>KI
00?o0000olcVfOo<i]T02oo<i]T3o`:XWPWoc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI
0_l000000ol2Z9koooooooooo`05ooooo`7o00000Oooool000Kooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI01[oc>KI00?o0000olcVfOo<i]T06Oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o0000
0Oooool000Kooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo00Gooooo
00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0VolcVf@03o`000?o<i]Woc>KI02Koc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001ooooo`001ooo
ool3o`0000Gooooo00?o0000ooooooooool01Oooool00ol2Z9ko0000olcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1HolcVf@03o`000?o<
i]Woc>KI05Ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNooooo`05ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcV
f@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03
o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0^
olcVf@03o`000?o<i]Woc>KI02goc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?ooool01oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI0_l2Z9hFolcVf@03o`000?o<i]Woc>KI01?oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNo`000?ooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Go
oooo0_l000000ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02oo<i]T2o`:XWPWoc>KI00?o0000olcVfOo<i]T01_o<i]T3o`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_l0003ooooo00Oooooo0Ol00001ooooo`00
3oooool2o`0000Kooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN
2oo<i]T3o`:XWPOoc>KI2?l2Z9h8olcVf@?o0ZRN2_o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol0003o0ZRNooooo`06ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01Ooo
ool00ol0003o0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWPkoc>KI00?o0000olcVfOo<i]T03?o<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@0JolcVf@03o`000?o<i]Woc>KI01Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool00ol0
003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T09_o<i]T00ol0
003oc>KIolcVf@0UolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ol2Z9koooooooooo`05oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol2Z9ko0000olcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0I?o<i]T00ol0003oc>KIolcVf@1SolcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Go
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KI
olcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0
001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcV
f@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l000000ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI04Soc>KI00?o0000olcVfOo<i]T0B?o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI01Coc>KI00?o0000olcVfOo<i]T04oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Ooo
ool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@;o0ZRN2Oo<i]T00ol0003oc>KIolcVf@06olcVf@;o0ZRN3Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool01oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@03o`000?o<i]Woc>KI00Soc>KI0ol2Z9h;
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07
ooooo`7o00000Oooool000oooooo0_l00006ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2Oo<i]T8o`:XWP[oc>KI0_l2Z9h:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo
00Cooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00go
c>KI00?o0000olcVfOo<i]T03Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00So
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@0IolcVf@03o`000?o<i]Woc>KI01Woc>KI00?o0ZRNolcVfOo<i]T0
2?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01Oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0UolcVf@03o`000?o<i]Woc>KI02Goc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oo
oooooooo00Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T0
0ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oo
oooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000So
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KI
olcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0
001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01Oooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T05Oo<i]T00ol0003oc>KIolcVf@0DolcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01Oooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`000?o<i]Woc>KI00Ooc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:X
W_ooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol0003oc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0000olcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo0_l00006ooooo`03o`000?l2
Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00Ooc>KI2?l2Z9h9olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01?ooool2o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol0003oc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08
olcVf@;o000000?o0ZRNooooooooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Gooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI00?o0ZRNolcVfOo<i]T03Oo<i]T00ol0003oc>KIolcVf@0<olcVf@03o`:XW_o<i]Woc>KI
00Soc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNoooo
ooooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI01Soc>KI00?o0000olcVfOo<
i]T06?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9ko
ooooooooo`05ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI
00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008
ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcV
fOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o
0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`00
0?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol0003oc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`00
0?l2Z9kooooo00Oooooo0Ol00001ooooo`002?ooool2o`0000Gooooo00?o0000ooooooooool01Ooo
ool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Ooo
ool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`05ooooo`03o`000?l2
Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Soc>KI00Co0ZRNolcVfOl0003o0ZRN2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`7o0000
0Oooool000Oooooo00Co0000oooooooooooo00001?ooool3o`0000Gooooo00?o0000o`:XW_l00000
2ol000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l00000
2?l000001?l2Z9ko0000o`000?l2Z9h:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l0
00002_l000000ol2Z9ko0000o`000009o`000003o`:XW_oooooooooo00Gooooo0_l00001ooooo`00
1oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02?o<i]T2o`:XWP03o`000?l2Z9koc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_ooool01oooool1o`00007o
oooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01Oooool00ol0003o
0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_ooool01oooool1o`00007o
oooo0007ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool01Oooool00ol0003o
0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`000?o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0000o`:XW_ooool01oooool1o`00007o
oooo0008ooooo`;o00001Oooool00ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0000olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol0
0001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1j
olcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcV
f@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
9Oo<i]T00ol0003oc>KIolcVf@0TolcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9kooooo
ooooo`05ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol0003o0ZRNolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol2Z9koc>KIolcV
f@0=olcVf@03o`000?o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool00ol0003o0ZRNolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0<olcVf@03o`000?o<i]Wo
c>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo00?o0000oooo
ooooool01Oooool00ol0003o0ZRNolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`000?o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2
Z9koooooooooo`05ooooo`7o00000Oooool000oooooo0_l00006ooooo`03o`000?l2Z9koc>KI00_o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ko
c>KI2?l2Z9h8olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Kooooo0_l00001ooooo`003oooool00ol0003ooooo
ooooo`05ooooo`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000olcVfOo<i]T02?o<i]T00ol2Z9koc>KI
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRN
ooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol0003o0ZRNolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@08olcVf@03o`000?o<i]Woc>KI00Ooc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool01oooool1o`00007ooooo000?
ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI01Goc>KI00?o0000olcVfOo<i]T05?o<i]T00ol2Z9koc>KIolcVf@0;
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:XW_ooool01oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<
i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000
O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2
o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
03;oc>KI00?o0000olcVfOo<i]T0<Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@0IolcVf@03o`000?o<i]Woc>KI01Soc>KI0_l2Z9h;olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9koooooooooo`05ooooo`7o00000Oooool000oooooo
00?o0000ooooooooool01Oooool00ol2Z9ko0000olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWPkoc>KI00?o0000olcVfOo<i]T03?o<i]T2o`:XWPWoc>KI
00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool0
1Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h<olcVf@03o`000?o<
i]Woc>KI00Woc>KI0ol2Z9h:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<
i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001ooooo`003oooool2o`0000Kooooo00?o0000
o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h6
olcVf@So0ZRN1_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`000?l2Z9kooooo00Kooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05oooo
o`03o`000?l2Z9koc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00Ooc>KI00?o0000olcVfOo<i]T01_o<i]T00ol2Z9koc>KIolcVf@0;olcV
f@03o`:XW_o<i]Woc>KI00coc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`000003o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0DolcVf@03o`000?o<i]Woc>KI01?o
c>KI00?o0ZRNolcVfOo<i]T03?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oo
oooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0QolcVf@03o`000?o<i]Woc>KI027oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2Oo<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Ooo
ool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI
07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007ko
c>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0<_o<i]T00ol0003oc>KIolcV
f@0aolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@07olcVf@;o000000?o0ZRNooooooooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Gooooo00?o0ZRNo`000?o<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN6oo<i]T0
0ol0003oc>KIolcVf@0HolcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@07olcVf@;o000000?o0ZRN
ooooooooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`00
0?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0ol2Z9h=olcV
f@03o`000?o<i]Woc>KI00_oc>KI0ol2Z9h9olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001ooooo`003oooool2o`0000Ko
oooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[o
c>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T3o`:XWPKo
c>KI2?l2Z9h7olcVf@?o0ZRN2_o<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o
0ZRNooooo`06ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol0003o0ZRN
olcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KI
olcVf@07olcVf@03o`000?o<i]Woc>KI00Koc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00_oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o
0000ooooooooool01Oooool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T05?o<i]T00ol0003oc>KIolcVf@0ColcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02?o<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01Oooool2o`000003o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T08Oo<i]T0
0ol0003oc>KIolcVf@0PolcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?ooool01oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l000000ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1EolcV
f@03o`000?o<i]Woc>KI05Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcV
f@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNo`000?ooool01oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0
N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<
i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooo
oooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`00
00Sooooo0Ol00001ooooo`001_ooool5o`0000Cooooo00?o0000ooooooooool01Oooool00ol2Z9ko
0000olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0colcVf@03o`000?o<i]Woc>KI03;oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNooooo`05ooooo`7o
00000Oooool000Oooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`05ooooo`03
o`:XW_l0003oc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o0ZRN6oo<i]T00ol0003oc>KIolcVf@0HolcVf@;o
0ZRN2oo<i]T2o`:XWP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNooooo`05ooooo`7o00000Oooool000Sooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?l2Z9koc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPSoc>KI0ol2Z9h>olcVf@03o`000?o<i]Woc>KI00_oc>KI
0ol2Z9h8olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI
00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool0
1Oooool1o`00007ooooo0009ooooo`03o`000?oooooooooo00?ooooo0ol00005ooooo`03o`000?l2
Z9koc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWPWoc>KI0ol2Z9h7olcVf@So0ZRN1oo<
i]T3o`:XWPWoc>KI0_l2Z9h<olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Cooooo0_l0
0001ooooo`001_ooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01Ooo
ool00ol0003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T2o`:XWPWoc>KI00?o0000olcVfOo<i]T01_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`001_ooool0
1Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool01Oooool2o`000003o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T08Oo<i]T00ol0003oc>KIolcVf@0PolcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0000o`:XW_ooool01oooool1o`00007ooooo0007ooooo`?o00001Oooool0
0ol0003oooooooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI03[oc>KI00?o0000olcVfOo<i]T0>_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool01oooool1o`00007ooooo000?oooo
o`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008oooo
o`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<
i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000
O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2
o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`03o`:XW_l0003o0000
00[oc>KI00?o0ZRNolcVfOo<i]T0LOo<i]T00ol0003oc>KIolcVf@1`olcVf@03o`:XW_o<i]Woc>KI
00Ooc>KI0_l000000ooooooo0ZRNooooo`05ooooo`7o00000Oooool000oooooo00?o0000oooooooo
ool01?ooool00ol2Z9ko0000o`00000:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T2o`:XWSCoc>KI00?o0000olcVfOo<i]T0<_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o
0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T02Oo<i]T00ol2Z9koc>KIolcVf@07olcVf@;o000000?oooooo`:XW_ooool01Oooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`:XWP[oc>KI
0_l2Z9hKolcVf@03o`000?o<i]Woc>KI01Soc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:X
W_oooooooooo00Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0
003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI0_l2Z9h:olcVf@?o0ZRN1oo<i]T5o`:XWPcoc>KI00?o0000olcVfOo<i]T02_o<
i]T4o`:XWPSoc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol0
0001ooooo`003oooool2o`0000Kooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T2o`:XWP_oc>KI0_l2Z9h:
olcVf@?o0ZRN1Oo<i]T8o`:XWPGoc>KI1?l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWPcoc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000
o`:XW_ooool01_ooool2o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:X
W_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI01?oc>KI00?o0000olcV
fOo<i]T04oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcV
fOo<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0000o`:X
W_ooool01oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<
i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<
i]T0;Oo<i]T00ol0003oc>KIolcVf@0]olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`00
3oooool00ol0003oooooooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI067oc>KI00?o0000olcVfOo<i]T0H?o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNo`000?ooool01oooool1o`00007ooooo
000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l0
0008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000
olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05oooo
o`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0
N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`03o`:XW_l0
003o000000[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@1UolcVf@03o`000?o<
i]Woc>KI06Coc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06olcVf@;o000000?o
ooooo`:XW_ooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo00?o0ZRN
o`000?l000002_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9hd
olcVf@03o`000?o<i]Woc>KI037oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:
olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@06
olcVf@;o000000?oooooo`:XW_ooool01Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo
00Gooooo00?o0ZRNo`000?o<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`:XWP_oc>KI0ol2Z9hJolcVf@03o`000?o<i]Woc>KI
01Soc>KI0_l2Z9h;olcVf@;o0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001oooo
o`003oooool2o`0000Kooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h9olcVf@?o0ZRN2oo<i]T3o`:XWPKoc>KI1Ol2Z9h8olcVf@So
0ZRN2Oo<i]T4o`:XWPOoc>KI0ol2Z9h:olcVf@?o0ZRN2Oo<i]T2o`:XWPcoc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<
i]T02_o<i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01?ooool2o`00007o
oooo000?ooooo`03o`000?oooooooooo00Gooooo00?o0000o`:XW_o<i]T02oo<i]T00ol2Z9koc>KI
olcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T2o`:XWPcoc>KI
0_l2Z9h9olcVf@?o0ZRN2Oo<i]T00ol0003oc>KIolcVf@06olcVf@Co0ZRN2Oo<i]T2o`:XWP_oc>KI
0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KI
olcVf@08olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool00ol0003ooooooooo
o`05ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0PolcVf@03o`000?o<
i]Woc>KI01ooc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<
i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNooooo`07ooooo`7o00000Ooo
ool000oooooo00?o0000ooooooooool01Oooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRN
olcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0jolcVf@03o`000?o<i]Woc>KI03Woc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRN
olcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00Oooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcV
f@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03
o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Wo
c>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`00
07koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`04ooooo`03o`:XW_l0003o000000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI05Woc>KI00?o0000olcVfOo<i]T0F?o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`000003
ooooool2Z9kooooo00Gooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`04ooooo`03o`:X
W_l0003o000000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00Woc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWSCoc>KI00?o0000olcVfOo<i]T0
<Oo<i]T2o`:XWP_oc>KI0_l2Z9h:olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:X
W_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T01_o<i]T2o`000003ooooool2Z9kooooo00Gooooo
0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0ol2
Z9h:olcVf@?o0ZRN2Oo<i]T5o`:XWPcoc>KI00?o0000olcVfOo<i]T02_o<i]T4o`:XWP[oc>KI0_l2
Z9h:olcVf@?o0ZRN2Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T01oo<i]T2o`000003o`:XW_oooooooooo00Gooooo0Ol00001ooooo`003oooool2
o`0000Kooooo00?o0000o`:XW_o<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2
o`:XWP[oc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T4o`:XWPCoc>KI2?l2Z9h5olcVf@Co0ZRN2oo<i]T3
o`:XWPWoc>KI0ol2Z9h:olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T0
0ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T0
0ol0003o0ZRNooooo`06ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol0
003o0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T2o`:XWQGoc>KI00?o0000olcVfOo<i]T04oo<i]T2o`:X
WP[oc>KI0_l2Z9h<olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@08olcVf@03o`000?l2Z9kooooo00Oooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`05ooooo`;o000000?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0;Oo<i]T00ol0003oc>KIolcVf@0/olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_l0003ooooo00Oooooo0Ol00001ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000
00?oc>KIo`:XW_o<i]T02oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI063oc>KI
00?o0000olcVfOo<i]T0H?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI
00?o0ZRNo`000?l000002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0
001nolcVf@03o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000
ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcV
f@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03
o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo0008ooooo`?o00001?ooool00ol0003oooooooooo`04ooooo`03o`:XW_l0003o
000000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T0
0ol2Z9koc>KIolcVf@1<olcVf@03o`000?o<i]Woc>KI04_oc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Wo
c>KI00Woc>KI0_l2Z9h;olcVf@03o`:XW_o<i]Woc>KI00Koc>KI0_l00002ooooo`03o`:XW_oooooo
oooo00?ooooo0Ol00001ooooo`002Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Cooooo00?o0ZRNo`000?l000002_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@08olcVf@;o0ZRN2oo<i]T2o`:X
WP[oc>KI0_l2Z9hXolcVf@03o`000?o<i]Woc>KI02Goc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:X
WP[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI
00[oc>KI00?o0ZRNolcVfOo<i]T01oo<i]T2o`000003ooooool2Z9kooooo00Gooooo0Ol00001oooo
o`001_ooool5o`0000Cooooo00?o0000ooooooooool01Oooool00ol2Z9ko0000olcVf@0:olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00Woc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T3o`:XWPSoc>KI1Ol2Z9h7olcVf@Go
0ZRN3?o<i]T00ol0003oc>KIolcVf@0:olcVf@Co0ZRN2?o<i]T4o`:XWPSoc>KI0ol2Z9h:olcVf@?o
0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03
o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02?o<i]T2o`000003o`:XW_oooooooooo00Go
oooo0Ol00001ooooo`001_ooool01?l0003oooooooooool00005ooooo`?o00001Oooool00ol0003o
0ZRNolcVf@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP_o
c>KI0ol2Z9h9olcVf@Co0ZRN1?o<i]T8o`:XWPGoc>KI1?l2Z9h9olcVf@?o0ZRN2_o<i]T2o`:XWP_o
c>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Wo
c>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`000?l2Z9kooooo00Ko
oooo0_l00001ooooo`001oooool00ol0003oooooo`000005ooooo`03o`000?oooooooooo00Gooooo
0_l000000ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI023oc>KI00?o0000olcVfOo<i]T0
7oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003ooooo00Oooooo0Ol00001ooooo`002?oo
ool2o`0000Gooooo00?o0000ooooooooool01Oooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o
0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o
0ZRNolcVfOo<i]T0Aoo<i]T00ol0003oc>KIolcVf@16olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o
0ZRNo`000?l000002?ooool1o`00007ooooo0009ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool01Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001
ooooo`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcV
f@;o00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03
o`000?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool0
1Oooool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?oo
ool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Wo
c>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`00
07koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003o
ooooooooo`03ooooo`04o`:XW_oooooo0000o`0000Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2
Z9koc>KIolcVf@09olcVf@;o0ZRN2oo<i]T2o`:XWTgoc>KI00?o0000olcVfOo<i]T0Boo<i]T2o`:X
WP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T00ol2Z9koc>KIolcVf@06olcVf@;o00000_ooool00ol2
Z9koooooooooo`03ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01?ooool00ol2Z9ko
0000o`00000:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T3o`:XWP[o
c>KI0ol2Z9hJolcVf@03o`000?o<i]Woc>KI01Ooc>KI0ol2Z9h:olcVf@?o0ZRN2oo<i]T2o`:XWP[o
c>KI0_l2Z9h:olcVf@03o`:XW_o<i]Woc>KI00Woc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko
c>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Ooc>KI0_l000000ooooooo0ZRNooooo`05ooooo`7o
00000Oooool000oooooo0_l00006ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@;o0ZRN2oo<i]T2o`:XWPWoc>KI0_l2Z9h;olcVf@;o0ZRN
2oo<i]T3o`:XWP[oc>KI0ol2Z9h6olcVf@Go0ZRN2?o<i]T8o`:XWPWoc>KI1?l2Z9h6olcVf@?o0ZRN
2_o<i]T3o`:XWP_oc>KI0ol2Z9h:olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T0
2_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l000000ol2Z9kooooo
ooooo`04ooooo`;o00000Oooool000oooooo00?o0000ooooooooool01Oooool00ol0003o0ZRNolcV
f@0;olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02oo<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00Soc>KI0_l2Z9h;olcVf@;o0ZRN3?o<i]T2o`:XWP_oc>KI0_l2
Z9h9olcVf@Co0ZRN2?o<i]T00ol0003oc>KIolcVf@06olcVf@Co0ZRN2?o<i]T2o`:XWP_oc>KI0_l2
Z9h<olcVf@;o0ZRN2oo<i]T2o`:XWP_oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcV
f@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol0003o0ZRNoooo
o`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`000003o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0;olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI02goc>KI00?o0000olcVfOo<i]T0;?o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Wo
c>KI00[oc>KI00?o0ZRNolcVfOo<i]T02_o<i]T00ol2Z9ko0000ooooo`07ooooo`7o00000Oooool0
00oooooo00?o0000ooooooooool01Oooool2o`000003olcVfOl2Z9koc>KI00_oc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@1PolcVf@03o`000?o<i]Woc>KI05ooc>KI00?o0ZRNolcV
fOo<i]T02_o<i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_l0003o000000Sooooo0Ol00001oooo
o`003oooool00ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o
00002?ooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`00
0?o<i]Woc>KI07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Ooo
ool2o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool0
0ol0003oooooooooo`05ooooo`;o0000O_o<i]T00ol0003oc>KIolcVf@1jolcVf@;o00002?ooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo00Gooooo0_l0001nolcVf@03o`000?o<i]Woc>KI
07[oc>KI0_l00008ooooo`7o00000Oooool000oooooo00?o0000ooooooooool01Oooool2o`0007ko
c>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000Sooooo0Ol00001ooooo`003oooool00ol0003ooooo
ooooo`03ooooo`04o`:XW_oooooo0000o`0007koc>KI00?o0000olcVfOo<i]T0N_o<i]T2o`0000;o
oooo00?o0ZRNooooooooool00oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo00Cooooo
00?o0ZRNo`000?l000002Oo<i]T2o`:XWP[oc>KI0_l2Z9h;olcVf@;o0ZRN2oo<i]T2o`:XWP[oc>KI
0_l2Z9i1olcVf@03o`000?o<i]Woc>KI03koc>KI0_l2Z9h;olcVf@;o0ZRN2_o<i]T2o`:XWP_oc>KI
0_l2Z9h:olcVf@;o0ZRN2?o<i]T2o`000003ooooool2Z9kooooo00Gooooo0Ol00001ooooo`003ooo
ool00ol0003oooooooooo`05ooooo`03o`:XW_l0003oc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@0:olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@?o0ZRN2Oo<i]T3o`:XWP[oc>KI0ol2Z9hJolcVf@03o`000?o<
i]Woc>KI01Ooc>KI0ol2Z9h:olcVf@?o0ZRN2_o<i]T3o`:XWPWoc>KI00?o0ZRNolcVfOo<i]T02_o<
i]T00ol2Z9koc>KIolcVf@09olcVf@03o`:XW_o<i]Woc>KI00[oc>KI00?o0ZRNolcVfOo<i]T02Oo<
i]T00ol2Z9koc>KIolcVf@08olcVf@;o000000?o0ZRNooooooooool01Oooool1o`00007ooooo000?
ooooo`;o00001_ooool00ol0003o0ZRNo`00000;o`000003o`:XW_l0003o000000Wo00000_l2Z9h;
o`0000;o0ZRN2ol00002o`:XWP[o00000_l2Z9h;o`0000?o0ZRN2Ol00003o`:XWP[o00000ol2Z9h6
o`0000Wo0ZRN1?l00008o`:XWPGo00002?l2Z9h6o`0000?o0ZRN2_l00003o`:XWP[o00000ol2Z9h:
o`0000;o0ZRN2ol00002o`:XWP[o00000_l2Z9h;o`0000;o0ZRN2ol000000ol2Z9ko0000o`00000:
o`000003o`:XW_oooooooooo00Gooooo0_l00001ooooo`003oooool00ol0003oooooooooo`05oooo
o`;o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`00000:o`000003o`:XW_l0003o0000
00[o000000?o0ZRNo`000?l000002_l000000ol2Z9ko0000o`000009o`000003o`:XW_l0003o0000
00_o000000?o0ZRNo`000?l000002Ol00002o`:XWP_o00000_l2Z9hZo`0000;o0ZRN2ol00002o`:X
WP_o00000_l2Z9h<o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002Ol000000ol2
Z9ko0000o`00000:o`000003o`:XW_l0003o000000[o000000?o0ZRNo`000?l000002_l000000ol2
Z9ko0000ooooo`07ooooo`7o00000Oooool000oooooo00?o0000ooooooooool02?ooool00ol2Z9ko
ooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02_ooool00ol2Z9ko
ooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool0M_ooool00ol2Z9ko
ooooooooo`0:ooooo`03o`:XW_oooooooooo00Wooooo00?o0ZRNooooooooool02_ooool00ol2Z9ko
ooooooooo`0:ooooo`03o`:XW_oooooooooo00[ooooo00?o0ZRNooooooooool02?ooool1o`00007o
oooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oo
oooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1
o`00007ooooo000?ooooo`03o`000?oooooooooo0?oooooo3Oooool1o`00007ooooo000?ooooo`03
o`000?oooooooooo01oooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0`ooooo`03
o`000?oooooooooo02oooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`0Oooooo`7o
00000Oooool000oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool01_ooool1o`00007ooooo000?oooooooo00004Ol0
0001ooooo`00oooooolQooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-5.96234, -5.90562, 0.0394506, \
0.0394506}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generate starting points for solutions", "Subsection"],

Cell[TextData[{
  "You may define the variable ",
  StyleBox["thePoints",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to be any list of one or more initial values. One point might be  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "Two",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "points might be",
  StyleBox[" ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["thePoints",
            FontWeight->"Bold"], " ", "=", " ", \({{1, 1}, {2, 3}}\)}], 
        TraditionalForm]]],
  StyleBox[";",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "etc. \n\nHere ",
  Cell[BoxData[
      FormBox[
        StyleBox["thePoints",
          FontWeight->"Bold"], TraditionalForm]]],
  " is the set of points on the two axes at intervals of 0.5. The ends of the \
axes were extended to produce more solutions. However, extending too far may \
produce anomalies in the plot (as you are likely to eventually discover)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(t1 = Table[{k, k}, {k, \(-5\), 5,  .5}]\)], "Input"],

Cell[BoxData[
    \({{\(-5\), \(-5\)}, {\(-4.5`\), \(-4.5`\)}, {\(-4.`\), \(-4.`\)}, \
{\(-3.5`\), \(-3.5`\)}, {\(-3.`\), \(-3.`\)}, {\(-2.5`\), \(-2.5`\)}, {\(-2.`\
\), \(-2.`\)}, {\(-1.5`\), \(-1.5`\)}, {\(-1.`\), \(-1.`\)}, {\(-0.5`\), \
\(-0.5`\)}, {0.`, 0.`}, {0.5`, 0.5`}, {1.`, 1.`}, {1.5`, 1.5`}, {2.`, 
        2.`}, {2.5`, 2.5`}, {3.`, 3.`}, {3.5`, 3.5`}, {4.`, 4.`}, {4.5`, 
        4.5`}, {5.`, 5.`}}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(\(thePoints = t1;\)\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Produce Final Output", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DisplayAll;\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.1 0.5 0.1 [
[.1 -0.0125 -6 -9 ]
[.1 -0.0125 6 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7 -0.0125 -3 -9 ]
[.7 -0.0125 3 0 ]
[.9 -0.0125 -3 -9 ]
[.9 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .1 -12 -4.5 ]
[-0.0125 .1 0 4.5 ]
[-0.0125 .3 -12 -4.5 ]
[-0.0125 .3 0 4.5 ]
[-0.0125 .5 -6 -4.5 ]
[-0.0125 .5 0 4.5 ]
[-0.0125 .7 -6 -4.5 ]
[-0.0125 .7 0 4.5 ]
[-0.0125 .9 -6 -4.5 ]
[-0.0125 .9 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.1 0 m
.1 .00625 L
s
[(-4)] .1 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(-2)] .3 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7 0 m
.7 .00625 L
s
[(2)] .7 -0.0125 0 1 Mshowa
.9 0 m
.9 .00625 L
s
[(4)] .9 -0.0125 0 1 Mshowa
.125 Mabswid
.15 0 m
.15 .00375 L
s
.2 0 m
.2 .00375 L
s
.25 0 m
.25 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.45 0 m
.45 .00375 L
s
.55 0 m
.55 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.75 0 m
.75 .00375 L
s
.8 0 m
.8 .00375 L
s
.85 0 m
.85 .00375 L
s
.05 0 m
.05 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .1 m
.00625 .1 L
s
[(-4)] -0.0125 .1 1 0 Mshowa
0 .3 m
.00625 .3 L
s
[(-2)] -0.0125 .3 1 0 Mshowa
0 .5 m
.00625 .5 L
s
[(0)] -0.0125 .5 1 0 Mshowa
0 .7 m
.00625 .7 L
s
[(2)] -0.0125 .7 1 0 Mshowa
0 .9 m
.00625 .9 L
s
[(4)] -0.0125 .9 1 0 Mshowa
.125 Mabswid
0 .15 m
.00375 .15 L
s
0 .2 m
.00375 .2 L
s
0 .25 m
.00375 .25 L
s
0 .35 m
.00375 .35 L
s
0 .4 m
.00375 .4 L
s
0 .45 m
.00375 .45 L
s
0 .55 m
.00375 .55 L
s
0 .6 m
.00375 .6 L
s
0 .65 m
.00375 .65 L
s
0 .75 m
.00375 .75 L
s
0 .8 m
.00375 .8 L
s
0 .85 m
.00375 .85 L
s
0 .05 m
.00375 .05 L
s
0 .95 m
.00375 .95 L
s
.25 Mabswid
0 0 m
0 1 L
s
.1 .99375 m
.1 1 L
s
.3 .99375 m
.3 1 L
s
.5 .99375 m
.5 1 L
s
.7 .99375 m
.7 1 L
s
.9 .99375 m
.9 1 L
s
.125 Mabswid
.15 .99625 m
.15 1 L
s
.2 .99625 m
.2 1 L
s
.25 .99625 m
.25 1 L
s
.35 .99625 m
.35 1 L
s
.4 .99625 m
.4 1 L
s
.45 .99625 m
.45 1 L
s
.55 .99625 m
.55 1 L
s
.6 .99625 m
.6 1 L
s
.65 .99625 m
.65 1 L
s
.75 .99625 m
.75 1 L
s
.8 .99625 m
.8 1 L
s
.85 .99625 m
.85 1 L
s
.05 .99625 m
.05 1 L
s
.95 .99625 m
.95 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .1 m
1 .1 L
s
.99375 .3 m
1 .3 L
s
.99375 .5 m
1 .5 L
s
.99375 .7 m
1 .7 L
s
.99375 .9 m
1 .9 L
s
.125 Mabswid
.99625 .15 m
1 .15 L
s
.99625 .2 m
1 .2 L
s
.99625 .25 m
1 .25 L
s
.99625 .35 m
1 .35 L
s
.99625 .4 m
1 .4 L
s
.99625 .45 m
1 .45 L
s
.99625 .55 m
1 .55 L
s
.99625 .6 m
1 .6 L
s
.99625 .65 m
1 .65 L
s
.99625 .75 m
1 .75 L
s
.99625 .8 m
1 .8 L
s
.99625 .85 m
1 .85 L
s
.99625 .05 m
1 .05 L
s
.99625 .95 m
1 .95 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.8 .9 .85 r
0 0 m
0 1 L
1 1 L
1 0 L
F
0 0 0 r
.01 w
0 0 m
1 0 L
1 1 L
0 1 L
0 0 L
s
0 g
.5 Mabswid
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
.01 .66 .62 r
.00946 .03949 m
0 0 rlineto s
.00946 .03949 m
0 .05 L
s
.00883 .08896 m
0 0 rlineto s
.00883 .08896 m
0 .1 L
s
.00811 .13841 m
0 0 rlineto s
.00811 .13841 m
0 .15 L
s
.00728 .18787 m
0 0 rlineto s
.00728 .18787 m
0 .2 L
s
.00632 .23735 m
0 0 rlineto s
.00632 .23735 m
0 .25 L
s
.00525 .28687 m
0 0 rlineto s
.00525 .28687 m
0 .3 L
s
.00406 .33645 m
0 0 rlineto s
.00406 .33645 m
0 .35 L
s
.00277 .38613 m
0 0 rlineto s
.00277 .38613 m
0 .4 L
s
.00141 .43593 m
0 0 rlineto s
.00141 .43593 m
0 .45 L
s
0 .48586 m
0 .51414 L
s
0 .55 m
.00141 .56407 L
s
0 .6 m
.00277 .61387 L
s
0 .65 m
.00406 .66355 L
s
0 .7 m
.00525 .71313 L
s
0 .75 m
.00632 .76265 L
s
0 .8 m
.00728 .81213 L
s
0 .85 m
.00811 .86159 L
s
0 .9 m
.00883 .91104 L
s
0 .95 m
.00946 .96051 L
s
0 1 m
0 1 L
s
.05 0 m
.03949 .00946 L
s
.06 .04 m
.04 .06 L
s
.0594 .08943 m
.0406 .11057 L
s
.05868 .13884 m
.04132 .16116 L
s
.05784 .18823 m
.04216 .21177 L
s
.05687 .23764 m
.04313 .26236 L
s
.05574 .28708 m
.04426 .31292 L
s
.05447 .33658 m
.04553 .36342 L
s
.05307 .38619 m
.04693 .41381 L
s
.05156 .43594 m
.04844 .46406 L
s
.05 .48586 m
.05 .51414 L
s
.04844 .53594 m
.05156 .56406 L
s
.04693 .58619 m
.05307 .61381 L
s
.04553 .63658 m
.05447 .66342 L
s
.04426 .68708 m
.05574 .71292 L
s
.04313 .73764 m
.05687 .76236 L
s
.04216 .78823 m
.05784 .81177 L
s
.04132 .83884 m
.05868 .86116 L
s
.0406 .88943 m
.0594 .91057 L
s
.04 .94 m
.06 .96 L
s
.03949 .99054 m
0 0 rlineto s
.03949 .99054 m
.05 1 L
s
.1 0 m
.08896 .00883 L
s
.11057 .0406 m
.08943 .0594 L
s
.11 .09 m
.09 .11 L
s
.10931 .13936 m
.09069 .16064 L
s
.10849 .18869 m
.09151 .21131 L
s
.1075 .23801 m
.0925 .26199 L
s
.10632 .28735 m
.09368 .31265 L
s
.10497 .33676 m
.09503 .36324 L
s
.10343 .38628 m
.09657 .41372 L
s
.10175 .43597 m
.09825 .46403 L
s
.1 .48586 m
.1 .51414 L
s
.09825 .53597 m
.10175 .56403 L
s
.09657 .58628 m
.10343 .61372 L
s
.09503 .63676 m
.10497 .66324 L
s
.09368 .68735 m
.10632 .71265 L
s
.0925 .73801 m
.1075 .76199 L
s
.09151 .78869 m
.10849 .81131 L
s
.09069 .83936 m
.10931 .86064 L
s
.09 .89 m
.11 .91 L
s
.08943 .9406 m
.11057 .9594 L
s
.08896 .99117 m
0 0 rlineto s
.08896 .99117 m
.1 1 L
s
.15 0 m
.13841 .00811 L
s
.16116 .04132 m
.13884 .05868 L
s
.16064 .09069 m
.13936 .10931 L
s
.16 .14 m
.14 .16 L
s
.1592 .18926 m
.1408 .21074 L
s
.15822 .23849 m
.14178 .26151 L
s
.15702 .28772 m
.14298 .31228 L
s
.15557 .337 m
.14443 .363 L
s
.15389 .3864 m
.14611 .4136 L
s
.152 .436 m
.148 .464 L
s
.15 .48586 m
.15 .51414 L
s
.148 .536 m
.152 .564 L
s
.14611 .5864 m
.15389 .6136 L
s
.14443 .637 m
.15557 .663 L
s
.14298 .68772 m
.15702 .71228 L
s
.14178 .73849 m
.15822 .76151 L
s
.1408 .78926 m
.1592 .81074 L
s
.14 .84 m
.16 .86 L
s
.13936 .89069 m
.16064 .90931 L
s
.13884 .94132 m
.16116 .95868 L
s
.13841 .99189 m
0 0 rlineto s
.13841 .99189 m
.15 1 L
s
.2 0 m
.18787 .00728 L
s
.21177 .04216 m
.18823 .05784 L
s
.21131 .09151 m
.18869 .10849 L
s
.21074 .1408 m
.18926 .1592 L
s
.21 .19 m
.19 .21 L
s
.20905 .23914 m
.19095 .26086 L
s
.20784 .28823 m
.19216 .31177 L
s
.20632 .33735 m
.19368 .36265 L
s
.20447 .38658 m
.19553 .41342 L
s
.20232 .43605 m
.19768 .46395 L
s
.2 .48586 m
.2 .51414 L
s
.19768 .53605 m
.20232 .56395 L
s
.19553 .58658 m
.20447 .61342 L
s
.19368 .63735 m
.20632 .66265 L
s
.19216 .68823 m
.20784 .71177 L
s
.19095 .73914 m
.20905 .76086 L
s
.19 .79 m
.21 .81 L
s
.18926 .8408 m
.21074 .8592 L
s
.18869 .89151 m
.21131 .90849 L
s
.18823 .94216 m
.21177 .95784 L
s
.18787 .99272 m
0 0 rlineto s
.18787 .99272 m
.2 1 L
s
.25 0 m
.23735 .00632 L
s
.26236 .04313 m
.23764 .05687 L
s
.26199 .0925 m
.23801 .1075 L
s
.26151 .14178 m
.23849 .15822 L
s
.26086 .19095 m
.23914 .20905 L
s
.26 .24 m
.24 .26 L
s
.25883 .28896 m
.24117 .31104 L
s
.25728 .33787 m
.24272 .36213 L
s
.25525 .38687 m
.24475 .41313 L
s
.25277 .43613 m
.24723 .46387 L
s
.25 .48586 m
.25 .51414 L
s
.24723 .53613 m
.25277 .56387 L
s
.24475 .58687 m
.25525 .61313 L
s
.24272 .63787 m
.25728 .66213 L
s
.24117 .68896 m
.25883 .71104 L
s
.24 .74 m
.26 .76 L
s
.23914 .79095 m
.26086 .80905 L
s
.23849 .84178 m
.26151 .85822 L
s
.23801 .8925 m
.26199 .9075 L
s
.23764 .94313 m
.26236 .95687 L
s
.23735 .99368 m
0 0 rlineto s
.23735 .99368 m
.25 1 L
s
.3 0 m
.28687 .00525 L
s
.31292 .04426 m
.28708 .05574 L
s
.31265 .09368 m
.28735 .10632 L
s
.31228 .14298 m
.28772 .15702 L
s
.31177 .19216 m
.28823 .20784 L
s
.31104 .24117 m
.28896 .25883 L
s
.31 .29 m
.29 .31 L
s
.30849 .33869 m
.29151 .36131 L
s
.30632 .38735 m
.29368 .41265 L
s
.30343 .43628 m
.29657 .46372 L
s
.3 .48586 m
.3 .51414 L
s
.29657 .53628 m
.30343 .56372 L
s
.29368 .58735 m
.30632 .61265 L
s
.29151 .63869 m
.30849 .66131 L
s
.29 .69 m
.31 .71 L
s
.28896 .74117 m
.31104 .75883 L
s
.28823 .79216 m
.31177 .80784 L
s
.28772 .84298 m
.31228 .85702 L
s
.28735 .89368 m
.31265 .90632 L
s
.28708 .94426 m
.31292 .95574 L
s
.28687 .99475 m
0 0 rlineto s
.28687 .99475 m
.3 1 L
s
.35 0 m
.33645 .00406 L
s
.36342 .04553 m
.33658 .05447 L
s
.36324 .09503 m
.33676 .10497 L
s
.363 .14443 m
.337 .15557 L
s
.36265 .19368 m
.33735 .20632 L
s
.36213 .24272 m
.33787 .25728 L
s
.36131 .29151 m
.33869 .30849 L
s
.36 .34 m
.34 .36 L
s
.35784 .38823 m
.34216 .41177 L
s
.35447 .43658 m
.34553 .46342 L
s
.35 .48586 m
.35 .51414 L
s
.34553 .53658 m
.35447 .56342 L
s
.34216 .58823 m
.35784 .61177 L
s
.34 .64 m
.36 .66 L
s
.33869 .69151 m
.36131 .70849 L
s
.33787 .74272 m
.36213 .75728 L
s
.33735 .79368 m
.36265 .80632 L
s
.337 .84443 m
.363 .85557 L
s
.33676 .89503 m
.36324 .90497 L
s
.33658 .94553 m
.36342 .95447 L
s
.33645 .99594 m
0 0 rlineto s
.33645 .99594 m
.35 1 L
s
.4 0 m
.38613 .00277 L
s
.41381 .04693 m
.38619 .05307 L
s
.41372 .09657 m
.38628 .10343 L
s
.4136 .14611 m
.3864 .15389 L
s
.41342 .19553 m
.38658 .20447 L
s
.41313 .24475 m
.38687 .25525 L
s
.41265 .29368 m
.38735 .30632 L
s
.41177 .34216 m
.38823 .35784 L
s
.41 .39 m
.39 .41 L
s
.40632 .43735 m
.39368 .46265 L
s
.4 .48586 m
.4 .51414 L
s
.39368 .53735 m
.40632 .56265 L
s
.39 .59 m
.41 .61 L
s
.38823 .64216 m
.41177 .65784 L
s
.38735 .69368 m
.41265 .70632 L
s
.38687 .74475 m
.41313 .75525 L
s
.38658 .79553 m
.41342 .80447 L
s
.3864 .84611 m
.4136 .85389 L
s
.38628 .89657 m
.41372 .90343 L
s
.38619 .94693 m
.41381 .95307 L
s
.38613 .99723 m
0 0 rlineto s
.38613 .99723 m
.4 1 L
s
.45 0 m
.43593 .00141 L
s
.46406 .04844 m
.43594 .05156 L
s
.46403 .09825 m
.43597 .10175 L
s
.464 .148 m
.436 .152 L
s
.46395 .19768 m
.43605 .20232 L
s
.46387 .24723 m
.43613 .25277 L
s
.46372 .29657 m
.43628 .30343 L
s
.46342 .34553 m
.43658 .35447 L
s
.46265 .39368 m
.43735 .40632 L
s
.46 .44 m
.44 .46 L
s
.45 .48586 m
.45 .51414 L
s
.44 .54 m
.46 .56 L
s
.43735 .59368 m
.46265 .60632 L
s
.43658 .64553 m
.46342 .65447 L
s
.43628 .69657 m
.46372 .70343 L
s
.43613 .74723 m
.46387 .75277 L
s
.43605 .79768 m
.46395 .80232 L
s
.436 .848 m
.464 .852 L
s
.43597 .89825 m
.46403 .90175 L
s
.43594 .94844 m
.46406 .95156 L
s
.43593 .99859 m
0 0 rlineto s
.43593 .99859 m
.45 1 L
s
.51414 0 m
.48586 0 L
s
.51414 .05 m
.48586 .05 L
s
.51414 .1 m
.48586 .1 L
s
.51414 .15 m
.48586 .15 L
s
.51414 .2 m
.48586 .2 L
s
.51414 .25 m
.48586 .25 L
s
.51414 .3 m
.48586 .3 L
s
.51414 .35 m
.48586 .35 L
s
.51414 .4 m
.48586 .4 L
s
.51414 .45 m
.48586 .45 L
s
newpath
.5 .5 .00707 0 365.73 arc
s
.48586 .55 m
.51414 .55 L
s
.48586 .6 m
.51414 .6 L
s
.48586 .65 m
.51414 .65 L
s
.48586 .7 m
.51414 .7 L
s
.48586 .75 m
.51414 .75 L
s
.48586 .8 m
.51414 .8 L
s
.48586 .85 m
.51414 .85 L
s
.48586 .9 m
.51414 .9 L
s
.48586 .95 m
.51414 .95 L
s
.48586 1 m
.51414 1 L
s
.56407 .00141 m
0 0 rlineto s
.56407 .00141 m
.55 0 L
s
.56406 .05156 m
.53594 .04844 L
s
.56403 .10175 m
.53597 .09825 L
s
.564 .152 m
.536 .148 L
s
.56395 .20232 m
.53605 .19768 L
s
.56387 .25277 m
.53613 .24723 L
s
.56372 .30343 m
.53628 .29657 L
s
.56342 .35447 m
.53658 .34553 L
s
.56265 .40632 m
.53735 .39368 L
s
.56 .46 m
.54 .44 L
s
.55 .51414 m
.55 .48586 L
s
.54 .56 m
.56 .54 L
s
.53735 .60632 m
.56265 .59368 L
s
.53658 .65447 m
.56342 .64553 L
s
.53628 .70343 m
.56372 .69657 L
s
.53613 .75277 m
.56387 .74723 L
s
.53605 .80232 m
.56395 .79768 L
s
.536 .852 m
.564 .848 L
s
.53597 .90175 m
.56403 .89825 L
s
.53594 .95156 m
.56406 .94844 L
s
.55 1 m
.56407 .99859 L
s
.61387 .00277 m
0 0 rlineto s
.61387 .00277 m
.6 0 L
s
.61381 .05307 m
.58619 .04693 L
s
.61372 .10343 m
.58628 .09657 L
s
.6136 .15389 m
.5864 .14611 L
s
.61342 .20447 m
.58658 .19553 L
s
.61313 .25525 m
.58687 .24475 L
s
.61265 .30632 m
.58735 .29368 L
s
.61177 .35784 m
.58823 .34216 L
s
.61 .41 m
.59 .39 L
s
.60632 .46265 m
.59368 .43735 L
s
.6 .51414 m
.6 .48586 L
s
.59368 .56265 m
.60632 .53735 L
s
.59 .61 m
.61 .59 L
s
.58823 .65784 m
.61177 .64216 L
s
.58735 .70632 m
.61265 .69368 L
s
.58687 .75525 m
.61313 .74475 L
s
.58658 .80447 m
.61342 .79553 L
s
.5864 .85389 m
.6136 .84611 L
s
.58628 .90343 m
.61372 .89657 L
s
.58619 .95307 m
.61381 .94693 L
s
.6 1 m
.61387 .99723 L
s
.66355 .00406 m
0 0 rlineto s
.66355 .00406 m
.65 0 L
s
.66342 .05447 m
.63658 .04553 L
s
.66324 .10497 m
.63676 .09503 L
s
.663 .15557 m
.637 .14443 L
s
.66265 .20632 m
.63735 .19368 L
s
.66213 .25728 m
.63787 .24272 L
s
.66131 .30849 m
.63869 .29151 L
s
.66 .36 m
.64 .34 L
s
.65784 .41177 m
.64216 .38823 L
s
.65447 .46342 m
.64553 .43658 L
s
.65 .51414 m
.65 .48586 L
s
.64553 .56342 m
.65447 .53658 L
s
.64216 .61177 m
.65784 .58823 L
s
.64 .66 m
.66 .64 L
s
.63869 .70849 m
.66131 .69151 L
s
.63787 .75728 m
.66213 .74272 L
s
.63735 .80632 m
.66265 .79368 L
s
.637 .85557 m
.663 .84443 L
s
.63676 .90497 m
.66324 .89503 L
s
.63658 .95447 m
.66342 .94553 L
s
.65 1 m
.66355 .99594 L
s
.71313 .00525 m
0 0 rlineto s
.71313 .00525 m
.7 0 L
s
.71292 .05574 m
.68708 .04426 L
s
.71265 .10632 m
.68735 .09368 L
s
.71228 .15702 m
.68772 .14298 L
s
.71177 .20784 m
.68823 .19216 L
s
.71104 .25883 m
.68896 .24117 L
s
.71 .31 m
.69 .29 L
s
.70849 .36131 m
.69151 .33869 L
s
.70632 .41265 m
.69368 .38735 L
s
.70343 .46372 m
.69657 .43628 L
s
.7 .51414 m
.7 .48586 L
s
.69657 .56372 m
.70343 .53628 L
s
.69368 .61265 m
.70632 .58735 L
s
.69151 .66131 m
.70849 .63869 L
s
.69 .71 m
.71 .69 L
s
.68896 .75883 m
.71104 .74117 L
s
.68823 .80784 m
.71177 .79216 L
s
.68772 .85702 m
.71228 .84298 L
s
.68735 .90632 m
.71265 .89368 L
s
.68708 .95574 m
.71292 .94426 L
s
.7 1 m
.71313 .99475 L
s
.76265 .00632 m
0 0 rlineto s
.76265 .00632 m
.75 0 L
s
.76236 .05687 m
.73764 .04313 L
s
.76199 .1075 m
.73801 .0925 L
s
.76151 .15822 m
.73849 .14178 L
s
.76086 .20905 m
.73914 .19095 L
s
.76 .26 m
.74 .24 L
s
.75883 .31104 m
.74117 .28896 L
s
.75728 .36213 m
.74272 .33787 L
s
.75525 .41313 m
.74475 .38687 L
s
.75277 .46387 m
.74723 .43613 L
s
.75 .51414 m
.75 .48586 L
s
.74723 .56387 m
.75277 .53613 L
s
.74475 .61313 m
.75525 .58687 L
s
.74272 .66213 m
.75728 .63787 L
s
.74117 .71104 m
.75883 .68896 L
s
.74 .76 m
.76 .74 L
s
.73914 .80905 m
.76086 .79095 L
s
.73849 .85822 m
.76151 .84178 L
s
.73801 .9075 m
.76199 .8925 L
s
.73764 .95687 m
.76236 .94313 L
s
.75 1 m
.76265 .99368 L
s
.81213 .00728 m
0 0 rlineto s
.81213 .00728 m
.8 0 L
s
.81177 .05784 m
.78823 .04216 L
s
.81131 .10849 m
.78869 .09151 L
s
.81074 .1592 m
.78926 .1408 L
s
.81 .21 m
.79 .19 L
s
.80905 .26086 m
.79095 .23914 L
s
.80784 .31177 m
.79216 .28823 L
s
.80632 .36265 m
.79368 .33735 L
s
.80447 .41342 m
.79553 .38658 L
s
.80232 .46395 m
.79768 .43605 L
s
.8 .51414 m
.8 .48586 L
s
.79768 .56395 m
.80232 .53605 L
s
.79553 .61342 m
.80447 .58658 L
s
.79368 .66265 m
.80632 .63735 L
s
.79216 .71177 m
.80784 .68823 L
s
.79095 .76086 m
.80905 .73914 L
s
.79 .81 m
.81 .79 L
s
.78926 .8592 m
.81074 .8408 L
s
.78869 .90849 m
.81131 .89151 L
s
.78823 .95784 m
.81177 .94216 L
s
.8 1 m
.81213 .99272 L
s
.86159 .00811 m
0 0 rlineto s
.86159 .00811 m
.85 0 L
s
.86116 .05868 m
.83884 .04132 L
s
.86064 .10931 m
.83936 .09069 L
s
.86 .16 m
.84 .14 L
s
.8592 .21074 m
.8408 .18926 L
s
.85822 .26151 m
.84178 .23849 L
s
.85702 .31228 m
.84298 .28772 L
s
.85557 .363 m
.84443 .337 L
s
.85389 .4136 m
.84611 .3864 L
s
.852 .464 m
.848 .436 L
s
.85 .51414 m
.85 .48586 L
s
.848 .564 m
.852 .536 L
s
.84611 .6136 m
.85389 .5864 L
s
.84443 .663 m
.85557 .637 L
s
.84298 .71228 m
.85702 .68772 L
s
.84178 .76151 m
.85822 .73849 L
s
.8408 .81074 m
.8592 .78926 L
s
.84 .86 m
.86 .84 L
s
.83936 .90931 m
.86064 .89069 L
s
.83884 .95868 m
.86116 .94132 L
s
.85 1 m
.86159 .99189 L
s
.91104 .00883 m
0 0 rlineto s
.91104 .00883 m
.9 0 L
s
.91057 .0594 m
.88943 .0406 L
s
.91 .11 m
.89 .09 L
s
.90931 .16064 m
.89069 .13936 L
s
.90849 .21131 m
.89151 .18869 L
s
.9075 .26199 m
.8925 .23801 L
s
.90632 .31265 m
.89368 .28735 L
s
.90497 .36324 m
.89503 .33676 L
s
.90343 .41372 m
.89657 .38628 L
s
.90175 .46403 m
.89825 .43597 L
s
.9 .51414 m
.9 .48586 L
s
.89825 .56403 m
.90175 .53597 L
s
.89657 .61372 m
.90343 .58628 L
s
.89503 .66324 m
.90497 .63676 L
s
.89368 .71265 m
.90632 .68735 L
s
.8925 .76199 m
.9075 .73801 L
s
.89151 .81131 m
.90849 .78869 L
s
.89069 .86064 m
.90931 .83936 L
s
.89 .91 m
.91 .89 L
s
.88943 .9594 m
.91057 .9406 L
s
.9 1 m
.91104 .99117 L
s
.96051 .00946 m
0 0 rlineto s
.96051 .00946 m
.95 0 L
s
.96 .06 m
.94 .04 L
s
.9594 .11057 m
.9406 .08943 L
s
.95868 .16116 m
.94132 .13884 L
s
.95784 .21177 m
.94216 .18823 L
s
.95687 .26236 m
.94313 .23764 L
s
.95574 .31292 m
.94426 .28708 L
s
.95447 .36342 m
.94553 .33658 L
s
.95307 .41381 m
.94693 .38619 L
s
.95156 .46406 m
.94844 .43594 L
s
.95 .51414 m
.95 .48586 L
s
.94844 .56406 m
.95156 .53594 L
s
.94693 .61381 m
.95307 .58619 L
s
.94553 .66342 m
.95447 .63658 L
s
.94426 .71292 m
.95574 .68708 L
s
.94313 .76236 m
.95687 .73764 L
s
.94216 .81177 m
.95784 .78823 L
s
.94132 .86116 m
.95868 .83884 L
s
.9406 .91057 m
.9594 .88943 L
s
.94 .96 m
.96 .94 L
s
.95 1 m
.96051 .99054 L
s
1 .05 m
.99054 .03949 L
s
1 .1 m
.99117 .08896 L
s
1 .15 m
.99189 .13841 L
s
1 .2 m
.99272 .18787 L
s
1 .25 m
.99368 .23735 L
s
1 .3 m
.99475 .28687 L
s
1 .35 m
.99594 .33645 L
s
1 .4 m
.99723 .38613 L
s
1 .45 m
.99859 .43593 L
s
1 .51414 m
1 .48586 L
s
.99859 .56407 m
0 0 rlineto s
.99859 .56407 m
1 .55 L
s
.99723 .61387 m
0 0 rlineto s
.99723 .61387 m
1 .6 L
s
.99594 .66355 m
0 0 rlineto s
.99594 .66355 m
1 .65 L
s
.99475 .71313 m
0 0 rlineto s
.99475 .71313 m
1 .7 L
s
.99368 .76265 m
0 0 rlineto s
.99368 .76265 m
1 .75 L
s
.99272 .81213 m
0 0 rlineto s
.99272 .81213 m
1 .8 L
s
.99189 .86159 m
0 0 rlineto s
.99189 .86159 m
1 .85 L
s
.99117 .91104 m
0 0 rlineto s
.99117 .91104 m
1 .9 L
s
.99054 .96051 m
0 0 rlineto s
.99054 .96051 m
1 .95 L
s
1 1 m
1 1 L
s
.871 .722 .529 r
.005 w
0 .5 m
.04167 .5 L
.08333 .5 L
.125 .5 L
.16667 .5 L
.20833 .5 L
.25 .5 L
.29167 .5 L
.33333 .5 L
.375 .5 L
.41667 .5 L
.45833 .5 L
.5 .5 L
.54167 .5 L
.58333 .5 L
.625 .5 L
.66667 .5 L
.70833 .5 L
.75 .5 L
.79167 .5 L
.83333 .5 L
.875 .5 L
.91667 .5 L
.95833 .5 L
1 .5 L
s
.274 .51 .706 r
.5 1 m
.5 .95833 L
.5 .91667 L
.5 .875 L
.5 .83333 L
.5 .79167 L
.5 .75 L
.5 .70833 L
.5 .66667 L
.5 .625 L
.5 .58333 L
.5 .54167 L
.5 .5 L
.5 .45833 L
.5 .41667 L
.5 .375 L
.5 .33333 L
.5 .29167 L
.5 .25 L
.5 .20833 L
.5 .16667 L
.5 .125 L
.5 .08333 L
.5 .04167 L
.5 0 L
s
.89 .09 .05 r
0 0 m
0 0 L
s
.10631 0 m
.10049 .00463 L
.09379 .01011 L
.08741 .01547 L
.08071 .02126 L
.07433 .02692 L
.06826 .03245 L
.06188 .03842 L
.05582 .04425 L
.05007 .04993 L
.04402 .05606 L
.03828 .06204 L
.03226 .06847 L
.02655 .07474 L
.02113 .08085 L
.01546 .08743 L
.01008 .09383 L
.00445 .10071 L
s
.00445 .10071 m
0 .10631 L
s
.23546 0 m
.23449 .0005 L
.21977 .0086 L
.20585 .01681 L
.19129 .02598 L
.17755 .03521 L
.16325 .04547 L
.14978 .05576 L
.13712 .06605 L
.12398 .07738 L
.11166 .08867 L
.10013 .09987 L
.08822 .11214 L
.07711 .12429 L
.06568 .13755 L
.05507 .15066 L
.04524 .16355 L
.03519 .17758 L
.02592 .19137 L
.01652 .20632 L
.00791 .22099 L
4e-05 .23535 L
s
4e-05 .23535 m
0 .23543 L
s
.60327 .98408 m
.64994 .97172 L
.69215 .95616 L
.73662 .93475 L
.78158 .90708 L
.82534 .87303 L
.86296 .83654 L
.92216 .75841 L
.94736 .71181 L
.96848 .65977 L
.98174 .61369 L
.98727 .58697 L
.99111 .56171 L
.99267 .54774 L
.99333 .54034 L
.99391 .53244 L
.99435 .52486 L
.99465 .51797 L
.99495 .50452 L
.9949 .49154 L
.99472 .48423 L
.99446 .47751 L
.99375 .46515 L
.99265 .45212 L
.99109 .43815 L
.98898 .42323 L
.98403 .3965 L
.97624 .36512 L
.96737 .33701 L
.94856 .29074 L
.92359 .24393 L
.86674 .16759 L
.82919 .13036 L
.7905 .09924 L
.74472 .06975 L
.69206 .04381 L
.66886 .03472 L
.64361 .02632 L
.62145 .02016 L
.59712 .01465 L
.58212 .01188 L
.56821 .00975 L
.55513 .00811 L
.54069 .0067 L
.52772 .0058 L
.51557 .00527 L
.50273 .00503 L
.49552 .00505 L
.48893 .00515 L
.47541 .00564 L
Mistroke
.46787 .00607 L
.46104 .00656 L
.44775 .00779 L
.43529 .00927 L
.40744 .01376 L
.3777 .02037 L
.32465 .03713 L
.27784 .05768 L
.23521 .0818 L
.19246 .11216 L
.12438 .17765 L
.08938 .22361 L
.06141 .27057 L
.04085 .31513 L
.03187 .33919 L
.02363 .36558 L
.01714 .39116 L
.0124 .41486 L
.00896 .4377 L
.00764 .44924 L
.0065 .46187 L
.00599 .46916 L
.00561 .47604 L
.00515 .48892 L
.00504 .49614 L
.00503 .50279 L
.00513 .51009 L
.00535 .51781 L
.00597 .5306 L
.00686 .54254 L
.00816 .55561 L
.00994 .56959 L
.01468 .59726 L
.0216 .62703 L
.03886 .67986 L
.06124 .72911 L
.08665 .77229 L
.11499 .81108 L
.14963 .84963 L
.22181 .9094 L
.26836 .93742 L
.3204 .96124 L
.36677 .97671 L
.39366 .98342 L
.419 .9883 L
.43208 .99029 L
.44599 .99202 L
.4579 .99318 L
.47103 .99413 L
.47841 .9945 L
Mistroke
.48516 .99475 L
.49296 .99492 L
.50036 .99497 L
.5135 .99479 L
.52094 .99453 L
.52783 .99419 L
.54129 .99325 L
.55394 .99203 L
.57748 .98887 L
.60262 .98422 L
.6295 .97773 L
.67602 .96262 L
.72327 .94176 L
.76171 .92013 L
.80148 .89257 L
.84282 .85704 L
.87814 .81939 L
.90668 .78216 L
.93298 .73986 L
.95657 .69117 L
.97353 .6441 L
.98087 .61731 L
.98638 .59183 L
.99087 .56359 L
.99268 .54761 L
.99331 .54057 L
.99388 .53293 L
.99458 .51964 L
.99492 .5071 L
.99495 .49488 L
.9947 .48362 L
.99415 .47145 L
.9932 .45808 L
.99181 .44415 L
.99017 .43117 L
.98627 .40759 L
.98172 .38624 L
.96808 .33908 L
.94827 .29011 L
.92087 .23949 L
.88977 .19491 L
.85674 .15687 L
.81802 .12071 L
.77214 .08655 L
.72547 .05936 L
.68024 .03901 L
.63768 .02456 L
.61301 .0181 L
.58976 .01323 L
.57703 .01106 L
Mistroke
.56494 .0093 L
.55392 .00797 L
.54221 .00683 L
.52944 .0059 L
.51763 .00534 L
.50491 .00505 L
.49767 .00503 L
.49089 .00511 L
.47797 .00552 L
.47074 .00589 L
.4642 .00632 L
.45147 .00741 L
.4395 .00874 L
.41277 .01277 L
.38415 .01877 L
.35908 .02551 L
.33301 .03404 L
.28765 .05289 L
.24583 .07527 L
.20887 .09969 L
.13396 .16681 L
.10104 .20703 L
.07023 .25444 L
.04628 .30217 L
.02881 .34841 L
.01712 .39127 L
.01219 .41608 L
.00873 .43959 L
.00739 .45166 L
.00631 .4644 L
.00564 .4753 L
.00519 .48724 L
.00503 .50015 L
.00508 .50738 L
.00522 .51394 L
.00575 .52671 L
.00655 .53875 L
.00763 .55068 L
.00911 .56345 L
.01263 .58643 L
.01821 .6135 L
.02463 .63793 L
.0428 .68966 L
.06525 .73664 L
.11631 .8127 L
.15114 .85114 L
.18689 .88335 L
.22956 .91456 L
.27913 .94296 L
.32865 .96437 L
Mistroke
.35295 .97263 L
.37597 .97918 L
.39885 .98453 L
.41989 .98845 L
.44344 .99173 L
.45646 .99306 L
.4688 .99399 L
.48079 .9946 L
.49353 .99493 L
.5044 .99495 L
.5164 .9947 L
.52924 .99411 L
.53645 .99363 L
.54305 .9931 L
.56793 .99029 L
.5811 .98828 L
.59347 .98607 L
.61643 .98108 L
.66691 .96598 L
.70904 .94867 L
.75265 .92564 L
.79786 .89532 L
.84174 .85806 L
.87868 .81875 L
.90847 .77956 L
.93316 .73953 L
.95559 .69348 L
.96584 .66731 L
.97399 .64259 L
.98093 .61706 L
.98621 .59275 L
.98972 .57195 L
.99251 .54937 L
.99358 .53712 L
.99438 .52418 L
.9948 .51312 L
.99497 .501 L
.99483 .48814 L
.99441 .47645 L
.99359 .46298 L
.99247 .45026 L
.98967 .42774 L
.98547 .40346 L
.98012 .37964 L
.97306 .35434 L
.95694 .30971 L
.93231 .25895 L
.90486 .21523 L
.87171 .17315 L
.83059 .13161 L
Mistroke
.7908 .09946 L
.74429 .06951 L
.69481 .04498 L
.6713 .03561 L
.64599 .02704 L
.62274 .02049 L
.5969 .0146 L
.57316 .01046 L
.55084 .00764 L
.53735 .00644 L
.52972 .00592 L
.52265 .00554 L
.50967 .00512 L
.50312 .00504 L
.49588 .00504 L
.48343 .0053 L
.47001 .00593 L
.45737 .00686 L
.44581 .008 L
.41981 .01156 L
.39164 .01703 L
.36261 .02447 L
.33607 .03296 L
.28754 .05294 L
.23765 .08027 L
.19371 .11117 L
.1564 .14372 L
.09539 .21488 L
.07002 .2548 L
.04667 .30128 L
.03688 .3253 L
.02766 .35203 L
.02081 .37599 L
.01486 .40184 L
.01033 .42774 L
.00742 .45136 L
.00642 .46282 L
.00565 .47522 L
.0052 .48694 L
.00503 .49772 L
.00513 .51033 L
.0056 .52381 L
.00637 .53652 L
.00737 .54807 L
.00887 .5616 L
.01093 .57624 L
.01579 .60266 L
.0224 .62999 L
.0311 .65852 L
.05095 .70822 L
Mistroke
.07475 .7533 L
.1005 .79223 L
.13218 .83123 L
.17111 .8699 L
.21051 .90149 L
.24982 .9271 L
.29259 .94942 L
.33372 .96621 L
.38419 .98123 L
.41131 .98696 L
.42525 .9893 L
.44027 .99136 L
.45352 .99279 L
.46564 .99378 L
.47784 .99448 L
.48941 .99486 L
.50287 .99497 L
.51533 .99474 L
.52899 .99412 L
.53588 .99367 L
.54349 .99306 L
.5556 .99184 L
.56834 .99023 L
.59098 .98654 L
.61514 .9814 L
.64125 .97439 L
.68698 .9583 L
.72796 .93936 L
.77311 .91281 L
.81861 .8788 L
.85526 .84465 L
.89012 .80464 L
.91769 .76559 L
.94352 .71975 L
.96267 .6759 L
.97668 .63334 L
.98408 .60327 L
Mfstroke
.58851 .91493 m
.62852 .90433 L
.6647 .89099 L
.70282 .87265 L
.74135 .84892 L
.77886 .81974 L
.81111 .78846 L
.86185 .7215 L
.88346 .68155 L
.90155 .63695 L
.91292 .59745 L
.91766 .57455 L
.92095 .55289 L
.92229 .54092 L
.92285 .53458 L
.92335 .52781 L
.92373 .52131 L
.92398 .5154 L
.92425 .50387 L
.9242 .49275 L
.92405 .48648 L
.92383 .48072 L
.92321 .47013 L
.92227 .45896 L
.92094 .44699 L
.91913 .4342 L
.91488 .41128 L
.90821 .38439 L
.9006 .36029 L
.88448 .32064 L
.86308 .28051 L
.81435 .21507 L
.78216 .18316 L
.749 .15649 L
.70976 .13122 L
.66463 .10898 L
.64474 .10119 L
.62309 .09399 L
.6041 .0887 L
.58325 .08398 L
.57038 .08162 L
.55847 .07978 L
.54725 .07838 L
.53488 .07717 L
.52376 .0764 L
.51335 .07595 L
.50234 .07574 L
.49616 .07575 L
.49051 .07584 L
.47893 .07626 L
Mistroke
.47246 .07663 L
.46661 .07705 L
.45522 .07811 L
.44453 .07938 L
.42067 .08322 L
.39517 .08889 L
.3497 .10325 L
.30958 .12087 L
.27304 .14155 L
.23639 .16757 L
.17804 .2237 L
.14804 .26309 L
.12407 .30335 L
.10644 .34154 L
.09875 .36217 L
.09168 .38479 L
.08612 .40671 L
.08206 .42702 L
.07911 .4466 L
.07797 .45649 L
.077 .46732 L
.07656 .47357 L
.07623 .47946 L
.07584 .4905 L
.07575 .49669 L
.07574 .50239 L
.07582 .50865 L
.07601 .51526 L
.07655 .52623 L
.07731 .53646 L
.07842 .54767 L
.07995 .55965 L
.08401 .58337 L
.08995 .60888 L
.10474 .65416 L
.12392 .69638 L
.1457 .73339 L
.17 .76664 L
.19968 .79968 L
.26155 .85092 L
.30145 .87494 L
.34606 .89535 L
.3858 .90861 L
.40885 .91436 L
.43058 .91854 L
.44178 .92025 L
.4537 .92173 L
.46391 .92273 L
.47517 .92354 L
.48149 .92386 L
Mistroke
.48728 .92407 L
.49396 .92422 L
.50031 .92426 L
.51157 .92411 L
.51794 .92388 L
.52385 .92359 L
.53539 .92278 L
.54623 .92174 L
.56641 .91903 L
.58796 .91505 L
.611 .90949 L
.65088 .89653 L
.69138 .87865 L
.72432 .86011 L
.75841 .83649 L
.79384 .80603 L
.82412 .77377 L
.84858 .74185 L
.87112 .70559 L
.89134 .66386 L
.90589 .62352 L
.91218 .60055 L
.9169 .57871 L
.92075 .55451 L
.9223 .54081 L
.92284 .53477 L
.92332 .52822 L
.92393 .51684 L
.92422 .50609 L
.92424 .49561 L
.92403 .48596 L
.92356 .47553 L
.92274 .46407 L
.92155 .45213 L
.92014 .44101 L
.9168 .42079 L
.91291 .40249 L
.90122 .36207 L
.88423 .32009 L
.86075 .27671 L
.83409 .2385 L
.80578 .20589 L
.77259 .17489 L
.73326 .14562 L
.69326 .12231 L
.65449 .10486 L
.61801 .09248 L
.59687 .08694 L
.57693 .08277 L
.56602 .0809 L
Mistroke
.55566 .0794 L
.54622 .07826 L
.53618 .07728 L
.52523 .07649 L
.51511 .07601 L
.50421 .07576 L
.49801 .07574 L
.4922 .07581 L
.48111 .07616 L
.47492 .07648 L
.46931 .07685 L
.4584 .07778 L
.44814 .07892 L
.42523 .08238 L
.4007 .08752 L
.37921 .09329 L
.35687 .10061 L
.31799 .11676 L
.28214 .13594 L
.25046 .15688 L
.18625 .21441 L
.15804 .24888 L
.13163 .28952 L
.11109 .33043 L
.09612 .37007 L
.0861 .4068 L
.08188 .42807 L
.07891 .44822 L
.07776 .45856 L
.07683 .46949 L
.07626 .47883 L
.07588 .48907 L
.07574 .50013 L
.07578 .50632 L
.0759 .51195 L
.07635 .5229 L
.07704 .53322 L
.07797 .54344 L
.07924 .55439 L
.08225 .57408 L
.08704 .59728 L
.09254 .61822 L
.10812 .66256 L
.12736 .70283 L
.17112 .76803 L
.20098 .80098 L
.23162 .82859 L
.2682 .85534 L
.31069 .87968 L
.35313 .89803 L
Mistroke
.37396 .90511 L
.39369 .91073 L
.4133 .91531 L
.43134 .91867 L
.45152 .92148 L
.46268 .92262 L
.47326 .92342 L
.48354 .92394 L
.49445 .92423 L
.50378 .92425 L
.51405 .92403 L
.52506 .92352 L
.53124 .92311 L
.5369 .92266 L
.55822 .92025 L
.56952 .91853 L
.58012 .91663 L
.5998 .91236 L
.64307 .89941 L
.67917 .88457 L
.71656 .86483 L
.75531 .83885 L
.79292 .80691 L
.82458 .77322 L
.85012 .73962 L
.87128 .70531 L
.89051 .66584 L
.89929 .64341 L
.90628 .62222 L
.91223 .60033 L
.91675 .5795 L
.91976 .56168 L
.92215 .54232 L
.92307 .53182 L
.92376 .52073 L
.92411 .51125 L
.92426 .50086 L
.92414 .48984 L
.92378 .47982 L
.92308 .46827 L
.92212 .45737 L
.91972 .43806 L
.91612 .41725 L
.91153 .39683 L
.90548 .37515 L
.89166 .3369 L
.87055 .29338 L
.84702 .25592 L
.81861 .21984 L
.78336 .18424 L
Mistroke
.74926 .15668 L
.70939 .13101 L
.66698 .10998 L
.64683 .10195 L
.62513 .09461 L
.60521 .08899 L
.58306 .08395 L
.56271 .0804 L
.54358 .07798 L
.53202 .07695 L
.52547 .0765 L
.51941 .07618 L
.50829 .07582 L
.50267 .07574 L
.49647 .07575 L
.48579 .07597 L
.4743 .07652 L
.46346 .07731 L
.45355 .07829 L
.43127 .08134 L
.40712 .08603 L
.38224 .09241 L
.35949 .09968 L
.31789 .11681 L
.27513 .14023 L
.23747 .16672 L
.20548 .19462 L
.15319 .25561 L
.13145 .28983 L
.11143 .32967 L
.10304 .35026 L
.09514 .37317 L
.08927 .39371 L
.08416 .41586 L
.08028 .43806 L
.07779 .45831 L
.07693 .46813 L
.07627 .47876 L
.07588 .48881 L
.07574 .49805 L
.07583 .50885 L
.07623 .52041 L
.07689 .5313 L
.07774 .5412 L
.07903 .5528 L
.0808 .56535 L
.08496 .588 L
.09063 .61142 L
.09808 .63588 L
.1151 .67847 L
Mistroke
.1355 .71712 L
.15757 .75049 L
.18473 .78391 L
.21809 .81706 L
.25186 .84413 L
.28556 .86608 L
.32222 .88522 L
.35747 .89961 L
.40073 .91249 L
.42398 .9174 L
.43593 .9194 L
.44881 .92116 L
.46016 .92239 L
.47055 .92324 L
.481 .92384 L
.49092 .92417 L
.50246 .92426 L
.51314 .92406 L
.52485 .92354 L
.53075 .92315 L
.53727 .92262 L
.54766 .92158 L
.55857 .9202 L
.57799 .91703 L
.59869 .91263 L
.62107 .90662 L
.66027 .89283 L
.69539 .87659 L
.73409 .85384 L
.7731 .82468 L
.80451 .79542 L
.83439 .76112 L
.85802 .72765 L
.88016 .68836 L
.89657 .65077 L
.90858 .61429 L
.91493 .58851 L
Mfstroke
.57376 .84577 m
.6071 .83694 L
.63725 .82583 L
.66901 .81054 L
.70113 .79077 L
.73239 .76645 L
.75926 .74038 L
.80155 .68458 L
.81955 .65129 L
.83463 .61412 L
.8441 .5812 L
.84805 .56212 L
.85079 .54408 L
.8519 .5341 L
.85238 .52881 L
.85279 .52317 L
.85311 .51775 L
.85332 .51284 L
.85354 .50323 L
.8535 .49396 L
.85337 .48874 L
.85319 .48393 L
.85268 .47511 L
.8519 .4658 L
.85078 .45582 L
.84927 .44517 L
.84574 .42607 L
.84017 .40366 L
.83383 .38358 L
.8204 .35053 L
.80256 .3171 L
.76196 .26256 L
.73513 .23597 L
.7075 .21374 L
.6748 .19268 L
.63719 .17415 L
.62062 .16766 L
.60258 .16166 L
.58675 .15725 L
.56937 .15332 L
.55865 .15135 L
.54872 .14982 L
.53938 .14865 L
.52907 .14764 L
.5198 .147 L
.51112 .14662 L
.50195 .14645 L
.4968 .14646 L
.49209 .14654 L
.48244 .14688 L
Mistroke
.47705 .14719 L
.47217 .14754 L
.46268 .14842 L
.45378 .14948 L
.43389 .15268 L
.41265 .15741 L
.37475 .16938 L
.34132 .18406 L
.31087 .20129 L
.28033 .22297 L
.2317 .26975 L
.2067 .30258 L
.18672 .33612 L
.17203 .36795 L
.16562 .38514 L
.15973 .40399 L
.1551 .42226 L
.15172 .43918 L
.14926 .4555 L
.14831 .46374 L
.1475 .47277 L
.14713 .47797 L
.14686 .48289 L
.14654 .49208 L
.14646 .49724 L
.14645 .50199 L
.14652 .50721 L
.14668 .51272 L
.14712 .52186 L
.14776 .53039 L
.14869 .53972 L
.14996 .54971 L
.15334 .56947 L
.15829 .59074 L
.17061 .62847 L
.1866 .66365 L
.20475 .6945 L
.225 .7222 L
.24973 .74973 L
.3013 .79243 L
.33454 .81245 L
.37172 .82946 L
.40484 .8405 L
.42404 .8453 L
.44215 .84879 L
.45149 .85021 L
.46142 .85144 L
.46993 .85227 L
.47931 .85295 L
.48458 .85322 L
Mistroke
.4894 .85339 L
.49497 .85352 L
.50026 .85355 L
.50965 .85342 L
.51495 .85324 L
.51988 .85299 L
.52949 .85232 L
.53853 .85145 L
.55534 .8492 L
.5733 .84587 L
.5925 .84124 L
.62573 .83044 L
.65948 .81554 L
.68694 .80009 L
.71534 .78041 L
.74487 .75503 L
.7701 .72814 L
.79048 .70154 L
.80927 .67133 L
.82612 .63655 L
.83824 .60293 L
.84348 .58379 L
.84742 .56559 L
.85062 .54542 L
.85191 .53401 L
.85236 .52898 L
.85277 .52352 L
.85327 .51403 L
.85352 .50507 L
.85353 .49634 L
.85336 .4883 L
.85296 .47961 L
.85228 .47006 L
.8513 .46011 L
.85012 .45084 L
.84734 .43399 L
.84409 .41874 L
.83435 .38505 L
.82019 .35008 L
.80062 .31392 L
.77841 .28208 L
.75481 .25491 L
.72716 .22908 L
.69438 .20468 L
.66105 .18526 L
.62874 .17072 L
.59834 .1604 L
.58072 .15579 L
.56411 .15231 L
.55502 .15075 L
Mistroke
.54639 .1495 L
.53851 .14855 L
.53015 .14773 L
.52103 .14707 L
.51259 .14667 L
.50351 .14646 L
.49834 .14645 L
.4935 .14651 L
.48426 .1468 L
.4791 .14707 L
.47443 .14737 L
.46533 .14815 L
.45679 .1491 L
.4377 .15198 L
.41725 .15627 L
.39934 .16108 L
.38072 .16717 L
.34832 .18063 L
.31845 .19662 L
.29205 .21407 L
.23854 .26201 L
.21503 .29074 L
.19302 .3246 L
.17591 .3587 L
.16343 .39172 L
.15508 .42233 L
.15157 .44006 L
.14909 .45685 L
.14814 .46547 L
.14736 .47457 L
.14689 .48236 L
.14656 .49089 L
.14645 .50011 L
.14649 .50527 L
.14659 .50996 L
.14696 .51908 L
.14753 .52768 L
.1483 .5362 L
.14936 .54533 L
.15188 .56173 L
.15587 .58107 L
.16045 .59852 L
.17343 .63547 L
.18947 .66903 L
.22593 .72336 L
.25082 .75081 L
.27635 .77382 L
.30683 .79612 L
.34224 .8164 L
.37761 .83169 L
Mistroke
.39496 .83759 L
.41141 .84227 L
.42775 .84609 L
.44278 .84889 L
.4596 .85124 L
.4689 .85218 L
.47772 .85285 L
.48628 .85329 L
.49538 .85352 L
.50315 .85354 L
.51171 .85336 L
.52088 .85294 L
.52604 .85259 L
.53075 .85221 L
.54852 .85021 L
.55793 .84877 L
.56676 .84719 L
.58317 .84363 L
.61922 .83284 L
.64931 .82048 L
.68046 .80403 L
.71276 .78237 L
.7441 .75576 L
.77048 .72768 L
.79176 .69968 L
.8094 .67109 L
.82542 .6382 L
.83274 .61951 L
.83856 .60185 L
.84352 .58361 L
.84729 .56625 L
.8498 .5514 L
.85179 .53526 L
.85256 .52651 L
.85313 .51727 L
.85343 .50937 L
.85355 .50072 L
.85345 .49153 L
.85315 .48318 L
.85256 .47355 L
.85176 .46447 L
.84976 .44838 L
.84676 .43105 L
.84294 .41403 L
.8379 .39596 L
.82638 .36408 L
.80879 .32782 L
.78918 .2966 L
.76551 .26654 L
.73613 .23686 L
Mistroke
.70771 .2139 L
.67449 .19251 L
.63915 .17498 L
.62236 .1683 L
.60428 .16217 L
.58767 .15749 L
.56921 .15329 L
.55226 .15033 L
.53631 .14832 L
.52668 .14746 L
.52123 .14708 L
.51618 .14682 L
.50691 .14651 L
.50223 .14645 L
.49706 .14646 L
.48816 .14665 L
.47858 .1471 L
.46955 .14776 L
.46129 .14857 L
.44272 .15112 L
.4226 .15502 L
.40187 .16034 L
.38291 .1664 L
.34824 .18067 L
.31261 .20019 L
.28122 .22226 L
.25457 .24551 L
.211 .29634 L
.19287 .32486 L
.17619 .35806 L
.1692 .37522 L
.16262 .39431 L
.15772 .41142 L
.15347 .42989 L
.15024 .44838 L
.14816 .46526 L
.14745 .47344 L
.14689 .4823 L
.14657 .49067 L
.14645 .49837 L
.14652 .50738 L
.14686 .51701 L
.14741 .52609 L
.14812 .53434 L
.1492 .544 L
.15067 .55446 L
.15414 .57333 L
.15886 .59285 L
.16507 .61323 L
.17925 .64873 L
Mistroke
.19625 .68093 L
.21464 .70874 L
.23727 .73659 L
.26508 .76422 L
.29322 .78678 L
.3213 .80507 L
.35185 .82102 L
.38123 .83301 L
.41728 .84374 L
.43665 .84783 L
.44661 .8495 L
.45734 .85097 L
.4668 .85199 L
.47545 .8527 L
.48417 .8532 L
.49244 .85347 L
.50205 .85355 L
.51095 .85338 L
.52071 .85295 L
.52563 .85262 L
.53106 .85219 L
.53972 .85131 L
.54881 .85017 L
.56499 .84753 L
.58224 .84385 L
.60089 .83885 L
.63356 .82736 L
.66283 .81383 L
.69508 .79486 L
.72758 .77057 L
.75376 .74618 L
.77865 .7176 L
.79835 .68971 L
.8168 .65696 L
.83048 .62564 L
.84048 .59524 L
.84577 .57376 L
Mfstroke
.55901 .77662 m
.58568 .76955 L
.6098 .76066 L
.63521 .74843 L
.6609 .73262 L
.68591 .71316 L
.70741 .69231 L
.74124 .64766 L
.75564 .62104 L
.7677 .5913 L
.77528 .56496 L
.77844 .5497 L
.78064 .53526 L
.78152 .52728 L
.7819 .52305 L
.78223 .51854 L
.78249 .5142 L
.78266 .51027 L
.78283 .50258 L
.7828 .49517 L
.7827 .49099 L
.78255 .48715 L
.78214 .48009 L
.78152 .47264 L
.78063 .46466 L
.77942 .45613 L
.77659 .44086 L
.77214 .42293 L
